//
//  CardListTableViewCell.m
//  WorldCardMobile
//

#import <QuartzCore/QuartzCore.h>
#import <Foundation/Foundation.h>

// define
#import "WCAppearanceDefine.h"

#import "WCCardHolderCell.h"

#import "UIView+Appearance.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCCardHolderCell
NSString *const CellActionType_Tel = @"PhoneActionType_Tel";
NSString *const CellActionType_SMS = @"PhoneActionType_SMS";
NSString *const CellActionType_EMail = @"PhoneActionType_EMail";
NSString *const CellActionType_Map = @"PhoneActionType_Map";
NSString *const CellActionType_Skype = @"PhoneActionType_Skype";
NSString *const CellActionType_Facetime = @"PhoneActionType_Facetime";
NSString *const CellActionType_Hangouts = @"PhoneActionType_Hangouts";


// images
NSString *const WCCardHolderCell_Unverified = @"WCCardHolderCell_Unverified";
NSString *const WCCardHolderCell_Checked = @"WCCardHolderCell_Checked";
NSString *const WCCardHolderCell_Uncheck = @"WCCardHolderCell_Uncheck";

NSString *const WCCardHolderCell_Navi = @"WCCardHolderCell_Navi";
NSString *const WCCardHolderCell_Download = @"WCCardHolderCell_Download";


const NSInteger WCCardHolderCellCustomTag = 1000;

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSInteger, WCCardHolderCellButtonTag)
{
    WCCardHolderCellButtonTag_Check=0,
    WCCardHolderCellButtonTag_ActionType,
    WCCardHolderCellButtonTag_Custom=WCCardHolderCellCustomTag, ///< WCCardholder中的所有button tag要在這個之前
};

////////////////////////////////////////////////////////////////////////////////////////////////////

/// a BOOL to identify the status of scrolling.
#define KCardListTableView_KeyIsDecelerating	@"CardListViewIsDecelerating"
#define KCardListCellHeight			72
#define KCardListCellImageWidth		95
#define KCardListCellImageHeight	55
#define KCommonFontSize             20
#define KInfoFontSize               13

#define KCardListCellEdgeInset      UIEdgeInsetsMake(8, 16, 9, 16)
#define KCardListCellLeftMarginWhenSelect 72
#define KCardListCellNameBottomSpace    4
#define KCardListCellCompanyBottomSpace    0

#define KCardListCellHorGap         16

#define KCardListCellUnVerifiedSize 24
#define KCardListCellSelectImageSize 72
#define KCardListCellCheckButtonEdgeInset      UIEdgeInsetsMake(24, 0, 24, 0)

#define KCardListCellActionTypeSizeHeight 72
#define KCardListCellActionTypeSizeWidth 56
#define KCardListCellActionTypeTopMargin 24

#define KCardListCellActionTypeSizeForDistance 40
#define KCardListCellActionTypeSizeWidthForDistance 24
#define KCardListCellHorGapForDistance 0
#define KCardListCellActionTypeTopMarginForDistance 7

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSOperationQueue *g_operationQueue = nil;  // 讀取影像的操作

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCCardHolderCell ()

@property (atomic, retain) NSOperation *currentImageLoadOperation;

@property (nonatomic, retain, readwrite) UIImageView* unverifiedImageView;
@property (nonatomic, retain, readwrite) UIImageView *cardImageView;
@property (nonatomic, retain, readwrite) UILabel *nameLabel;
@property (nonatomic, retain, readwrite) UILabel *companyLabel;
@property (nonatomic, retain, readwrite) UILabel *jobTitleLabel;
@property (nonatomic, retain, readwrite) UILabel *additionLabel;

@property (nonatomic, retain, readwrite) PPButton* ppButtonCheck;
@property (nonatomic, retain, readwrite) PPButton *additionButton;

/// 設定是否顯示未校正圖片
@property (nonatomic, assign) BOOL showUnverifiedImage;

@property (nonatomic, retain) NSArray *layoutConstraints;
@property (nonatomic, retain) UILongPressGestureRecognizer *longPressGestureRecognizer;

//@property (atomic, assign) WCCardHolderCellType cellType;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCCardHolderCell





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Life cycle methods


//===============================================================================
//
//===============================================================================
- (id)initWithDelegate:(id)delegate
       reuseIdentifier:(NSString *)identifier
{
    if(!g_operationQueue)
    {
        g_operationQueue = [[NSOperationQueue alloc] init];
        [g_operationQueue  setMaxConcurrentOperationCount:1];
    }
    
	if (self = [super initWithStyle:UITableViewCellStyleDefault reuseIdentifier:identifier]) 
	{	
		self.delegate = delegate;
        
		// 使用系統物件才能取代highlight顯示影像
		self.backgroundView = [[[UIImageView alloc] init] autorelease];
		self.selectedBackgroundView = [[[UIImageView alloc] init] autorelease];
//        [self.contentView setTranslatesAutoresizingMaskIntoConstraints:NO];
        
        //////////////////////////////////////////////////

		_cardImageView = [[UIImageView alloc] init];
        if (self.cardImageView)
        {
            [self.cardImageView setTranslatesAutoresizingMaskIntoConstraints:NO];
            self.cardImageView.clipsToBounds = YES;
            self.cardImageView.contentMode = UIViewContentModeScaleAspectFit;
            [self.cardImageView setBorderWidth:1.0];
            [self.cardImageView setBorderColor:[UIColor colorWithHexString:@"#979797"]];
            
            [self.contentView addSubview:self.cardImageView];
        }
        
        //////////////////////////////////////////////////

        UIEdgeInsets actionTypeInsets = UIEdgeInsetsMake(KCardListCellActionTypeTopMargin, KCardListCellHorGap, KCardListCellActionTypeTopMargin, KCardListCellHorGap);
        
        _additionButton =[[PPButton ppButtonWithIconImageName:nil
                                                            tag:WCCardHolderCellButtonTag_ActionType
                                                       delegate:self
                                          normalBackgroundColor:nil
                                     highlightedBackgroundColor:nil
                                                imageEdgeInsets:actionTypeInsets] retain];
        if(self.additionButton)
        {
            [self.additionButton setTranslatesAutoresizingMaskIntoConstraints:NO];
            [self.additionButton setEnableLongPress:(self.cellType==WCCardHolderCellType_ActionType)];
            self.additionButton.minimumImageHeight = 0;
            [self.contentView addSubview:self.additionButton];
        }
        

        //////////////////////////////////////////////////
        _unverifiedImageView = [[UIImageView alloc] init];
        if (self.unverifiedImageView)
        {
            [self.unverifiedImageView setTranslatesAutoresizingMaskIntoConstraints:NO];
            [self.contentView addSubview:self.unverifiedImageView];
        }
        
        //////////////////////////////////////////////////
        _ppButtonCheck = [[PPButton ppButtonWithIconImageName:nil
                                                          tag:WCCardHolderCellButtonTag_Check
                                                     delegate:self
                                        normalBackgroundColor:nil
                                   highlightedBackgroundColor:nil
                                              imageEdgeInsets:KCardListCellCheckButtonEdgeInset] retain];
        
        if(self.ppButtonCheck)
        {
            [self.ppButtonCheck setTranslatesAutoresizingMaskIntoConstraints:NO];
            [self.contentView addSubview:self.ppButtonCheck];
            self.ppButtonCheck.minimumImageHeight = 0;
            [self.ppButtonCheck setHidden:YES];
        }

        //////////////////////////////////////////////////

        UIFont		*labelFont = [UIFont systemFontOfSize:KCommonFontSize];
        
		//////////////////////////////////////////////////
		_nameLabel = [[UILabel alloc] init];
        if (self.nameLabel)
        {
            [self.nameLabel setTranslatesAutoresizingMaskIntoConstraints:NO];
            [self.nameLabel setFont:labelFont];
            [self.nameLabel setBackgroundColor:[UIColor clearColor]];
            [self.nameLabel setTextColor:WCAppearanceDefine_CellTitleColor];
            [self.nameLabel setLineBreakMode:NSLineBreakByTruncatingTail];
            [self.contentView addSubview:self.nameLabel];

        }
		
		_companyLabel = [[UILabel alloc] init];
        if (self.companyLabel)
        {
            [self.companyLabel setTranslatesAutoresizingMaskIntoConstraints:NO];
            [self.companyLabel setFont:[UIFont systemFontOfSize:KInfoFontSize]];
            [self.companyLabel setBackgroundColor:[UIColor clearColor]];
            [self.companyLabel setTextColor:[UIColor colorWithHexString:@"#787878"]];
            [self.companyLabel setLineBreakMode:NSLineBreakByTruncatingTail];
            [self.contentView addSubview:self.companyLabel];
        }
		
		_jobTitleLabel = [[UILabel alloc] init];
        if (self.jobTitleLabel)
        {
            [self.jobTitleLabel setTranslatesAutoresizingMaskIntoConstraints:NO];
            [self.jobTitleLabel setFont:[UIFont systemFontOfSize:KInfoFontSize]];
            [self.jobTitleLabel setBackgroundColor:[UIColor clearColor]];
            [self.jobTitleLabel setTextColor:[UIColor colorWithHexString:@"#787878"]];
            [self.jobTitleLabel setLineBreakMode:NSLineBreakByTruncatingTail];
            [self.contentView addSubview:self.jobTitleLabel];
        }
		
        _additionLabel = [[UILabel alloc] init];
        if (self.additionLabel)
        {
            [self.additionLabel setTranslatesAutoresizingMaskIntoConstraints:NO];
            [self.additionLabel setFont:[UIFont systemFontOfSize:KInfoFontSize]];
            [self.additionLabel setBackgroundColor:[UIColor clearColor]];
            [self.additionLabel setTextAlignment:NSTextAlignmentRight];
            [self.additionLabel setTextColor:[UIColor colorWithHexString:@"#787878"]];
            [self.additionLabel setLineBreakMode:NSLineBreakByTruncatingTail];
            [self.contentView addSubview:self.additionLabel];
        }
        
		self.currentImageLoadOperation = nil;
        
		self.cardID = nil;
        
        //////////////////////////////////////////////////
 
        [self resetLayoutConstraints];

//        [self.additionButton setBackgroundColor:[UIColor cyanColor]];
//        [self.ppButtonCheck setBackgroundColor:[UIColor orangeColor]];
//        [self.unverifiedImageView setBackgroundColor:[UIColor greenColor]];
//        [self.nameLabel setBackgroundColor:[UIColor blueColor]];
//        [self.companyLabel setBackgroundColor:[UIColor redColor]];
//        [self.jobTitleLabel setBackgroundColor:[UIColor yellowColor]];
//        [self.additionLabel setBackgroundColor:[UIColor purpleColor]];
	}
	
	return self;
}


//===============================================================================
//
//===============================================================================
- (void)dealloc 
{
    // synchronize items
    
    [self removeLayoutConstraints];
    
    [self unregistLongPressGesture];
    
    self.delegate = nil;
	self.cardID = nil;
	[self stopCurrentImageLoadOperation];    

    [self.additionButton removeFromSuperview];
    self.additionButton = nil;
    
    [self.cardImageView removeFromSuperview];
    self.cardImageView = nil;

    [self.nameLabel removeFromSuperview];
	self.nameLabel = nil;
    
    [self.additionLabel removeFromSuperview];
    self.additionLabel = nil;
    
    [self.companyLabel removeFromSuperview];
	self.companyLabel = nil;
    
    [self.jobTitleLabel removeFromSuperview];
	self.jobTitleLabel = nil;
    
    [self.unverifiedImageView removeFromSuperview];
    self.unverifiedImageView = nil;
    
    [self.ppButtonCheck removeFromSuperview];
    self.ppButtonCheck = nil;
    
    self.normalBgImage = nil;
    self.highlightBgImage = nil;
	self.backgroundView = nil;
	self.selectedBackgroundView = nil;
	
    //////////////////////////////////////////////////
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - layout



//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraints
{
    if(self.cardImageView==nil||
       self.ppButtonCheck==nil||
       self.nameLabel==nil||
       self.companyLabel==nil||
       self.jobTitleLabel==nil||
       self.additionLabel==nil||
       self.additionButton==nil||
       self.unverifiedImageView==nil)
    {
        return ;
    }
    
    [self.contentView layoutIfNeeded];

    NSDictionary *views = @{@"cardImageView":self.cardImageView,
                            @"ppButtonCheck":self.ppButtonCheck,
                            @"nameLabel":self.nameLabel,
                            @"companyLabel":self.companyLabel,
                            @"phoneLabel":self.jobTitleLabel,
                            @"additionLabel":self.additionLabel,
                            @"additionButton":self.additionButton,
                            @"unverifiedImageView":self.unverifiedImageView};
    
    NSString	*FONTSIZE = @"FONTSIZE";
    UIFont		*labelFont = [UIFont boldSystemFontOfSize:KCommonFontSize];
    CGSize		labelSize = [FONTSIZE sizeWithAttributes:@{NSFontAttributeName:labelFont}];
    
    UIFont		*infoFont = [UIFont systemFontOfSize:KInfoFontSize];
    CGSize		infoSize = [FONTSIZE sizeWithAttributes:@{NSFontAttributeName:infoFont}];
    
    NSString	*sampleString = @"99999.99 KM";
    UIFont		*distanceFont = [UIFont boldSystemFontOfSize:KInfoFontSize];
    CGSize		distanceLabelSize = [sampleString sizeWithAttributes:@{NSFontAttributeName:distanceFont}];


    //////////////////////////////////////////////////
    // !! 下面的值設定順序要固定
    
    NSInteger leftMargin = KCardListCellEdgeInset.left;
    
    NSInteger AdditionLabelRightMargin = KCardListCellEdgeInset.right;  // addition label的右邊界
    NSInteger AdditionButtonRightMargin = KCardListCellEdgeInset.right; // addition button的右邊界

    if (self.selectMode)
    {
        leftMargin = KCardListCellLeftMarginWhenSelect;
    }

    //////////////////////////////////////////////////
    // 名片圖
    NSInteger cardImageWidth = 0;
    NSInteger cellHozGap = 0;
    
    if (self.showCardImage)
    {
        cardImageWidth = KCardListCellImageWidth;
        cellHozGap = KCardListCellHorGap;
    }
    
    //////////////////////////////////////////////////
    // addition button
    NSInteger AdditionButtonWidth = 0;
    
    if (self.showAdditionButton)
    {
        AdditionLabelRightMargin = KCardListCellActionTypeSizeWidth;
        AdditionButtonRightMargin = 0;
        AdditionButtonWidth = KCardListCellActionTypeSizeWidth;
    }

    //////////////////////////////////////////////////
    // addition label
    NSInteger AdditionLabelHeight = 0;
    NSInteger AdditionLabelWidth = 0;
    NSInteger AdditionLabelTopMargin = 0;
    
    if (self.showAdditionLabal)
    {
        AdditionLabelTopMargin = KCardListCellEdgeInset.top;
        AdditionLabelHeight = labelSize.height;
        
        AdditionLabelWidth = distanceLabelSize.width;
        
        // 有秀addition label時，右邊界固定是 KCardListCellEdgeInset.right;
        AdditionLabelRightMargin = KCardListCellEdgeInset.right;
    }
    
    //////////////////////////////////////////////////
    // 如果沒有addition label, addition button 才能秀未校正
    if (self.showAdditionLabal==NO &&
        self.showAdditionButton==NO)
    {
        if (self.verified==NO)
        {
            AdditionLabelRightMargin += KCardListCellUnVerifiedSize;
            AdditionButtonRightMargin += KCardListCellUnVerifiedSize;
        }
    }
    //////////////////////////////////////////////////
    
    NSDictionary *metrics = @{@"CellTopMargin":@(KCardListCellEdgeInset.top),
                              @"CellLeftMargin":@(leftMargin),
                              @"AdditionLabelRightMargin":@(AdditionLabelRightMargin),
                              @"CardImageWidth":@(cardImageWidth),
                              @"CardImageHeight":@(KCardListCellImageHeight),
                              @"SelectImageLeftMargin":@(KCardListCellEdgeInset.left),
                              @"LabelHeight":@(labelSize.height),
                              @"InfoHeight":@(infoSize.height),
                              @"CellHozGap":@(cellHozGap),
                              @"UnverifiedRightMargin":@(KCardListCellHorGap),
                              @"NameBottomSpace":@(KCardListCellNameBottomSpace),
                              @"CompanyBottomSpace":@(KCardListCellCompanyBottomSpace),
                              @"UnverifiedSize":@(KCardListCellUnVerifiedSize),
                              @"SelectImageSize":@(KCardListCellSelectImageSize),
                              @"AdditionLabelWidth":@(AdditionLabelWidth),
                              @"AdditionLabelHeight":@(AdditionLabelHeight),
                              @"AdditionLabelTopMargin":@(AdditionLabelTopMargin),
                              @"AdditionButtonRightMargin":@(AdditionButtonRightMargin),
                              @"AdditionButtonWidth":@(AdditionButtonWidth),
                              @"ActionTypeTopMargin":@(KCardListCellActionTypeTopMargin),
                              @"BottomReserveHeight":@(self.bottomReserveHeight)
                              };

    //////////////////////////////////////////////////
    //
    [self removeLayoutConstraints];
    
    //////////////////////////////////////////////////
    NSMutableArray *constraints = [NSMutableArray array];
 
    [constraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|-(CellLeftMargin)-[cardImageView(CardImageWidth)]-(CellHozGap)-[nameLabel][additionLabel(AdditionLabelWidth)]-(AdditionLabelRightMargin)-|"
                                                                             options:NSLayoutFormatDirectionLeftToRight
                                                                             metrics:metrics
                                                                               views:views]];
    
    [constraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|-(CellLeftMargin)-[cardImageView(CardImageWidth)]-(CellHozGap)-[companyLabel][additionButton(AdditionButtonWidth)]-(AdditionButtonRightMargin)-|"
                                                                             options:NSLayoutFormatDirectionLeftToRight
                                                                             metrics:metrics
                                                                               views:views]];
    
    [constraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|-(CellLeftMargin)-[cardImageView(CardImageWidth)]-(CellHozGap)-[phoneLabel][additionButton(AdditionButtonWidth)]-(AdditionButtonRightMargin)-|"
                                                                             options:NSLayoutFormatDirectionLeftToRight
                                                                             metrics:metrics
                                                                               views:views]];
    
    [constraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|-(AdditionLabelTopMargin)-[additionLabel(AdditionLabelHeight)][additionButton]-(BottomReserveHeight)-|"
                                                                             options:NSLayoutFormatDirectionLeadingToTrailing
                                                                             metrics:metrics
                                                                               views:views]];
    
    [constraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|-(CellTopMargin)-[cardImageView(CardImageHeight)]"
                                                                             options:NSLayoutFormatDirectionLeadingToTrailing
                                                                             metrics:metrics
                                                                               views:views]];
    
    [constraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|-(CellTopMargin)-[nameLabel(LabelHeight)]-(NameBottomSpace)-[companyLabel(InfoHeight)]-(CompanyBottomSpace)-[phoneLabel(InfoHeight)]"
                                                                             options:NSLayoutFormatDirectionLeadingToTrailing
                                                                             metrics:metrics
                                                                               views:views]];
    //////////////////////////////////////////////////

    // select view
    [constraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[ppButtonCheck(SelectImageSize)]"
                                                                             options:NSLayoutFormatDirectionLeftToRight
                                                                             metrics:metrics
                                                                               views:views]];
    
    [constraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[ppButtonCheck(SelectImageSize)]"
                                                                             options:NSLayoutFormatDirectionLeadingToTrailing
                                                                             metrics:metrics
                                                                               views:views]];

    
    // unverified
    [constraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:[unverifiedImageView(UnverifiedSize)]-(UnverifiedRightMargin)-|"
                                                                             options:NSLayoutFormatDirectionLeftToRight
                                                                             metrics:metrics
                                                                               views:views]];
    
    [constraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|-(UnverifiedSize)-[unverifiedImageView(UnverifiedSize)]"
                                                                             options:NSLayoutFormatDirectionLeadingToTrailing
                                                                             metrics:metrics
                                                                               views:views]];
    
    if ([constraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:constraints];
        [self.contentView addConstraints:self.layoutConstraints];
        [self.contentView layoutIfNeeded];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.contentView removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}


//==============================================================================
//
//==============================================================================
- (void)setLabel:(UILabel *)label italic:(BOOL)italic
{
    NSString *sourceString = [label.text copy];
    
    if ([sourceString length]>0)
    {
        NSMutableAttributedString *text = [[NSMutableAttributedString alloc]
                                           initWithString:sourceString
                                           attributes:italic?@{NSObliquenessAttributeName: @(0.1)}:nil];
        label.attributedText = text;
        [text release];
    }
    
    [sourceString release];
}



//===============================================================================
//
//===============================================================================
- (void)layoutSubviews 
{
	[super layoutSubviews];
    
    //////////////////////////////////////////////////
	if (self.highlighted == YES)
    {
        // !! selectedBackgroundView有可能會被系統換掉，所以設定image前一定要檢查是否還是UIImageView。
        if(![self.selectedBackgroundView isKindOfClass:[UIImageView class]])
            self.selectedBackgroundView = [[[UIImageView alloc] init] autorelease];
        
        ((UIImageView *)self.selectedBackgroundView).image = self.highlightBgImage;
    }
    else
    {
        if(![self.backgroundView isKindOfClass:[UIImageView class]])
            self.backgroundView = [[[UIImageView alloc] init] autorelease];
        
        ((UIImageView *)self.backgroundView).image = self.normalBgImage;
        
        [self.cardImageView layoutSubviews];
        [self.ppButtonCheck layoutSubviews];
        [self.nameLabel layoutSubviews];
        [self.companyLabel layoutSubviews];
        [self.jobTitleLabel layoutSubviews];
    }
    
    //////////////////////////////////////////////////
    [self resetLayoutConstraints];
}





#pragma mark - Overwrite methods


//==============================================================================
//
//==============================================================================
- (void)prepareForReuse
{
    [super prepareForReuse];
    
    //////////////////////////////////////////////////
    // 回復成初始狀態
    self.cardImageView.image = nil;
    self.nameLabel.text = nil;
    self.companyLabel.text = nil;
    self.jobTitleLabel.text = nil;
    self.additionLabel.text = nil;
    [self.additionButton setImage:nil];
    
    self.cardID = nil;
    
    self.selectMode = NO;
    self.cellType = WCCardHolderCellType_None;
    self.showCardImage = NO;
    self.showAdditionLabal = NO;
    self.showAdditionButton = NO;
    
    self.checked = NO;
    self.verified = NO;
    self.currentActionType = ContactActionType_Tel;
    self.enableLongPress = NO;
    
}


//===============================================================================
//
//===============================================================================
- (void)setChecked:(BOOL)checked
{
	_checked = checked;
    NSString *imagePath = nil;
	if(_checked)
    {
        imagePath = [[NSBundle mainBundle] pathForResource:WCCardHolderCell_Checked ofType:@"png"];
    }
	else
    {
        imagePath = [[NSBundle mainBundle] pathForResource:WCCardHolderCell_Uncheck ofType:@"png"];
    }

    if ([imagePath length]>0)
    {
        [self.ppButtonCheck setImage:[UIImage imageWithContentsOfFile:imagePath] forState:UIControlStateNormal];
    }

    //////////////////////////////////////////////////
    [self layoutIfNeeded];
}


//===============================================================================
//
//===============================================================================
- (void)setVerified:(BOOL)verified
{
	_verified = verified;
	
    [self setLabel:self.nameLabel italic:!_verified];
    [self setLabel:self.companyLabel italic:!_verified];
    [self setLabel:self.jobTitleLabel italic:!_verified];
    
	if(_verified)
    {
		[self.unverifiedImageView setImage:nil];
    }
    else
    {
        NSString *imagePath = [[NSBundle mainBundle] pathForResource:WCCardHolderCell_Unverified ofType:@"png"];
        if ([imagePath length]>0)
        {
            [self.unverifiedImageView setImage:[UIImage imageWithContentsOfFile:imagePath]];
        }
    }
    
    //////////////////////////////////////////////////
    [self layoutIfNeeded];
}


//===============================================================================
//
//===============================================================================
- (void)setSelectMode:(BOOL)selectMode
{
    _selectMode = selectMode;
    
    if (selectMode)
    {
        [self.ppButtonCheck setHidden:NO];
    }
    else
    {
        [self.ppButtonCheck setHidden:YES];
    }
}


//==============================================================================
//
//==============================================================================
- (void)setEnableLongPress:(BOOL)enableLongPress
{
    _enableLongPress = enableLongPress;
    
    if (self.enableLongPress)
    {
        [self registLongPressGesture];
    }
    else
    {
        [self unregistLongPressGesture];
    }
}




#pragma mark - Operation methods

//===============================================================================
//
//===============================================================================
- (void)loadAndShowCardImage
{
	if (!self.cardImageView)
        return;
    
    NSOperation *curOperation = nil;
    __block UIImage *thumbImage = nil;
    
    
    //////////////////////////////////////////////////
    // get current operation
    curOperation = [[[g_operationQueue operations] firstObject] retain];
    

    //////////////////////////////////////////////////
    // check if canceled
    if([curOperation isCancelled])
    {
        goto _EXIT;
    }
    
    
    //////////////////////////////////////////////////
    // wait if is decelerating
	while (YES)
	{
		NSMutableDictionary *userInfo = [[NSThread mainThread] threadDictionary];
		BOOL isDecelerating = [[userInfo objectForKey:KCardListTableView_KeyIsDecelerating] boolValue];
        
        if(isDecelerating)
            [NSThread sleepForTimeInterval:0.05];
        else break;
    }
	
	
    //////////////////////////////////////////////////
    // check if canceled
    if([curOperation isCancelled])
    {
        goto _EXIT;
    }
    
    
    //////////////////////////////////////////////////
    // load image
    if([self.delegate respondsToSelector:@selector(copyCardListCellThumbImage:)])
        thumbImage = [self.delegate copyCardListCellThumbImage:self];
    
    if(!thumbImage)
        goto _EXIT;
    
    
    //////////////////////////////////////////////////
    // show image
    dispatch_sync(dispatch_get_main_queue(), ^{
        [self.cardImageView setImage:thumbImage];
    });
    
    
_EXIT:
    
    [thumbImage release];
    [curOperation release];
}





#pragma mark - Private methods

//===============================================================================
//
//===============================================================================
- (void)stopCurrentImageLoadOperation
{
    [self.currentImageLoadOperation cancel];
    self.currentImageLoadOperation = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (private) long press gesture


//==============================================================================
//
//==============================================================================
- (void)registLongPressGesture
{
    self.longPressGestureRecognizer = [[[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(recvLongPressGesture:)] autorelease];
    
    [self addGestureRecognizer:self.longPressGestureRecognizer];
}



//==============================================================================
//
//==============================================================================
- (void)unregistLongPressGesture
{
    [self removeGestureRecognizer:self.longPressGestureRecognizer];
    self.longPressGestureRecognizer = nil;
}


//==============================================================================
//
//==============================================================================
- (void)recvLongPressGesture:(UILongPressGestureRecognizer *)longPressGestureRecognizer
{
    if(longPressGestureRecognizer.state==UIGestureRecognizerStateBegan)
    {
        if ([self.delegate respondsToSelector:@selector(wcCardHodlerCellDidLongPress:)])
        {
            [self.delegate wcCardHodlerCellDidLongPress:self];
        }
    }
}







#pragma mark - Instance methods

//===============================================================================
//
//===============================================================================
- (void)startLoadCardImage
{
    [self stopCurrentImageLoadOperation];
    self.currentImageLoadOperation = [[[NSInvocationOperation alloc] initWithTarget:self
                                                                       selector:@selector(loadAndShowCardImage)
                                                                             object:nil] autorelease];
        
    [g_operationQueue addOperation:self.currentImageLoadOperation];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - quick setup cell style with cellType


//==============================================================================
//
//==============================================================================
- (void)setCellType:(WCCardHolderCellType)cellType
{
    _cellType = cellType;
    
    
    //////////////////////////////////////////////////
    UIEdgeInsets actionTypeInsets = UIEdgeInsetsMake(KCardListCellActionTypeTopMargin, KCardListCellHorGap,
                                                     KCardListCellActionTypeTopMargin, KCardListCellHorGap);
    
    switch (self.cellType)
    {
        case WCCardHolderCellType_Normal:
        case WCCardHolderCellType_Duplicate:
        {
            self.showCardImage = YES;
            self.showAdditionLabal = NO;
            self.showAdditionButton = NO;
            break;
        }
        case WCCardHolderCellType_ActionType:
        {
            self.showCardImage = YES;
            self.showAdditionLabal = NO;
            self.showAdditionButton = YES;
            
            self.currentActionType = ContactActionType_Tel;
            
            break;
        }
        case WCCardHolderCellType_Distance:
        {
            self.showCardImage = YES;
            self.showAdditionLabal = YES;
            self.showAdditionButton = YES;
            
            self.currentActionType = ContactActionType_Tel;
            
            actionTypeInsets = UIEdgeInsetsMake(KCardListCellActionTypeTopMarginForDistance, 0,
                                                KCardListCellActionTypeTopMarginForDistance, 0);
            break;
        }
        case WCCardHolderCellType_DuplicateWithOwner:
        {
            self.showCardImage = YES;
            self.showAdditionLabal = YES;
            self.showAdditionButton = NO;
            
            break;
        }
        case WCCardHolderCellType_CompanyContacts:
        {
            self.showCardImage = NO;
            self.showAdditionLabal = NO;
            self.showAdditionButton = YES;
            
            self.currentActionType = ContactActionType_Tel;
            break;
        }
        case WCCardHolderCellType_CompanyContactsWithOwner:
        {
            self.showCardImage = NO;
            self.showAdditionLabal = YES;
            self.showAdditionButton = YES;
            
            self.currentActionType = ContactActionType_Tel;
            
            actionTypeInsets = UIEdgeInsetsMake(KCardListCellActionTypeTopMarginForDistance, 0,
                                                KCardListCellActionTypeTopMarginForDistance, 0);
            break;
        }
        case WCCardHolderCellType_OnlyDisplayData:
        {
            self.showCardImage = NO;
            self.showAdditionLabal = NO;
            self.showAdditionButton = NO;
            break;
        }
            
        default:
            break;
    }
    //////////////////////////////////////////////////
    // 所有type都要處理的
    
    // 只有normal時才要未校正圖示
    [self.unverifiedImageView setHidden:!(self.showAdditionLabal==NO&&self.showAdditionButton==NO)];
    
    // 設定additionButton的ImageEdgeInsets
    [self.additionButton setImageEdgeInsets:actionTypeInsets];
    // ActionType才要長按
    [self.additionButton setEnableLongPress:(self.cellType==WCCardHolderCellType_ActionType)];
    //////////////////////////////////////////////////
    [self layoutIfNeeded];
}


//==============================================================================
//
//==============================================================================
- (void)setCurrentActionType:(ContactActionType)currentActionType
{
    _currentActionType = currentActionType;
    
    [self switchActionTypeButtonWithActionType:currentActionType];
}


//==============================================================================
//
//==============================================================================
- (void)switchActionTypeButtonWithActionType:(ContactActionType)actionType
{
    if (self.cellType==WCCardHolderCellType_ActionType)
    {
        [self.additionButton setImageWithName:[WCCardHolderCell imageNameWithActionType:actionType]];
    }
    else if (self.cellType==WCCardHolderCellType_Distance)
    {
        [self.additionButton setImageWithName:WCCardHolderCell_Navi];
    }
    else if (self.cellType==WCCardHolderCellType_CompanyContacts ||
             self.cellType==WCCardHolderCellType_CompanyContactsWithOwner)
    {
        [self.additionButton setImageWithName:WCCardHolderCell_Download];
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//===============================================================================
//
//===============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCCardHolderCellButtonTag_Check:
        {
            if ([self.delegate respondsToSelector:@selector(didClickCheckButtonWithCell:)])
            {
                [self.delegate didClickCheckButtonWithCell:self];
            }
            break;
        }
        case WCCardHolderCellButtonTag_ActionType:
        {
            if (self.cellType==WCCardHolderCellType_ActionType)
            {
                if ([self.delegate respondsToSelector:@selector(wcCardHolderCell:didClickActionButtonWithType:)])
                {
                    [self.delegate wcCardHolderCell:self didClickActionButtonWithType:self.currentActionType];
                }
            }
            else
            {
                if ([self.delegate respondsToSelector:@selector(didClickAdditionButtonWithCell:)])
                {
                    [self.delegate didClickAdditionButtonWithCell:self];
                }
            }
            break;
        }
        default:
            break;
    }

}


//===============================================================================
//
//===============================================================================
- (void)ppButton:(PPButton *)ppButton longPressWithState:(UIGestureRecognizerState)state
{
    // 開始表示長按時間到了
    if (state == UIGestureRecognizerStateBegan)
    {
        if ([self.delegate respondsToSelector:@selector(wcCardHodlerCellDidLongPressActionButton:)])
        {
            [self.delegate wcCardHodlerCellDidLongPressActionButton:self];
        }
    }
}






#pragma mark - Class methods


//===============================================================================
//
//===============================================================================
+ (void)tellThreadTernimate
{
    [[g_operationQueue operations] makeObjectsPerformSelector:@selector(cancel)];
}


//===============================================================================
// iphone 3G, 比較慢的手機才要用，目前用不到
//===============================================================================
+ (void)tellThreadDecelerating:(BOOL)isDecelerating
{
	NSMutableDictionary *userInfo = [[NSThread mainThread] threadDictionary];
	[userInfo setObject:@(isDecelerating) forKey:KCardListTableView_KeyIsDecelerating];
}


//==============================================================================
//
//==============================================================================
+ (NSString *)imageNameWithActionType:(ContactActionType)actionType
{
    NSString *imageName = CellActionType_Tel;
    switch (actionType)
    {
        case ContactActionType_SMS:
        {
            imageName = CellActionType_SMS;
            break;
        }
        case ContactActionType_EMail:
        {
            imageName = CellActionType_EMail;
            break;
        }
        case ContactActionType_Map:
        {
            imageName = CellActionType_Map;
            break;
        }
        case ContactActionType_Skype:
        {
            imageName = CellActionType_Skype;
            break;
        }
        case ContactActionType_FaceTime:
        {
            imageName = CellActionType_Facetime;
            break;
        }
        case ContactActionType_Hangouts:
        {
            imageName = CellActionType_Hangouts;
            break;
        }
            
        case ContactActionType_Tel:
        default:
            break;
    }
    return imageName;
}


//==============================================================================
//
//==============================================================================
+ (UIImage *)imageWithActionType:(ContactActionType)actionType
{
    NSString *imageName = [WCCardHolderCell imageNameWithActionType:actionType];
    NSString *imagePath = [[NSBundle mainBundle] pathForResource:imageName ofType:@"png"];
    
    if ([imagePath length]==0)
    {
        return nil;
    }
    
    return [[[UIImage alloc] initWithContentsOfFile:imagePath] autorelease];
}


@end
