//
//  CVCTargetView.m
//  Pods
//
//  Created by eddie on 2015/8/18.
//
//

#import "CVCTargetView.h"
#import "WCCaptureViewController+ResourceDefine.h"

@implementation CVCTargetView

//================================================================================
//
//================================================================================
- (void)drawRect:(CGRect)rect
{
    [super drawRect:rect];
    
    if(CGRectEqualToRect(CGRectZero, rect) == true)
    {
        return;
    }
    
    //////////////////////////////////////////////////

    CGContextRef context = UIGraphicsGetCurrentContext();
    
    if(context != nil)
    {
        CGContextSaveGState(context);
        
        //////////////////////////////////////////////////

        CGRect rect;
        
        if(CGSizeEqualToSize(CGSizeZero, self.fixedBoxSize) == false)
        {
            CGFloat centerX = CGRectGetMidX(self.bounds);
            CGFloat centerY = CGRectGetMidY(self.bounds);
            
            rect = CGRectMake(centerX-self.fixedBoxSize.width/2.0,
                              centerY-self.fixedBoxSize.height/2.0,
                              self.fixedBoxSize.width,
                              self.fixedBoxSize.height);
        }
        else
        {
            rect = CGRectInset(self.bounds, self.horzBoxInset, self.vertBoxInset);
        }
        
        CGPoint targetBoxPoint[4] =
        {
            CGPointMake(CGRectGetMinX(rect), CGRectGetMinY(rect)),
            CGPointMake(CGRectGetMaxX(rect), CGRectGetMinY(rect)),
            CGPointMake(CGRectGetMinX(rect), CGRectGetMaxY(rect)),
            CGPointMake(CGRectGetMaxX(rect), CGRectGetMaxY(rect))
        };
        
        //
        // 0-----1 先找出畫面中心，再分別找出四個點的位置
        // |     | 點的index如左圖所示
        // |     | 接著再依據四個點的位置來決定畫出的直橫線方向
        // 2-----3
        //
        
        // 設定色彩和線寬等
//        CGContextSetShouldAntialias(context, 0);
        CGContextSetLineWidth(context, WCCVC_LD_TargetBoxLineWidth);
        CGContextSetStrokeColorWithColor(context, WCCVC_LD_LightBlueColor.CGColor);
        
        // 繪製直橫線，依據點的index來決定
        // 例如：左上角的點就是往右畫橫線，往下畫直線
        // +-2.5是為了消掉角落的鋸齒
        
        for(NSUInteger i = 0; i < 4; i++)
        {
            CGContextBeginPath(context);
            
            //畫橫線
            if (i == 0 || i == 2)
            {
                //往右畫
                CGContextMoveToPoint(context, targetBoxPoint[i].x - WCCVC_LD_TargetBoxLineWidth/2, targetBoxPoint[i].y);
                CGContextAddLineToPoint(context, targetBoxPoint[i].x + WCCVC_LD_TargetBoxLineLength, targetBoxPoint[i].y);
            }
            else
            {
                //往左畫
                CGContextMoveToPoint(context, targetBoxPoint[i].x + WCCVC_LD_TargetBoxLineWidth/2, targetBoxPoint[i].y);
                CGContextAddLineToPoint(context, targetBoxPoint[i].x - WCCVC_LD_TargetBoxLineLength, targetBoxPoint[i].y);
            }
            
            CGContextStrokePath(context);
            CGContextDrawPath(context, kCGPathFillStroke);
            
            //////////////////////////////////////////////////
            
            CGContextBeginPath(context);
            
            CGContextMoveToPoint(context, targetBoxPoint[i].x, targetBoxPoint[i].y);
            
            //畫直線
            if (i == 0 || i == 1)
            {
                //往下畫
                
                CGContextAddLineToPoint(context, targetBoxPoint[i].x, targetBoxPoint[i].y + WCCVC_LD_TargetBoxLineLength);
            }
            else
            {
                //往上畫
                
                CGContextAddLineToPoint(context, targetBoxPoint[i].x, targetBoxPoint[i].y - WCCVC_LD_TargetBoxLineLength);
            }
            
            CGContextStrokePath(context);
            CGContextDrawPath(context, kCGPathFillStroke);
            
        }

        //////////////////////////////////////////////////

        CGContextRestoreGState(context);
    }
}

@end
