//
//  WCImageBrowseViewController.m
//
//  Created by Howard.Lin on 13/11/21.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "WCImageBrowseViewController.h"

// Define
#import "WCImageBrowseViewController+ResourceDefine.h"
#import "WCAppearanceDefine.h"

// View
#import "CVCTargetView.h"
#import "PPBusyView.h"
#import "PPImageScrollView.h"

// Controller
#import "PPImageEnhanceController.h"
#import "PPLogController.h"

// Category
#import "UIImage+Additions.h"
#import "UIColor+PropertyDictionary.h"
#import "UIView+Appearance.h"
#import "UIViewController+ShareApplication.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCImageBrowseViewController ()

@property (nonatomic,retain) PPBusyView                 *busyView;
@property (nonatomic,retain) WCImageBrowseBottomBarView *browseImageBottomBarView;
@property (nonatomic,retain) WCImageBrowseTopBarView    *browseImageTopBarView;

@property (nonatomic,retain) NSArray *layoutConstraints;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCImageBrowseViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//===============================================================================
//
//===============================================================================
- (id)init
{
    if(self=[super init])
    {
        _topBarViewHeight = PBIV_TopBarViewHeight;
        _bottomBarViewHeight = PBIV_BottomBarViewHeight;
        
        _showNextCaptureButton = YES;
        //////////////////////////////////////////////////

        
        //////////////////////////////////////////////////
        
        // MARK: 顯示範圍設定
        self.browseAreaInset = UIEdgeInsetsMake(0, 0, _bottomBarViewHeight, 0);
        
        //////////////////////////////////////////////////
        
        self.view.backgroundColor = WCAppearanceDefine_NavigationBarColor;
    }
    
    return self;
}


//===============================================================================
//
//===============================================================================
- (void)dealloc
{
    _delegate   = nil;
    
    [self.browseImageBottomBarView removeFromSuperview];
    self.browseImageBottomBarView = nil;
    
    [self.browseImageTopBarView removeFromSuperview];
    self.browseImageTopBarView = nil;
    
    [_busyView removeFromSuperview];
    [_busyView release];
    _busyView = nil;

    [_sourceImage release];
    _sourceImage = nil;
    
    [_userInfo release];
    _userInfo = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//===============================================================================
//
//===============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    PPLogFunctionIn();
    
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    self.hidesBottomBarWhenPushed = YES;
    
    // 因為iphoneX的navigation bar layout關系，所以這邊底色要跟navigationbar顏色一致
    [self.navigationController.navigationBar setBarTintColor:PBIV_BottomBarView_DarkBlueColor];
    //////////////////////////////////////////////////
    
    if(self.browseImageTopBarView==nil)
    {
        _browseImageTopBarView = [[WCImageBrowseTopBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    }
    
    if(self.browseImageTopBarView!=nil)
    {
        self.browseImageTopBarView.delegate = self;
        
        //////////////////////////////////////////////////
        
        UIBarButtonItem *leftButtonItem = [[UIBarButtonItem alloc] initWithCustomView:self.browseImageTopBarView];
        
        if(leftButtonItem!=nil)
        {
            self.navigationItem.leftBarButtonItem = leftButtonItem;
            [leftButtonItem release];
        }
    }
    
    //////////////////////////////////////////////////
    
    if(self.browseImageBottomBarView==nil)
    {
        self.browseImageBottomBarView = [[[WCImageBrowseBottomBarView alloc] initWithFrame:CGRectZero] autorelease];
    }
    
    if(self.browseImageBottomBarView!=nil)
    {
        [self.browseImageBottomBarView setTranslatesAutoresizingMaskIntoConstraints:NO];
        self.browseImageBottomBarView.delegate = self;
        
        //////////////////////////////////////////////////
        
        [self.browseImageBottomBarView updateCaptureCountLabelWithNumber:self.totalNumberOfImage];
        
        //////////////////////////////////////////////////

        self.browseImageBottomBarView.captureBackCardButton.hidden = !self.showRearCaptureButton;
        self.browseImageBottomBarView.nextCardButton.hidden = !self.showNextCaptureButton;

        //////////////////////////////////////////////////

        self.browseImageBottomBarView.backgroundColor = PBIV_BottomBarView_DarkBlueColor;
        
        //////////////////////////////////////////////////

        if(self.imageBrowseViewControllerMode==WCImageBrowseViewControllerMode_AddCard)
        {
            if(self.browseImageBottomBarView.backButton!=nil &&
               self.browseImageBottomBarView.doneButton!=nil)
            {
                PPBarViewItemModel *backItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.browseImageBottomBarView.backButton];
                
                backItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                
                //////////////////////////////////////////////////
                
                PPBarViewItemModel *doneItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.browseImageBottomBarView.doneButton];
                
                doneItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                
                //////////////////////////////////////////////////
                
                if(backItemModel!=nil &&
                   doneItemModel!=nil)
                {
                    [self.browseImageBottomBarView setItemModels:@[backItemModel,doneItemModel] forBlockType:PPBarViewBlockType_Center];
                }
            }
        }
        else
        {
            if(self.browseImageBottomBarView.nextCardButton!=nil &&
               self.browseImageBottomBarView.backButton!=nil &&
               self.browseImageBottomBarView.captureBackCardButton!=nil &&
               self.browseImageBottomBarView.doneButton!=nil)
            {
                PPBarViewItemModel *nextCardItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.browseImageBottomBarView.nextCardButton];
                
                nextCardItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                
                //////////////////////////////////////////////////
                
                PPBarViewItemModel *backItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.browseImageBottomBarView.backButton];
                
                backItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                
                //////////////////////////////////////////////////
                
                PPBarViewItemModel *captureBackItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.browseImageBottomBarView.captureBackCardButton];
                
                captureBackItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                
                //////////////////////////////////////////////////
                
                PPBarViewItemModel *doneItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.browseImageBottomBarView.doneButton];
                
                doneItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                
                //////////////////////////////////////////////////
                
                if(nextCardItemModel!=nil &&
                   backItemModel!=nil &&
                   captureBackItemModel!=nil &&
                   doneItemModel!=nil)
                {
                    NSMutableArray *buttoModels = [NSMutableArray array];
                    
                    if (self.showNextCaptureButton==YES)
                    {
                        [buttoModels addObject:nextCardItemModel];
                    }
                    
                    [buttoModels addObject:backItemModel];
                    
                    if (self.showRearCaptureButton==YES)
                    {
                        [buttoModels addObject:captureBackItemModel];
                    }
                    
                    [buttoModels addObject:doneItemModel];
                    
                    [self.browseImageBottomBarView setItemModels:buttoModels forBlockType:PPBarViewBlockType_Center];
                }
            }
        }

        //////////////////////////////////////////////////

        [self.view addSubview:self.browseImageBottomBarView];
    }

    //////////////////////////////////////////////////

    if(self.sourceImage!=nil)
    {
        self.image = self.sourceImage;
    }
    
    //////////////////////////////////////////////////

    if(self.imageLight==YES ||
       self.imageSegment==YES)
    {
        // 進行名片的前背景分離 前先顯示忙碌
        [self showBusyView:YES withSuperView:[UIApplication sharedApplication].keyWindow];
    }
    
    //////////////////////////////////////////////////
    
    [self.view setNeedsUpdateConstraints];

    PPLogFunctionOut();
}


//===============================================================================
//
//===============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    PPLogFunctionIn();
    
    [super viewDidAppear:animated];

    //////////////////////////////////////////////////

    [self cardImageEhance];

    //////////////////////////////////////////////////

    PPLogFunctionOut();
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [super viewDidDisappear:animated];
    
    //////////////////////////////////////////////////

    [self.browseImageBottomBarView removeFromSuperview];
    self.browseImageBottomBarView = nil;

    [self.browseImageTopBarView removeFromSuperview];
    self.browseImageTopBarView = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Respoding to View Rotation event

//================================================================================
//
//================================================================================
- (void)willAnimateRotationToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation duration:(NSTimeInterval)duration
{
    [super willAnimateRotationToInterfaceOrientation:toInterfaceOrientation duration:duration];
    
    //////////////////////////////////////////////////

    if([self.delegate respondsToSelector:@selector(browseImageViewController:willAnimateRotationToInterfaceOrientation:)]==YES)
    {
        [self.delegate browseImageViewController:self willAnimateRotationToInterfaceOrientation:toInterfaceOrientation];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - layout constraints


//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraints
{
    if(self.browseImageBottomBarView==nil)
    {
        return;
    }
    
    [self removeLayoutConstraints];
    //////////////////////////////////////////////////
 
    NSInteger bottomBarHeight = PPBarViewDefaultHeightForNavigationBarNormal;
    
    if(@available(iOS 11, *))
    {
        bottomBarHeight += self.view.safeAreaInsets.bottom;
        self.browseImageBottomBarView.addtionBlockEdgeInsets = UIEdgeInsetsMake(0, 0, self.view.safeAreaInsets.bottom, 0);
        
        self.browseAreaInset = UIEdgeInsetsMake(0, 0, bottomBarHeight, 0);
        [self assignBrowseViewLayuotConstraints];
    }
          
    NSDictionary *views = @{@"browseImageBottomBarView":self.browseImageBottomBarView};
    NSDictionary *metrics = @{@"BottomBarHeight":@(bottomBarHeight)};
    
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[browseImageBottomBarView]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:[browseImageBottomBarView(BottomBarHeight)]|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.layoutConstraints];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.view removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}


//==============================================================================
//
//==============================================================================
- (void)viewSafeAreaInsetsDidChange
{
    [super viewSafeAreaInsetsDidChange];
    
    [self resetLayoutConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)updateViewConstraints
{
    [super updateViewConstraints];
    
    //////////////////////////////////////////////////
    [self resetLayoutConstraints];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout of subview

//================================================================================
//
//================================================================================
//- (void)layoutSubviews
//{
//    PPLogFunctionIn();
//
//    //////////////////////////////////////////////////
//
//    [super layoutSubviews];
//
//    //////////////////////////////////////////////////
//
//    CGRect visibleFrame = [self layoutFrame];
//
//    //////////////////////////////////////////////////
//
//    self.browseImageBottomBarView.frame = CGRectMake(visibleFrame.origin.x, visibleFrame.origin.y+visibleFrame.size.height-self.bottomBarViewHeight, visibleFrame.size.width, self.bottomBarViewHeight);
//
//    //////////////////////////////////////////////////
//
//    PPLogFunctionOut();
//}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - status bar Method

//================================================================================
//
//================================================================================
- (BOOL)prefersStatusBarHidden
{
    return YES;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//===============================================================================
//
//===============================================================================
- (void)cardImageEhance
{
    PPLogFunctionIn();
    
    if(self.imageLight==YES ||
       self.imageSegment==YES)
    {
        //=======================================================
        // 進行名片的前背景分離
        //=======================================================
        
        __block typeof(self) blockself = self;
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^(void){
            if(blockself.imageSegment==YES)
            {
                //取得有效範圍
                PPQuadrilateralModel *quadriateralModel = [PPImageEnhanceController houghTransformQuadrilateralModelForImage:blockself.sourceImage];
                
                //////////////////////////////////////////////////
                
                //裁切
                UIImage *validRectImage = [PPImageEnhanceController deskewImage:blockself.sourceImage withQuadrilateralModel:quadriateralModel];
                
                //////////////////////////////////////////////////
                
                if(validRectImage!=nil)
                {
                    blockself.sourceImage = validRectImage;
                }
            }
            
            //////////////////////////////////////////////////
            
            if(blockself.imageLight==YES)
            {
                //亮化
                UIImage *lightableImage = [PPImageEnhanceController lightCorrectImage:blockself.sourceImage];

                if(lightableImage!=nil)
                {
                    blockself.sourceImage = lightableImage;
                }
            }
            
            //////////////////////////////////////////////////
            
            dispatch_async(dispatch_get_main_queue(), ^(void){
                // !! setImage會包含設定到imageView所以要放到main thread
                blockself.image = blockself.sourceImage;
                [blockself showBusyView:NO withSuperView:nil];
                
                [super viewDidLayoutSubviews];
            });
        });
    }
    
    PPLogFunctionOut();
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCImageBrowseTopBarViewDelegate Method

//===============================================================================
//
//===============================================================================
- (void)ppBrowseImageTopBarView:(WCImageBrowseTopBarView *)browseImageTopBarView ppButton:(PPButton *)button controlEvent:(UIControlEvents)controlEvent
{
    switch (button.tag)
    {
        case WCImageBrowseTopBarViewButtonTag_TurnLeft:
        {
            [self animateRotateImageViewWithOrientation:PPImageBrowseViewController_Orientation_Left];
            break;
        }
        case WCImageBrowseTopBarViewButtonTag_TurnRight:
        {
            [self animateRotateImageViewWithOrientation:PPImageBrowseViewController_Orientation_Right];
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCImageBrowseBottomBarViewDelegate Method

//===============================================================================
//
//===============================================================================
- (void)ppBrowseImageBottomBarView:(WCImageBrowseBottomBarView *)browseImageBottomBarView ppButton:(PPButton *)button controlEvent:(UIControlEvents)controlEvent
{
    switch (button.tag)
    {
        case WCImageBrowseBottomBarViewButtonTag_Back:
        {
            if([self.delegate respondsToSelector:@selector(browseImageViewController:action:)]==YES)
            {
                [self.delegate browseImageViewController:self
                                                    action:WCImageBrowseViewControllerAction_Exit];
            }
            
            break;
        }
        case WCImageBrowseBottomBarViewButtonTag_Done:
        case WCImageBrowseBottomBarViewButtonTag_CaptureBackCard:
        case WCImageBrowseBottomBarViewButtonTag_NextCard:
        {
            self.image = [self imageWithApplyRotation];
            
            //////////////////////////////////////////////////
            
            self.sourceImage = [UIImage imageWithCGImage:self.image.CGImage
                                                   scale:1
                                             orientation:self.image.imageOrientation];
            
            //////////////////////////////////////////////////

            WCImageBrowseViewControllerAction action = WCImageBrowseViewControllerAction_Done;
            
            if(button.tag==WCImageBrowseBottomBarViewButtonTag_CaptureBackCard)
            {
                action = WCImageBrowseViewControllerAction_CaptureBackCard;
            }
            else if(button.tag==WCImageBrowseBottomBarViewButtonTag_NextCard)
            {
                action = WCImageBrowseViewControllerAction_NextCard;
            }
            
            //////////////////////////////////////////////////

            if([self.delegate respondsToSelector:@selector(browseImageViewController:action:)]==YES)
            {
                [self.delegate browseImageViewController:self
                                                  action:action];
            }
            
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//===============================================================================
//
//===============================================================================
- (void)showBusyView:(BOOL)show withSuperView:(UIView *)superView
{
    PPLogFunctionIn(@"show:%d",show);
    
    if(show==YES)
    {
        if(self.busyView==nil)
        {
            _busyView = [[PPBusyView alloc] initWithSuperView:superView];
        }

        if(self.busyView!=nil)
        {
            self.busyView.style = PPBusyViewStyle_Border;
        }
    }
    else
    {
        [self.busyView removeFromSuperview];
        self.busyView = nil;
    }
    
    PPLogFunctionOut();
}

@end

