//
//  PPCSVData.m
//  WorldCardMobile
//
//  Created by harry on 2011/6/29.
//  Copyright 2011年 __MyCompanyName__. All rights reserved.
//

#import "PPCSVData.h"
#import "PPSystemInfoController.h"


@implementation PPCSVData

//================================================================================
//
//================================================================================
- (id)initWithContactTemplateModel
{
    if ((self = [super init]) != nil) 
	{
        //@IPPAN@V01;10076
        _bPhoneticNameFieldEnabled = NO;
        
        _fieldKeyUseCount = [[NSMutableDictionary alloc]init];
        //------------------------------------------
        //  _mutableFieldKeyArray
        //------------------------------------------
        _mutableFieldKeyArray = [[NSMutableArray alloc]init];
        if(_mutableFieldKeyArray)
        {
            //------------------------------------------------------------
            //  Initialize mutableFieldKeyArray
            //------------------------------------------------------------
            
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Group];

            
#if defined (FOR_CHINESE_VERSION) || defined (FOR_JAPANESE_VERSION) || defined (FOR_KOREAN_VERSION)
            
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_LastName];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_FirstName];
            
#else
            
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_FirstName];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_LastName];
            
#endif
            
            //@IPPAN@V01;10076
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_PhoneticFirstName];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_PhoneticLastName];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_MiddleName];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Prefix];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Suffix];
            
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Company];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_PhoneticCompany];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_JobTitle];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Department];
            
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Phone_Mobile];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Phone_iPhone];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Phone_Home];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Phone_Work];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Phone_Main];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Phone_HomeFax];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Phone_WorkFax];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Phone_Pager];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Phone_Other];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Phone_GoogleVoice];
            
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Email_Home];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Email_Work];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Email_Other];
            
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_URL_Homepage];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_URL_Home];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_URL_Work];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_URL_Other];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_URL_Blog];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_URL_Profile];
            
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_IM_MSN];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_IM_Skype];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_IM_QQ];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_IM_Yahoo];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_IM_ICQ];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_IM_GoogleTalk];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_IM_Jabber];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_IM_AIM];
                        
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Date_Anniversary];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Date_Birthday];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Date_Other];
            
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Home];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Home_Street];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Home_City];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Home_State];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Home_ZIP];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Home_Country];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Work];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Work_Street];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Work_City];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Work_State];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Work_ZIP];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Work_Country];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Other];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Other_Street];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Other_City];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Other_State];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Other_ZIP];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Address_Other_Country];
            
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_UnifiedBusinessNo];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_NickName];
            [_mutableFieldKeyArray addObject:KPPCSV_CDL1_Note];
            
            
        }
        
                
        //------------------------------------------
        //  _mutableDictionary
        //------------------------------------------
        _mutableDictionary = [[NSMutableDictionary alloc]init];
        
        //------------------------------------------
        //  initialize _mutableDictionary
        //------------------------------------------
        [self pp_initialize_CSV_dictionary];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    if(_fieldKeyUseCount)
    {
        [_fieldKeyUseCount release];
        _fieldKeyUseCount = nil;
    }
    
    if(_mutableFieldKeyArray)
    {
        [_mutableFieldKeyArray release];
        _mutableFieldKeyArray = nil;
    }
    
       
    if(_mutableDictionary)
    {
        [_mutableDictionary release];
        _mutableDictionary = nil;
    }
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private Methods

//================================================================================
//
//================================================================================
- (void)pp_initialize_CSV_dictionary
{
    if(_mutableDictionary == nil)
    {
        _mutableDictionary = [[NSMutableDictionary alloc]init];
    }
    
    NSMutableDictionary* mutable_L2_main_dictionary = nil;
    NSString* basedDisplayName = nil;
    NSArray* LabelNameArray;
    NSMutableArray* mutableDataArray = nil;
    NSNumber* dataMaxCountNumber = nil;
    
    //---------------------------------------
    //  Name
    //---------------------------------------
    NSDictionary* nameProperty = [[NSDictionary alloc]initWithObjects:[NSArray arrayWithObjects:@"First", 
                                                                       @"First Phonetic",
                                                                       @"Last",
                                                                       @"Last Phonetic",
                                                                       @"Middle",
                                                                       @"Prefix",
                                                                       @"Suffix",nil] 
                                                            forKeys:[NSArray arrayWithObjects:@"kABPersonFirstNameProperty", 
                                                                       @"kABPersonFirstNamePhoneticProperty",
                                                                       @"kABPersonLastNameProperty",
                                                                       @"kABPersonLastNamePhoneticProperty",
                                                                       @"kABPersonMiddleNameProperty",
                                                                       @"kABPersonPrefixProperty",
                                                                       @"kABPersonSuffixProperty", nil]];
    if(nameProperty)
    {
        NSArray* namePropertyAllKeyArray = [nameProperty allKeys];
        if(namePropertyAllKeyArray)
        {
            for(int i=0; i<[namePropertyAllKeyArray count]; i++)
            {
                //---------------------------------------
                //  First Name
                //---------------------------------------
                
                //  BasedDisplayName
                basedDisplayName = (NSString*)[nameProperty objectForKey:@"kABPersonFirstNameProperty"];
                
                if(basedDisplayName)
                {
                    mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
                    if(mutable_L2_main_dictionary)
                    {
                        [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
                        
                        //  Data Array
                        mutableDataArray = [[NSMutableArray alloc]init];
                        if(mutableDataArray)
                        {
                            [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                            
                            [mutableDataArray release];
                            mutableDataArray = nil;
                        }
                        
                        //  Data Max Count
                        dataMaxCountNumber = [[NSNumber alloc]initWithInt:KPPCSV_FirstName_DefaultMaxCount];
                        if(dataMaxCountNumber!=nil)
                        {
                            [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                            
                            [dataMaxCountNumber release];
                            dataMaxCountNumber = nil;
                        }
                        
                        //------------------------------------------
                        [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:KPPCSV_CDL1_FirstName];
                        //------------------------------------------
                        
                        [mutable_L2_main_dictionary release];
                        mutable_L2_main_dictionary = nil;
                    }
                }
                
                
                //---------------------------------------
                //  Last Name
                //---------------------------------------
                
                //  BasedDisplayName
                
                basedDisplayName = (NSString*)[nameProperty objectForKey:@"kABPersonLastNameProperty"];
                if(basedDisplayName)
                {
                    mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
                    if(mutable_L2_main_dictionary)
                    {
                        [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
                        
                        //  Data Array
                        mutableDataArray = [[NSMutableArray alloc]init];
                        if(mutableDataArray)
                        {
                            [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                            
                            [mutableDataArray release];
                            mutableDataArray = nil;
                        }
                        
                        //  Data Max Count
                        dataMaxCountNumber = [[NSNumber alloc]initWithInt:KPPCSV_LastName_DefaultMaxCount];
                        if(dataMaxCountNumber!=nil)
                        {
                            [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                            
                            [dataMaxCountNumber release];
                            dataMaxCountNumber = nil;
                        }
                        
                        //------------------------------------------
                        [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:KPPCSV_CDL1_LastName];
                        //------------------------------------------                
                        
                        [mutable_L2_main_dictionary release];
                        mutable_L2_main_dictionary = nil;
                    }
                }
                
                
                
                //  2012.02.13 added - start
                
                //---------------------------------------
                //  Phonetic First Name
                //---------------------------------------
                
                //  BasedDisplayName
                
                basedDisplayName = (NSString*)[nameProperty objectForKey:@"kABPersonFirstNamePhoneticProperty"];
                if(basedDisplayName)
                {
                    mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
                    if(mutable_L2_main_dictionary)
                    {
                        [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
                        
                        //  Data Array
                        mutableDataArray = [[NSMutableArray alloc]init];
                        if(mutableDataArray)
                        {
                            [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                            
                            [mutableDataArray release];
                            mutableDataArray = nil;
                        }
                        
                        //  Data Max Count
                        dataMaxCountNumber = [[NSNumber alloc]initWithInt:KPPCSV_PhoneticFirstName_DefaultMaxCount];
                        if(dataMaxCountNumber!=nil)
                        {
                            [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                            
                            [dataMaxCountNumber release];
                            dataMaxCountNumber = nil;
                        }
                        
                        //------------------------------------------
                        [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:KPPCSV_CDL1_PhoneticFirstName];
                        //------------------------------------------
                        
                        [mutable_L2_main_dictionary release];
                        mutable_L2_main_dictionary = nil;
                    }
                }
                
                
                //---------------------------------------
                //  Phonetic Last Name
                //---------------------------------------
                
                //  BasedDisplayName
                
                basedDisplayName = (NSString*)[nameProperty objectForKey:@"kABPersonLastNamePhoneticProperty"];
                if(basedDisplayName)
                {
                    mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
                    if(mutable_L2_main_dictionary)
                    {
                        [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
                        
                        //  Data Array
                        mutableDataArray = [[NSMutableArray alloc]init];
                        if(mutableDataArray)
                        {
                            [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                            
                            [mutableDataArray release];
                            mutableDataArray = nil;
                        }
                        
                        //  Data Max Count
                        dataMaxCountNumber = [[NSNumber alloc]initWithInt:KPPCSV_PhoneticLastName_DefaultMaxCount];
                        if(dataMaxCountNumber!=nil)
                        {
                            [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                            
                            [dataMaxCountNumber release];
                            dataMaxCountNumber = nil;
                        }
                        
                        //------------------------------------------
                        [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:KPPCSV_CDL1_PhoneticLastName];
                        //------------------------------------------
                        
                        [mutable_L2_main_dictionary release];
                        mutable_L2_main_dictionary = nil;
                    }
                }
                
                
                //  2012.02.13 added - end
                
                //---------------------------------------
                //  Middle Name
                //---------------------------------------
                
                //  BasedDisplayName
                
                basedDisplayName = (NSString*)[nameProperty objectForKey:@"kABPersonMiddleNameProperty"];
                if(basedDisplayName)
                {
                    mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
                    if(mutable_L2_main_dictionary)
                    {
                        [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
                        
                        //  Data Array
                        mutableDataArray = [[NSMutableArray alloc]init];
                        if(mutableDataArray)
                        {
                            [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                            
                            [mutableDataArray release];
                            mutableDataArray = nil;
                        }
                        
                        //  Data Max Count
                        dataMaxCountNumber = [[NSNumber alloc]initWithInt:KPPCSV_MiddleName_DefaultMaxCount];
                        if(dataMaxCountNumber!=nil)
                        {
                            [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                            
                            [dataMaxCountNumber release];
                            dataMaxCountNumber = nil;
                        }
                        
                        //------------------------------------------
                        [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:KPPCSV_CDL1_MiddleName];
                        //------------------------------------------
                        
                        [mutable_L2_main_dictionary release];
                        mutable_L2_main_dictionary = nil;
                    }
                }
                
                //---------------------------------------
                //  Prefix Name
                //---------------------------------------
                
                //  BasedDisplayName
                
                basedDisplayName = (NSString*)[nameProperty objectForKey:@"kABPersonPrefixProperty"];
                if(basedDisplayName)
                {
                    mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
                    if(mutable_L2_main_dictionary)
                    {
                        [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
                        
                        //  Data Array
                        mutableDataArray = [[NSMutableArray alloc]init];
                        if(mutableDataArray)
                        {
                            [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                            
                            [mutableDataArray release];
                            mutableDataArray = nil;
                        }
                        
                        //  Data Max Count
                        dataMaxCountNumber = [[NSNumber alloc]initWithInt:KPPCSV_Prefix_DefaultMaxCount];
                        if(dataMaxCountNumber!=nil)
                        {
                            [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                            
                            [dataMaxCountNumber release];
                            dataMaxCountNumber = nil;
                        }
                        
                        //------------------------------------------
                        [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:KPPCSV_CDL1_Prefix];
                        //------------------------------------------
                        
                        [mutable_L2_main_dictionary release];
                        mutable_L2_main_dictionary = nil;
                    }
                }
                
                //---------------------------------------
                //  Suffix Name
                //---------------------------------------
                
                //  BasedDisplayName
                
                basedDisplayName = (NSString*)[nameProperty objectForKey:@"kABPersonSuffixProperty"];
                if(basedDisplayName)
                {
                    mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
                    if(mutable_L2_main_dictionary)
                    {
                        [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
                        
                        //  Data Array
                        mutableDataArray = [[NSMutableArray alloc]init];
                        if(mutableDataArray)
                        {
                            [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                            
                            [mutableDataArray release];
                            mutableDataArray = nil;
                        }
                        
                        //  Data Max Count
                        dataMaxCountNumber = [[NSNumber alloc]initWithInt:KPPCSV_Suffix_DefaultMaxCount];
                        if(dataMaxCountNumber!=nil)
                        {
                            [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                            
                            [dataMaxCountNumber release];
                            dataMaxCountNumber = nil;
                        }
                        
                        //------------------------------------------
                        [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:KPPCSV_CDL1_Suffix];
                        //------------------------------------------
                        
                        [mutable_L2_main_dictionary release];
                        mutable_L2_main_dictionary = nil;
                    }
                }
                
                
            }
        }
    }
    [nameProperty release];
    //---------------------------------------
    //  Company Info
    //---------------------------------------
    int iDataMaxCount = 1;
    int i=0;
    LabelNameArray = @[KPPCSV_LABEL_Company_Name,
                       KPPCSV_LABEL_Company_YomiCompany,
                       KPPCSV_LABEL_Company_Title,
                       KPPCSV_LABEL_Company_Department];
    for(i=0; i<[LabelNameArray count]; i++)
    {
        NSString* tmp_CDL1_key = nil;
            
        if(i == 0)
        {
            tmp_CDL1_key = KPPCSV_CDL1_Company;
            iDataMaxCount = KPPCSV_Company_DefaultMaxCount;
        }
        else if(i == 1)
        {
            tmp_CDL1_key = KPPCSV_CDL1_PhoneticCompany;
            iDataMaxCount = KPPCSV_PhoneticCompany_DefaultMaxCount;
        }
        else if(i == 2)
        {
            tmp_CDL1_key = KPPCSV_CDL1_JobTitle;
            iDataMaxCount = KPPCSV_JobTitle_DefaultMaxCount;
        }
        else if(i == 3)
        {
            tmp_CDL1_key = KPPCSV_CDL1_Department;
            iDataMaxCount = KPPCSV_Department_DefaultMaxCount;
        }
         
        basedDisplayName = [LabelNameArray objectAtIndex:i];
        if(basedDisplayName)
        {
            mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
            if(mutable_L2_main_dictionary)
            {
                [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
                    
                //  Data Array
                mutableDataArray = [[NSMutableArray alloc]init];
                if(mutableDataArray)
                {
                    [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                        
                    [mutableDataArray release];
                    mutableDataArray = nil;
                }
                    
                //  Data Max Count
                dataMaxCountNumber = [[NSNumber alloc]initWithInt:iDataMaxCount];
                if(dataMaxCountNumber!=nil)
                {
                    [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                        
                    [dataMaxCountNumber release];
                    dataMaxCountNumber = nil;
                }
                
                //------------------------------------------
                [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:tmp_CDL1_key];
                //------------------------------------------
                    
                [mutable_L2_main_dictionary release];
                mutable_L2_main_dictionary = nil;
            }
        }
    }
    
    //---------------------------------------
    //  Phone
    //---------------------------------------
    NSString* labelName = nil;
    NSString* fieldName = nil;
    
    iDataMaxCount = 1;
    fieldName = @"Phone";
    if(fieldName)
    {
        LabelNameArray = @[KPPCSV_LABEL_PhoneType_Mobile,
                           KPPCSV_LABEL_PhoneType_iPhone,
                           KPPCSV_LABEL_PhoneType_Home,
                           KPPCSV_LABEL_PhoneType_Work,
                           KPPCSV_LABEL_PhoneType_Main,
                           KPPCSV_LABEL_PhoneType_HomeFax,
                           KPPCSV_LABEL_PhoneType_WorkFax,
                           KPPCSV_LABEL_PhoneType_Pager,
                           KPPCSV_LABEL_PhoneType_Other,
                           KPPCSV_LABEL_PhoneType_GoogleVoice];
        for(i=0; i<[LabelNameArray count]; i++)
        {
            NSString* tmp_CDL1_key = nil;
                
            if(i == 0)
            {
                tmp_CDL1_key = KPPCSV_CDL1_Phone_Mobile;
                iDataMaxCount = KPPCSV_Phone_Mobile_DefaultMaxCount;
            }
            else if(i == 1)
            {
                tmp_CDL1_key = KPPCSV_CDL1_Phone_iPhone;
                iDataMaxCount = KPPCSV_Phone_iPhone_DefaultMaxCount;
            }
            else if(i == 2)
            {
                tmp_CDL1_key = KPPCSV_CDL1_Phone_Home;
                iDataMaxCount = KPPCSV_Phone_Home_DefaultMaxCount;
            }
            else if(i == 3)
            {
                tmp_CDL1_key = KPPCSV_CDL1_Phone_Work;
                iDataMaxCount = KPPCSV_Phone_Work_DefaultMaxCount;
            }
            else if(i == 4)
            {
                tmp_CDL1_key = KPPCSV_CDL1_Phone_Main;
                iDataMaxCount = KPPCSV_Phone_Main_DefaultMaxCount;
            }
            else if(i == 5)
            {
                tmp_CDL1_key = KPPCSV_CDL1_Phone_HomeFax;
                iDataMaxCount = KPPCSV_Phone_HomeFax_DefaultMaxCount;
            }
            else if(i == 6)
            {
                tmp_CDL1_key = KPPCSV_CDL1_Phone_WorkFax;
                iDataMaxCount = KPPCSV_Phone_WorkFax_DefaultMaxCount;
            }
            else if(i == 7)
            {
                tmp_CDL1_key = KPPCSV_CDL1_Phone_Pager;
                iDataMaxCount = KPPCSV_Phone_Pager_DefaultMaxCount;
            }
            else if(i == 8)
            {
                tmp_CDL1_key = KPPCSV_CDL1_Phone_Other;
                iDataMaxCount = KPPCSV_Phone_Other_DefaultMaxCount;
            }
            else if(i == 9)
            {
                tmp_CDL1_key = KPPCSV_CDL1_Phone_GoogleVoice;
                iDataMaxCount = KPPCSV_Phone_GoogleVoice_DefaultMaxCount;
            }
                
            labelName = [LabelNameArray objectAtIndex:i];
            if(labelName)
            {
                basedDisplayName = [[NSString alloc] initWithFormat:@"%@ (%@)",fieldName, labelName];
                if(basedDisplayName)
                {
                    mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
                    if(mutable_L2_main_dictionary)
                    {
                        [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
                            
                        //  Data Array
                        mutableDataArray = [[NSMutableArray alloc]init];
                        if(mutableDataArray)
                        {
                            [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                            
                            [mutableDataArray release];
                            mutableDataArray = nil;
                        }
                            
                        //  Data Max Count
                        dataMaxCountNumber = [[NSNumber alloc]initWithInt:iDataMaxCount];
                        if(dataMaxCountNumber!=nil)
                        {
                            [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                                
                            [dataMaxCountNumber release];
                            dataMaxCountNumber = nil;                            }
                        
                        //------------------------------------------
                        [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:tmp_CDL1_key];
                        //------------------------------------------
                            
                        [mutable_L2_main_dictionary release];
                        mutable_L2_main_dictionary = nil;
                    }
                        
                    [basedDisplayName release];
                    basedDisplayName = nil;
                }
            }
        }
    }
        
    //---------------------------------------
    //  Email
    //---------------------------------------
    iDataMaxCount = 1;
    fieldName = @"Email";
    if(fieldName)
    {
        LabelNameArray = @[KPPCSV_LABEL_CommonType_Home,
                           KPPCSV_LABEL_CommonType_Work,
                           KPPCSV_LABEL_CommonType_Other];
        for(i=0; i<[LabelNameArray count]; i++)
        {
            NSString* tmp_CDL1_key = nil;
            
            if(i == 0)
            {
                tmp_CDL1_key = KPPCSV_CDL1_Email_Home;
                iDataMaxCount = KPPCSV_Email_Home_DefaultMaxCount;
            }
            else if(i == 1)
            {
                tmp_CDL1_key = KPPCSV_CDL1_Email_Work;
                iDataMaxCount = KPPCSV_Email_Work_DefaultMaxCount;
            }
            else if(i == 2)
            {
                tmp_CDL1_key = KPPCSV_CDL1_Email_Other;
                iDataMaxCount = KPPCSV_Email_Other_DefaultMaxCount;
            }
            
            
            labelName = [LabelNameArray objectAtIndex:i];
            if(labelName)
            {
                basedDisplayName = [[NSString alloc]initWithFormat:@"%@ (%@)",fieldName, labelName];
                if(basedDisplayName)
                {
                    mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
                    if(mutable_L2_main_dictionary)
                    {
                        [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
                        
                        //  Data Array
                        mutableDataArray = [[NSMutableArray alloc]init];
                        if(mutableDataArray)
                        {
                            [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                            
                            [mutableDataArray release];
                            mutableDataArray = nil;
                        }
                        
                        //  Data Max Count
                        dataMaxCountNumber = [[NSNumber alloc]initWithInt:iDataMaxCount];
                        if(dataMaxCountNumber!=nil)
                        {
                            [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                            
                            [dataMaxCountNumber release];
                            dataMaxCountNumber = nil;
                        }
                        
                        //------------------------------------------
                        if(tmp_CDL1_key!=nil && mutable_L2_main_dictionary!=nil)
                        {
                            [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:tmp_CDL1_key];
                        }
                        //------------------------------------------
                        
                        [mutable_L2_main_dictionary release];
                        mutable_L2_main_dictionary = nil;
                    }
                    
                    [basedDisplayName release];
                    basedDisplayName = nil;
                }
            }
        }
    }
    
    
    //---------------------------------------
    //  URL
    //---------------------------------------
    iDataMaxCount = 1;
    fieldName = @"URL";
    if(fieldName)
    {
        LabelNameArray = @[KPPCSV_LABEL_URLType_Homepage,
                           KPPCSV_LABEL_CommonType_Home,
                           KPPCSV_LABEL_CommonType_Work,
                           KPPCSV_LABEL_CommonType_Other,
                           KPPCSV_LABEL_URLType_Blog,
                           KPPCSV_LABEL_URLType_Profile];
        for(i=0; i<[LabelNameArray count]; i++)
        {
            NSString* tmp_CDL1_key = nil;
            
            if(i == 0)
            {
                tmp_CDL1_key = KPPCSV_CDL1_URL_Homepage;
                iDataMaxCount = KPPCSV_URL_Homepage_DefaultMaxCount;
            }
            else if(i == 1)
            {
                tmp_CDL1_key = KPPCSV_CDL1_URL_Home;
                iDataMaxCount = KPPCSV_URL_Home_DefaultMaxCount;
            }
            else if(i == 2)
            {
                tmp_CDL1_key = KPPCSV_CDL1_URL_Work;
                iDataMaxCount = KPPCSV_URL_Work_DefaultMaxCount;
            }
            else if(i == 3)
            {
                tmp_CDL1_key = KPPCSV_CDL1_URL_Other;
                iDataMaxCount = KPPCSV_URL_Other_DefaultMaxCount;
            }
            else if(i == 4)
            {
                tmp_CDL1_key = KPPCSV_CDL1_URL_Blog;
                iDataMaxCount = KPPCSV_URL_Blog_DefaultMaxCount;
            }
            else if(i == 5)
            {
                tmp_CDL1_key = KPPCSV_CDL1_URL_Profile;
                iDataMaxCount = KPPCSV_URL_Profile_DefaultMaxCount;
            }
            
            labelName = [LabelNameArray objectAtIndex:i];
            if(labelName)
            {
                basedDisplayName = [[NSString alloc]initWithFormat:@"%@ (%@)",fieldName, labelName];
                if(basedDisplayName)
                {
                    mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
                    if(mutable_L2_main_dictionary)
                    {
                        [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
                        
                        //  Data Array
                        mutableDataArray = [[NSMutableArray alloc]init];
                        if(mutableDataArray)
                        {
                            [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                            
                            [mutableDataArray release];
                            mutableDataArray = nil;
                        }
                        
                        //  Data Max Count
                        dataMaxCountNumber = [[NSNumber alloc]initWithInt:iDataMaxCount];
                        if(dataMaxCountNumber!=nil)
                        {
                            [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                            
                            [dataMaxCountNumber release];
                            dataMaxCountNumber = nil;
                        }
                        
                        //------------------------------------------
                        [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:tmp_CDL1_key];
                        //------------------------------------------
                        
                        [mutable_L2_main_dictionary release];
                        mutable_L2_main_dictionary = nil;
                    }
                    
                    [basedDisplayName release];
                    basedDisplayName = nil;
                }
            }
        }
    }
    
    //---------------------------------------
    //  IM
    //---------------------------------------
    iDataMaxCount = 1;
    fieldName = @"InstantMessage";
    if(fieldName)
    {
        LabelNameArray = @[KPPCSV_LABEL_IMType_MSN,
                           KPPCSV_LABEL_IMType_Skype,
                           KPPCSV_LABEL_IMType_QQ,
                           KPPCSV_LABEL_IMType_Yahoo,
                           KPPCSV_LABEL_IMType_ICQ,
                           KPPCSV_LABEL_IMType_GoogleTalk,
                           KPPCSV_LABEL_IMType_Jabber,
                           KPPCSV_LABEL_IMType_Aim,
                           KPPCSV_LABEL_IMType_GaduGadu,
                           KPPCSV_LABEL_IMType_Other];
        for(i=0; i<[LabelNameArray count]; i++)
        {
            NSString* tmp_CDL1_key = nil;
            
            if(i == 0)
            {
                tmp_CDL1_key = KPPCSV_CDL1_IM_MSN;
                iDataMaxCount = KPPCSV_IM_MSN_DefaultMaxCount;
            }
            else if(i == 1)
            {
                tmp_CDL1_key = KPPCSV_CDL1_IM_Skype;
                iDataMaxCount = KPPCSV_IM_Skype_DefaultMaxCount;
            }
            else if(i == 2)
            {
                tmp_CDL1_key = KPPCSV_CDL1_IM_QQ;
                iDataMaxCount = KPPCSV_IM_QQ_DefaultMaxCount;
            }
            else if(i == 3)
            {
                tmp_CDL1_key = KPPCSV_CDL1_IM_Yahoo;
                iDataMaxCount = KPPCSV_IM_Yahoo_DefaultMaxCount;
            }
            else if(i == 4)
            {
                tmp_CDL1_key = KPPCSV_CDL1_IM_ICQ;
                iDataMaxCount = KPPCSV_IM_ICQ_DefaultMaxCount;
            }
            else if(i == 5)
            {
                tmp_CDL1_key = KPPCSV_CDL1_IM_GoogleTalk;
                iDataMaxCount = KPPCSV_IM_GoogleTalk_DefaultMaxCount;
            }
            else if(i == 6)
            {
                tmp_CDL1_key = KPPCSV_CDL1_IM_Jabber;
                iDataMaxCount = KPPCSV_IM_Jabber_DefaultMaxCount;
            }
            else if(i == 7)
            {
                tmp_CDL1_key = KPPCSV_CDL1_IM_AIM;
                iDataMaxCount = KPPCSV_IM_AIM_DefaultMaxCount;
            }
            else if(i == 8)
            {
                tmp_CDL1_key = KPPCSV_CDL1_IM_GaduGadu;
                iDataMaxCount = KPPCSV_IM_GaduGadu_DefaultMaxCount;
            }
            else if(i == 9)
            {
                tmp_CDL1_key = KPPCSV_CDL1_IM_Other;
                iDataMaxCount = KPPCSV_IM_Other_DefaultMaxCount;
            }

            
            
            labelName = [LabelNameArray objectAtIndex:i];
            if(labelName)
            {
                basedDisplayName = [[NSString alloc]initWithFormat:@"%@", labelName];
                if(basedDisplayName)
                {
                    mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
                    if(mutable_L2_main_dictionary)
                    {
                        [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
                        
                        //  Data Array
                        mutableDataArray = [[NSMutableArray alloc]init];
                        if(mutableDataArray)
                        {
                            [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                            
                            [mutableDataArray release];
                            mutableDataArray = nil;
                        }
                        
                        //  Data Max Count
                        dataMaxCountNumber = [[NSNumber alloc]initWithInt:iDataMaxCount];
                        if(dataMaxCountNumber!=nil)
                        {
                            [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                            
                            [dataMaxCountNumber release];
                            dataMaxCountNumber = nil;
                        }
                        
                        //------------------------------------------
                        [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:tmp_CDL1_key];
                        //------------------------------------------
                        
                        [mutable_L2_main_dictionary release];
                        mutable_L2_main_dictionary = nil;
                    }
                    
                    [basedDisplayName release];
                    basedDisplayName = nil;
                }
            }
        }
    }
    
    //---------------------------------------
    //  Date
    //---------------------------------------
    iDataMaxCount = 1;
    fieldName = @"Date";
    if(fieldName)
    {
        LabelNameArray = @[KPPCSV_LABEL_EventType_Anniversary,
                           KPPCSV_LABEL_Birthday,
                           KPPCSV_LABEL_CommonType_Other];
        for(i=0; i<[LabelNameArray count]; i++)
        {
            NSString* tmp_CDL1_key = nil;
            
            if(i == 0)
            {
                tmp_CDL1_key = KPPCSV_CDL1_Date_Anniversary;
                iDataMaxCount = KPPCSV_Date_Anniversary_DefaultMaxCount;
            }
            else if(i == 1)
            {
                tmp_CDL1_key = KPPCSV_CDL1_Date_Birthday;
                iDataMaxCount = KPPCSV_Date_Birthday_DefaultMaxCount;
            }
            else if(i == 2)
            {
                tmp_CDL1_key = KPPCSV_CDL1_Date_Other;
                iDataMaxCount = KPPCSV_Date_Other_DefaultMaxCount;
            }
            
            
            labelName = [LabelNameArray objectAtIndex:i];
            if(labelName)
            {
                basedDisplayName = [[NSString alloc]initWithFormat:@"%@ (%@)",fieldName, labelName];
                if(basedDisplayName)
                {
                    mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
                    if(mutable_L2_main_dictionary)
                    {
                        [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
                        
                        //  Data Array
                        mutableDataArray = [[NSMutableArray alloc]init];
                        if(mutableDataArray)
                        {
                            [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                            
                            [mutableDataArray release];
                            mutableDataArray = nil;
                        }
                        
                        //  Data Max Count
                        dataMaxCountNumber = [[NSNumber alloc]initWithInt:iDataMaxCount];
                        if(dataMaxCountNumber!=nil)
                        {
                            [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                            
                            [dataMaxCountNumber release];
                            dataMaxCountNumber = nil;
                        }
                        
                        //------------------------------------------
                        if (tmp_CDL1_key)
                        {
                            [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:tmp_CDL1_key];
                        }
                        //------------------------------------------
                        
                        [mutable_L2_main_dictionary release];
                        mutable_L2_main_dictionary = nil;
                    }
                    
                    [basedDisplayName release];
                    basedDisplayName = nil;
                }
            }
        }
    }
    

    //---------------------------------------
    //  Address
    //---------------------------------------
    iDataMaxCount = 1;
    fieldName = @"Address";
    
    if(fieldName)
    {
        LabelNameArray = @[KPPCSV_LABEL_CommonType_Home,
                           KPPCSV_LABEL_CommonType_Work,
                           KPPCSV_LABEL_CommonType_Other];
        
        for(i=0; i<[LabelNameArray count]; i++)
        {
            NSArray *tmp_CDL1_keys = nil;
            
            if(i == 0)
            {
                tmp_CDL1_keys = @[KPPCSV_CDL1_Address_Home,
                                  KPPCSV_CDL1_Address_Home_Street,
                                  KPPCSV_CDL1_Address_Home_City,
                                  KPPCSV_CDL1_Address_Home_State,
                                  KPPCSV_CDL1_Address_Home_ZIP,
                                  KPPCSV_CDL1_Address_Home_Country];
                
                iDataMaxCount = KPPCSV_Address_Home_DefaultMaxCount;
            }
            else if(i == 1)
            {
                tmp_CDL1_keys = @[KPPCSV_CDL1_Address_Work,
                                  KPPCSV_CDL1_Address_Work_Street,
                                  KPPCSV_CDL1_Address_Work_City,
                                  KPPCSV_CDL1_Address_Work_State,
                                  KPPCSV_CDL1_Address_Work_ZIP,
                                  KPPCSV_CDL1_Address_Work_Country];
                
                iDataMaxCount = KPPCSV_Address_Work_DefaultMaxCount;
            }
            else if(i == 2)
            {
                tmp_CDL1_keys = @[KPPCSV_CDL1_Address_Other,
                                  KPPCSV_CDL1_Address_Other_Street,
                                  KPPCSV_CDL1_Address_Other_City,
                                  KPPCSV_CDL1_Address_Other_State,
                                  KPPCSV_CDL1_Address_Other_ZIP,
                                  KPPCSV_CDL1_Address_Other_Country];
                
                iDataMaxCount = KPPCSV_Address_Other_DefaultMaxCount;
            }
            
            
            //////////////////////////////////////////////////
            
            labelName = [LabelNameArray objectAtIndex:i];

            NSArray *subFieldNames = @[@"", KPPCSV_LABEL_Address_Street, KPPCSV_LABEL_Address_City, KPPCSV_LABEL_Address_State, KPPCSV_LABEL_Address_ZIP, KPPCSV_LABEL_Address_Country];
            
            for(int j=0; j<6; j++)
            {
                NSString *subFieldName = [subFieldNames objectAtIndex:j];
                
                if([subFieldName length] > 0)
                {
                    basedDisplayName = [[NSString alloc] initWithFormat:@"%@ - %@ (%@)",fieldName, subFieldName, labelName];
                }
                else
                {
                    basedDisplayName = [[NSString alloc] initWithFormat:@"%@ (%@)",fieldName, labelName];
                }
                
                if(basedDisplayName)
                {
                    mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
                    if(mutable_L2_main_dictionary)
                    {
                        [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
                        
                        //  Data Array
                        mutableDataArray = [[NSMutableArray alloc]init];
                        if(mutableDataArray)
                        {
                            [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                            
                            [mutableDataArray release];
                            mutableDataArray = nil;
                        }
                        
                        //  Data Max Count
                        dataMaxCountNumber = [[NSNumber alloc]initWithInt:iDataMaxCount];
                        if(dataMaxCountNumber!=nil)
                        {
                            [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                            
                            [dataMaxCountNumber release];
                            dataMaxCountNumber = nil;
                        }
                        
                        //------------------------------------------
                        [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:[tmp_CDL1_keys objectAtIndex:j]];
                        //------------------------------------------
                        
                        [mutable_L2_main_dictionary release];
                        mutable_L2_main_dictionary = nil;
                    }
                    
                    [basedDisplayName release];
                    basedDisplayName = nil;
                }
            }
        }
    }

    
    //---------------------------------------
    //  NikeName
    //---------------------------------------
    basedDisplayName = @"NickName";
    if(basedDisplayName)
    {
        mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
        if(mutable_L2_main_dictionary)
        {
            [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
            
            //  Data Array
            mutableDataArray = [[NSMutableArray alloc]init];
            if(mutableDataArray)
            {
                [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                
                [mutableDataArray release];
                mutableDataArray = nil;
            }
            
            //  Data Max Count
            dataMaxCountNumber = [[NSNumber alloc]initWithInt:KPPCSV_Note_DefaultMaxCount];
            if(dataMaxCountNumber!=nil)
            {
                [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                
                [dataMaxCountNumber release];
                dataMaxCountNumber = nil;
            }
            
            //------------------------------------------
            [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:KPPCSV_CDL1_NickName];
            //------------------------------------------
            
            [mutable_L2_main_dictionary release];
            mutable_L2_main_dictionary = nil;
        }        
    }
    //---------------------------------------
    //  UnifiedBusinessNo
    //---------------------------------------
    basedDisplayName = @"UnifiedBusinessNo";
    if(basedDisplayName)
    {
        mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
        if(mutable_L2_main_dictionary)
        {
            [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
            
            //  Data Array
            mutableDataArray = [[NSMutableArray alloc]init];
            if(mutableDataArray)
            {
                [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                
                [mutableDataArray release];
                mutableDataArray = nil;
            }
            
            //  Data Max Count
            dataMaxCountNumber = [[NSNumber alloc]initWithInt:KPPCSV_Note_DefaultMaxCount];
            if(dataMaxCountNumber!=nil)
            {
                [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                
                [dataMaxCountNumber release];
                dataMaxCountNumber = nil;
            }
            
            //------------------------------------------
            [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:KPPCSV_CDL1_UnifiedBusinessNo];
            //------------------------------------------
            
            [mutable_L2_main_dictionary release];
            mutable_L2_main_dictionary = nil;
        }        
    }
    //---------------------------------------
    //  Note
    //---------------------------------------
    basedDisplayName = @"Note";
    if(basedDisplayName)
    {
        mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
        if(mutable_L2_main_dictionary)
        {
            [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
            
            //  Data Array
            mutableDataArray = [[NSMutableArray alloc]init];
            if(mutableDataArray)
            {
                [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                
                [mutableDataArray release];
                mutableDataArray = nil;
            }
            
            //  Data Max Count
            dataMaxCountNumber = [[NSNumber alloc]initWithInt:KPPCSV_Note_DefaultMaxCount];
            if(dataMaxCountNumber!=nil)
            {
                [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                
                [dataMaxCountNumber release];
                dataMaxCountNumber = nil;
            }
            
            //------------------------------------------
            [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:KPPCSV_CDL1_Note];
            //------------------------------------------
            
            [mutable_L2_main_dictionary release];
            mutable_L2_main_dictionary = nil;
        }        
    }
    
    //---------------------------------------
    //  Group
    //---------------------------------------
    basedDisplayName = @"Group";
    if(basedDisplayName)
    {
        mutable_L2_main_dictionary = [[NSMutableDictionary alloc]init];
        if(mutable_L2_main_dictionary)
        {
            [mutable_L2_main_dictionary setObject:basedDisplayName forKey:KPPCSV_CDL2_BasedDisplayName];
            
            //  Data Array
            mutableDataArray = [[NSMutableArray alloc]init];
            if(mutableDataArray)
            {
                [mutable_L2_main_dictionary setObject:mutableDataArray forKey:KPPCSV_CDL2_Data];
                
                [mutableDataArray release];
                mutableDataArray = nil;
            }
            
            //  Data Max Count
            dataMaxCountNumber = [[NSNumber alloc]initWithInt:KPPCSV_Group_DefaultMaxCount];
            if(dataMaxCountNumber!=nil)
            {
                [mutable_L2_main_dictionary setObject:dataMaxCountNumber forKey:KPPCSV_CDL2_DataMaxCount];
                
                [dataMaxCountNumber release];
                dataMaxCountNumber = nil;
            }
            
            //------------------------------------------
            [_mutableDictionary setObject:mutable_L2_main_dictionary forKey:KPPCSV_CDL1_Group];
            //------------------------------------------
            
            [mutable_L2_main_dictionary release];
            mutable_L2_main_dictionary = nil;
        }
    }

}


//================================================================================
//
//================================================================================
- (NSInteger)pp_getFieldDataMaxCountWithKey:(NSString*)aFieldKey
{
    int iMaxCount = 0;
    if(_mutableDictionary == nil) return 0;
    
    NSDictionary* fieldDic = nil;
    fieldDic = (NSDictionary*)[_mutableDictionary objectForKey:aFieldKey];
    if(fieldDic)
    {
        NSNumber* maxCountNum = nil;
        maxCountNum = (NSNumber*)[fieldDic objectForKey:KPPCSV_CDL2_DataMaxCount];
        if(maxCountNum!=nil)
        {
            iMaxCount = [maxCountNum intValue];
        }
    }
    
    return iMaxCount;
}


//================================================================================
//
//================================================================================
- (NSInteger)pp_getFieldDataCurrentCountWithKey:(NSString*)aFieldKey
{
    NSInteger iCurrentCount = 0;
    if(_mutableDictionary == nil) return 0;
    
    NSDictionary* fieldDic = nil;
    fieldDic = (NSDictionary*)[_mutableDictionary objectForKey:aFieldKey];
    if(fieldDic)
    {
        NSMutableArray* dataArray = nil;
        dataArray = (NSMutableArray*)[fieldDic objectForKey:KPPCSV_CDL2_Data];
        if(dataArray)
        {
            iCurrentCount = [dataArray count];
        }
    }
    
    return iCurrentCount;
}


//================================================================================
//
//================================================================================
- (NSString*)pp_getFieldBaseDisplayNameWithKey:(NSString*)aFieldKey
{
    NSString* baseDisplayName = nil;
    
    if(_mutableDictionary == nil || aFieldKey == nil) return nil;
    
    NSDictionary* fieldDic = (NSDictionary*)[_mutableDictionary objectForKey:aFieldKey];
    if(fieldDic)
    {
        baseDisplayName = (NSString*)[fieldDic objectForKey:KPPCSV_CDL2_BasedDisplayName];
    }
    
    return baseDisplayName;
}


//================================================================================
//
//================================================================================
- (NSString*)pp_getFieldDataWithKey:(NSString*)aFieldKey withIndex:(NSInteger)aIndex
{
    NSString* dataText = nil;
    
    if(_mutableDictionary == nil || aFieldKey == nil) return nil;
    
    NSDictionary* fieldDic = (NSDictionary*)[_mutableDictionary objectForKey:aFieldKey];
    if(fieldDic)
    {
        NSArray* dataArray = nil;
        dataArray = (NSArray*)[fieldDic objectForKey:KPPCSV_CDL2_Data];
        if(dataArray)
        {
            if(aIndex < [dataArray count])
            {
                dataText = (NSString*)[dataArray objectAtIndex:aIndex];                
            }
        }
    }
    
    return dataText;
}


//==============================================================================
//
//==============================================================================
- (NSInteger)pp_usedCountWithKey:(NSString *)aFieldKey
{
    return [[_fieldKeyUseCount objectForKey:aFieldKey] integerValue];
}


//==============================================================================
//
//==============================================================================
- (void)pp_setUsedCount:(NSInteger)usedCount withKey:(NSString *)aFieldKey
{
    [_fieldKeyUseCount setObject:@(usedCount) forKey:aFieldKey];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - private string methods


//==============================================================================
// // gmail的csv資料有特殊符號時就需要雙引號包起來，所以統一有資料時統一先處理雙引號資料，然後用雙引號把字串包起來。
//==============================================================================
- (NSString*)gmailValidValueFromOriginalText:(NSString *)originalText
{
    if([originalText length] > 0)
    {
        NSMutableString *validString = [NSMutableString stringWithString:originalText];
     
        // 資料包含雙引號時的處理
        [validString replaceOccurrencesOfString:@"\"" withString:@"\"\"" options:NSCaseInsensitiveSearch range:NSMakeRange(0, validString.length)];
        
        // 前後加上雙引號
        [validString insertString:@"\"" atIndex:0];
        [validString appendString:@"\""];
        
        return [NSString stringWithString:validString];
    }
    else
    {
        return @"";
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Public Methods

//================================================================================
//
//================================================================================
- (BOOL)isFieldFull:(NSString*)aFieldKey
{
    BOOL bIsFieldFull = YES;
    
    if(aFieldKey == nil) return YES;
    
    NSInteger iFieldMaxCount = [self pp_getFieldDataMaxCountWithKey:aFieldKey];
    NSInteger iFieldCurrentCount = [self pp_getFieldDataCurrentCountWithKey:aFieldKey];
    
    if(iFieldCurrentCount < iFieldMaxCount)
    {
        bIsFieldFull = NO;
    }
    
    return bIsFieldFull;
}


//================================================================================
//
//================================================================================
- (void)addOneItem:(NSString*)aItemText forKey:(NSString*)aFieldKey
{
    if(_mutableDictionary == nil) return;
    if(aItemText == nil || aFieldKey == nil) return;
    
    //if([self isFieldFull:aFieldKey] == YES) return;
    
    NSDictionary* one_L2_Dictionary = (NSDictionary*)[_mutableDictionary objectForKey:aFieldKey];
    if(one_L2_Dictionary)
    {
        NSMutableArray* mutableDataArray = nil;
        mutableDataArray = (NSMutableArray*)[one_L2_Dictionary objectForKey:KPPCSV_CDL2_Data];
        if(mutableDataArray)
        {
            [mutableDataArray addObject:aItemText];
        }
    }
}


//================================================================================
//
//================================================================================
- (NSArray *)newCSVTitleArrayForWriter
{
    NSArray* resultArray = nil;
    NSMutableArray* mutableResultArray = nil;
    
    if(_mutableDictionary == nil) return nil;
    if(_mutableFieldKeyArray == nil) return nil;
    
    //------------------------------------------------------------
    //  Start To Create Title Array For Writer
    //------------------------------------------------------------
    NSInteger iMaxFieldDataCount = 0;
    NSString* basedDisplayName = nil;
    NSString* fullDisplayName = nil;    //最後的顯示字串
    
    mutableResultArray = [[NSMutableArray alloc]init];
    if(mutableResultArray)
    {
        for(int i=0; i<[_mutableFieldKeyArray count]; i++)
        {
            NSString* fieldKey = (NSString*)[_mutableFieldKeyArray objectAtIndex:i];
            if(fieldKey)
            {
                iMaxFieldDataCount = [self pp_getFieldDataMaxCountWithKey:fieldKey];
                basedDisplayName = [self pp_getFieldBaseDisplayNameWithKey:fieldKey];
                
                if(basedDisplayName && iMaxFieldDataCount > 0)
                {
                    for(int j=0; j<iMaxFieldDataCount; j++)
                    {
                        if(iMaxFieldDataCount > 1)
                        {
                            fullDisplayName = [[NSString alloc]initWithFormat:@"%@ %d", basedDisplayName, j];
                        }
                        else
                        {
                            fullDisplayName = [[NSString alloc]initWithString:basedDisplayName];
                        }
                        
                        //  取得最後顯示的名稱, 加入結果陣列中
                        if(fullDisplayName)
                        {
                            [mutableResultArray addObject:fullDisplayName];
                            
                            [fullDisplayName release];
                            fullDisplayName = nil;
                        }
                        else
                        {
                            //-------------------------------------------
                            //  例外處理, csv有對齊上的問題要注意,
                            //  因此不管有沒有取得顯示名稱, 都要加入一個item, 
                            //  才不會產生無法對齊的問題
                            //-------------------------------------------
                            fullDisplayName = [[NSString alloc]init];
                            if(fullDisplayName)
                            {
                                [mutableResultArray addObject:fullDisplayName];
                                
                                [fullDisplayName release];
                                fullDisplayName = nil;
                            }
                        }
                    }
                }
            }
        }
        
        //---------------------------------------
        //  Create Result Array
        //---------------------------------------
        resultArray = [[NSArray alloc]initWithArray:mutableResultArray copyItems:YES];
        
        [mutableResultArray release];
        mutableResultArray = nil;
    }
    
    return resultArray;
}


//================================================================================
//
//================================================================================
- (NSArray *)newCSVDataArrayForWriter:(BOOL)aIsForExcel
{
    NSArray* resultArray = nil;
    NSMutableArray* mutableResultArray = nil;
    
    if(_mutableDictionary == nil) return nil;
    if(_mutableFieldKeyArray == nil) return nil;
    
    //------------------------------------------------------------
    //  Start To Create Title Array For Writer
    //------------------------------------------------------------
    NSInteger iMaxFieldDataCount = 0;
    NSInteger iCurrentFieldCount = 0;
    NSString* nsOneFieldDataText = nil;
    NSMutableString* nsMutableOneFieldDataText = nil;
    
    NSMutableString* nsMutableAdditionalNote = nil;
    NSMutableString* nsOneAdditionalItem = nil;
    NSString* nsBaseDisplayName = nil;
    
    mutableResultArray = [[NSMutableArray alloc]init];
    if(mutableResultArray)
    {
        nsMutableAdditionalNote = [[NSMutableString alloc]init];
        if(nsMutableAdditionalNote)
        {
            for(int i=0; i<[_mutableFieldKeyArray count]; i++)
            {
                NSString* fieldKey = (NSString*)[_mutableFieldKeyArray objectAtIndex:i];
                if(fieldKey)
                {
                    iMaxFieldDataCount = [self pp_getFieldDataMaxCountWithKey:fieldKey];
                    iCurrentFieldCount = [self pp_getFieldDataCurrentCountWithKey:fieldKey];
                    
                    //  為了對齊
                    if(iCurrentFieldCount < iMaxFieldDataCount)
                    {
                        iCurrentFieldCount = iMaxFieldDataCount;
                    }
                    
                    if(iCurrentFieldCount > 0)
                    {
                        nsBaseDisplayName = [self pp_getFieldBaseDisplayNameWithKey:fieldKey];
                        if(nsBaseDisplayName)// get-rule
                        {
                            for(int j=0; j<iCurrentFieldCount; j++)
                            {
                                if(j<iMaxFieldDataCount)
                                {
                                    nsMutableOneFieldDataText = [[NSMutableString alloc]init];
                                    if(nsMutableOneFieldDataText)
                                    {
                                        nsOneFieldDataText = [self pp_getFieldDataWithKey:fieldKey withIndex:j];
                                        //  取得最後顯示的名稱, 加入結果陣列中
                                        if(nsOneFieldDataText)  //    get-rule
                                        {
                                            if(aIsForExcel)
                                            {
                                                NSRange tmpRange = [fieldKey rangeOfString:@"KPPCSV_CDL1_Phone"];
                                                if(tmpRange.location != NSNotFound)
                                                {
                                                    NSString* nsTmpPhoneStr = nil;
                                                    nsTmpPhoneStr = [NSString stringWithFormat:@"=\"%@\"",nsOneFieldDataText];
                                                    
                                                    nsOneFieldDataText = nsTmpPhoneStr;
                                                }
                                                tmpRange = [fieldKey rangeOfString:@"KPPCSV_CDL1_UnifiedBusinessNo"];
                                                if(tmpRange.location != NSNotFound)
                                                {
                                                    NSString* nsTmpUnifiedBusinessNoStr = nil;
                                                    nsTmpUnifiedBusinessNoStr = [NSString stringWithFormat:@"=\"%@\"",nsOneFieldDataText];
                                                    
                                                    nsOneFieldDataText = nsTmpUnifiedBusinessNoStr;
                                                }

                                            }
                                            
                                            [nsMutableOneFieldDataText appendString:nsOneFieldDataText];
                                            
                                            if([fieldKey isEqualToString:KPPCSV_CDL1_Note] == YES)
                                            {
                                                if([nsMutableAdditionalNote length] > 0)
                                                {
                                                    if([nsMutableOneFieldDataText length] > 0)
                                                    {
                                                        [nsMutableOneFieldDataText appendString:@"\n"];
                                                    }
                                                    [nsMutableOneFieldDataText appendString:nsMutableAdditionalNote];
                                                }
                                                
                                            }
                                            [mutableResultArray addObject:nsMutableOneFieldDataText];
                                        }
                                        else
                                        {
                                            //-------------------------------------------
                                            //  例外處理, csv有對齊上的問題要注意,
                                            //  因此不管有沒有取得顯示名稱, 都要加入一個item, 
                                            //  才不會產生無法對齊的問題
                                            //-------------------------------------------
                                            [nsMutableOneFieldDataText release];
                                            nsMutableOneFieldDataText = [[NSMutableString alloc]init];
                                            if(nsMutableOneFieldDataText)
                                            {
                                                if([fieldKey isEqualToString:KPPCSV_CDL1_Note] == YES)
                                                {
                                                    if([nsMutableAdditionalNote length] > 0)
                                                    {
                                                        if([nsMutableOneFieldDataText length] > 0)
                                                        {
                                                            [nsMutableOneFieldDataText appendString:@"\n"];
                                                        }
                                                        [nsMutableOneFieldDataText appendString:nsMutableAdditionalNote];
                                                    }
                                                    
                                                }
                                                
                                                [mutableResultArray addObject:nsMutableOneFieldDataText];
                                                
                                                [nsMutableOneFieldDataText release];
                                                nsMutableOneFieldDataText = nil;
                                            }
                                        }
                                        
                                        [nsMutableOneFieldDataText release];
                                        nsMutableOneFieldDataText = nil;
                                    }
                                }
                                else
                                {
                                    nsOneFieldDataText = [self pp_getFieldDataWithKey:fieldKey withIndex:j];
                                    
                                    //  取得最後顯示的名稱, 加入結果陣列中
                                    if([nsOneFieldDataText length] > 0)  //    get-rule
                                    {
                                        nsOneAdditionalItem = [[NSMutableString alloc] initWithFormat:@"%@ : %@",nsBaseDisplayName, nsOneFieldDataText];
                                        
                                        if([nsOneAdditionalItem length] > 0)
                                        {
                                            [nsMutableAdditionalNote appendFormat:@"%@\n", nsOneAdditionalItem];
                                        }
                                        [nsOneAdditionalItem release];
                                        nsOneAdditionalItem = nil;

                                    }
                                }
                            }
                        }
                    }
                }
            }
            
            //---------------------------------------
            //  Create Result Array
            //---------------------------------------
            resultArray = [[NSArray alloc]initWithArray:mutableResultArray copyItems:YES];
            
            [nsMutableAdditionalNote release];
            nsMutableAdditionalNote = nil;
        }
        [mutableResultArray release];
        mutableResultArray = nil;
    }
    
    return resultArray;
}







//================================================================================
//
//================================================================================
- (NSString *)fieldDataWithKey:(NSString *)key index:(NSInteger)index
{
    NSString *text = nil;
    NSInteger dataCount = [self pp_getFieldDataCurrentCountWithKey:key];
    
    if(dataCount > 0)
    {
        text = [self pp_getFieldDataWithKey:key withIndex:index];
    }
    
    return text;
}


//================================================================================
// 資料來源：_Documents/Outlok_csv_20160225.xlsx
//================================================================================
- (NSArray *)newOutlookCSVTitleArrayForWriter
{
    NSArray* resultArray = nil;
    PPSystemInfoLanguage language = [PPSystemInfoController language];
    
    //
    // !! 在終端機中執行_Documents目錄下的 "python dumpOutlookTitle.py Outlok_csv_20160225.xlsx"
    //    可印出所有title
    //
    
    switch (language)
    {
        case PPSystemInfoLanguage_ChineseTraditional:
            resultArray = @[@"名字", @"中間名", @"姓氏", @"稱謂", @"公司", @"部門", @"職稱", @"商務 - 街", @"商務 - 市/鎮", @"商務 - 縣/市", @"商務 - 郵遞區號", @"商務 - 國家/地區", @"住家 - 街", @"住家 - 市/鎮", @"住家 - 縣/市", @"住家 - 郵遞區號", @"住家 - 國家/地區", @"其他 - 街", @"其他 - 市/鎮", @"其他 - 縣/市", @"其他 - 郵遞區號", @"其他 - 國家/地區", @"商務傳真", @"商務電話", @"商務電話 2", @"公司代表線", @"住家傳真", @"住家電話", @"住家電話 2", @"行動電話", @"其他電話", @"呼叫器", @"紀念日", @"電子郵件地址", @"電子郵件 2 地址", @"電子郵件 3 地址", @"生日", @"類別", @"記事", @"網頁"];
            break;
            
        case PPSystemInfoLanguage_ChineseSimplified:
            resultArray = @[@"名", @"中间名", @"姓", @"称谓", @"单位", @"部门", @"职务", @"商务地址 街道", @"商务地址 市/县", @"商务地址 省/市/自治区", @"商务地址 邮政编码", @"商务地址 国家/地区", @"住宅地址 街道", @"住宅地址 市/县", @"住宅地址 省/市/自治区", @"住宅地址 邮政编码", @"住宅地址 国家/地区", @"其他地址 街道", @"其他地址 市/县", @"其他地址 省/市/自治区", @"其他地址 邮政编码", @"其他地址 国家/地区", @"商务传真", @"商务电话", @"商务电话 2", @"单位主要电话", @"住宅传真", @"住宅电话", @"住宅电话 2", @"移动电话", @"其他电话", @"寻呼机", @"纪念日", @"电子邮件地址", @"电子邮件 2 地址", @"电子邮件 3 地址", @"生日", @"类别", @"附注", @"网页"];
            break;
            
        case PPSystemInfoLanguage_Japanese:
            resultArray = @[@"名", @"ミドル ネーム", @"姓", @"敬称", @"会社名", @"部署", @"役職", @"番地 (会社)", @"市町村 (会社)", @"都道府県 (会社)", @"郵便番号 (会社)", @"国 (会社)/地域", @"番地 (自宅)", @"市町村 (自宅)", @"都道府県 (自宅)", @"郵便番号 (自宅)", @"国 (自宅)/地域", @"番地 (その他)", @"市町村 (その他)", @"都道府県 (その他)", @"郵便番号 (その他)", @"国 (その他)/地域", @"会社 FAX", @"会社電話", @"会社電話 2", @"会社代表電話", @"自宅 FAX", @"自宅電話", @"自宅電話 2", @"携帯電話", @"その他の電話", @"ポケットベル", @"記念日", @"電子メール アドレス", @"電子メール 2 アドレス", @"電子メール 3 アドレス", @"誕生日", @"分類", @"メモ", @"Web ページ"];
            break;
            
        case PPSystemInfoLanguage_Korean:
            resultArray = @[@"이름", @"중간 이름", @"성", @"호칭(한글)", @"회사", @"부서", @"직함", @"근무지 주소 번지", @"근무지 구/군/시", @"근무지 시/도", @"근무지 우편 번호", @"근무지 국가/지역", @"집 번지", @"집 주소 구/군/시", @"집 주소 시/도", @"집 주소 우편 번호", @"집 주소 국가/지역", @"기타 번지", @"기타 구/군/시", @"기타 시/도", @"기타 우편 번호", @"기타 국가/지역", @"근무지 팩스", @"근무처 전화", @"근무처 전화 2", @"회사 대표 전화", @"집 팩스", @"집 전화 번호", @"집 전화 2", @"휴대폰", @"기타 전화", @"호출기", @"결혼 기념일", @"전자 메일 주소", @"전자 메일 2 주소", @"전자 메일 3 주소", @"생일", @"범주 항목", @"메모", @"웹 페이지"];
            break;
            
        case PPSystemInfoLanguage_French:
            resultArray = @[@"Prénom", @"Deuxième prénom", @"Nom", @"Suffixe", @"Société", @"Service", @"Titre", @"Rue (bureau)", @"Ville (bureau)", @"Dép/Région (bureau)", @"Code postal (bureau)", @"Pays/Région (bureau)", @"Rue (domicile)", @"Ville (domicile)", @"Dép/Région (domicile)", @"Code postal (domicile)", @"Pays/Région (domicile)", @"Rue (autre)", @"Ville (autre)", @"Dép/Région (autre)", @"Code postal (autre)", @"Pays/Région (autre)", @"Télécopie (bureau)", @"Téléphone (bureau)", @"Téléphone 2 (bureau)", @"Téléphone société", @"Télécopie (domicile)", @"Téléphone (domicile)", @"Téléphone 2 (domicile)", @"Tél. mobile", @"Téléphone (autre)", @"Récepteur de radiomessagerie", @"Anniversaire de mariage ou fête", @"Adresse de messagerie", @"Adresse de messagerie", @"Adresse de messagerie", @"Anniversaire", @"Catégories", @"Notes", @"Page web"];
            break;
            
        case PPSystemInfoLanguage_German:
            resultArray = @[@"Vorname", @"Weitere Vornamen", @"Nachname", @"Suffix", @"Firma", @"Abteilung", @"Position", @"Straße geschäftlich", @"Ort geschäftlich", @"Region geschäftlich", @"Postleitzahl geschäftlich", @"Land/Region geschäftlich", @"Straße privat", @"Ort privat", @"Bundesland/Kanton privat", @"Postleitzahl privat", @"Land/Region privat", @"Weitere Straße", @"Weiterer Ort", @"Weiteres/r Bundesland/Kanton", @"Weitere Postleitzahl", @"Weiteres/e Land/Region", @"Fax geschäftlich", @"Telefon geschäftlich", @"Telefon geschäftlich 2", @"Telefon Firma", @"Fax privat", @"Telefon (privat)", @"Telefon (privat 2)", @"Mobiltelefon", @"Weiteres Telefon", @"Pager", @"Jahrestag", @"E-Mail-Adresse", @"E-Mail-Adresse", @"E-Mail-Adresse", @"Geburtstag", @"Kategorien", @"Notizen", @"Webseite"];
            break;
            
        case PPSystemInfoLanguage_Italian:
            resultArray = @[@"Nome", @"Secondo nome", @"Cognome", @"Titolo straniero", @"Società", @"Reparto", @"Posizione", @"Via (uff.)", @"Città (uff.)", @"Provincia (uff.)", @"CAP (uff.)", @"Paese/area geografica (uff.)", @"Via (ab.)", @"Città (ab.)", @"Provincia (ab.)", @"CAP (ab.)", @"Paese/area geografica (ab.)", @"Altra via", @"Altra città", @"Altra provincia", @"Altro CAP", @"Altro paese/area geografica", @"Fax (uff.)", @"Ufficio", @"Ufficio 2", @"Telefono principale società", @"Fax (ab.)", @"Abitazione", @"Abitazione 2", @"Cellulare", @"Altro telefono", @"Cercapersone", @"Anniversario", @"Indirizzo posta elettronica", @"Indirizzo posta elettronica", @"Indirizzo posta elettronica", @"Compleanno", @"Categorie", @"Notes", @"Pagina Web"];
            break;
            
        case PPSystemInfoLanguage_Spanish:
            resultArray = @[@"Nombre", @"Segundo nombre", @"Apellidos", @"Suffix", @"Organización", @"Department", @"Puesto", @"Calle del trabajo", @"Ciudad de trabajo", @"Provincia o estado de trabajo", @"Código postal del trabajo", @"País o región del trabajo", @"Home Street", @"Home City", @"Home State", @"Home Postal Code", @"País o región del domicilio", @"Otra calle", @"Otra ciudad", @"Otra provincia o estado", @"Otro código postal", @"Otro país o región", @"Business Fax", @"Teléfono del trabajo", @"Business Phone 2", @"Número de centralita de la organización", @"Home Fax", @"Particular", @"Home Phone 2", @"Mobile Phone", @"Otro teléfono", @"Pager", @"Anniversary", @"E-mail Address", @"E-mail Address", @"E-mail Address", @"Birthday", @"Categorías", @"Notes", @"Página web"];
            break;
            
        case PPSystemInfoLanguage_Portuguese:
            resultArray = @[@"Primeiro nome", @"Outros nomes/apelidos", @"Apelido", @"Sufixo", @"Empresa", @"Departamento", @"Cargo", @"Rua da empresa", @"Localidade da empresa", @"Distrito da empresa", @"Código postal da empresa", @"País/Região da Empresa", @"Rua da residência", @"Localidade da residência", @"Distrito da residência", @"Código postal da residência", @"País da Residência/Região", @"Rua do outro endereço", @"Localidade do outro endereço", @"Distrito do outro endereço", @"Código postal do outro endereço", @"Outro País/Região", @"Fax da empresa", @"Telefone da empresa", @"2º telefone da empresa", @"Telefone principal da empresa", @"Fax da residência", @"Telefone da residência", @"2º telefone da residência", @"Telemóvel", @"Outro telefone", @"Pager", @"Aniversário", @"Endereço de correio eletrónico", @"Endereço de correio eletrónico", @"Endereço de correio eletrónico", @"Data de nascimento", @"Categorias", @"Notas", @"Página na Web"];
            break;
            
        case PPSystemInfoLanguage_Dutch:
            resultArray = @[@"Voornaam", @"Middelste naam", @"Achternaam", @"Achtervoegsel", @"Bedrijf", @"Afdeling", @"Functie", @"Werkadres, straat", @"Werkadres, plaats", @"Werkadres, provincie", @"Werkadres, postcode", @"Land/regio (werk)", @"Huisadres, straat", @"Huisadres, plaats", @"Huisadres, provincie", @"Huisadres, postcode", @"Land/regio (thuis)", @"Ander adres, straat", @"Ander adres, plaats", @"Ander adres, provincie", @"Ander adres, postcode", @"Land/regio (anders)", @"Fax op werk", @"Telefoon op werk", @"Telefoon op werk 2", @"Hoofdtelefoon bedrijf", @"Fax thuis", @"Telefoon thuis", @"Telefoon thuis 2", @"Mobiele telefoon", @"Andere telefoon", @"Pager", @"Speciale datum", @"E-mailadres", @"E-mailadres", @"E-mailadres", @"Verjaardag", @"Categorieën", @"Notities", @"Webpagina"];
            break;
            
        case PPSystemInfoLanguage_Polish:
            resultArray = @[@"Imiê", @"Drugie imiê", @"Nazwisko", @"Sufiks", @"Firma", @"Dzia³", @"Stanowisko", @"Adres s³u¿bowy - ulica", @"Adres s³u¿bowy - miejscowoœæ", @"Adres s³u¿bowy - województwo", @"Adres s³u¿bowy - kod pocztowy", @"Adres s³u¿bowy - kraj/region", @"Adres domowy - ulica", @"Adres domowy - miejscowoœæ", @"Adres domowy - województwo", @"Adres domowy - kod pocztowy", @"Adres domowy - kraj/region", @"Inny adres - ulica", @"Inny adres - miejscowoœæ", @"Inny adres - województwo", @"Inny adres - kod pocztowy", @"Inny adres - kraj/region", @"Faks s³u¿bowy", @"Telefon s³u¿bowy", @"Telefon s³u¿bowy 2", @"G³ówny telefon do firmy", @"Faks domowy", @"Telefon domowy", @"Telefon domowy 2", @"Telefon komórkowy", @"Inny telefon", @"Pager", @"Rocznica", @"Adres e-mail", @"Adres e-mail", @"Adres e-mail", @"Urodziny", @"Kategorie", @"Notatki", @"Strona sieci Web"];
            break;
            
        case PPSystemInfoLanguage_Turkish:
            resultArray = @[@"Ýlk Adý", @"Ýkinci Adý", @"Soyadý", @"Sonek", @"Þirket", @"Bölüm", @"Ýþ Unvaný", @"Ýþ-Cadde", @"Ýþ-Þehir", @"Ýþ-Bölge", @"Ýþ-Posta Kodu", @"Ýþ-Ülke/Bölge", @"Ev-Cadde", @"Ev-Þehir", @"Ev-Bölge", @"Ev-Posta Kodu", @"Ev-Ülke/Bölge", @"Diðer-Cadde", @"Diðer-Þehir", @"Diðer-Bölge", @"Diðer-Posta Kodu", @"Diðer-Ülke/Bölge", @"Ýþ Faks No", @"Ýþ Telefon No", @"Ýþ Telefonu 2", @"Þirket Santral Telefonu", @"Ev-Faks No", @"Ev Telefonu", @"Ev Telefonu 2", @"Cep Telefonu", @"Diðer Telefon No", @"Çaðrý Cihazý", @"Yýldönümü", @"Elektronik Posta Adresi", @"Elektronik Posta Adresi", @"Elektronik Posta Adresi", @"Doðum günü", @"Kategoriler", @"Notlar", @"Web Sayfasý"];
            break;
            
        case PPSystemInfoLanguage_Arabic:
            resultArray = @[@"Title", @"First Name", @"Middle Name", @"Last Name", @"Suffix", @"Company", @"Department", @"Job Title", @"Business Street", @"Business City", @"Business State", @"Business Postal Code", @"Business Country/Region", @"Home Street", @"Home City", @"Home State", @"Home Postal Code", @"Home Country/Region", @"Other Street", @"Other City", @"Other State", @"Other Postal Code", @"Other Country/Region", @"Business Fax", @"Business Phone", @"Business Phone 2", @"Company Main Phone", @"Home Fax", @"Home Phone", @"Home Phone 2", @"Mobile Phone", @"Other Phone", @"Pager", @"Primary Phone", @"Anniversary", @"E-mail Address", @"E-mail 2 Address", @"E-mail 2 Address", @"Birthday", @"Categories", @"Notes", @"Web Page"];
            break;
            
        default:
            resultArray = @[@"First Name", @"Middle Name", @"Last Name", @"Suffix", @"Company", @"Department", @"Job Title", @"Business Street", @"Business City", @"Business State", @"Business Postal Code", @"Business Country/Region", @"Home Street", @"Home City", @"Home State", @"Home Postal Code", @"Home Country/Region", @"Other Street", @"Other City", @"Other State", @"Other Postal Code", @"Other Country/Region", @"Business Fax", @"Business Phone", @"Business Phone 2", @"Company Main Phone", @"Home Fax", @"Home Phone", @"Home Phone 2", @"Mobile Phone", @"Other Phone", @"Pager", @"Anniversary", @"E-mail Address", @"E-mail 2 Address", @"E-mail 2 Address", @"Birthday", @"Categories", @"Notes", @"Web Page"];
            
            break;
    }
   
    return [resultArray retain];
}


//================================================================================
// 只拿第一筆資料
//================================================================================
- (void)addOutlookFieldDataWithKey:(NSString *)key resultArray:(NSMutableArray *)resultArray
{
    // !! 看目前應該取得哪一筆
    NSInteger usedCount = [self pp_usedCountWithKey:key];

    NSString *text = [self fieldDataWithKey:key index:usedCount];

    if([text length] > 0)
    {
        [resultArray addObject:text];
    }
    else
    {
        [resultArray addObject:@""];
    }
    
    [self pp_setUsedCount:++usedCount withKey:key];
}


//================================================================================
// 資料順序要和newOutlookCSVTitleArrayForWriter回傳的欄位順序相同
//================================================================================
- (NSArray *)newOutlookCSVDataArrayForWriter
{
    if(_mutableDictionary == nil)
        return nil;
    
    if(_mutableFieldKeyArray == nil)
        return nil;
    
    NSMutableArray *resultArray = [[NSMutableArray alloc]init];
    
    if(resultArray)
    {
        NSArray *fieldKeys = nil;
        
        //////////////////////////////////////////////////
        // Name
        
        fieldKeys = @[KPPCSV_CDL1_FirstName, KPPCSV_CDL1_MiddleName, KPPCSV_CDL1_LastName, KPPCSV_CDL1_Suffix];
        
        for(NSString *key in fieldKeys)
        {
            [self addOutlookFieldDataWithKey:key resultArray:resultArray];
        }


        //////////////////////////////////////////////////
        // Company
        
        fieldKeys = @[KPPCSV_CDL1_Company, KPPCSV_CDL1_Department, KPPCSV_CDL1_JobTitle];
        
        for(NSString *key in fieldKeys)
        {
            [self addOutlookFieldDataWithKey:key resultArray:resultArray];
        }

        
        //////////////////////////////////////////////////
        // Address
        
        fieldKeys = @[KPPCSV_CDL1_Address_Work_Street, KPPCSV_CDL1_Address_Work_City, KPPCSV_CDL1_Address_Work_State, KPPCSV_CDL1_Address_Work_ZIP, KPPCSV_CDL1_Address_Work_Country, KPPCSV_CDL1_Address_Home_Street, KPPCSV_CDL1_Address_Home_City, KPPCSV_CDL1_Address_Home_State, KPPCSV_CDL1_Address_Home_ZIP, KPPCSV_CDL1_Address_Home_Country, KPPCSV_CDL1_Address_Other_Street, KPPCSV_CDL1_Address_Other_City, KPPCSV_CDL1_Address_Other_State, KPPCSV_CDL1_Address_Other_ZIP, KPPCSV_CDL1_Address_Other_Country];
        
        for(NSString *key in fieldKeys)
        {
            [self addOutlookFieldDataWithKey:key resultArray:resultArray];
        }
  
        
        //////////////////////////////////////////////////
        // Phone
        
        fieldKeys = @[KPPCSV_CDL1_Phone_WorkFax, KPPCSV_CDL1_Phone_Work, KPPCSV_CDL1_Phone_Work, KPPCSV_CDL1_Phone_Main,
                      KPPCSV_CDL1_Phone_HomeFax, KPPCSV_CDL1_Phone_Home, KPPCSV_CDL1_Phone_Home, KPPCSV_CDL1_Phone_Mobile,
                      KPPCSV_CDL1_Phone_Other, KPPCSV_CDL1_Phone_Pager];
        
        for(NSString *key in fieldKeys)
        {
            [self addOutlookFieldDataWithKey:key resultArray:resultArray];
        }
        
        
        //////////////////////////////////////////////////
        // Anniversary
        
        fieldKeys = @[KPPCSV_CDL1_Date_Anniversary];
        
        for(NSString *key in fieldKeys)
        {
            [self addOutlookFieldDataWithKey:key resultArray:resultArray];
        }

        
        //////////////////////////////////////////////////
        // Email
        
        fieldKeys = @[KPPCSV_CDL1_Email_Work, KPPCSV_CDL1_Email_Home, KPPCSV_CDL1_Email_Other];
        
        for(NSString *key in fieldKeys)
        {
            [self addOutlookFieldDataWithKey:key resultArray:resultArray];
        }
        

        //////////////////////////////////////////////////
        // Birthday
        
        fieldKeys = @[KPPCSV_CDL1_Date_Birthday];
        
        for(NSString *key in fieldKeys)
        {
            [self addOutlookFieldDataWithKey:key resultArray:resultArray];
        }

        
        //////////////////////////////////////////////////
        // Categories (special case)
        
        NSString *groupKey = KPPCSV_CDL1_Group;
        NSMutableString *text = [NSMutableString stringWithString:@""];
        NSInteger dataCount = [self pp_getFieldDataCurrentCountWithKey:groupKey];
        
        for(int i=0; i<dataCount; i++)
        {
            NSString *cur = [self pp_getFieldDataWithKey:groupKey withIndex:i];
            
            if([cur length] > 0)
            {
                if([text length] > 0)
                {
                    [text appendFormat:@";%@", cur];
                }
                else
                {
                    [text appendString:cur];
                }
            }
        }
        
        [resultArray addObject:text];
        
        
        //////////////////////////////////////////////////
        // Note
        
        fieldKeys = @[KPPCSV_CDL1_Note];
        
        for(NSString *key in fieldKeys)
        {
            [self addOutlookFieldDataWithKey:key resultArray:resultArray];
        }

        
        //////////////////////////////////////////////////
        // Web Page
        
        fieldKeys = @[KPPCSV_CDL1_URL_Homepage];
        
        for(NSString *key in fieldKeys)
        {
            [self addOutlookFieldDataWithKey:key resultArray:resultArray];
        }
   }
    
    return resultArray;
}


//================================================================================
// 資料來源：_Documents/google_csv_20160226.csv
//================================================================================
- (NSArray *)newGmailCSVTitleArrayForWriter
{
    NSArray *resultArray = @[@"Given Name", @"Additional Name", @"Family Name", @"Given Name Yomi", @"Family Name Yomi", @"Name Prefix", @"Name Suffix",
                             @"Birthday",
                             @"Event 1 - Type", @"Event 1 - Value", @"Event 2 - Type", @"Event 2 - Value",
                             @"E-mail 1 - Type", @"E-mail 1 - Value", @"E-mail 2 - Type", @"E-mail 2 - Value", @"E-mail 3 - Type", @"E-mail 3 - Value",
                             @"IM 1 - Service", @"IM 1 - Value",
                             @"Organization 1 - Name", @"Organization 1 - Yomi Name", @"Organization 1 - Title", @"Organization 1 - Department",
                             @"Phone 1 - Type", @"Phone 1 - Value", @"Phone 2 - Type", @"Phone 2 - Value", @"Phone 3 - Type", @"Phone 3 - Value", @"Phone 4 - Type", @"Phone 4 - Value", @"Phone 5 - Type", @"Phone 5 - Value", @"Phone 6 - Type", @"Phone 6 - Value", @"Phone 7 - Type", @"Phone 7 - Value", @"Phone 8 - Type", @"Phone 8 - Value", @"Phone 9 - Type", @"Phone 9 - Value", @"Phone 10 - Type", @"Phone 10 - Value",
                             @"Website 1 - Type", @"Website 1 - Value", @"Website 2 - Type", @"Website 2 - Value", @"Website 3 - Type", @"Website 3 - Value", @"Website 4 - Type", @"Website 4 - Value", @"Website 5 - Type", @"Website 5 - Value", @"Website 6 - Type", @"Website 6 - Value",
                             @"Address 1 - Type", @"Address 1 - Street", @"Address 1 - City", @"Address 1 - Region", @"Address 1 - Postal Code", @"Address 1 - Country", @"Address 2 - Type", @"Address 2 - Street", @"Address 2 - City", @"Address 2 - Region", @"Address 2 - Postal Code", @"Address 2 - Country", @"Address 3 - Type", @"Address 3 - Street", @"Address 3 - City", @"Address 3 - Region", @"Address 3 - Postal Code", @"Address 3 - Country",
                             @"Nickname",
                             @"Notes"];
    
    return [resultArray retain];
}


//================================================================================
//
//================================================================================
- (void)addGmailDataWithKey:(NSString *)key onlyFirstField:(BOOL)onlyFirstField resultArray:(NSMutableArray *)resultArray
{
    if([key hasPrefix:@"KPPCSV_"] == YES)
    {
        NSMutableString *text = [NSMutableString stringWithString:@""];
        NSInteger dataCount = [self pp_getFieldDataCurrentCountWithKey:key];
        
        for(int i=0; i<dataCount; i++)
        {
            if(i > 0)
            {
                [text appendString:@" ::: "];
            }
            
            NSString *oneField = [self pp_getFieldDataWithKey:key withIndex:i];
            
            if([oneField length])
            {
                [text appendString:oneField];
            }
            
            if(onlyFirstField == YES)
            {
                break;
            }
        }

        //////////////////////////////////////////////////

        [resultArray addObject:[self gmailValidValueFromOriginalText:text]];

    }
    else
    {
        // 直接寫入
        [resultArray addObject:key];
    }
}


//================================================================================
// 資料順序要和newGmailCSVTitleArrayForWriter相同
//================================================================================
- (NSArray *)newGmailCSVDataArrayForWriter
{
    if(_mutableDictionary == nil)
        return nil;
    
    if(_mutableFieldKeyArray == nil)
        return nil;
    
    NSMutableArray *resultArray = [[NSMutableArray alloc]init];
    
    if(resultArray)
    {
        NSArray *fieldKeys = nil;
        
        //////////////////////////////////////////////////
        // Name (7) - @"Given Name", @"Additional Name", @"Family Name", @"Given Name Yomi", @"Family Name Yomi", @"Name Prefix", @"Name Suffix"
        
        fieldKeys = @[KPPCSV_CDL1_FirstName, KPPCSV_CDL1_MiddleName, KPPCSV_CDL1_LastName, KPPCSV_CDL1_PhoneticFirstName, KPPCSV_CDL1_PhoneticLastName, KPPCSV_CDL1_Prefix, KPPCSV_CDL1_Suffix];
        
        for(NSString *key in fieldKeys)
        {
            [self addGmailDataWithKey:key onlyFirstField:YES resultArray:resultArray];
        }
        
        
        //////////////////////////////////////////////////
        // Birthday (1) - @"Birthday"
        
        fieldKeys = @[KPPCSV_CDL1_Date_Birthday];
        
        for(NSString *key in fieldKeys)
        {
            [self addGmailDataWithKey:key onlyFirstField:YES resultArray:resultArray];
        }
        
        
        //////////////////////////////////////////////////
        // Anniversary (4) - @"Event 1 - Type", @"Event 1 - Value", @"Event 2 - Type", @"Event 2 - Value"
        
        fieldKeys = @[@"Anniversary", KPPCSV_CDL1_Date_Anniversary, @"Other", KPPCSV_CDL1_Date_Other];
        
        for(NSString *key in fieldKeys)
        {
            [self addGmailDataWithKey:key onlyFirstField:NO resultArray:resultArray];
        }
        
        
        //////////////////////////////////////////////////
        // Email (6) - @"E-mail 1 - Type", @"E-mail 1 - Value", @"E-mail 2 - Type", @"E-mail 2 - Value", @"E-mail 3 - Type", @"E-mail 3 - Value"
        
        fieldKeys = @[@"Work", KPPCSV_CDL1_Email_Work, @"Home", KPPCSV_CDL1_Email_Home, @"Other", KPPCSV_CDL1_Email_Other];
        
        for(NSString *key in fieldKeys)
        {
            [self addGmailDataWithKey:key onlyFirstField:NO resultArray:resultArray];
        }
        
        
        //////////////////////////////////////////////////
        // IM (2) - @"IM 1 - Service", @"IM 1 - Value"
        
        fieldKeys = @[KPPCSV_CDL1_IM_GoogleTalk,
                      KPPCSV_CDL1_IM_AIM,
                      KPPCSV_CDL1_IM_Yahoo,
                      KPPCSV_CDL1_IM_Skype,
                      KPPCSV_CDL1_IM_QQ,
                      KPPCSV_CDL1_IM_MSN,
                      KPPCSV_CDL1_IM_ICQ,
                      KPPCSV_CDL1_IM_Jabber,
                      KPPCSV_CDL1_IM_GaduGadu,
                      KPPCSV_CDL1_IM_Other];
        
        NSMutableString *imService = [NSMutableString stringWithString:@""];
        NSMutableString *imValue = [NSMutableString stringWithString:@""];
        
        for(NSString *key in fieldKeys)
        {
            NSString *text = [self fieldDataWithKey:key index:0];
            
            if([text length] > 0)
            {
                if([imService length] > 0)
                {
                    [imService appendString:@" ::: "];
                }
                
                if([imValue length] > 0)
                {
                    [imValue appendString:@" ::: "];
                }
                
                [imService appendString:[self pp_getFieldBaseDisplayNameWithKey:key]];
                [imValue appendString:text];
            }
        }
        
        //////////////////////////////////////////////////
        
        [resultArray addObject:[self gmailValidValueFromOriginalText:imService]];

        [resultArray addObject:[self gmailValidValueFromOriginalText:imValue]];
        
        //////////////////////////////////////////////////
        // Company (4) - @"Organization 1 - Name", @"Organization 1 - Yomi Name", @"Organization 1 - Title", @"Organization 1 - Department"
        
        fieldKeys = @[KPPCSV_CDL1_Company, KPPCSV_CDL1_PhoneticCompany, KPPCSV_CDL1_JobTitle, KPPCSV_CDL1_Department];
        
        for(NSString *key in fieldKeys)
        {
            [self addGmailDataWithKey:key onlyFirstField:YES resultArray:resultArray];
        }
        
        
        //////////////////////////////////////////////////
        // Phone (20) - @"Phone 1 - Type", @"Phone 1 - Value", @"Phone 2 - Type", @"Phone 2 - Value", @"Phone 3 - Type", @"Phone 3 - Value", @"Phone 4 - Type", @"Phone 4 - Value", @"Phone 5 - Type", @"Phone 5 - Value", @"Phone 6 - Type", @"Phone 6 - Value", @"Phone 7 - Type", @"Phone 7 - Value", @"Phone 8 - Type", @"Phone 8 - Value", @"Phone 9 - Type", @"Phone 9 - Value", @"Phone 10 - Type", @"Phone 10 - Value"
        
        fieldKeys = @[@"Work", KPPCSV_CDL1_Phone_Work,
                      @"Home", KPPCSV_CDL1_Phone_Home,
                      @"Work Fax", KPPCSV_CDL1_Phone_WorkFax,
                      @"Home Fax", KPPCSV_CDL1_Phone_HomeFax,
                      @"Mobile", KPPCSV_CDL1_Phone_Mobile,
                      @"iPhone", KPPCSV_CDL1_Phone_iPhone,
                      @"Main", KPPCSV_CDL1_Phone_Main,
                      @"Pager", KPPCSV_CDL1_Phone_Pager,
                      @"Google Voice", KPPCSV_CDL1_Phone_GoogleVoice,
                      @"Other", KPPCSV_CDL1_Phone_Other];
        
        for(NSString *key in fieldKeys)
        {
            [self addGmailDataWithKey:key onlyFirstField:NO resultArray:resultArray];
        }
        
        
        //////////////////////////////////////////////////
        // Web Page (12) - @"Website 1 - Type", @"Website 1 - Value", @"Website 2 - Type", @"Website 2 - Value", @"Website 3 - Type", @"Website 3 - Value", @"Website 4 - Type", @"Website 4 - Value", @"Website 5 - Type", @"Website 5 - Value", @"Website 6 - Type", @"Website 6 - Value"
        
        fieldKeys = @[@"Work", KPPCSV_CDL1_URL_Work,
                      @"Home", KPPCSV_CDL1_URL_Home,
                      @"Homepage", KPPCSV_CDL1_URL_Homepage,
                      @"Blog", KPPCSV_CDL1_URL_Blog,
                      @"Profile", KPPCSV_CDL1_URL_Profile,
                      @"Other", KPPCSV_CDL1_URL_Other];
        
        for(NSString *key in fieldKeys)
        {
            [self addGmailDataWithKey:key onlyFirstField:NO resultArray:resultArray];
        }
        
        
        //////////////////////////////////////////////////
        // Address (18) - @"Address 1 - Type", @"Address 1 - Street", @"Address 1 - City", @"Address 1 - Region", @"Address 1 - Postal Code", @"Address 1 - Country", @"Address 2 - Type", @"Address 2 - Street", @"Address 2 - City", @"Address 2 - Region", @"Address 2 - Postal Code", @"Address 2 - Country", @"Address 3 - Type", @"Address 3 - Street", @"Address 3 - City", @"Address 3 - Region", @"Address 3 - Postal Code", @"Address 3 - Country",
        
        fieldKeys = @[@"Work", KPPCSV_CDL1_Address_Work_Street, KPPCSV_CDL1_Address_Work_City, KPPCSV_CDL1_Address_Work_State, KPPCSV_CDL1_Address_Work_ZIP, KPPCSV_CDL1_Address_Work_Country, @"Home", KPPCSV_CDL1_Address_Home_Street, KPPCSV_CDL1_Address_Home_City, KPPCSV_CDL1_Address_Home_State, KPPCSV_CDL1_Address_Home_ZIP, KPPCSV_CDL1_Address_Home_Country, @"Other", KPPCSV_CDL1_Address_Other_Street, KPPCSV_CDL1_Address_Other_City, KPPCSV_CDL1_Address_Other_State, KPPCSV_CDL1_Address_Other_ZIP, KPPCSV_CDL1_Address_Other_Country];
        
        for(NSString *key in fieldKeys)
        {
            [self addGmailDataWithKey:key onlyFirstField:NO resultArray:resultArray];
        }
        
        
        //////////////////////////////////////////////////
        // Nickname (1) - @"Nickname"
        
        fieldKeys = @[KPPCSV_CDL1_NickName];
        
        for(NSString *key in fieldKeys)
        {
            [self addGmailDataWithKey:key onlyFirstField:YES resultArray:resultArray];
        }
        
        
        //////////////////////////////////////////////////
        // Note (1) - @"Notes"
        
        fieldKeys = @[KPPCSV_CDL1_Note];
        
        for(NSString *key in fieldKeys)
        {
            [self addGmailDataWithKey:key onlyFirstField:YES resultArray:resultArray];
        }
    }
    
    return resultArray;
}


//================================================================================
//
//================================================================================
- (void)enablePhoneticNameField:(BOOL)bEnabled
{
}


@end
