//
//  WCAdvancedSearchViewController.m
//  ADAL
//
//  Created by sanhue on 2018/10/22.
//

#import "WCAdvancedSearchViewController.h"


// Define
#import "NSDate+Format.h"
#import "ContactApperanceDefine.h"
#import "WCAdvancedSearchViewController+ParameterDefine.h"
#import "WCAdvancedSearchViewController+ResourceDefine.h"
#import "PPDateSectionController+ParameterDefine.h"
#import "WCFieldLabelString.h"
#import "WCGroupModel+Tree.h"
#import "WCAppearanceDefine.h"
#import "UIColor+Contact.h"

//View
#import "AdvanceSearchView.h"
#import "PPTableViewCell.h"
#import "SearchPhoneTextFieldTableViewCell.h"
#import "SearchTextFieldTableViewCell.h"
#import "SearchNumberTextFieldTableViewCell.h"
#import "SearchDateAndTimeTextFieldTableViewCell.h"
#import "SearchPicklistChoiceTableViewCell.h"
#import "AdvanceSearchNavigationBarView.h"
#import "PPButton+Factory.h"
#import "SearchOptionTableHeaderView.h"
#import "PPBusyView.h"
#import "PPSectionHeaderView.h"

//Controller
#import "PPSelectItemViewController.h"
#import "PPNavigationController.h"
#import "SearchDateViewController.h"
#import "WCMultiLayerGroupPickerViewController.h"
#import "PPSelectController.h"
#import "WCToastController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCAdvancedSearchViewController Extension

@interface WCAdvancedSearchViewController ()
<
AdvanceSearchViewDelegate,
AdvanceSearchViewDataSource,
AdvanceSearchNavigationBarViewDelegate,
PPPhoneTextFieldTableViewCellDelegate,
PPSelectControllerDelegate,
PPSelectItemViewControllerDelegate,
SearchDateViewControllerDelegate,
SearchOptionTableHeaderViewDelegate
>

@property (nonatomic, assign)            Class                           advancedSearchModelClass;
@property (nonatomic, assign)            BOOL                            keyboardShown;
@property (nonatomic, assign)            CGSize                          keyboardSize;

//@property (nonatomic, retain)            NSMutableArray                 *currentCustomFieldArray;
@property (nonatomic, retain, readwrite, nullable) NSMutableArray                 *currentOptionCategoryArray;

@property (nonatomic, retain, readwrite, nullable) WCAdvancedSearchModel         *currentAdvancedSearchModel;

@property (nonatomic, retain, nullable)            PPBusyView                     *busyView;
@property (nonatomic, retain, readwrite, nullable) AdvanceSearchView              *advanceSearchView;
@property (nonatomic, retain, nullable)            AdvanceSearchNavigationBarView *advanceSearchNavigationBarView;
@property (nonatomic, retain, nullable)            SearchOptionTableHeaderView    *searchOptionTableHeaderView;

@property (nonatomic, retain, nullable)            PPSelectItemViewController *selectItemViewController;
@property (nonatomic, copy, nullable)              WCAdvancedSearchSelectItemCompletion selectItemViewControllerCompletionHandler;

@property (nonatomic, retain, nullable)            PPSelectController         *selectController;
@property (nonatomic, copy, nullable)              WCAdvancedSearchOperatorCompletion selectControllerCompletionHandler;

@property (nonatomic, retain, nullable)            NSArray         *layoutConstraints;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCAdvancedSearchViewController Implementation

@implementation WCAdvancedSearchViewController




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (instancetype)initWithModelClass:(Class)modelClass
{
    self.advancedSearchModelClass = modelClass;
    if (self = [super init])
    {
        _keyboardShown = NO;
        _keyboardSize  = CGSizeZero;
        
        //////////////////////////////////////////////////
        _currentSelectIndexPath     = nil;
        _currentAdvancedSearchModel = [[self.advancedSearchModelClass alloc] init];
        if (self.currentAdvancedSearchModel!=nil)
        {
            [self.currentAdvancedSearchModel.contactInfoConditions addObject:WCAdvancedSearchViewController_NewSearchOption];
            [self.currentAdvancedSearchModel.categoryConditions addObject:WCAdvancedSearchViewController_NewSearchOption];
            [self.currentAdvancedSearchModel.dateConditions addObject:WCAdvancedSearchViewController_NewSearchOption];
        }
        
        _isContainCategory = YES;
        self.currentOptionCategoryArray = [NSMutableArray arrayWithObjects:
                                           @(WCAdvancedSearchViewController_OptionCategory_ContactInfo),
                                           @(WCAdvancedSearchViewController_OptionCategory_Group),
                                           @(WCAdvancedSearchViewController_OptionCategory_Date),nil];

        self.advanceSearchView = [[[AdvanceSearchView alloc] initWithFrame:CGRectZero] autorelease];
        
    }
    return self;
}

//================================================================================
//
//================================================================================
- (instancetype)init
{
    if (self = [self initWithModelClass:[WCAdvancedSearchModel class]])
    {
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.navigationController.delegate = nil;
    self.navigationItem.leftBarButtonItem = nil;
    
    [self.searchOptionTableHeaderView removeFromSuperview];
    self.searchOptionTableHeaderView.delegate = nil;
    self.searchOptionTableHeaderView = nil;
    
    [self.advanceSearchNavigationBarView removeFromSuperview];
    self.advanceSearchNavigationBarView.delegate = nil;
    self.advanceSearchNavigationBarView = nil;
    
    self.busyView = nil;
    self.currentAdvancedSearchModel = nil;
    self.currentOptionCategoryArray = nil;
    self.currentSelectIndexPath = nil;
    
    self.layoutConstraints = nil;
    //////////////////////////////////////////////////
    [_advanceSearchView removeFromSuperview];
    _advanceSearchView.dataSource = nil;
    _advanceSearchView.delegate = nil;
    [_advanceSearchView release];
    _advanceSearchView = nil;
    
    self.selectItemViewControllerCompletionHandler = nil;
    _selectItemViewController.delegate = nil;
    [_selectItemViewController release];
    _selectItemViewController = nil;

    self.selectControllerCompletionHandler = nil;
    _selectController.delegate = nil;
    [_selectController release];
    _selectController = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    [self registerNotifications];
    
    //////////////////////////////////////////////////
    self.advanceSearchNavigationBarView = [[[AdvanceSearchNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds] autorelease];
    if(self.advanceSearchNavigationBarView!=nil)
    {
        self.advanceSearchNavigationBarView.delegate  = self;
        
        //////////////////////////////////////////////////
        //覆蓋NavigationBarView上方列
        if(self.navigationController!=nil)
        {
            UIBarButtonItem *leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:self.advanceSearchNavigationBarView];
            
            if(leftBarButtonItem!=nil)
            {
                self.navigationItem.leftBarButtonItem = leftBarButtonItem;
                [leftBarButtonItem release];
            }
        }
    }
    
    //////////////////////////////////////////////////
    _searchOptionTableHeaderView = [[SearchOptionTableHeaderView alloc] initWithFrame:CGRectZero];
    if (self.searchOptionTableHeaderView!=nil)
    {
        [self.searchOptionTableHeaderView setTranslatesAutoresizingMaskIntoConstraints:NO];
        self.searchOptionTableHeaderView.delegate = self;
        [self.view addSubview:self.searchOptionTableHeaderView];
    }
    
    //////////////////////////////////////////////////
    
    if(self.advanceSearchView!=nil)
    {
        [self.advanceSearchView setTranslatesAutoresizingMaskIntoConstraints:NO];
        self.advanceSearchView.dataSource = self;
        self.advanceSearchView.delegate   = self;
        
        //////////////////////////////////////////////////
        if(self.advanceSearchView.superview==nil)
        {
            [self.view addSubview:self.advanceSearchView];
        }
    }
    [self resetLayoutConstraintsWithKeyboardHeight:0];
}


//================================================================================
//
//================================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    [self.advanceSearchView.advanceSearchTableView endEditing:YES];
    [self unRegisterNotifications];
    //////////////////////////////////////////////////
    [super viewWillDisappear:animated];
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    self.navigationItem.leftBarButtonItem = nil;
    
    [self.searchOptionTableHeaderView removeFromSuperview];
    self.searchOptionTableHeaderView.delegate = nil;
    self.searchOptionTableHeaderView = nil;
    
    [self.advanceSearchNavigationBarView removeFromSuperview];
    self.advanceSearchNavigationBarView.delegate = nil;
    self.advanceSearchNavigationBarView = nil;
    
    //////////////////////////////////////////////////
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - layout constraints


//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraintsWithKeyboardHeight:(CGFloat)keyboardHeight
{
    if(self.advanceSearchView==nil||
       self.searchOptionTableHeaderView==nil)
    {
        
        return;
    }
    
    [self removeLayoutConstraints];
    //////////////////////////////////////////////////
    NSDictionary *views = @{@"advanceSearchView":self.advanceSearchView,
                            @"searchOptionTableHeaderView":self.searchOptionTableHeaderView,
                            @"topLayoutGuide":self.topLayoutGuide,
                            };
    NSDictionary *metrics = @{@"OptionHeaderHeight":@(WCAdvancedSearchViewControllerHeaderViewHeight),
                              @"keyboardHeight":@(keyboardHeight)};
    
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[advanceSearchView]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[searchOptionTableHeaderView]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];

    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[topLayoutGuide][searchOptionTableHeaderView(OptionHeaderHeight)][advanceSearchView]-(keyboardHeight)-|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.layoutConstraints];
        [self.view layoutIfNeeded];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.view removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notification Method

//================================================================================
//
//================================================================================
- (void)keyboardWillShown:(NSNotification *)notification
{
}


//================================================================================
//
//================================================================================
- (void)keyboardWillChangeFrame:(NSNotification *)notification
{
    self.keyboardShown = YES;
    
    //////////////////////////////////////////////////
    NSDictionary* info = [notification userInfo];
    self.keyboardSize  = [[info objectForKey:UIKeyboardFrameEndUserInfoKey] CGRectValue].size;
    
    //////////////////////////////////////////////////
    [self resetLayoutConstraintsWithKeyboardHeight:MIN(self.keyboardSize.width, self.keyboardSize.height)];
   //////////////////////////////////////////////////
    UITableViewCell *cell = [self.advanceSearchView.advanceSearchTableView cellForRowAtIndexPath:self.currentSelectIndexPath];
    
    if(cell!=nil)
    {
        CGRect cellFrame = cell.frame;

        CGFloat height = self.view.bounds.size.height;
        
        height -= MIN(self.keyboardSize.width, self.keyboardSize.height);
        
        //////////////////////////////////////////////////
        CGRect rect = CGRectMake(0, self.advanceSearchView.advanceSearchTableView.contentOffset.y, self.view.bounds.size.width, height);
        
        //////////////////////////////////////////////////
        if (!CGRectContainsPoint(rect, cellFrame.origin))
        {
            __block typeof(self) blockself = self;
            dispatch_async(dispatch_get_main_queue(), ^{
                
                [blockself.advanceSearchView.advanceSearchTableView scrollRectToVisible:cellFrame
                                                                               animated:NO];
            });
            
        }
    }
}


//================================================================================
//
//================================================================================
- (void)keyboardWillHidden:(NSNotification *)notification
{
    self.keyboardShown = NO;
    
    //////////////////////////////////////////////////
    UIEdgeInsets contentInsets = UIEdgeInsetsZero;
    self.advanceSearchView.advanceSearchTableView.contentInset = contentInsets;
    self.advanceSearchView.advanceSearchTableView.scrollIndicatorInsets = contentInsets;
    
    //////////////////////////////////////////////////
    [self resetLayoutConstraintsWithKeyboardHeight:0];
}


//================================================================================
//
//================================================================================
- (void)registerNotifications
{
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWillShown:)
                                                 name:UIKeyboardWillShowNotification
                                               object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWillChangeFrame:)
                                                 name:UIKeyboardWillChangeFrameNotification
                                               object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWillHidden:)
                                                 name:UIKeyboardWillHideNotification
                                               object:nil];
}


//================================================================================
//
//================================================================================
- (void)unRegisterNotifications
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (void)setIsContainCategory:(BOOL)isContainCategory
{
    
    if (isContainCategory==YES)
    {
        if ([self.currentOptionCategoryArray containsObject:@(WCAdvancedSearchViewController_OptionCategory_Group)]==NO)
        {
            [self.currentOptionCategoryArray addObject:@(WCAdvancedSearchViewController_OptionCategory_Group)];
        }
    }
    else
    {
        [self.currentOptionCategoryArray removeObject:@(WCAdvancedSearchViewController_OptionCategory_Group)];
    }
}


//================================================================================
//
//================================================================================
- (void)loadAdvancedSearchModel:(WCAdvancedSearchModel *)advancedSearchModel
{
    WCAdvancedSearchModel *adjustSearchModel = [advancedSearchModel copy];

    //////////////////////////////////////////////////
    if ([adjustSearchModel.contactInfoConditions count]==0)
    {
        [adjustSearchModel.contactInfoConditions addObject:WCAdvancedSearchViewController_NewSearchOption];
    }
    else
    {
        if ([adjustSearchModel.contactInfoConditions count]<WCAdvancedSearchViewController_MaxOptionCount)
        {
            id tempObject = [adjustSearchModel.contactInfoConditions lastObject];
            if ([tempObject isKindOfClass:[WCSearchOptionModel class]]==YES)
            {
                [adjustSearchModel.contactInfoConditions addObject:WCAdvancedSearchViewController_NewSearchOption];
            }
        }
    }
    
    //////////////////////////////////////////////////
    if ([adjustSearchModel.categoryConditions count]==0)
    {
        [adjustSearchModel.categoryConditions addObject:WCAdvancedSearchViewController_NewSearchOption];
    }
    
    //////////////////////////////////////////////////
    if ([adjustSearchModel.dateConditions count]==0)
    {
        [adjustSearchModel.dateConditions addObject:WCAdvancedSearchViewController_NewSearchOption];
    }
    
    //////////////////////////////////////////////////
    self.currentAdvancedSearchModel = adjustSearchModel;
    [adjustSearchModel release];
    
    [self.advanceSearchView.advanceSearchTableView reloadData];
}


//================================================================================
//
//================================================================================
- (PPSectionModel *)fieldSectionModelForSearchOptionCategory:(WCAdvancedSearchViewController_OptionCategory)optionCategory
{
    PPSectionModel *sectionModel = [[[PPSectionModel alloc] init] autorelease];
    
    switch (optionCategory)
    {
        case WCAdvancedSearchViewController_OptionCategory_ContactInfo:
        {
            [sectionModel.rowModels addObject:[PPRowModel rowModelWithRow:WCSearchType_Name
                                                                     text:[self fieldTypeStringFromType:WCSearchType_Name]
                                                               detailText:nil
                                                                   object:nil]];
            [sectionModel.rowModels addObject:[PPRowModel rowModelWithRow:WCSearchType_Company
                                                                     text:[self fieldTypeStringFromType:WCSearchType_Company]
                                                               detailText:nil
                                                                   object:nil]];
            [sectionModel.rowModels addObject:[PPRowModel rowModelWithRow:WCSearchType_Department
                                                                     text:[self fieldTypeStringFromType:WCSearchType_Department]
                                                               detailText:nil
                                                                   object:nil]];
            [sectionModel.rowModels addObject:[PPRowModel rowModelWithRow:WCSearchType_JobTitle
                                                                     text:[self fieldTypeStringFromType:WCSearchType_JobTitle]
                                                               detailText:nil
                                                                   object:nil]];
            [sectionModel.rowModels addObject:[PPRowModel rowModelWithRow:WCSearchType_Phone
                                                                     text:[self fieldTypeStringFromType:WCSearchType_Phone]
                                                               detailText:nil
                                                                   object:nil]];
            [sectionModel.rowModels addObject:[PPRowModel rowModelWithRow:WCSearchType_Address
                                                                     text:[self fieldTypeStringFromType:WCSearchType_Address]
                                                               detailText:nil
                                                                   object:nil]];
            [sectionModel.rowModels addObject:[PPRowModel rowModelWithRow:WCSearchType_Email
                                                                     text:[self fieldTypeStringFromType:WCSearchType_Email]
                                                               detailText:nil
                                                                   object:nil]];
            [sectionModel.rowModels addObject:[PPRowModel rowModelWithRow:WCSearchType_URL
                                                                     text:[self fieldTypeStringFromType:WCSearchType_URL]
                                                               detailText:nil
                                                                   object:nil]];
            [sectionModel.rowModels addObject:[PPRowModel rowModelWithRow:WCSearchType_InstantMessage
                                                                     text:[self fieldTypeStringFromType:WCSearchType_InstantMessage]
                                                               detailText:nil
                                                                   object:nil]];
            [sectionModel.rowModels addObject:[PPRowModel rowModelWithRow:WCSearchType_SocialNetwork
                                                                     text:[self fieldTypeStringFromType:WCSearchType_SocialNetwork]
                                                               detailText:nil
                                                                   object:nil]];
            [sectionModel.rowModels addObject:[PPRowModel rowModelWithRow:WCSearchType_UnifiedBusinessNo
                                                                     text:[self fieldTypeStringFromType:WCSearchType_UnifiedBusinessNo]
                                                               detailText:nil
                                                                   object:nil]];
            [sectionModel.rowModels addObject:[PPRowModel rowModelWithRow:WCSearchType_Note
                                                                     text:[self fieldTypeStringFromType:WCSearchType_Note]
                                                               detailText:nil
                                                                   object:nil]];
            
            break;
        }
        default:
            break;
    }
    
    return sectionModel;
}


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)conditionsWithOptionCategory:(WCAdvancedSearchViewController_OptionCategory)optionCategory
{
    switch (optionCategory)
    {
        case WCAdvancedSearchViewController_OptionCategory_ContactInfo:
        {
            return self.currentAdvancedSearchModel.contactInfoConditions;
        }
        case WCAdvancedSearchViewController_OptionCategory_Group:
        {
            return self.currentAdvancedSearchModel.categoryConditions;
        }
        case WCAdvancedSearchViewController_OptionCategory_Date:
        {
            return self.currentAdvancedSearchModel.dateConditions;
        }
       default:
            return nil;
    }
}
////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Public Utilities


//================================================================================
//
//================================================================================
- (NSString *)fieldTypeStringFromType:(WCSearchType)searchType
{
    // 還要包含暱稱
    switch (searchType)
    {
        case WCSearchType_Name:
            return [WCFieldLabelString labelStringWithType:WCSearchType_Name];
        case WCSearchType_Phone:
            return [WCFieldLabelString labelStringWithType:WCSearchType_Phone];
        case WCSearchType_Company:
            return [WCFieldLabelString labelStringWithType:WCSearchType_Company];
        case WCSearchType_JobTitle:
            return [WCFieldLabelString labelStringWithType:WCSearchType_JobTitle];
        case WCSearchType_Department:
            return [WCFieldLabelString labelStringWithType:WCSearchType_Department];
        case WCSearchType_Address:
            return [WCFieldLabelString labelStringWithType:WCSearchType_Address];
        case WCSearchType_Email:
            return [WCFieldLabelString labelStringWithType:WCSearchType_Email];
        case WCSearchType_URL:
            return [WCFieldLabelString labelStringWithType:WCSearchType_URL];
        case WCSearchType_InstantMessage:
            return [WCFieldLabelString labelStringWithType:WCSearchType_InstantMessage];
        case WCSearchType_SocialNetwork:
            return [WCFieldLabelString labelStringWithType:WCSearchType_SocialNetwork];
        case WCSearchType_Birthday:
            return [WCFieldLabelString labelStringWithType:WCSearchType_Birthday];
        case WCSearchType_Anniversary:
            return [WCFieldLabelString labelStringWithType:WCSearchType_Anniversary];
        case WCSearchType_Note:
            return [WCFieldLabelString labelStringWithType:WCSearchType_Note];
        case WCSearchType_Group:
            return WCCV_MLS_Category;
        case WCSearchType_UnifiedBusinessNo:
            return [WCFieldLabelString labelStringWithType:WCSearchType_UnifiedBusinessNo];
        case WCSearchType_CreateTime:
            return WCCV_MLS_CreateTime;
        case WCSearchType_ModifiedTime:
            return WCCV_MLS_ModifyTime;
        default:
            return nil;
    }
}


//================================================================================
//
//================================================================================
- (BOOL)isAddSearchOptionAtIndexPath:(NSIndexPath *)indexPath
{
    BOOL isAddSearchOption = NO;
    NSMutableArray *currentOptions = nil;
    
    //////////////////////////////////////////////////
    NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:indexPath.section];
    WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
    
    currentOptions = [self conditionsWithOptionCategory:optionCategory];
    
    if (currentOptions==nil)
    {
        return isAddSearchOption;
    }
    //////////////////////////////////////////////////
    // 若非WCSearchOptionModel則是新增條件
    id tempObject = [currentOptions objectAtIndex:indexPath.row];
    if ([tempObject isKindOfClass:[WCSearchOptionModel class]]==NO)
    {
        isAddSearchOption = YES;
    }
    
    //////////////////////////////////////////////////
    return isAddSearchOption;
}


//================================================================================
//
//================================================================================
- (BOOL)addSearchOptionIfNeedWithArray:(NSMutableArray *)categoryArray
{
    BOOL result = NO;
    if (categoryArray.count<WCAdvancedSearchViewController_MaxOptionCount)
    {
        id tempObject = [categoryArray lastObject];
        if ((tempObject==nil) ||
            [tempObject isKindOfClass:[WCSearchOptionModel class]]==YES)
        {
            [categoryArray addObject:WCAdvancedSearchViewController_NewSearchOption];
            result = YES;
        }
    }
    
    return result;
}

//================================================================================
// 清除條件中的 "新增"，並檢查內容是否有錯
//================================================================================
- (WCAdvancedSearchModel *)correctAdvnacedSearchModelWithReturnedErrorFieldTitle:(NSString *__nullable *__nullable)errorFieldTitle
{
    NSString *errorContentTitle = nil;
    WCAdvancedSearchModel *advancedSearchModel = [[[self.advancedSearchModelClass alloc] init] autorelease];
    
    //////////////////////////////////////////////////
    do
    {
        for (id tempModel in self.currentAdvancedSearchModel.contactInfoConditions)
        {
            if ([tempModel isKindOfClass:[WCSearchOptionModel class]]==YES)
            {
                WCSearchOptionModel *contactInfoOption = tempModel;
                
                // 都要有值，才是對的資料
                if ([contactInfoOption.text length]>0)
                {
                    [advancedSearchModel.contactInfoConditions addObject:tempModel];
                }
                else
                {
                    errorContentTitle = [self fieldTypeStringFromType:contactInfoOption.searchType];
                    break;
                }
            }
        }
        
        //////////////////////////////////////////////////
        if ([errorContentTitle length]>0)
        {
            break;
        }
        

        //////////////////////////////////////////////////
        for (id tempModel in self.currentAdvancedSearchModel.categoryConditions)
        {
            if ([tempModel isKindOfClass:[WCSearchOptionModel class]]==YES)
            {
                [advancedSearchModel.categoryConditions addObject:tempModel];
            }
        }
        
        //////////////////////////////////////////////////
        for (id tempModel in self.currentAdvancedSearchModel.dateConditions)
        {
            if ([tempModel isKindOfClass:[WCSearchOptionModel class]]==YES)
            {
                [advancedSearchModel.dateConditions addObject:tempModel];
            }
        }
        

    } while (0);
    
    if([errorContentTitle length]>0)
    {
        if(errorFieldTitle!=NULL)
        {
            *errorFieldTitle = errorContentTitle;
        }
    }
    
    return advancedSearchModel;
}



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - public 介面操作



//==============================================================================
// MARK: 用在單一cell的更新，如 類別，時間，帳號
//==============================================================================
- (void)updateCellWithOptionModel:(WCSearchOptionModel*)optionModel optionCategory:(WCAdvancedSearchViewController_OptionCategory)optionCategory
{
    NSMutableArray *conditions = [self conditionsWithOptionCategory:optionCategory];
    
    if (conditions==nil)
    {
        return;
    }
    
    [conditions removeLastObject];
    
    //////////////////////////////////////////////////
    if(optionModel)
    {
        [conditions addObject:optionModel];
    }
    else
    {
        [conditions addObject:WCAdvancedSearchViewController_NewSearchOption];
    }
    
    //////////////////////////////////////////////////
    [self.advanceSearchView.advanceSearchTableView reloadData];
}


//==============================================================================
// MARK: 用在多cell, 如聯絡資訊，自訂欄位
//==============================================================================
- (void)insertCellWithOptionModel:(WCSearchOptionModel*)optionModel optionCategory:(WCAdvancedSearchViewController_OptionCategory)optionCategory
{
    if(optionModel==nil)
    {
        return ;
    }
    
    //////////////////////////////////////////////////
    NSMutableArray *conditions = [self conditionsWithOptionCategory:optionCategory];
    
    if (conditions==nil)
    {
        return;
    }
    
    // !! 先移除 "add"
    [conditions removeLastObject];
    
    // 加到最後
    [conditions addObject:optionModel];
    
    //////////////////////////////////////////////////
    //!!要檢查是否新增"新增xx"的欄位
    [self addSearchOptionIfNeedWithArray:conditions];
  
    [self.advanceSearchView.advanceSearchTableView reloadData];
}


//==============================================================================
// MARK: 刪除cell
//==============================================================================
- (void)removeCellAtIndexPath:(NSIndexPath *)indexPath
{
    NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:indexPath.section];
    WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
    
    NSMutableArray *conditions = [self conditionsWithOptionCategory:optionCategory];
    
    if (conditions==nil)
    {
        return;
    }
    
    [conditions removeObjectAtIndex:indexPath.row];
    //////////////////////////////////////////////////
    //!!要檢查是否新增"新增xx"的欄位
    [self addSearchOptionIfNeedWithArray:conditions];
    
    [self.advanceSearchView.advanceSearchTableView reloadData];
}


//==============================================================================
// 顯示選取清單介面
//==============================================================================
- (void)showSelectItemViewControllerWithTitle:(NSString *)title
                                    indexPath:(NSIndexPath*)indexPath
                                 sectionModel:(PPSectionModel *)sectionModel
                              completeHandler:(WCAdvancedSearchSelectItemCompletion)completeHandler
{
    if ([sectionModel.rowModels count]==0)
    {
        return ;
    }
    
    self.currentSelectIndexPath = indexPath;
    
    //////////////////////////////////////////////////
    self.selectItemViewController = [[[PPSelectItemViewController alloc] init] autorelease];
    if(self.selectItemViewController!=nil)
    {
        self.selectItemViewControllerCompletionHandler = completeHandler;

        self.selectItemViewController.delegate = self;
        self.selectItemViewController.defaultBarViewStyle = PPBarViewStyle_CenteredAbsolute;
        self.selectItemViewController.tableViewBackgroundColor = [UIColor whiteColor];
        
        self.selectItemViewController.title = title;
        [self.selectItemViewController.ppSectionController.sectionModelsForDefault addObject:sectionModel];
        
        [self.navigationController pushViewController:self.selectItemViewController animated:YES];
    }
}


//==============================================================================
//
//==============================================================================
- (void)showOperatorSelectionWithIndexPath:(NSIndexPath *)indexPath completeHandler:(WCAdvancedSearchOperatorCompletion)completeHandler
{
    self.currentSelectIndexPath = indexPath;
    
    self.selectController = [[[PPSelectController alloc] init] autorelease];
    if(self.selectController!=nil)
    {
        self.selectControllerCompletionHandler = completeHandler;
        self.selectController.delegate = self;
        self.selectController.tableViewCellSelectionStyle = UITableViewCellSelectionStyleNone;
        
        //////////////////////////////////////////////////
        
        self.selectController.sourceItemStringArray = @[WCASVC_MLS_OptionOperatorAnd,WCASVC_MLS_OptionOperatorOr];
        self.selectController.selectedIndex = -1;
        
        [self.selectController showFromViewController:self animated:YES];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AdvanceSearchViewDataSource

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInAdvanceSearchView:(AdvanceSearchView *)advanceSearchView
{
    return self.currentOptionCategoryArray.count;
}


//================================================================================
//
//================================================================================
- (NSInteger)advanceSearchView:(AdvanceSearchView *)advanceSearchView numberOfRowsInSection:(NSInteger)section
{
    NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:section];
    WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
    NSMutableArray *condition = [self conditionsWithOptionCategory:optionCategory];
    return [condition count];
}


//================================================================================
// MARK: 產生Cell欄位
//================================================================================
- (UITableViewCell *)advanceSearchView:(AdvanceSearchView *)advanceSearchView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = nil;
    
    do
    {
        if ([self isAddSearchOptionAtIndexPath:indexPath]==YES)
        {
            cell = [advanceSearchView.advanceSearchTableView dequeueReusableCellWithIdentifier:DefaultCellIdentifier];
            
            //////////////////////////////////////////////////
            if(cell==nil)
            {
                cell = [[[PPTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                               reuseIdentifier:DefaultCellIdentifier] autorelease];
            }
            
            [cell.textLabel setTextColor:WCAppearanceDefine_CellTitleColor];
            //////////////////////////////////////////////////
            NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:indexPath.section];
            WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
            
            switch (optionCategory)
            {
                case WCAdvancedSearchViewController_OptionCategory_ContactInfo:
                {
                    //這邊tableview 是編輯狀態，導致箭號消失
                    cell.editingAccessoryType  = UITableViewCellAccessoryNone;
                    cell.textLabel.text = WCASVC_MLS_OptionOperatorAdd;
                    break;
                }
                default:
                {
                    //這邊tableview 是編輯狀態，導致箭號消失
                    cell.editingAccessoryType  = UITableViewCellAccessoryDisclosureIndicator;
                    cell.textLabel.text = WCASVC_MLS_OptionOperatorEmpty;
                    break;
                }
            }
        }
        else
        {
            NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:indexPath.section];
            WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
            
            switch (optionCategory)
            {
                case WCAdvancedSearchViewController_OptionCategory_ContactInfo:
                {
                    WCSearchOptionModel *currentOptionModel = [self.currentAdvancedSearchModel.contactInfoConditions objectAtIndex:indexPath.row];
                    switch (currentOptionModel.searchType)
                    {
                        case WCSearchType_Phone:
                        case WCSearchType_UnifiedBusinessNo:
                        {
                            cell = [advanceSearchView.advanceSearchTableView dequeueReusableCellWithIdentifier:PhoneTextFieldIdentifier];
                            
                            //////////////////////////////////////////////////
                            if(cell==nil)
                            {
                                cell = [[[SearchPhoneTextFieldTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:PhoneTextFieldIdentifier] autorelease];
                            }
                            
                            //////////////////////////////////////////////////
                            SearchPhoneTextFieldTableViewCell *textFieldCell = (SearchPhoneTextFieldTableViewCell *)cell;
                            [textFieldCell.textLabel setTextColor:WCAppearanceDefine_CellTitleColor];
                            
                            textFieldCell.delegate = self.advanceSearchView;
                            textFieldCell.contactKeyboardToolBarViewDelegate = self.advanceSearchView;
                            textFieldCell.operatorDelegate = self.advanceSearchView;
                            
                            //////////////////////////////////////////////////
                            textFieldCell.ignoreCustomLabelFrame = YES;
                            
                            //////////////////////////////////////////////////
                            textFieldCell.textField.keyboardType = UIKeyboardTypePhonePad;
                            
                            [textFieldCell.textLabel setText:[self fieldTypeStringFromType:currentOptionModel.searchType]];
                            [textFieldCell.textField setText:currentOptionModel.text];
                            
                            //////////////////////////////////////////////////
                            textFieldCell.textField.inputAccessoryView.frame = CGRectMake(0, 0, self.view.bounds.size.width,ContactKeyboardToolBarViewButtonHeight);
                            
                            //////////////////////////////////////////////////
                            if (indexPath.row==0)
                            {
                                textFieldCell.searchOperatorButton.enabled = NO;
                                textFieldCell.directionImageView.hidden = YES;
                                
                                [textFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorFirst maxWidth:0.0];
                            }
                            else
                            {
                                textFieldCell.searchOperatorButton.enabled = YES;
                                textFieldCell.directionImageView.hidden = NO;
                                
                                if (currentOptionModel.searchOperator==WCSearchOperator_OR)
                                {
                                    [textFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorOr maxWidth:0.0];
                                }
                                else
                                {
                                    [textFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorAnd maxWidth:0.0];
                                }
                            }
                            
                            break;
                        }
                        case WCSearchType_Name:
                        case WCSearchType_Company:
                        case WCSearchType_JobTitle:
                        case WCSearchType_Department:
                        case WCSearchType_Address:
                        case WCSearchType_Email:
                        case WCSearchType_URL:
                        case WCSearchType_InstantMessage:
                        case WCSearchType_SocialNetwork:
                        case WCSearchType_Note:
                        {
                            NSString *indentifiler = [NSString stringWithFormat:@"%td",currentOptionModel.searchType];
                            cell = [advanceSearchView.advanceSearchTableView dequeueReusableCellWithIdentifier:[TextFieldTableViewCell stringByAppendingString:indentifiler]];
                            
                            //////////////////////////////////////////////////
                            if(cell==nil)
                            {
                                cell = [[[SearchTextFieldTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:[TextFieldTableViewCell stringByAppendingString:indentifiler]] autorelease];
                            }
                            
                            //////////////////////////////////////////////////
                            SearchTextFieldTableViewCell *textFieldCell = (SearchTextFieldTableViewCell *)cell;
                            [textFieldCell.textLabel setTextColor:WCAppearanceDefine_CellTitleColor];
                            
                            textFieldCell.delegate  = self.advanceSearchView;
                            textFieldCell.contactKeyboardToolBarViewDelegate = self.advanceSearchView;
                            textFieldCell.operatorDelegate = self.advanceSearchView;
                            
                            //////////////////////////////////////////////////
                            textFieldCell.ignoreCustomLabelFrame = YES;
                            
                            //////////////////////////////////////////////////
                            [textFieldCell.textLabel setText:[self fieldTypeStringFromType:currentOptionModel.searchType]];
                            [textFieldCell.textField setText:currentOptionModel.text];
                            
                            //////////////////////////////////////////////////
                            textFieldCell.textField.inputAccessoryView.frame = CGRectMake(0, 0, self.view.bounds.size.width,ContactKeyboardToolBarViewButtonHeight);
                            
                            //////////////////////////////////////////////////
                            if (currentOptionModel.searchType==WCSearchType_Email)
                            {
                                textFieldCell.textField.keyboardType = UIKeyboardTypeEmailAddress;
                                textFieldCell.textField.autocapitalizationType = UITextAutocapitalizationTypeNone;
                            }
                            else
                            {
                                textFieldCell.textField.keyboardType = UIKeyboardTypeDefault;
                                textFieldCell.textField.autocapitalizationType = UITextAutocapitalizationTypeWords;
                            }
                            
                            //////////////////////////////////////////////////
                            if (indexPath.row==0)
                            {
                                textFieldCell.searchOperatorButton.enabled = NO;
                                textFieldCell.directionImageView.hidden = YES;
                                
                                [textFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorFirst maxWidth:0.0];
                            }
                            else
                            {
                                textFieldCell.searchOperatorButton.enabled = YES;
                                textFieldCell.directionImageView.hidden = NO;
                                
                                if (currentOptionModel.searchOperator==WCSearchOperator_OR)
                                {
                                    [textFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorOr maxWidth:0.0];
                                }
                                else
                                {
                                    [textFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorAnd maxWidth:0.0];
                                }
                            }
                            
                            break;
                        }
                        default:
                        {
                            break;
                        }
                    }
                    
                    break;
                }
                case WCAdvancedSearchViewController_OptionCategory_Date:
                {
                    cell = [advanceSearchView.advanceSearchTableView dequeueReusableCellWithIdentifier:[NSString stringWithFormat:@"%td-%td",indexPath.section,indexPath.row]];
                    
                    //////////////////////////////////////////////////
                    if(cell==nil)
                    {
                        cell = [[[PPTableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle
                                                       reuseIdentifier:[NSString stringWithFormat:@"%td-%td",indexPath.section,indexPath.row]] autorelease];
                    }
                    
                    //////////////////////////////////////////////////
                    cell.editingAccessoryType = UITableViewCellAccessoryDisclosureIndicator;
                    [cell.textLabel setTextColor:WCAppearanceDefine_CellTitleColor];
                    
                    WCSearchOptionModel *currentOptionModel = [self.currentAdvancedSearchModel.dateConditions objectAtIndex:indexPath.row];
                    cell.textLabel.text = [self fieldTypeStringFromType:currentOptionModel.searchType];
                    
                    NSDateFormatter *dateFormatter = [[[NSDateFormatter alloc] init] autorelease];
                    [dateFormatter setDateFormat:NSDateFormat_Day];
                    
                    NSString *fromDateString = [dateFormatter stringFromDate:currentOptionModel.fromDate];
                    if (fromDateString==nil)
                    {
                        fromDateString = @"";
                    }
                    
                    NSString *toDateString   = [dateFormatter stringFromDate:currentOptionModel.toDate];
                    if (toDateString==nil)
                    {
                        toDateString = @"";
                    }
                    
                    cell.detailTextLabel.text = [NSString stringWithFormat:@"%@~%@", fromDateString, toDateString];
                    
                    break;
                }
                case WCAdvancedSearchViewController_OptionCategory_Group:
                {
                    cell = [advanceSearchView.advanceSearchTableView dequeueReusableCellWithIdentifier:[NSString stringWithFormat:@"%td-%td",indexPath.section,indexPath.row]];
                    
                    //////////////////////////////////////////////////
                    if(cell==nil)
                    {
                        cell = [[[PPTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                                       reuseIdentifier:[NSString stringWithFormat:@"%td-%td",indexPath.section,indexPath.row]] autorelease];
                    }
                    
                    //////////////////////////////////////////////////
                    cell.editingAccessoryType = UITableViewCellAccessoryDisclosureIndicator;
                    [cell.textLabel setTextColor:WCAppearanceDefine_CellTitleColor];
                    
                    WCSearchOptionModel *currentOptionModel = [self.currentAdvancedSearchModel.categoryConditions objectAtIndex:indexPath.row];
                    cell.textLabel.numberOfLines = 0;
                    cell.textLabel.lineBreakMode = NSLineBreakByWordWrapping;
                    cell.textLabel.text = currentOptionModel.text;
                    cell.textLabel.font = [UIFont systemFontOfSize:WCAdvancedSearchViewControllerTableViewCellCategoryTextFontSize];
                    
                    break;
                }

                default:
                    break;
            }
        }
    } while (0);
    
    return cell;
}


//================================================================================
//
//================================================================================
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath
{
    //////////////////////////////////////////////////
    [self.advanceSearchView.advanceSearchTableView endEditing:YES];
    
    //////////////////////////////////////////////////
    do
    {
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        if(editingStyle==UITableViewCellEditingStyleInsert)
        {
            __block typeof(self) blockSelf = self;
            
            NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:indexPath.section];
            WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
            if(optionCategory==WCAdvancedSearchViewController_OptionCategory_ContactInfo)
            {                
                [self showSelectItemViewControllerWithTitle:WCASVC_MLS_NavigationContactFieldAdd
                                                  indexPath:indexPath
                                               sectionModel:[self fieldSectionModelForSearchOptionCategory:WCAdvancedSearchViewController_OptionCategory_ContactInfo]
                                            completeHandler:^(PPSectionModel * _Nonnull selectedSectionModel, PPRowModel * _Nonnull selectedRowModel)
                 {
                     NSNumber *optionCategoryNumber = [blockSelf.currentOptionCategoryArray objectAtIndex:blockSelf.currentSelectIndexPath.section];
                     WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;

                     if (optionCategory==WCAdvancedSearchViewController_OptionCategory_ContactInfo)
                     {
                         WCSearchOptionModel *optionModel = [WCSearchOptionModel searchOptionModelForAND];
                         if (optionModel!=nil)
                         {
                             optionModel.searchType = selectedRowModel.row;

                             [blockSelf insertCellWithOptionModel:optionModel optionCategory:optionCategory];
                         }
                     }
                 }];
            }
        }
        else if (editingStyle==UITableViewCellEditingStyleDelete)
        {
            __block typeof(self) blockSelf = self;
            dispatch_async(dispatch_get_main_queue(), ^{
                [blockSelf removeCellAtIndexPath:indexPath];
            });
        }
    } while (0);
}


//================================================================================
//
//================================================================================
- (NSString *)advanceSearchView:(AdvanceSearchView *)advanceSearchView titleForHeaderInSection:(NSInteger)section
{
    NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:section];
    WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
    
    switch (optionCategory)
    {
        case WCAdvancedSearchViewController_OptionCategory_ContactInfo:
        {
            return WCASVC_MLS_SectionTitleContact;
        }
        case WCAdvancedSearchViewController_OptionCategory_Group:
        {
            return WCASVC_MLS_SectionTitleCategory;
        }
        case WCAdvancedSearchViewController_OptionCategory_Date:
        {
            return WCASVC_MLS_SectionTitleDate;
        }
        default:
        {
            return @"";
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AdvanceSearchViewDelegate

//================================================================================
//
//================================================================================
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [advanceSearchView.advanceSearchTableView deselectRowAtIndexPath:indexPath animated:NO];
    
    //////////////////////////////////////////////////
    UITableViewCell *cell = [self.advanceSearchView.advanceSearchTableView cellForRowAtIndexPath:indexPath];
    
    NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:indexPath.section];
    WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
    switch (optionCategory)
    {
        case WCAdvancedSearchViewController_OptionCategory_ContactInfo:
        {
            if(cell.editingStyle==UITableViewCellEditingStyleInsert)
            {
                [self advanceSearchView:advanceSearchView commitEditingStyle:UITableViewCellEditingStyleInsert forRowAtIndexPath:indexPath];
            }
            
            break;
        }
        case WCAdvancedSearchViewController_OptionCategory_Group:
        {
            __block typeof(self) blockSelf = self;
            
            self.currentSelectIndexPath = indexPath;
            
            [WCMultiLayerGroupPickerViewController showMultiLayerGroupPickerViewConrollerFromViewController:self
                                                                                                titleString:WCASVC_MLS_NavigationCategoryAdd
                                                                                             multiSelection:YES
                                                                                              showPinButton:NO
                                                                                                  enablePin:NO
                                                                                      checkWhileNoSelection:NO
                                                                                         exclusiveWithOther:NO
                                                                                               forcePresent:NO
                                                                                  requestSourceGroupHandler:^NSArray *(NSError **error){
                                                                                      if (blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(requestGroupListInAdvancedSearchViewController:)]==YES)
                                                                                      {
                                                                                          return [blockSelf.delegate requestGroupListInAdvancedSearchViewController:blockSelf];
                                                                                      }
                                                                                      
                                                                                      return nil;
                                                                                  } requestSelectedGroupHandler:^NSArray *(NSError **error) {
                                                                                      id tempObject = [blockSelf.currentAdvancedSearchModel.categoryConditions firstObject];
                                                                                      if ([tempObject isKindOfClass:[WCSearchOptionModel class]]==YES)
                                                                                      {
                                                                                          NSMutableArray *groupList = nil;
                                                                                          if (blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(requestGroupListInAdvancedSearchViewController:)]==YES)
                                                                                          {
                                                                                              groupList = [blockSelf.delegate requestGroupListInAdvancedSearchViewController:blockSelf];
                                                                                          }
                                                                                          
                                                                                          WCSearchOptionModel *categoryOptionModel = tempObject;
                                                                                          NSMutableArray *geoupSelected = [NSMutableArray array];
                                                                                          for (NSString *groupGuid in categoryOptionModel.groupGuids)
                                                                                          {
                                                                                              for (WCGroupModel *groupModel in groupList)
                                                                                              {
                                                                                                  WCGroupModel *groupModelSelected = [groupModel groupInTreeWithGuid:groupGuid];
                                                                                                  if (groupModelSelected!=nil)
                                                                                                  {
                                                                                                      [geoupSelected addObject:groupModelSelected];
                                                                                                      break;
                                                                                                  }
                                                                                              }
                                                                                          }
                                                                                          
                                                                                          return geoupSelected;
                                                                                      }
                                                                                      else
                                                                                      {
                                                                                          return nil;
                                                                                      }
                                                                                  } requestErrorMessageHandler:^NSString *(NSError *error) {
                                                                                      
                                                                                      //                                                                                      if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:requestErrorMessageForError:)])
                                                                                      //                                                                                      {
                                                                                      //                                                                                          return [self.delegate groupAccessFlowController:self requestErrorMessageForError:error];
                                                                                      //                                                                                      }
                                                                                      return nil;
                                                                                  } selectionHandler:^(NSArray *selectedGroups) {
                                                                                      dispatch_async(dispatch_get_main_queue(), ^{
                                                                                          
                                                                                          WCSearchOptionModel *optionModel = nil;
                                                                                          WCGroupModel *firstObject = [selectedGroups firstObject];
                                                                                          if (firstObject!=nil)
                                                                                          {
                                                                                               optionModel = [WCSearchOptionModel searchOptionModelForAND];
                                                                                              
                                                                                              NSMutableArray *groupIDArray = [NSMutableArray array];
                                                                                              NSMutableArray *groupGUIDArray = [NSMutableArray array];
                                                                                              for (WCGroupModel *groupModel in selectedGroups)
                                                                                              {
                                                                                                  [groupIDArray addObject:[NSString stringWithInteger: groupModel.ID]];
                                                                                                  if(groupModel.guid)
                                                                                                  {
                                                                                                      [groupGUIDArray addObject:groupModel.guid];
                                                                                                  }
                                                                                              }
                                                                                              
                                                                                              optionModel.groupGuids = groupGUIDArray;
                                                                                              optionModel.searchType = WCSearchType_Group;
                                                                                              
                                                                                              //////////////////////////////////////////////////
                                                                                              if (blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(advancedSearchViewController:groupPathSelectedWithGroupIDArray:)]==YES)
                                                                                              {
                                                                                                  optionModel.text = [blockSelf.delegate advancedSearchViewController:blockSelf groupPathSelectedWithGroupIDArray:groupIDArray];
                                                                                              }
                                                                                              [blockSelf updateCellWithOptionModel:optionModel optionCategory:WCAdvancedSearchViewController_OptionCategory_Group];
                                                                                          }

                                                                                      });
                                                                                  } finishHandler:nil];
            break;
        }
        case WCAdvancedSearchViewController_OptionCategory_Date:
        {
            self.currentSelectIndexPath = indexPath;
            
            id tempModel = [self.currentAdvancedSearchModel.dateConditions objectAtIndex:indexPath.row];
            
            SearchDateViewController *searchDateViewController = [[SearchDateViewController alloc] init];
            if(searchDateViewController!=nil)
            {
                searchDateViewController.delegate = self;
                searchDateViewController.dateTypeArray = [NSMutableArray arrayWithObjects:[NSNumber numberWithInteger:WCSearchType_CreateTime],
                                                          [NSNumber numberWithInteger:WCSearchType_ModifiedTime], nil];
                
                if ([tempModel isKindOfClass:[WCSearchOptionModel class]]==YES)
                {
                    //初始化
                    WCSearchOptionModel *currentOptionModel = tempModel;
                    searchDateViewController.currentDateType = currentOptionModel.searchType;
                    searchDateViewController.fromDate = currentOptionModel.fromDate;
                    searchDateViewController.toDate   = currentOptionModel.toDate;
                }
                
                [self.navigationController pushViewController:searchDateViewController animated:YES];
                [searchDateViewController release];
            }
            
            break;
        }
        default:
            break;
    }
    
}


//================================================================================
//
//================================================================================
- (UITableViewCellEditingStyle)advanceSearchView:(AdvanceSearchView *)advanceSearchView editingStyleForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCellEditingStyle currentStyle = UITableViewCellEditingStyleNone;
    
    NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:indexPath.section];
    WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
    switch (optionCategory)
    {
        case WCAdvancedSearchViewController_OptionCategory_ContactInfo:
        {
            if ([self isAddSearchOptionAtIndexPath:indexPath]==YES)
            {
                currentStyle = UITableViewCellEditingStyleInsert;
            }
            else
            {
                currentStyle = UITableViewCellEditingStyleDelete;
            }
            break;
        }
        default:
        {
            if ([self isAddSearchOptionAtIndexPath:indexPath]==NO)
            {
                currentStyle = UITableViewCellEditingStyleDelete;
            }
            
            break;
        }
    }
    
    return currentStyle;
}


//================================================================================
//
//================================================================================
- (CGFloat)advanceSearchView:(AdvanceSearchView *)advanceSearchView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return [self advanceSearchView:advanceSearchView estimatedHeightForRowAtIndexPath:indexPath];
}


//================================================================================
//
//================================================================================
- (CGFloat)advanceSearchView:(AdvanceSearchView *)advanceSearchView estimatedHeightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if ([self isAddSearchOptionAtIndexPath:indexPath]==YES)
    {
        return advanceSearchView.advanceSearchTableView.estimatedRowHeight;
    }
    else
    {
        NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:indexPath.section];
        WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
        switch (optionCategory)
        {
            case WCAdvancedSearchViewController_OptionCategory_ContactInfo:
            {
                return advanceSearchView.advanceSearchTableView.estimatedRowHeight*2;
            }
            case WCAdvancedSearchViewController_OptionCategory_Group:
            {
                WCSearchOptionModel *optionModel = [self.currentAdvancedSearchModel.categoryConditions objectAtIndex:indexPath.row];
                
                NSMutableParagraphStyle *style = [[NSParagraphStyle defaultParagraphStyle] mutableCopy];
                [style setLineBreakMode:NSLineBreakByWordWrapping];
                NSDictionary *attributes = @{NSFontAttributeName:[UIFont systemFontOfSize:WCAdvancedSearchViewControllerTableViewCellCategoryTextFontSize], NSParagraphStyleAttributeName:style};
                [style release];
                
                CGRect boundingRect = [optionModel.text boundingRectWithSize:CGSizeMake(self.view.bounds.size.width-100, 10000)
                                                                     options:NSStringDrawingUsesLineFragmentOrigin
                                                                  attributes:attributes
                                                                     context:nil];
                return boundingRect.size.height+30;
            }
            default:
            {
                return advanceSearchView.advanceSearchTableView.estimatedRowHeight;
            }
        }
    }
}


//================================================================================
// MARK: 鍵盤上方按鈕被點擊
//================================================================================
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView contactEditKeyboardToolBarView:(ContactKeyboardToolBarView *)contactEditKeyboardToolBarView ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case ContactKeyboardToolBarViewButtonTag_HideKeyboard:
        {
            if(self.keyboardShown==YES)
            {
                self.keyboardShown = NO;
                
                //////////////////////////////////////////////////
                [self.view endEditing:YES];
            }
            
            break;
        }
        case ContactKeyboardToolBarViewButtonTag_SwitchInput:
        {
            
            //            typeof(self) blockself = self;
            dispatch_async(dispatch_get_main_queue(), ^{
                //                [blockself switchKeyboardDisplay];
            });
            
            break;
        }
        default:
        {
            break;
        }
    }
}


//================================================================================
//MARK: 上方運算子點選(目前僅聯絡人/自訂)
//================================================================================
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView searchTableViewCellDidClickOperatorButton:(UITableViewCell *)searchTableViewCell
{
    NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:self.currentSelectIndexPath.section];
    WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
    
    NSIndexPath *indexPath= [advanceSearchView.advanceSearchTableView indexPathForCell:searchTableViewCell];
    
    [self showOperatorSelectionWithIndexPath:indexPath completeHandler:^(NSUInteger itemIndex, NSString * _Nonnull itemString) {
        
        NSMutableArray *conditions = [self conditionsWithOptionCategory:optionCategory];
        if([conditions count]>indexPath.row)
        {
            WCSearchOptionModel *currentOptionModel = [conditions objectAtIndex:indexPath.row];
            
            //////////////////////////////////////////////////
            if([itemString isEqualToString:WCASVC_MLS_OptionOperatorAnd]==YES)
            {
                currentOptionModel.searchOperator = WCSearchOperator_AND;
            }
            else
            {
                currentOptionModel.searchOperator = WCSearchOperator_OR;
            }
        }
    }];
}



//================================================================================
//
//================================================================================
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView ppPhoneTextFieldTableViewCellDidEndEditing:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath
{
    NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:indexPath.section];
    WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
    switch (optionCategory)
    {
        case WCAdvancedSearchViewController_OptionCategory_ContactInfo:
        {
            WCSearchOptionModel *currentOptionModel = [self.currentAdvancedSearchModel.contactInfoConditions objectAtIndex:indexPath.row];
            currentOptionModel.text = phoneTextFieldTableViewCell.textField.text;
            
            break;
        }
        default:
            break;
    }
}


//================================================================================
//
//================================================================================
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView ppTextFieldTableViewCellDidEndEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath
{
    NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:indexPath.section];
    WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
    switch (optionCategory)
    {
        case WCAdvancedSearchViewController_OptionCategory_ContactInfo:
        {
            WCSearchOptionModel *currentOptionModel = [self.currentAdvancedSearchModel.contactInfoConditions objectAtIndex:indexPath.row];
            currentOptionModel.text = textFieldTableViewCell.textField.text;
            
            break;
        }

        default:
            break;
    }
}


//================================================================================
//
//================================================================================
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView ppTextFieldTableViewCellDidBeginEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath
{
    if([textFieldTableViewCell isKindOfClass:[SearchDateAndTimeTextFieldTableViewCell class]]==YES)
    {
        // MARK: 日期欄位 Pre Focus
        SearchDateAndTimeTextFieldTableViewCell *dateAndTimeTextFieldTableViewCell = (SearchDateAndTimeTextFieldTableViewCell *)textFieldTableViewCell;
        
        NSString *fromDateString = dateAndTimeTextFieldTableViewCell.textField.text;
        NSString *toDateString = dateAndTimeTextFieldTableViewCell.subTextField.text;
        
        NSString *dateFormat = NSDateFormat_Day;
        CustomRectTextField *currentTextField = dateAndTimeTextFieldTableViewCell.textField;
        
        if ([dateAndTimeTextFieldTableViewCell.subTextField isFirstResponder]==YES)
        {
            // to cell，要設定下限
            currentTextField = dateAndTimeTextFieldTableViewCell.subTextField;
            if ([fromDateString length]>0)
            {
                NSDate *fromDate = [NSDate dateFromString:fromDateString format:NSDateFormat_Day];
                [dateAndTimeTextFieldTableViewCell.datePicker setMinimumDate:fromDate];
                [dateAndTimeTextFieldTableViewCell.datePicker setMaximumDate:nil];
            }
            else
            {
                [dateAndTimeTextFieldTableViewCell.datePicker setMinimumDate:nil];
                [dateAndTimeTextFieldTableViewCell.datePicker setMaximumDate:nil];
            }
            
        }
        else
        {
            // from cell，要設定上限
            if ([toDateString length]>0)
            {
                NSDate *toDate = [NSDate dateFromString:toDateString format:NSDateFormat_Day];
                [dateAndTimeTextFieldTableViewCell.datePicker setMinimumDate:nil];
                [dateAndTimeTextFieldTableViewCell.datePicker setMaximumDate:toDate];
            }
            else
            {
                [dateAndTimeTextFieldTableViewCell.datePicker setMinimumDate:nil];
                [dateAndTimeTextFieldTableViewCell.datePicker setMaximumDate:nil];
            }
            
        }
        
        //給定預設時間字串
        do
        {
            //////////////////////////////////////////////////
            if([currentTextField.text length]>0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            if(dateAndTimeTextFieldTableViewCell.datePicker.datePickerMode==UIDatePickerModeDateAndTime)
            {
                dateFormat = NSDateFormat_Minute;
            }
            
            currentTextField.text = [[NSDate date] stringWithFormat:dateFormat];
        }
        while (0);
        
        //////////////////////////////////////////////////
        [dateAndTimeTextFieldTableViewCell setDatePickerDateWithDateString:currentTextField.text format:dateFormat];
    }
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AdvanceSearchNavigationBarViewDelegate


//================================================================================
//
//================================================================================
- (void)advanceSearchNavigationBarView:(AdvanceSearchNavigationBarView *)advanceSearchNavigationBarView ppButton:(PPButton *)button withControlEvent:(UIControlEvents)event
{
    switch (button.tag)
    {
        case AdvanceSearchNavigationBarViewButtonTag_Search:
        {
            [self.advanceSearchView.advanceSearchTableView endEditing:YES];
            
            //////////////////////////////////////////////////
            NSString *errorContentTitle = nil;
            WCAdvancedSearchModel *correctModel = [self correctAdvnacedSearchModelWithReturnedErrorFieldTitle:&errorContentTitle];
            
            //////////////////////////////////////////////////
            if ([errorContentTitle length]>0)
            {
                __block typeof(self) blockSelf = self;
                dispatch_async(dispatch_get_main_queue(), ^{
                    
                    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@""
                                                                                             message:[NSString stringWithFormat:WCASVC_MLS_ErrorSearchContent, errorContentTitle]
                                                                                      preferredStyle:UIAlertControllerStyleAlert];
                    [alertController addAction:[UIAlertAction actionWithTitle:WCASVC_MLS_Confirm
                                                                        style:UIAlertActionStyleDefault
                                                                      handler:nil]];
                    
                    [blockSelf presentViewController:alertController animated:YES completion:nil];
                });
            }
            else
            {
                if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(advancedSearchViewController:endWithAdvancedSearchModel:)]==YES)
                {
                    [self.delegate advancedSearchViewController:self endWithAdvancedSearchModel:correctModel];
                }
            }
            break;
        }
        case AdvanceSearchNavigationBarViewButtonTag_Cancel:
        default:
        {
            [self goBackAnimated:YES];
            
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPSelectControllerDelegate

//================================================================================
//
//================================================================================
- (void)ppSelectController:(PPSelectController *)selectController itemSelectedIndex:(NSInteger)itemIndex withString:(NSString *)itemString
{
    if(self.selectControllerCompletionHandler)
    {
        self.selectControllerCompletionHandler(itemIndex, itemString);
    }
    
    //////////////////////////////////////////////////
    [self.advanceSearchView.advanceSearchTableView reloadRowsAtIndexPaths:[NSArray arrayWithObject:self.currentSelectIndexPath]
                                                         withRowAnimation:UITableViewRowAnimationAutomatic];
}


//================================================================================
//
//================================================================================
- (void)ppSelectControllerDidDismiss:(PPSelectController *)selectController
{
    self.selectController = nil;
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPSelectItemViewControllerDelegate

//================================================================================
//
//================================================================================
- (void)ppSelectItemViewController:(PPSelectItemViewController *)ppSelectItemViewController selectRowModel:(PPRowModel *)rowModel sectionModel:(PPSectionModel *)sectionModel
{
    if (self.selectItemViewControllerCompletionHandler)
    {
        self.selectItemViewControllerCompletionHandler (sectionModel, rowModel);
    }
    [ppSelectItemViewController goBackAnimated:YES];
}


//================================================================================
//
//================================================================================
- (PPButton *)buttonCloseForSelectItemViewController:(PPSelectItemViewController *)ppSelectItemViewController
{
    PPButton *backButton = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                           tag:0
                                                      delegate:nil
                                         normalBackgroundColor:nil
                                    highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                               imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    return backButton;
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - SearchDateViewControllerDelegate

//================================================================================
//
//================================================================================
- (void)didFinishInSearchDateViewController:(SearchDateViewController *)searchDateViewController
{
    __block typeof(self) blockSelf = self;
    dispatch_async(dispatch_get_main_queue(), ^{
        WCSearchOptionModel *dateOptionModel = nil;
        if(searchDateViewController.fromDate!=nil || searchDateViewController.toDate!=nil)
        {
            dateOptionModel = [WCSearchOptionModel searchOptionModelForAND];
            if (dateOptionModel!=nil)
            {
                dateOptionModel.searchType = searchDateViewController.currentDateType;
                dateOptionModel.fromDate   = searchDateViewController.fromDate;
                dateOptionModel.toDate     = searchDateViewController.toDate;
                
                [blockSelf updateCellWithOptionModel:dateOptionModel optionCategory:WCAdvancedSearchViewController_OptionCategory_Date];
            }
        }
        
    });
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - SearchOptionTableHeaderViewDelegate

//================================================================================
//
//================================================================================
- (void)didClickClearAllButtonInSearchOptionTableHeaderView:(SearchOptionTableHeaderView *)searchOptionTableHeaderView
{
    [self.advanceSearchView.advanceSearchTableView endEditing:YES];
    
    WCAdvancedSearchModel *newSearchModel = [[[self.advancedSearchModelClass alloc] init] autorelease];
    
    [self loadAdvancedSearchModel:newSearchModel];
}

@end
