//
//  AdvanceSearchNavigationBarView.m
//  Extension
//
//  Created by AndrewLai on 2018/3/29.
//

#import "AdvanceSearchNavigationBarView.h"

// Define
#import "WCAppearanceDefine.h"
#import "WCAdvancedSearchViewController+ResourceDefine.h"

// Category
#import "PPButton+Factory.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation AdvanceSearchNavigationBarView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    
    self.style = PPBarViewStyle_CenteredAbsolute;
    
    //////////////////////////////////////////////////
    self.backgroundColor = [UIColor clearColor];
    
    //////////////////////////////////////////////////
    self.backgroundImageView.image = nil;
    
    //////////////////////////////////////////////////
    [self.titleLabel setText:WCASVC_MLS_NavigationAdvanceSearchTitle];
    
    _cancelButton = [[PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                     tag:AdvanceSearchNavigationBarViewButtonTag_Cancel
                                                delegate:self
                                   normalBackgroundColor:nil
                              highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                         imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset] retain];
    if(_cancelButton!=nil)
    {
        [_cancelButton addControlEvents:UIControlEventTouchUpInside];
        
        //////////////////////////////////////////////////
        PPBarViewItemModel *itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_cancelButton];
        
        if(itemModel!=nil)
        {
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
        }
    }
    
    //////////////////////////////////////////////////
    _searchButton = [[PPButton ppButtonWithIconImageName:nil
                                                     tag:AdvanceSearchNavigationBarViewButtonTag_Search
                                                delegate:self
                                   normalBackgroundColor:nil
                              highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                         imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset] retain];
    if(_searchButton!=nil)
    {
        [_searchButton setTitle:WCASVC_MLS_NavigationButtonTitleSearch maxWidth:0];
        [_searchButton addControlEvents:UIControlEventTouchUpInside];
        
        //////////////////////////////////////////////////
        PPBarViewItemModel *searchButtonItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_searchButton];
        
        if(searchButtonItemModel!=nil)
        {
            searchButtonItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self setItemModels:@[searchButtonItemModel] forBlockType:PPBarViewBlockType_Right];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_cancelButton removeFromSuperview];
    [_cancelButton release];
    _cancelButton = nil;
    
    [_searchButton removeFromSuperview];
    [_searchButton release];
    _searchButton = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if([self.delegate respondsToSelector:@selector(advanceSearchNavigationBarView:ppButton:withControlEvent:)]==YES)
    {
        [self.delegate advanceSearchNavigationBarView:self ppButton:ppButton withControlEvent:controlEvent];
    }
}

@end
