//
//  WCABGroupNavigationBarView.m
//
//
//  Created by Howard.Lin on 2014/3/26.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "WCABGroupNavigationBarView.h"
#import "WCABItemSelectFlowController+ResourceDefine.h"
#import "NSString+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCABGroupNavigationBarView()
{
    PPButton *backButton_;
}
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCABGroupNavigationBarView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
 backButton = backButton_;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    if(self = [super initWithFrame:frame])
    {
        self.style = PPBarViewStyle_CenteredAbsolute;
        
        self.titleLabel.text = WCAIS_MLS_IphoneContact;
        
        //////////////////////////////////////////////////
        
        backButton_ = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
        
        if(backButton_!=nil)
        {
            [backButton_ setTag:WCABGroupNavigationBarViewButtonTag_Back];
            [self setViews:[NSArray arrayWithObject:backButton_] forBlockType:PPBarViewBlockType_Left];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [backButton_ setDelegate:nil];
    [backButton_ removeControlEvents:UIControlEventAllEvents];
    
    [backButton_ removeFromSuperview];
    [backButton_ release];
    backButton_ = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}

@end
