//
//  PPZipController.m
//


#import "PPZipController.h"

// Third Party
#if defined (USE_SSZipArchive) ||defined (USE_ZipArchive)
#import "ZipArchive.h"
#endif


NSString * const PPZipController_CombineSymbol = @"<++>";
BOOL g_cancel;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation PPZipController

@implementation PPZipController





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//===============================================================================
//
//===============================================================================
+ (double)contentSizeWithSrcDir:(NSString *)srcDir excludeDirPatterns:(NSArray *)excludeDirPatterns
{
    double contentSize = 0;
    
    @autoreleasepool
    {
        do
        {
            NSFileManager *fileManager = [NSFileManager defaultManager];
            NSDirectoryEnumerator *dirEnum = [fileManager enumeratorAtPath:srcDir];
            NSString *file;
            NSString *fullPath;
            NSArray *dirArray;
            NSString *normalizedSrcDir = srcDir;
            
            if([normalizedSrcDir hasSuffix:@"/"] == YES)
            {
                normalizedSrcDir = [normalizedSrcDir substringToIndex:[normalizedSrcDir length]-1];
            }
            
            while (file = [dirEnum nextObject])
            {
                @autoreleasepool
                {
                    BOOL isDir = NO;
                    
                    fullPath = [NSString stringWithFormat:@"%@/%@", normalizedSrcDir, file];
                    [fileManager fileExistsAtPath:fullPath isDirectory:&isDir];
                    dirArray = [file pathComponents];
                    
                    
                    //////////////////////////////////////////////////
                    // 檢查是否是要濾除的目錄
                    
                    NSString *checkDir = nil;
                    
                    if(isDir == YES)
                    {
                        checkDir = [dirArray lastObject];
                    }
                    else if([dirArray count] >= 2)
                    {
                        checkDir = [dirArray objectAtIndex:[dirArray count]-2];
                    }
                    
                    if(checkDir != nil)
                    {
                        BOOL isExcluded = NO;
                        
                        for(NSString *pattern in excludeDirPatterns)
                        {
                            NSRange range = [checkDir rangeOfString:pattern options:NSCaseInsensitiveSearch];
                            
                            if(range.length > 0)
                            {
                                isExcluded = YES;
                                break;
                            }
                        }
                        
                        if(isExcluded == YES)
                        {
                            continue;
                        }
                    }
                    
                    
                    //////////////////////////////////////////////////
                    // 加入要壓縮的檔案
                    
                    if(!isDir && ![[dirArray lastObject] hasPrefix:@"."])
                    {
                        NSDictionary *fileAttrDict = [fileManager attributesOfItemAtPath:fullPath error:nil];
                        
                        contentSize += [fileAttrDict fileSize];
                    }
                } // end of @autoreleasepool
            }
        }
        while(0);
    }
    
    return contentSize;
}


//===============================================================================
//
//===============================================================================
+ (BOOL)zipWithSrcDir:(NSString *)srcDir excludeDirPatterns:(NSArray *)excludeDirPatterns dstFile:(NSString *)dstFile password:(NSString *)password
{
    return [self zipWithSrcDir:srcDir
            excludeDirPatterns:excludeDirPatterns
                       dstFile:dstFile
                      password:password
               progressHandler:nil];
}


//===============================================================================
//
//===============================================================================
+ (BOOL)zipWithSrcDir:(NSString *)srcDir
   excludeDirPatterns:(NSArray *)excludeDirPatterns
              dstFile:(NSString *)dstFile
             password:(NSString *)password
      progressHandler:(PPZipControllerProgressHandler)progressHandler
{
#if defined (USE_SSZipArchive) &&  defined (USE_ZipArchive)
    NSAssert(NO, @"同時安裝了SSZipArchive與ZipArchive會造成問題，請檢查並移除其中一個");
#endif

    BOOL result = NO;
    
    g_cancel = NO;
    
    @autoreleasepool
    {
        
#if defined (USE_SSZipArchive)
        SSZipArchive *zipArchive = [[SSZipArchive alloc] initWithPath:dstFile];
        
        do
        {
            if ([zipArchive open]==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSFileManager *fileManager = [NSFileManager defaultManager];
            NSDirectoryEnumerator *dirEnum = [fileManager enumeratorAtPath:srcDir];
            NSString *file;
            NSString *newFileName;
            NSString *fullPath;
            NSArray *dirArray;
            NSString *normalizedSrcDir = srcDir;
            double totalSize = [self contentSizeWithSrcDir:srcDir excludeDirPatterns:excludeDirPatterns];
            double zippedSize = 0;
            
            if([normalizedSrcDir hasSuffix:@"/"] == YES)
            {
                normalizedSrcDir = [normalizedSrcDir substringToIndex:[normalizedSrcDir length]-1];
            }
            
            if (progressHandler)
            {
                progressHandler(0.0);
            }
            
            while ((file = [dirEnum nextObject]) != nil && g_cancel == NO)
            {
                @autoreleasepool
                {
                    BOOL isDir = NO;
                    
                    fullPath = [NSString stringWithFormat:@"%@/%@", normalizedSrcDir, file];
                    [fileManager fileExistsAtPath:fullPath isDirectory:&isDir];
                    dirArray = [file pathComponents];
                    
                    
                    //////////////////////////////////////////////////
                    // 檢查是否是要濾除的目錄
                    
                    NSString *checkDir = nil;
                    
                    if(isDir == YES)
                    {
                        checkDir = [dirArray lastObject];
                    }
                    else if([dirArray count] >= 2)
                    {
                        checkDir = [dirArray objectAtIndex:[dirArray count]-2];
                    }
                    
                    if(checkDir != nil)
                    {
                        BOOL isExcluded = NO;
                        
                        for(NSString *pattern in excludeDirPatterns)
                        {
                            //                            NSLog(@"checkDir:%@ pattern:%@", checkDir, pattern);
                            
                            NSRange range = [checkDir rangeOfString:pattern options:NSCaseInsensitiveSearch];
                            
                            if(range.length > 0)
                            {
                                isExcluded = YES;
                                break;
                            }
                        }
                        
                        if(isExcluded == YES)
                        {
                            continue;
                        }
                    }
                    
                    
                    //////////////////////////////////////////////////
                    // 加入要壓縮的檔案
                    
                    if(!isDir && ![[dirArray lastObject] hasPrefix:@"."])
                    {
                        newFileName = [file stringByReplacingOccurrencesOfString:@"/"
                                                                      withString:PPZipController_CombineSymbol];
                        
                        [zipArchive writeFileAtPath:fullPath
                                       withFileName:newFileName
                                   compressionLevel:-1
                                           password:password
                                                AES:NO];
                        
                        //////////////////////////////////////////////////
                        
                        NSDictionary *fileAttrDict = [fileManager attributesOfItemAtPath:fullPath error:nil];
                        zippedSize += [fileAttrDict fileSize];
                        
                    }
                    
                    //////////////////////////////////////////////////
                    if (progressHandler)
                    {
                        progressHandler((CGFloat)(zippedSize/totalSize));
                    }
                    
                } // end of @autoreleasepool
            }
            
            result = [zipArchive close];
            
            if(g_cancel == YES)
            {
                result = NO;
            }
        }
        while(0);
        
        [zipArchive release];
        
#elif defined (USE_ZipArchive)
        ZipArchive *zipArchive = [[ZipArchive alloc] init];
        
        do
        {
            if([zipArchive CreateZipFile2:dstFile Password:password] == NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSFileManager *fileManager = [NSFileManager defaultManager];
            NSDirectoryEnumerator *dirEnum = [fileManager enumeratorAtPath:srcDir];
            NSString *file;
            NSString *newFileName;
            NSString *fullPath;
            NSArray *dirArray;
            NSString *normalizedSrcDir = srcDir;
            double totalSize = [self contentSizeWithSrcDir:srcDir excludeDirPatterns:excludeDirPatterns];
            double zippedSize = 0;
            
            if([normalizedSrcDir hasSuffix:@"/"] == YES)
            {
                normalizedSrcDir = [normalizedSrcDir substringToIndex:[normalizedSrcDir length]-1];
            }
            
            if (progressHandler)
            {
                progressHandler(0.0);
            }
            
            while ((file = [dirEnum nextObject]) != nil && g_cancel == NO)
            {
                @autoreleasepool
                {
                    BOOL isDir = NO;
                    
                    fullPath = [NSString stringWithFormat:@"%@/%@", normalizedSrcDir, file];
                    [fileManager fileExistsAtPath:fullPath isDirectory:&isDir];
                    dirArray = [file pathComponents];
                    
                    
                    //////////////////////////////////////////////////
                    // 檢查是否是要濾除的目錄
                    
                    NSString *checkDir = nil;
                    
                    if(isDir == YES)
                    {
                        checkDir = [dirArray lastObject];
                    }
                    else if([dirArray count] >= 2)
                    {
                        checkDir = [dirArray objectAtIndex:[dirArray count]-2];
                    }
                    
                    if(checkDir != nil)
                    {
                        BOOL isExcluded = NO;
                        
                        for(NSString *pattern in excludeDirPatterns)
                        {
                            //                            NSLog(@"checkDir:%@ pattern:%@", checkDir, pattern);
                            
                            NSRange range = [checkDir rangeOfString:pattern options:NSCaseInsensitiveSearch];
                            
                            if(range.length > 0)
                            {
                                isExcluded = YES;
                                break;
                            }
                        }
                        
                        if(isExcluded == YES)
                        {
                            continue;
                        }
                    }
                    
                    
                    //////////////////////////////////////////////////
                    // 加入要壓縮的檔案
                    
                    if(!isDir && ![[dirArray lastObject] hasPrefix:@"."])
                    {
                        newFileName = [file stringByReplacingOccurrencesOfString:@"/"
                                                                      withString:PPZipController_CombineSymbol];
                        
                        [zipArchive addFileToZip:fullPath newname:newFileName];
                        
                        //////////////////////////////////////////////////
                        
                        NSDictionary *fileAttrDict = [fileManager attributesOfItemAtPath:fullPath error:nil];
                        zippedSize += [fileAttrDict fileSize];
                        
                    }
                    
                    //////////////////////////////////////////////////
                    if (progressHandler)
                    {
                        progressHandler((CGFloat)(zippedSize/totalSize));
                    }
                    
                } // end of @autoreleasepool
            }
            
            result = [zipArchive CloseZipFile2];
            
            if(g_cancel == YES)
            {
                result = NO;
            }
        }
        while(0);
        
        [zipArchive release];
#else
        NSAssert(NO, @"使用PPZipController，需在podfile中指定 PPZipController/SSZipArchive 或 PPZipController/ZipArchive");
#endif
        if (progressHandler != nil && g_cancel == NO)
        {
            progressHandler(1.0);
        }
    }
    
    return result;
}


//===============================================================================
//
//===============================================================================
+ (NSError *)unzipWithSrcFile:(NSString *)srcFile
                       dstDir:(NSString *)dstDir
                     password:(NSString *)password
{
    return [self unzipWithSrcFile:srcFile
                           dstDir:dstDir
                         password:password
                  progressHandler:nil];
}

//===============================================================================
//
//===============================================================================
+ (NSError *)unzipWithSrcFile:(NSString *)srcFile
                       dstDir:(NSString *)dstDir
                     password:(NSString *)password
              progressHandler:(PPZipControllerProgressHandler)progressHandler
{
    NSError *error = nil;

    @autoreleasepool
    {
        NSFileManager *fileManager = [NSFileManager defaultManager];
#if defined (USE_SSZipArchive) &&  defined (USE_ZipArchive)
        NSAssert(NO, @"同時安裝了SSZipArchive與ZipArchive會造成問題，請檢查並移除其中一個");
#endif
        
#if defined (USE_SSZipArchive)
                
        //////////////////////////////////////////////////
        [SSZipArchive unzipFileAtPath:srcFile
                        toDestination:dstDir
                            overwrite:YES
                             password:password
                      progressHandler:^(NSString * _Nonnull entry, unz_file_info zipInfo, long entryNumber, long total) {
            if (progressHandler)
            {
                progressHandler(0.5 * ((CGFloat)entryNumber/total/100.0));
            }
        } completionHandler:^(NSString * _Nonnull path, BOOL succeeded, NSError * _Nullable error) {
            
            NSFileManager *fileManager = [NSFileManager defaultManager];
            NSDirectoryEnumerator *dirEnum = [fileManager enumeratorAtPath:dstDir];
            NSString *file = nil;
            
            CGFloat numberOfFiles = [[fileManager subpathsAtPath:dstDir] count];
            CGFloat numberOfMovedFile = 0;
            
            while (file = [dirEnum nextObject])
            {
                @autoreleasepool
                {
                    //////////////////////////////////////////////////
                    // make dir tree
                    
                    NSString *convertFilePath = [file stringByReplacingOccurrencesOfString:PPZipController_CombineSymbol
                                                                                withString:@"/"];
                    
                    NSArray *dirArray = [convertFilePath componentsSeparatedByString:@"/"];
                    NSMutableString *checkDir = [[[NSMutableString alloc] initWithString:dstDir] autorelease];
                    NSInteger dirCount = [dirArray count]-1; // last component is file name, ignore
                    
                    for(NSInteger i=0; i<dirCount; i++)
                    {
                        [checkDir appendFormat:@"/%@", [dirArray objectAtIndex:i]];
                        
                        if([fileManager fileExistsAtPath:checkDir] == NO)
                        {
                            [fileManager createDirectoryAtPath:checkDir
                                   withIntermediateDirectories:YES
                                                    attributes:nil
                                                         error:&error];
                            
                            if(error != nil)
                            {
                                break;
                            }
                        }
                    }
                    
                    if(error != nil)
                    {
                        [error retain];
                        break;
                    }
                    
                    
                    //////////////////////////////////////////////////
                    // move file
                    
                    if(dirCount > 0)
                    {
                        NSString *curFilePath = [NSString stringWithFormat:@"%@/%@", dstDir, file];
                        NSString *moveFilePath = [NSString stringWithFormat:@"%@/%@", dstDir, convertFilePath];
                        
                        if([curFilePath isEqualToString:moveFilePath] == NO &&
                           [fileManager moveItemAtPath:curFilePath toPath:moveFilePath error:&error] == NO)
                        {
                            [error retain];
                            break;
                        }
                        
                        numberOfMovedFile ++;
                    }
                    
                    
                    if (progressHandler)
                    {
                        progressHandler(0.5 + 0.5 * (numberOfMovedFile/numberOfFiles));
                    }
                    
                } // end of @autoreleasepool
            }
        }];
        
#elif defined (USE_ZipArchive)
        
        ZipArchive *zipArchive = [[ZipArchive alloc] init];
        BOOL isFileOpened = NO;
        
        do
        {
            if(zipArchive == nil)
            {
                break;
            }
            
            if (progressHandler)
            {
                zipArchive.progressBlock = ^(int percentage, int filesProcessed, unsigned long numFiles){
                    progressHandler(0.5 * ((CGFloat)percentage/100.0));
                };
            }
            //////////////////////////////////////////////////
            // unzip backup file
            
            if([zipArchive UnzipOpenFile:srcFile Password:password] == NO)
            {
                break;
            }
            
            isFileOpened = YES;
            
            if (progressHandler)
            {
                progressHandler(0.0);
            }
            
            if([zipArchive UnzipFileTo:dstDir overWrite:YES] == NO)
            {
                break;
            }
            
            [zipArchive UnzipCloseFile];
            
            
            isFileOpened = NO;
            
            
            //////////////////////////////////////////////////
            
            NSDirectoryEnumerator *dirEnum = [fileManager enumeratorAtPath:dstDir];
            NSString *file = nil;
            
            CGFloat numberOfFiles = [[fileManager subpathsAtPath:dstDir] count];
            CGFloat numberOfMovedFile = 0;
            
            while (file = [dirEnum nextObject])
            {
                @autoreleasepool
                {
                    //////////////////////////////////////////////////
                    // make dir tree
                    
                    NSString *convertFilePath = [file stringByReplacingOccurrencesOfString:PPZipController_CombineSymbol
                                                                                withString:@"/"];
                    
                    NSArray *dirArray = [convertFilePath componentsSeparatedByString:@"/"];
                    NSMutableString *checkDir = [[[NSMutableString alloc] initWithString:dstDir] autorelease];
                    NSInteger dirCount = [dirArray count]-1; // last component is file name, ignore
                    
                    for(NSInteger i=0; i<dirCount; i++)
                    {
                        [checkDir appendFormat:@"/%@", [dirArray objectAtIndex:i]];
                        
                        if([fileManager fileExistsAtPath:checkDir] == NO)
                        {
                            [fileManager createDirectoryAtPath:checkDir
                                   withIntermediateDirectories:YES
                                                    attributes:nil
                                                         error:&error];
                            
                            if(error != nil)
                            {
                                break;
                            }
                        }
                    }
                    
                    if(error != nil)
                    {
                        [error retain];
                        break;
                    }
                    
                    
                    //////////////////////////////////////////////////
                    // move file
                    
                    if(dirCount > 0)
                    {
                        NSString *curFilePath = [NSString stringWithFormat:@"%@/%@", dstDir, file];
                        NSString *moveFilePath = [NSString stringWithFormat:@"%@/%@", dstDir, convertFilePath];
                        
                        if([curFilePath isEqualToString:moveFilePath] == NO &&
                           [fileManager moveItemAtPath:curFilePath toPath:moveFilePath error:&error] == NO)
                        {
                            [error retain];
                            break;
                        }
                        
                        numberOfMovedFile ++;
                    }
                    
                    
                    if (progressHandler)
                    {
                        progressHandler(0.5 + 0.5 * (numberOfMovedFile/numberOfFiles));
                    }
                    
                } // end of @autoreleasepool
            }
        }
        while(0);
        
        if(isFileOpened)
        {
            [zipArchive UnzipCloseFile];
        }
        
        [zipArchive release];
#else
        NSAssert(NO, @"使用PPZipController，需在podfile中指定 PPZipController/SSZipArchive 或 PPZipController/ZipArchive");
#endif
    

        //////////////////////////////////////////////////
        if(error != nil)
        {
            [fileManager removeItemAtPath:dstDir error:nil];
        }
        
        if (progressHandler)
        {
            progressHandler(1.0);
        }
        
    } // end of @autoreleasepool
    
    return [error autorelease];
}


//================================================================================
//
//================================================================================
+ (void)cancel
{
    g_cancel = YES;
}

@end

