//
//  PPZipController.h
//

#import <Foundation/Foundation.h>

typedef void (^PPZipControllerProgressHandler)(CGFloat progress);
extern NSString * const PPZipController_CombineSymbol;

////////////////////////////////////////////////////////////////////////////////////////////////////


@interface PPZipController : NSObject


/**
 * 壓縮來源資料夾包含的所有檔案大小
 *
 * @param srcDir 壓縮來源資料夾
 * @param excludeDirPatterns 包含這些字段的子資料夾將不會加入壓縮檔
 * @return 檔案大小 (byte)
 */
+ (double)contentSizeWithSrcDir:(NSString *)srcDir excludeDirPatterns:(NSArray *)excludeDirPatterns;


/**
 * Zip file in dictionary
 *
 * @param srcDir 壓縮來源資料夾
 * @param excludeDirPatterns 包含這些字段的子資料夾將不會加入壓縮檔
 * @param dstFile 壓縮檔名稱及路徑
 * @param password Password if needed
 * @return YES if success
 */
+ (BOOL)zipWithSrcDir:(NSString *)srcDir
   excludeDirPatterns:(NSArray *)excludeDirPatterns
              dstFile:(NSString *)dstFile
             password:(NSString *)password;


/**
 * Zip file in dictionary
 *
 * @param srcDir 壓縮來源資料夾
 * @param excludeDirPatterns 包含這些字段的子資料夾將不會加入壓縮檔
 * @param dstFile 壓縮檔名稱及路徑
 * @param password Password if needed
 * @param progressHandler 處理進度通知
 * @return YES if success
 */
+ (BOOL)zipWithSrcDir:(NSString *)srcDir
   excludeDirPatterns:(NSArray *)excludeDirPatterns
              dstFile:(NSString *)dstFile
             password:(NSString *)password
      progressHandler:(PPZipControllerProgressHandler)progressHandler;


/**
 * Unzip file
 *
 * @param srcFile 壓縮檔名稱及路徑
 * @param dstDir 解壓縮目標資料夾
 * @param password Password if needed
 * @return error
 */
+ (NSError *)unzipWithSrcFile:(NSString *)srcFile
                       dstDir:(NSString *)dstDir
                     password:(NSString *)password;


/**
 * Unzip file
 *
 * @param srcFile 壓縮檔名稱及路徑
 * @param dstDir 解壓縮目標資料夾
 * @param password Password if needed
 * @param progressHandler 處理進度通知
 * @return error
 */
+ (NSError *)unzipWithSrcFile:(NSString *)srcFile
                       dstDir:(NSString *)dstDir
                     password:(NSString *)password
              progressHandler:(PPZipControllerProgressHandler)progressHandler;


/**
 Cancel zip/unzip action (目前只有zip)
 */
+ (void)cancel;


@end
