//
//  PPWorldcardAddressController.m
//  
//
//  Created by Mike on 13/12/25.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPWorldcardAddressController.h"
#import "PPSystemInfoController.h"

@implementation PPWorldcardAddressController

//================================================================================
//
//================================================================================
+ (NSUInteger)addressSystemLanguage
{
    NSString *systemLang = [PPSystemInfoController stringWithLanguage:[PPSystemInfoController language]];
        
    ////////////////////////////////////////////////////////////////////////////////////////////////////

    if([systemLang isEqualToString:@"en"])              return PPWorldcardAddressControllerSystemLanguage_English;
    else if([systemLang isEqualToString:@"ko"])			return PPWorldcardAddressControllerSystemLanguage_Korea;
    else if([systemLang isEqualToString:@"ja"])			return PPWorldcardAddressControllerSystemLanguage_Japan;
    else if([systemLang isEqualToString:@"es"])			return PPWorldcardAddressControllerSystemLanguage_Spanish;
    else if([systemLang isEqualToString:@"de"])			return PPWorldcardAddressControllerSystemLanguage_German;
    else if([systemLang isEqualToString:@"pt"])			return PPWorldcardAddressControllerSystemLanguage_Portuguese;
    else if([systemLang isEqualToString:@"it"])			return PPWorldcardAddressControllerSystemLanguage_Italy;
    else if([systemLang isEqualToString:@"zh-Hant"])    return PPWorldcardAddressControllerSystemLanguage_TraditionalChinese;
    else if([systemLang isEqualToString:@"zh-Hans"])    return PPWorldcardAddressControllerSystemLanguage_SimplifiedChinese;
    else if([systemLang isEqualToString:@"nl"])			return PPWorldcardAddressControllerSystemLanguage_Dutch;
    else if([systemLang isEqualToString:@"fr"])			return PPWorldcardAddressControllerSystemLanguage_French;
    else if([systemLang isEqualToString:@"da"])			return PPWorldcardAddressControllerSystemLanguage_Danish;
    else if([systemLang isEqualToString:@"fi"])			return PPWorldcardAddressControllerSystemLanguage_Finnish;
    else if([systemLang isEqualToString:@"nb"])			return PPWorldcardAddressControllerSystemLanguage_Norwegian;
    else if([systemLang isEqualToString:@"sv"])			return PPWorldcardAddressControllerSystemLanguage_Swedish;
    else if([systemLang isEqualToString:@"ru"])			return PPWorldcardAddressControllerSystemLanguage_Russian;
    else if([systemLang isEqualToString:@"pl"])			return PPWorldcardAddressControllerSystemLanguage_Polish;
    else if([systemLang isEqualToString:@"tr"])			return PPWorldcardAddressControllerSystemLanguage_Turkish;
    else if([systemLang isEqualToString:@"uk"])			return PPWorldcardAddressControllerSystemLanguage_Ukrainian;
    else if([systemLang isEqualToString:@"ar"])			return PPWorldcardAddressControllerSystemLanguage_Arabic;
    else if([systemLang isEqualToString:@"hr"])			return PPWorldcardAddressControllerSystemLanguage_Croatian;
    else if([systemLang isEqualToString:@"cs"])			return PPWorldcardAddressControllerSystemLanguage_Czech;
    else if([systemLang isEqualToString:@"el"])			return PPWorldcardAddressControllerSystemLanguage_Greek;
    else if([systemLang isEqualToString:@"he"])			return PPWorldcardAddressControllerSystemLanguage_Hebrew;
    else if([systemLang isEqualToString:@"ro"])			return PPWorldcardAddressControllerSystemLanguage_Romanian;
    else if([systemLang isEqualToString:@"sk"])			return PPWorldcardAddressControllerSystemLanguage_Slovak;
    else if([systemLang isEqualToString:@"th"])			return PPWorldcardAddressControllerSystemLanguage_Thai;
    else if([systemLang isEqualToString:@"id"])			return PPWorldcardAddressControllerSystemLanguage_Indonesian;
    else if([systemLang isEqualToString:@"ms"])			return PPWorldcardAddressControllerSystemLanguage_Malay;
    else if([systemLang isEqualToString:@"ca"])			return PPWorldcardAddressControllerSystemLanguage_Catalonia;
    else if([systemLang isEqualToString:@"hu"])			return PPWorldcardAddressControllerSystemLanguage_Hungarian;
    else if([systemLang isEqualToString:@"vi"])			return PPWorldcardAddressControllerSystemLanguage_Vietnamese;
    else if([systemLang isEqualToString:@"hi"])			return PPWorldcardAddressControllerSystemLanguage_Hindi;
	else
    {
        return PPWorldcardAddressControllerSystemLanguage_English;
    }
}


//================================================================================
//
//================================================================================
+ (NSInteger)formatFromStreet:(NSString *)street
                         city:(NSString *)city
                     province:(NSString *)province
                   postalCode:(NSString *)postalCode
                  countryName:(NSMutableString *)countryName
                       format:(NSInteger)format
                  countryCode:(NSMutableString *)countryCode
                  bcrLanguage:(NSInteger)bcrLanguage
               systemLanguage:(NSInteger)systemLanguage
{
    NSInteger result = 0;

    //////////////////////////////////////////////////
    
    NSUInteger  uniStreetLength         = [street length]+1;
    NSUInteger  uniCityLength           = [city length]+1;
    NSUInteger  uniProvinceLength       = [province length]+1;
    NSUInteger  uniPostalCodeLength     = [postalCode length]+1;
    NSUInteger  uniCountryNameLength    = MAX([countryName length]+1, 128);
    NSUInteger  uniCountryCodeLength    = MAX([countryCode length]+1, 3);
    
    //////////////////////////////////////////////////
    
    UniChar     *uniStreet      = (uniStreetLength>1?malloc(uniStreetLength*sizeof(UniChar)):NULL);
    UniChar     *uniCity        = (uniCityLength>1?malloc(uniCityLength*sizeof(UniChar)):NULL);
    UniChar     *uniProvince    = (uniProvinceLength>1?malloc(uniProvinceLength*sizeof(UniChar)):NULL);
    UniChar     *uniPostalCode  = (uniPostalCodeLength>1?malloc(uniPostalCodeLength*sizeof(UniChar)):NULL);
    UniChar     *uniCountryName = malloc(uniCountryNameLength*sizeof(UniChar));
    UniChar     *uniCountryCode = malloc(uniCountryCodeLength*sizeof(UniChar));
    
    //////////////////////////////////////////////////
    
    if(uniStreet!=NULL)
    {
        memset(uniStreet, 0, uniStreetLength*sizeof(UniChar));
        [street getCharacters:uniStreet range:NSMakeRange(0, uniStreetLength-1)];
    }

    if(uniCity!=NULL)
    {
        memset(uniCity, 0, uniCityLength*sizeof(UniChar));
        [city getCharacters:uniCity range:NSMakeRange(0, uniCityLength-1)];
    }
    
    if(uniProvince!=NULL)
    {
        memset(uniProvince, 0, uniProvinceLength*sizeof(UniChar));
        [province getCharacters:uniProvince range:NSMakeRange(0, uniProvinceLength-1)];
    }
    
    if(uniPostalCode!=NULL)
    {
        memset(uniPostalCode, 0, uniPostalCodeLength*sizeof(UniChar));
        [postalCode getCharacters:uniPostalCode range:NSMakeRange(0, uniPostalCodeLength-1)];
    }
    
    if(uniCountryName!=NULL)
    {
        memset(uniCountryName, 0, uniCountryNameLength*sizeof(UniChar));
        
        if(countryName!=nil)
        {
            [countryName getCharacters:uniCountryName range:NSMakeRange(0, MIN([countryName length], uniCountryNameLength-1))];
        }
    }
    
    if(uniCountryCode!=NULL)
    {
        memset(uniCountryCode, 0, uniCountryCodeLength*sizeof(UniChar));
        
        if(countryCode!=nil)
        {
            [countryCode getCharacters:uniCountryCode range:NSMakeRange(0, MIN([countryCode length], uniCountryCodeLength-1))];
        }
    }
    
    //////////////////////////////////////////////////
    
    result = AddressFormatID(uniStreet, uniCity, uniProvince, uniPostalCode, uniCountryName, (int)format, uniCountryCode, (int)bcrLanguage, systemLanguage);
    
    //////////////////////////////////////////////////
    
    if(countryName!=nil)
    {
        NSString *tempString = [NSString stringWithCharacters:uniCountryName length:uniCountryNameLength-1];

        // !!移除多餘的\0
        tempString = [tempString stringByTrimmingCharactersInSet:[NSCharacterSet controlCharacterSet]];

        [countryName setString:tempString];
    }
    
    if(countryCode!=nil)
    {
        [countryCode setString:[NSString stringWithCharacters:uniCountryCode length:uniCountryCodeLength-1]];
    }
    
    //////////////////////////////////////////////////
    
    if(uniStreet!=NULL)
    {
        free(uniStreet);
    }

    if(uniCity!=NULL)
    {
        free(uniCity);
    }
    
    if(uniProvince!=NULL)
    {
        free(uniProvince);
    }
    
    if(uniPostalCode!=NULL)
    {
        free(uniPostalCode);
    }
    
    if(uniCountryName!=NULL)
    {
        free(uniCountryName);
    }
    
    if(uniCountryCode!=NULL)
    {
        free(uniCountryCode);
    }
    
    //////////////////////////////////////////////////
    
    return result;
}

//================================================================================
//
//================================================================================
+ (NSString *)addressFromStreet:(NSString *)street
                           city:(NSString *)city
                       province:(NSString *)province
                     postalCode:(NSString *)postalCode
                    countryName:(NSString *)countryName
                         format:(NSInteger)format
{
    NSString *address = nil;
    
    //////////////////////////////////////////////////
    
    NSUInteger  uniStreetLength         = [street length]+1;
    NSUInteger  uniCityLength           = [city length]+1;
    NSUInteger  uniProvinceLength       = [province length]+1;
    NSUInteger  uniPostalCodeLength     = [postalCode length]+1;
    NSUInteger  uniCountryNameLength    = [countryName length]+1;
    NSUInteger  uniAddressLength        = uniStreetLength+uniCityLength+uniProvinceLength+uniPostalCodeLength+uniCountryNameLength+11;
    
    //////////////////////////////////////////////////
    
    UniChar     *uniStreet      = (uniStreetLength>1?malloc((uniStreetLength)*sizeof(UniChar)):NULL);
    UniChar     *uniCity        = (uniCityLength>1?malloc((uniCityLength)*sizeof(UniChar)):NULL);
    UniChar     *uniProvince    = (uniProvinceLength>1?malloc((uniProvinceLength)*sizeof(UniChar)):NULL);
    UniChar     *uniPostalCode  = (uniPostalCodeLength>1?malloc((uniPostalCodeLength)*sizeof(UniChar)):NULL);
    UniChar     *uniCountryName = (uniCountryNameLength>1?malloc((uniCountryNameLength)*sizeof(UniChar)):NULL);
    UniChar     *uniAddress     = (uniAddressLength>1?malloc((uniAddressLength)*sizeof(UniChar)):NULL);
    
    //////////////////////////////////////////////////
    
    if(uniStreet!=NULL)
    {
        memset(uniStreet, 0, uniStreetLength*sizeof(UniChar));
        [street getCharacters:uniStreet range:NSMakeRange(0, uniStreetLength-1)];
    }
    
    if(uniCity!=NULL)
    {
        memset(uniCity, 0, uniCityLength*sizeof(UniChar));
        [city getCharacters:uniCity range:NSMakeRange(0, uniCityLength-1)];
    }
    
    if(uniProvince!=NULL)
    {
        memset(uniProvince, 0, uniProvinceLength*sizeof(UniChar));
        [province getCharacters:uniProvince range:NSMakeRange(0, uniProvinceLength-1)];
    }
    
    if(uniPostalCode!=NULL)
    {
        memset(uniPostalCode, 0, uniPostalCodeLength*sizeof(UniChar));
        [postalCode getCharacters:uniPostalCode range:NSMakeRange(0, uniPostalCodeLength-1)];
    }
    
    if(uniCountryName!=NULL)
    {
        memset(uniCountryName, 0, uniCountryNameLength*sizeof(UniChar));
        [countryName getCharacters:uniCountryName range:NSMakeRange(0, uniCountryNameLength-1)];
    }

    //////////////////////////////////////////////////
    
    if(uniAddress!=NULL)
    {
        memset(uniAddress, 0, uniAddressLength*sizeof(UniChar));
        
        //////////////////////////////////////////////////
        
        FullAddress(uniStreet, uniCity, uniProvince, uniPostalCode, uniCountryName, (int)format, uniAddress);
        
        //////////////////////////////////////////////////
        
        address = [NSString stringWithCharacters:uniAddress length:uniAddressLength];
        
        // !!移除多餘的\0
        address = [address stringByTrimmingCharactersInSet:[NSCharacterSet controlCharacterSet]];
    }
    
    //////////////////////////////////////////////////
    
    if(uniStreet!=NULL)
    {
        free(uniStreet);
    }
    
    if(uniCity!=NULL)
    {
        free(uniCity);
    }
    
    if(uniProvince!=NULL)
    {
        free(uniProvince);
    }
    
    if(uniPostalCode!=NULL)
    {
        free(uniPostalCode);
    }
    
    if(uniCountryName!=NULL)
    {
        free(uniCountryName);
    }

    if(uniAddress!=NULL)
    {
        free(uniAddress);
    }
    
    //////////////////////////////////////////////////
    
    return address;
}

//================================================================================
//
//================================================================================
+ (NSString *)googleMapAddressFromStreet:(NSString *)street
                                    city:(NSString *)city
                                province:(NSString *)province
                              postalCode:(NSString *)postalCode
                             countryCode:(NSString *)countryCode
{
    NSString *googleMapAddress = nil;
    
    //////////////////////////////////////////////////
    
    NSUInteger  uniStreetLength             = [street length]+1;
    NSUInteger  uniCityLength               = [city length]+1;
    NSUInteger  uniProvinceLength           = [province length]+1;
    NSUInteger  uniPostalCodeLength         = [postalCode length]+1;
    NSUInteger  uniCountryCodeLength        = [countryCode length]+1;
    NSUInteger  uniGoogleMapAddressLength   = uniStreetLength+uniCityLength+uniProvinceLength+uniPostalCodeLength+uniCountryCodeLength+3;
    
    //////////////////////////////////////////////////
    
    UniChar     *uniStreet              = (uniStreetLength>1?malloc((uniStreetLength)*sizeof(UniChar)):NULL);
    UniChar     *uniCity                = (uniCityLength>1?malloc((uniCityLength)*sizeof(UniChar)):NULL);
    UniChar     *uniProvince            = (uniProvinceLength>1?malloc((uniProvinceLength)*sizeof(UniChar)):NULL);
    UniChar     *uniPostalCode          = (uniPostalCodeLength>1?malloc((uniPostalCodeLength)*sizeof(UniChar)):NULL);
    UniChar     *uniCountryCode         = (uniCountryCodeLength>1?malloc((uniCountryCodeLength)*sizeof(UniChar)):NULL);
    UniChar     *uniGoogleMapAddress    = (uniGoogleMapAddressLength>1?malloc((uniGoogleMapAddressLength)*sizeof(UniChar)):NULL);
    
    //////////////////////////////////////////////////
    
    if(uniStreet!=NULL)
    {
        memset(uniStreet, 0, uniStreetLength*sizeof(UniChar));
        [street getCharacters:uniStreet range:NSMakeRange(0, uniStreetLength-1)];
    }
    
    if(uniCity!=NULL)
    {
        memset(uniCity, 0, uniCityLength*sizeof(UniChar));
        [city getCharacters:uniCity range:NSMakeRange(0, uniCityLength-1)];
    }
    
    if(uniProvince!=NULL)
    {
        memset(uniProvince, 0, uniProvinceLength*sizeof(UniChar));
        [province getCharacters:uniProvince range:NSMakeRange(0, uniProvinceLength-1)];
    }
    
    if(uniPostalCode!=NULL)
    {
        memset(uniPostalCode, 0, uniPostalCodeLength*sizeof(UniChar));
        [postalCode getCharacters:uniPostalCode range:NSMakeRange(0, uniPostalCodeLength-1)];
    }
    
    if(uniCountryCode!=NULL)
    {
        memset(uniCountryCode, 0, uniCountryCodeLength*sizeof(UniChar));
        [countryCode getCharacters:uniCountryCode range:NSMakeRange(0, uniCountryCodeLength-1)];
    }
    
    //////////////////////////////////////////////////
    
    if(uniGoogleMapAddress!=NULL)
    {
        memset(uniGoogleMapAddress, 0, uniGoogleMapAddressLength*sizeof(UniChar));
        
        //////////////////////////////////////////////////
        
        GoogleMapAddress(uniStreet, uniCity, uniProvince, uniPostalCode, uniCountryCode, uniGoogleMapAddress);
        
        //////////////////////////////////////////////////
        
        googleMapAddress = [NSString stringWithCharacters:uniGoogleMapAddress length:uniGoogleMapAddressLength];

        // !!移除多餘的\0
        googleMapAddress = [googleMapAddress stringByTrimmingCharactersInSet:[NSCharacterSet controlCharacterSet]];
    }
    
    //////////////////////////////////////////////////
    
    if(uniStreet!=NULL)
    {
        free(uniStreet);
    }
    
    if(uniCity!=NULL)
    {
        free(uniCity);
    }
    
    if(uniProvince!=NULL)
    {
        free(uniProvince);
    }
    
    if(uniPostalCode!=NULL)
    {
        free(uniPostalCode);
    }
    
    if(uniCountryCode!=NULL)
    {
        free(uniCountryCode);
    }
    
    if(uniGoogleMapAddress!=NULL)
    {
        free(uniGoogleMapAddress);
    }
    
    //////////////////////////////////////////////////
    
    return googleMapAddress;
}

@end
