#ifdef WIN32
#include "stdafx.h"
#endif

#include "UBase64.h"
#include <stdio.h>
#include <string.h>

#define BINARY_UNIT_SIZE 3
#define BASE64_UNIT_SIZE 4


CBase64::CBase64()
{
    strcpy((char*)m_base64EncodeLookup,"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
    m_base64DecodeLookup[0]=65;		m_base64DecodeLookup[1]=65;		m_base64DecodeLookup[2]=65;		m_base64DecodeLookup[3]=65;
    m_base64DecodeLookup[4]=65;		m_base64DecodeLookup[5]=65;		m_base64DecodeLookup[6]=65;		m_base64DecodeLookup[7]=65;
    m_base64DecodeLookup[8]=65;		m_base64DecodeLookup[9]=65;		m_base64DecodeLookup[10]=65;	m_base64DecodeLookup[11]=65;
    m_base64DecodeLookup[12]=65;	m_base64DecodeLookup[13]=65;	m_base64DecodeLookup[14]=65;	m_base64DecodeLookup[15]=65;
    m_base64DecodeLookup[16]=65;	m_base64DecodeLookup[17]=65;	m_base64DecodeLookup[18]=65;	m_base64DecodeLookup[19]=65;
    m_base64DecodeLookup[20]=65;	m_base64DecodeLookup[21]=65;	m_base64DecodeLookup[22]=65;	m_base64DecodeLookup[23]=65;
    m_base64DecodeLookup[24]=65;	m_base64DecodeLookup[25]=65;	m_base64DecodeLookup[26]=65;	m_base64DecodeLookup[27]=65;
    m_base64DecodeLookup[28]=65;	m_base64DecodeLookup[29]=65;	m_base64DecodeLookup[30]=65;	m_base64DecodeLookup[31]=65;
    m_base64DecodeLookup[32]=65;	m_base64DecodeLookup[33]=65;	m_base64DecodeLookup[34]=65;	m_base64DecodeLookup[35]=65;
    m_base64DecodeLookup[36]=65;	m_base64DecodeLookup[37]=65;	m_base64DecodeLookup[38]=65;	m_base64DecodeLookup[39]=65;
    m_base64DecodeLookup[40]=65;	m_base64DecodeLookup[41]=65;	m_base64DecodeLookup[42]=65;	m_base64DecodeLookup[43]=62;
    m_base64DecodeLookup[44]=65;	m_base64DecodeLookup[45]=65;	m_base64DecodeLookup[46]=65;	m_base64DecodeLookup[47]=63;
    m_base64DecodeLookup[48]=52;	m_base64DecodeLookup[49]=53;	m_base64DecodeLookup[50]=54;	m_base64DecodeLookup[51]=55;
    m_base64DecodeLookup[52]=56;	m_base64DecodeLookup[53]=57;	m_base64DecodeLookup[54]=58;	m_base64DecodeLookup[55]=59;
    m_base64DecodeLookup[56]=60;	m_base64DecodeLookup[57]=61;	m_base64DecodeLookup[58]=65;	m_base64DecodeLookup[59]=65;
    m_base64DecodeLookup[60]=65;	m_base64DecodeLookup[61]=65;	m_base64DecodeLookup[62]=65;	m_base64DecodeLookup[63]=65;
    m_base64DecodeLookup[64]=65;	m_base64DecodeLookup[65]=0;		m_base64DecodeLookup[66]=1;		m_base64DecodeLookup[67]=2;
    m_base64DecodeLookup[68]=3;		m_base64DecodeLookup[69]=4;		m_base64DecodeLookup[70]=5;		m_base64DecodeLookup[71]=6;
    m_base64DecodeLookup[72]=7;		m_base64DecodeLookup[73]=8;		m_base64DecodeLookup[74]=9;		m_base64DecodeLookup[75]=10;
    m_base64DecodeLookup[76]=11;	m_base64DecodeLookup[77]=12;	m_base64DecodeLookup[78]=13;	m_base64DecodeLookup[79]=14;
    m_base64DecodeLookup[80]=15;	m_base64DecodeLookup[81]=16;	m_base64DecodeLookup[82]=17;	m_base64DecodeLookup[83]=18;
    m_base64DecodeLookup[84]=19;	m_base64DecodeLookup[85]=20;	m_base64DecodeLookup[86]=21;	m_base64DecodeLookup[87]=22;
    m_base64DecodeLookup[88]=23;	m_base64DecodeLookup[89]=24;	m_base64DecodeLookup[90]=25;	m_base64DecodeLookup[91]=65;
    m_base64DecodeLookup[92]=65;	m_base64DecodeLookup[93]=65;	m_base64DecodeLookup[94]=65;	m_base64DecodeLookup[95]=65;
    m_base64DecodeLookup[96]=65;	m_base64DecodeLookup[97]=26;	m_base64DecodeLookup[98]=27;	m_base64DecodeLookup[99]=28;
    m_base64DecodeLookup[100]=29;	m_base64DecodeLookup[101]=30;	m_base64DecodeLookup[102]=31;	m_base64DecodeLookup[103]=32;
    m_base64DecodeLookup[104]=33;	m_base64DecodeLookup[105]=34;	m_base64DecodeLookup[106]=35;	m_base64DecodeLookup[107]=36;
    m_base64DecodeLookup[108]=37;	m_base64DecodeLookup[109]=38;	m_base64DecodeLookup[110]=39;	m_base64DecodeLookup[111]=40;
    m_base64DecodeLookup[112]=41;	m_base64DecodeLookup[113]=42;	m_base64DecodeLookup[114]=43;	m_base64DecodeLookup[115]=44;
    m_base64DecodeLookup[116]=45;	m_base64DecodeLookup[117]=46;	m_base64DecodeLookup[118]=47;	m_base64DecodeLookup[119]=48;
    m_base64DecodeLookup[120]=49;	m_base64DecodeLookup[121]=50;	m_base64DecodeLookup[122]=51;	m_base64DecodeLookup[123]=65;
    m_base64DecodeLookup[124]=65;	m_base64DecodeLookup[125]=65;	m_base64DecodeLookup[126]=65;	m_base64DecodeLookup[127]=65;
    m_base64DecodeLookup[128]=65;	m_base64DecodeLookup[129]=65;	m_base64DecodeLookup[130]=65;	m_base64DecodeLookup[131]=65;
    m_base64DecodeLookup[132]=65;	m_base64DecodeLookup[133]=65;	m_base64DecodeLookup[134]=65;	m_base64DecodeLookup[135]=65;
    m_base64DecodeLookup[136]=65;	m_base64DecodeLookup[137]=65;	m_base64DecodeLookup[138]=65;	m_base64DecodeLookup[139]=65;
    m_base64DecodeLookup[140]=65;	m_base64DecodeLookup[141]=65;	m_base64DecodeLookup[142]=65;	m_base64DecodeLookup[143]=65;
    m_base64DecodeLookup[144]=65;	m_base64DecodeLookup[145]=65;	m_base64DecodeLookup[146]=65;	m_base64DecodeLookup[147]=65;
    m_base64DecodeLookup[148]=65;	m_base64DecodeLookup[149]=65;	m_base64DecodeLookup[150]=65;	m_base64DecodeLookup[151]=65;
    m_base64DecodeLookup[152]=65;	m_base64DecodeLookup[153]=65;	m_base64DecodeLookup[154]=65;	m_base64DecodeLookup[155]=65;
    m_base64DecodeLookup[156]=65;	m_base64DecodeLookup[157]=65;	m_base64DecodeLookup[158]=65;	m_base64DecodeLookup[159]=65;
    m_base64DecodeLookup[160]=65;	m_base64DecodeLookup[161]=65;	m_base64DecodeLookup[162]=65;	m_base64DecodeLookup[163]=65;
    m_base64DecodeLookup[164]=65;	m_base64DecodeLookup[165]=65;	m_base64DecodeLookup[166]=65;	m_base64DecodeLookup[167]=65;
    m_base64DecodeLookup[168]=65;	m_base64DecodeLookup[169]=65;	m_base64DecodeLookup[170]=65;	m_base64DecodeLookup[171]=65;
    m_base64DecodeLookup[172]=65;	m_base64DecodeLookup[173]=65;	m_base64DecodeLookup[174]=65;	m_base64DecodeLookup[175]=65;
    m_base64DecodeLookup[176]=65;	m_base64DecodeLookup[177]=65;	m_base64DecodeLookup[178]=65;	m_base64DecodeLookup[179]=65;
    m_base64DecodeLookup[180]=65;	m_base64DecodeLookup[181]=65;	m_base64DecodeLookup[182]=65;	m_base64DecodeLookup[183]=65;
    m_base64DecodeLookup[184]=65;	m_base64DecodeLookup[185]=65;	m_base64DecodeLookup[186]=65;	m_base64DecodeLookup[187]=65;
    m_base64DecodeLookup[188]=65;	m_base64DecodeLookup[189]=65;	m_base64DecodeLookup[190]=65;	m_base64DecodeLookup[191]=65;
    m_base64DecodeLookup[192]=65;	m_base64DecodeLookup[193]=65;	m_base64DecodeLookup[194]=65;	m_base64DecodeLookup[195]=65;
    m_base64DecodeLookup[196]=65;	m_base64DecodeLookup[197]=65;	m_base64DecodeLookup[198]=65;	m_base64DecodeLookup[199]=65;
    m_base64DecodeLookup[200]=65;	m_base64DecodeLookup[201]=65;	m_base64DecodeLookup[202]=65;	m_base64DecodeLookup[203]=65;
    m_base64DecodeLookup[204]=65;	m_base64DecodeLookup[205]=65;	m_base64DecodeLookup[206]=65;	m_base64DecodeLookup[207]=65;
    m_base64DecodeLookup[208]=65;	m_base64DecodeLookup[209]=65;	m_base64DecodeLookup[210]=65;	m_base64DecodeLookup[211]=65;
    m_base64DecodeLookup[212]=65;	m_base64DecodeLookup[213]=65;	m_base64DecodeLookup[214]=65;	m_base64DecodeLookup[215]=65;
    m_base64DecodeLookup[216]=65;	m_base64DecodeLookup[217]=65;	m_base64DecodeLookup[218]=65;	m_base64DecodeLookup[219]=65;
    m_base64DecodeLookup[220]=65;	m_base64DecodeLookup[221]=65;	m_base64DecodeLookup[222]=65;	m_base64DecodeLookup[223]=65;
    m_base64DecodeLookup[224]=65;	m_base64DecodeLookup[225]=65;	m_base64DecodeLookup[226]=65;	m_base64DecodeLookup[227]=65;
    m_base64DecodeLookup[228]=65;	m_base64DecodeLookup[229]=65;	m_base64DecodeLookup[230]=65;	m_base64DecodeLookup[231]=65;
    m_base64DecodeLookup[232]=65;	m_base64DecodeLookup[233]=65;	m_base64DecodeLookup[234]=65;	m_base64DecodeLookup[235]=65;
    m_base64DecodeLookup[236]=65;	m_base64DecodeLookup[237]=65;	m_base64DecodeLookup[238]=65;	m_base64DecodeLookup[239]=65;
    m_base64DecodeLookup[240]=65;	m_base64DecodeLookup[241]=65;	m_base64DecodeLookup[242]=65;	m_base64DecodeLookup[243]=65;
    m_base64DecodeLookup[244]=65;	m_base64DecodeLookup[245]=65;	m_base64DecodeLookup[246]=65;	m_base64DecodeLookup[247]=65;
    m_base64DecodeLookup[248]=65;	m_base64DecodeLookup[249]=65;	m_base64DecodeLookup[250]=65;	m_base64DecodeLookup[251]=65;
    m_base64DecodeLookup[252]=65;	m_base64DecodeLookup[253]=65;	m_base64DecodeLookup[254]=65;	m_base64DecodeLookup[255]=65;
    
}

CBase64::~CBase64()
{
    
}


//
// NewBase64Decode
//
// Decodes the base64 ASCII string in the inputBuffer to a newly malloced
// output buffer.
//
//  inputBuffer - the source ASCII string for the decode
//	length - the length of the string or -1 (to specify strlen should be used)
//	outputLength - if not-NULL, on output will contain the decoded length
//
// returns the decoded buffer. Must be free'd by caller. Length is given by
//	outputLength.
//
void *CBase64::NewBase64Decode(
                               const char *inputBuffer,
                               int length,
                               int *outputLength)
{
    if (length == -1)
    {
        length = (int)strlen(inputBuffer);
    }
    
    int outputBufferSize =
    ((length+BASE64_UNIT_SIZE-1) / BASE64_UNIT_SIZE) * BINARY_UNIT_SIZE;
    unsigned char *outputBuffer = (unsigned char *)CPPMem.new_unsigned_char(outputBufferSize);
    
    int i = 0;
    int j = 0;
    while (i < length)
    {
        //
        // Accumulate 4 valid characters (ignore everything else)
        //
        unsigned char accumulated[BASE64_UNIT_SIZE];
        int accumulateIndex = 0;
        while (i < length)
        {
            unsigned char decode = m_base64DecodeLookup[inputBuffer[i++]];
            if (decode != 65)
            {
                accumulated[accumulateIndex] = decode;
                accumulateIndex++;
                
                if (accumulateIndex == BASE64_UNIT_SIZE)
                {
                    break;
                }
            }
        }
        
        //
        // Store the 6 bits from each of the 4 characters as 3 bytes
        //
        outputBuffer[j] = (accumulated[0] << 2) | (accumulated[1] >> 4);
        outputBuffer[j + 1] = (accumulated[1] << 4) | (accumulated[2] >> 2);
        outputBuffer[j + 2] = (accumulated[2] << 6) | accumulated[3];
        j += accumulateIndex - 1;
    }
    
    if (outputLength)
    {
        *outputLength = j;
    }
    return outputBuffer;
}

//
// NewBase64Decode
//
// Encodes the arbitrary data in the inputBuffer as base64 into a newly malloced
// output buffer.
//
//  inputBuffer - the source data for the encode
//	length - the length of the input in bytes
//  separateLines - if zero, no CR/LF characters will be added. Otherwise
//		a CR/LF pair will be added every 64 encoded chars.
//	outputLength - if not-NULL, on output will contain the encoded length
//		(not including terminating 0 char)
//
// returns the encoded buffer. Must be free'd by caller. Length is given by
//	outputLength.
//
char *CBase64::NewBase64Encode(
                               const void *buffer,
                               int length,
                               bool separateLines,
                               int *outputLength)
{
    const unsigned char *inputBuffer = (const unsigned char *)buffer;
    
#define MAX_NUM_PADDING_CHARS 2
#define OUTPUT_LINE_LENGTH 64
#define INPUT_LINE_LENGTH ((OUTPUT_LINE_LENGTH / BASE64_UNIT_SIZE) * BINARY_UNIT_SIZE)
#define CR_LF_SIZE 2
    
    //
    // Byte accurate calculation of final buffer size
    //
    int outputBufferSize =
    ((length / BINARY_UNIT_SIZE)
     + ((length % BINARY_UNIT_SIZE) ? 1 : 0))
    * BASE64_UNIT_SIZE;
    if (separateLines)
    {
        outputBufferSize +=
        (outputBufferSize / OUTPUT_LINE_LENGTH) * CR_LF_SIZE;
    }
    
    //
    // Include space for a terminating zero
    //
    outputBufferSize += 1;
    
    //
    // Allocate the output buffer
    //
    char *outputBuffer = (char *)CPPMem.new_char(outputBufferSize);
    if (!outputBuffer)
    {
        return NULL;
    }
    
    int i = 0;
    int j = 0;
    const int lineLength = separateLines ? INPUT_LINE_LENGTH : length;
    int lineEnd = lineLength;
    
    while (true)
    {
        if (lineEnd > length)
        {
            lineEnd = length;
        }
        
        for (; i + BINARY_UNIT_SIZE - 1 < lineEnd; i += BINARY_UNIT_SIZE)
        {
            //
            // Inner loop: turn 48 bytes into 64 base64 characters
            //
            outputBuffer[j++] = m_base64EncodeLookup[(inputBuffer[i] & 0xFC) >> 2];
            outputBuffer[j++] = m_base64EncodeLookup[((inputBuffer[i] & 0x03) << 4)
                                                     | ((inputBuffer[i + 1] & 0xF0) >> 4)];
            outputBuffer[j++] = m_base64EncodeLookup[((inputBuffer[i + 1] & 0x0F) << 2)
                                                     | ((inputBuffer[i + 2] & 0xC0) >> 6)];
            outputBuffer[j++] = m_base64EncodeLookup[inputBuffer[i + 2] & 0x3F];
        }
        
        if (lineEnd == length)
        {
            break;
        }
        
        //
        // Add the newline
        //
        outputBuffer[j++] = '\r';
        outputBuffer[j++] = '\n';
        lineEnd += lineLength;
    }
    
    if (i + 1 < length)
    {
        //
        // Handle the single '=' case
        //
        outputBuffer[j++] = m_base64EncodeLookup[(inputBuffer[i] & 0xFC) >> 2];
        outputBuffer[j++] = m_base64EncodeLookup[((inputBuffer[i] & 0x03) << 4)
                                                 | ((inputBuffer[i + 1] & 0xF0) >> 4)];
        outputBuffer[j++] = m_base64EncodeLookup[(inputBuffer[i + 1] & 0x0F) << 2];
        outputBuffer[j++] =	'=';
    }
    else if (i < length)
    {
        //
        // Handle the double '=' case
        //
        outputBuffer[j++] = m_base64EncodeLookup[(inputBuffer[i] & 0xFC) >> 2];
        outputBuffer[j++] = m_base64EncodeLookup[(inputBuffer[i] & 0x03) << 4];
        outputBuffer[j++] = '=';
        outputBuffer[j++] = '=';
    }
    outputBuffer[j] = 0;
    
    //
    // Set the output length and return the buffer
    //
    if (outputLength)
    {
        *outputLength = j;
    }
    return outputBuffer;
}

