///////////////////////////////////////////////////////////////////////////////
#include "PPCStringW.h"

PPCStringW::PPCStringW()
{
	Init();
	AllocBaseMem();	
}

PPCStringW::PPCStringW(PPCStringW& stringSrc)
{
	int iLen;
	Init();
	iLen = stringSrc.GetLength();
	//m_BufferPtr = (char*)GlobalAlloc(GPTR,sizeof(char)*(iLen+1));
	m_BufferPtr = CPPMem.new_PPWCHAR(iLen+1);
	if (m_BufferPtr != 0)
	{
		m_oneWStr.wcscpy(m_BufferPtr,stringSrc.GetBuffer());
		m_BufferSize = iLen;
	}else
	{
		AllocBaseMem();
	}
}

PPCStringW::PPCStringW(PPWCHAR *stringSrc)
{
	int iLen;
	Init();

	iLen = m_oneWStr.wcslen(stringSrc);
	//m_BufferPtr = (char*)GlobalAlloc(GPTR,sizeof(char)*(iLen+1));
	m_BufferPtr = CPPMem.new_PPWCHAR(iLen+1);
	if (m_BufferPtr != 0)
	{
		m_oneWStr.wcscpy(m_BufferPtr,stringSrc);
		m_BufferSize = iLen;
	}else
	{
		AllocBaseMem();
	}
}

// only support a..z 0..9
PPCStringW::PPCStringW(char *lpsz)
{
	int iLen,i;
	char tmpOne;

	Init();
	if (lpsz != 0)
	{
		iLen = (int)strlen(lpsz);
		
		m_BufferPtr = CPPMem.new_PPWCHAR(iLen+1);
		if (m_BufferPtr != 0)
		{
			for (i = 0;i < iLen;i++)
			{
				tmpOne = lpsz[i] & 0xFF;
				m_BufferPtr[i] = tmpOne;
			}
			m_BufferPtr[i] = 0;
			m_BufferSize = iLen;
		}else
		{
			AllocBaseMem();
		}
	}else
	{
		AllocBaseMem();
	}
}

PPWCHAR *PPCStringW::GetBuffer()
{
	return m_BufferPtr;
}


void PPCStringW::Init()
{
	m_BufferPtr = 0;
	m_BufferSize = 0;
}

void PPCStringW::AllocBaseMem()
{
	m_BufferPtr = CPPMem.new_PPWCHAR(1);
	if (m_BufferPtr != 0)
	{
		m_BufferPtr[0] = 0;
		m_BufferSize = 1;
	}
}



void PPCStringW::Release()
{
	if (m_BufferPtr != 0)
	{
		delete [] m_BufferPtr;
		m_BufferPtr = 0;
		m_BufferSize = 0;
	}
}


PPCStringW::~PPCStringW()
//  free any attached data
{
	Release();
}

PPCStringW::operator PPWCHAR*() const
{
	return m_BufferPtr;
}

const PPCStringW& PPCStringW::operator=(PPCStringW& stringSrc)
{
	int iLen;
	

		iLen = stringSrc.GetLength();
		if (m_BufferSize > iLen)
		{
			m_oneWStr.wcscpy(m_BufferPtr,stringSrc.GetBuffer());
			m_BufferSize = iLen;
		}else
		{
			Release();
			//m_BufferPtr = (char*)GlobalAlloc(GPTR,sizeof(char)*(iLen+1));
			m_BufferPtr = CPPMem.new_PPWCHAR(iLen+1);
			if (m_BufferPtr != 0)
			{
				m_oneWStr.wcscpy(m_BufferPtr,stringSrc.GetBuffer());
				m_BufferSize = iLen;
			}else
			{
				AllocBaseMem();
			}
		}
		return *this;
}

const PPCStringW& PPCStringW::operator=(PPWCHAR * lpsz)
{
	int iLen;

		if (lpsz != 0)
		{
			iLen = m_oneWStr.wcslen(lpsz);
			if (m_BufferSize > iLen)
			{
				m_oneWStr.wcscpy(m_BufferPtr,lpsz);
				m_BufferSize = iLen;
			}else
			{
				Release();
				//m_BufferPtr = (char*)GlobalAlloc(GPTR,sizeof(char)*(iLen+1));
				m_BufferPtr = CPPMem.new_PPWCHAR(iLen+1);
				if (m_BufferPtr != 0)
				{
					m_oneWStr.wcscpy(m_BufferPtr,lpsz);
					m_BufferSize = iLen;
				}else
				{
					AllocBaseMem();
				}
			}
		}else
		{
			if (m_BufferPtr != 0)
			{
				m_BufferPtr[0] = 0;
			}else
			{
				AllocBaseMem();
			}
		}
		return *this;
}


const PPCStringW& PPCStringW::operator=(const char * lpsz)
{
	int iLen;

		if (lpsz != 0)
		{
			iLen = (int)strlen(lpsz);
			if (m_BufferSize > iLen)
			{
				m_oneWStr.wcscpy_fromAnsi(m_BufferPtr,lpsz);
				m_BufferSize = iLen;
			}else
			{
				Release();
				//m_BufferPtr = (char*)GlobalAlloc(GPTR,sizeof(char)*(iLen+1));
				m_BufferPtr = CPPMem.new_PPWCHAR(iLen+1);
				if (m_BufferPtr != 0)
				{
					m_oneWStr.wcscpy_fromAnsi(m_BufferPtr,lpsz);
					m_BufferSize = iLen;
				}else
				{
					AllocBaseMem();
				}
			}
		}else
		{
			if (m_BufferPtr != 0)
			{
				m_BufferPtr[0] = 0;
			}else
			{
				AllocBaseMem();
			}
		}
		return *this;
}

/////////////////////////////////////////////////////////////////////////////
// Special conversion assignment


PPCStringW operator+(PPCStringW& string1,PPCStringW& string2)
{
	PPCStringW s;
	int iLen;
	PPWCHAR *tmpBuffer;
	PPWString oneWStr;

		iLen = string1.GetLength() + string2.GetLength();
		if (iLen > 0)
		{
			tmpBuffer = CPPMem.new_PPWCHAR(iLen + 2);
			if (tmpBuffer != 0)
			{
				oneWStr.wcscpy(tmpBuffer,string1.GetBuffer());
				oneWStr.wcscat(tmpBuffer,string2.GetBuffer());
				s = tmpBuffer;
				delete [] tmpBuffer;
			}
		}
		return s;
}

PPCStringW operator+(PPCStringW& str1, PPWCHAR *lpsz)
{
	PPCStringW s;
	int iLen;
	PPWCHAR *tmpBuffer;
	PPWString oneWStr;

		iLen = str1.GetLength() + oneWStr.wcslen(lpsz);
		if (iLen > 0)
		{
			tmpBuffer = CPPMem.new_PPWCHAR(iLen + 2);
			if (tmpBuffer != 0)
			{
				oneWStr.wcscpy(tmpBuffer,str1.GetBuffer());
				oneWStr.wcscat(tmpBuffer,lpsz);
				s = tmpBuffer;
			
				delete [] tmpBuffer;
			}
		}
		return s;
}

PPCStringW operator+(PPCStringW& str1,const char *lpsz)
{
	PPCStringW s;
	int iLen;
	PPWCHAR *tmpBuffer;
	PPWString oneWStr;

		iLen = (int)str1.GetLength() + (int)strlen(lpsz);
		if (iLen > 0)
		{
			tmpBuffer = CPPMem.new_PPWCHAR(iLen + 2);
			if (tmpBuffer != 0)
			{
				oneWStr.wcscpy(tmpBuffer,str1.GetBuffer());
				oneWStr.wcscat_fromAnsi(tmpBuffer,lpsz);
				s = tmpBuffer;
			
				delete [] tmpBuffer;
			}
		}
		return s;
}


PPCStringW operator+(PPWCHAR *lpsz, PPCStringW& string1)
{
	PPCStringW s;
	int iLen;
	PPWCHAR *tmpBuffer;
	PPWString oneWStr;

		iLen = string1.GetLength() + oneWStr.wcslen(lpsz);
		if (iLen > 0)
		{
			tmpBuffer = CPPMem.new_PPWCHAR(iLen + 2);
			if (tmpBuffer != 0)
			{
				oneWStr.wcscpy(tmpBuffer,lpsz);
				oneWStr.wcscat(tmpBuffer,string1.GetBuffer());
				s = tmpBuffer;

				delete [] tmpBuffer;
			}
		}
		return s;
}

int PPCStringW::Compare(PPWCHAR *lpsz)
{
	if (m_BufferSize != 0)
	{
		return m_oneWStr.wcscmp(m_BufferPtr,lpsz);
	}else
	{
		if (lpsz == 0)
		{
			return 0;
		}else
		{
			return -1;
		}
	}

	return -1;
}

int PPCStringW::Compare(const char *lpsz)
{
	if (m_BufferSize != 0)
	{
		return m_oneWStr.wcscmp_fromAnsi(m_BufferPtr,lpsz);
	}else
	{
		if (lpsz == 0)
		{
			return 0;
		}else
		{
			return -1;
		}
	}

	return -1;
}

int PPCStringW::CompareNoCase(PPWCHAR *lpsz) 
{
	if (m_BufferSize != 0)
	{
		return m_oneWStr.wcsicmp(m_BufferPtr,lpsz);
	}else
	{
		if (lpsz == 0)
		{
			return 0;
		}else
		{
			return -1;
		}
	}
	return -1;
}

int PPCStringW::CompareNoCase(const char *lpsz) 
{
	if (m_BufferSize != 0)
	{
		return m_oneWStr.wcsicmp_fromAnsi(m_BufferPtr,lpsz);
	}else
	{
		if (lpsz == 0)
		{
			return 0;
		}else
		{
			return -1;
		}
	}
	return -1;
}


const PPCStringW& PPCStringW::operator+=(PPWCHAR *lpsz)
{
	PPCStringW s;

		s = *this + lpsz;
		*this = s;

		return *this;
}

const PPCStringW& PPCStringW::operator+=(const char *lpsz)
{
	PPCStringW s;

		s = *this + lpsz;
		*this = s;

		return *this;
}



const PPCStringW& PPCStringW::operator+=(PPCStringW& string1)
{
	PPCStringW s;

		s = *this + string1;
		*this = s;
		return *this;
}

int PPCStringW::GetLength()
{
	return m_oneWStr.wcslen(m_BufferPtr);
}

PPWCHAR PPCStringW::GetAt(int nIndex)
{
	if ((nIndex >= 0) && (nIndex < GetLength()))
	{
		return m_BufferPtr[nIndex];
	}
	return 0;
}

///////////////////////////////////////////////////////////////////////////////
// Commonly used routines (rarely used routines in STREX.CPP)

void PPCStringW::MakeUpper()
{
	if (m_BufferPtr != 0)
	{
		m_oneWStr.wcsupr(m_BufferPtr);
	}
}

void PPCStringW::MakeLower()
{
	if (m_BufferPtr != 0)
	{
		m_oneWStr.wcslwr(m_BufferPtr);
	}

}


/////////////////////////////////////////////////////////////////////////////
// PPCStringW formatting
void PPCStringW::TrimRight(PPWCHAR* lpszTargetList)
{
	// find beginning of trailing matches
	// by starting at beginning (DBCS aware)
	int i,iLen;

		iLen = GetLength();
		for (i = 0;i < iLen;i++)
		{
			if (findInStr(m_BufferPtr[iLen - i - 1],lpszTargetList) == -1)
			{
				m_BufferPtr[iLen - i] = 0;
				break;
			}
		}
}

void PPCStringW::TrimRight(const char* lpszTargetList)
{
	PPCStringW oneWStr;

	oneWStr = lpszTargetList;

	TrimRight(oneWStr);
}

void PPCStringW::TrimLeft(PPWCHAR* lpszTargets)
{
	// if we're not trimming anything, we're not doing any work
	int i,iLen;

		iLen = GetLength();
		for (i = 0;i < iLen;i++)
		{
			if (findInStr(m_BufferPtr[i],lpszTargets) == -1)
			{
				break;
			}
		}
		if (i > 0)
		{
			memmove(m_BufferPtr,&m_BufferPtr[i],(iLen-i)*sizeof(PPWCHAR));
			m_BufferPtr[iLen-i] = 0;
		}
}

void PPCStringW::TrimLeft(const char* lpszTargets)
{
	PPCStringW oneWStr;

		oneWStr = lpszTargets;
		TrimLeft(oneWStr);
}

int PPCStringW::findInStr(PPWCHAR oneChar,PPWCHAR *Buffer)
{
	int i,iLen;

		if (Buffer != 0)
		{
			
			iLen = m_oneWStr.wcslen(Buffer);
			for (i = 0;i < iLen ;i++)
			{
				if (Buffer[i] == oneChar)
				{
					return i;
				}
			}
		}
		return -1;
}

int PPCStringW::Find(PPWCHAR *charPtr,int iStart)
{
	int i,j,iLen;
	int destLen;
	int iFindCount = 0;

		if (m_BufferPtr != 0)
		{
			destLen = m_oneWStr.wcslen(charPtr);
			iLen = m_oneWStr.wcslen(m_BufferPtr);
			for (i = iStart;i < iLen;i++)
			{
				iFindCount = 0;
				for (j = 0;j < destLen;j++)
				{
					if ((i+j) < iLen)
					{
						if ((PPWCHAR)m_BufferPtr[i+j] == (PPWCHAR)charPtr[j])
						{
							iFindCount++;
						}
					}else
					{
						break;
					}
				}
				if (iFindCount == destLen)
				{
					return i;
				}
			}
		}
		return -1;
	
}

PPCStringW PPCStringW::Left(int iLeftLen)
{
	int iLen,i;
	PPCStringW tmpOne;
	PPWCHAR tmpChar[2];

		if (m_BufferPtr != 0)
		{
			iLen = m_oneWStr.wcslen(m_BufferPtr);
			if ((iLeftLen > 0))
			{
				for (i = 0;i < iLeftLen;i++)
				{
					if (i >= iLen)
					{
						break;
					}else
					{
						tmpChar[0] = m_BufferPtr[i];
						tmpChar[1] = 0;
						tmpOne += tmpChar;
					}
				}
			}
		}
		return tmpOne;
}

PPCStringW PPCStringW::Right( int nLen )
{   

	if (nLen > m_BufferSize)
	{
		nLen = m_BufferSize;
	}

	if (nLen == m_BufferSize )
        return *this;

    int nPos = m_BufferSize - nLen;

    PPCStringW str;

	str = &m_BufferPtr[nPos];

    return str;
}

#ifndef __ANDROID__
PPCStringW PPCStringW::Format(const PPWCHAR* format, ...)
{
	int n_size = 0;
	int args_size = 0;
	PPCStringW retStr;

	va_list args;
	
	va_start(args, format);
	
	args_size = (int)m_oneWStr.wcslen(format) + (int)strlen((char*)args)*2 + 1024;

	Release();
	m_BufferPtr = CPPMem.new_PPWCHAR(args_size+1);
	if (m_BufferPtr != 0)
	{
		m_BufferSize = args_size;
		n_size = m_oneWStr.vswprintf(m_BufferPtr, format, args);
		m_BufferSize = n_size;
	}	
	va_end(args);

	retStr = GetBuffer();
	return retStr; 
}
#endif

int PPCStringW::Replace(PPWCHAR *lpszOld, PPWCHAR *lpszNew)
{
	int idx = 0;
	int iLen = 0;
	int iCount = 0;
	int iALen = 0;
	PPCStringW oneTmp;
	PPCStringW newTmp;
	int inFlag = 0;


		oneTmp = *this;

		iLen = m_oneWStr.wcslen(lpszOld);
		if (iLen > 0)
		{
			idx = oneTmp.Find(lpszOld,idx);
			while (idx != -1)
			{
				inFlag = 1;
				newTmp += oneTmp.Left(idx);
				newTmp += lpszNew;
				iALen = oneTmp.GetLength();
				oneTmp = oneTmp.Right(iALen-(idx+iLen));
				idx = 0;
				idx = oneTmp.Find(lpszOld,idx);
				iCount++;
			}
			if (inFlag == 1)
			{
				newTmp += oneTmp;
				*this = newTmp;
			}
		}

		return iCount;
}

int PPCStringW::Replace(const char *lpszOld,const char *lpszNew)
{
	PPCStringW oldStr;
	PPCStringW newStr;
		
		oldStr = lpszOld;
		newStr = lpszNew;

	return Replace(oldStr,newStr);
}



int PPCStringW::ToValue()
{
	char *tmpCharP;
	int retV = 0;
	int i;

	if (m_BufferPtr != 0)
	{
		tmpCharP = CPPMem.new_char(m_BufferSize+2);
		if (tmpCharP != 0)
		{
			for (i = 0;i < m_BufferSize;i++)
			{
				tmpCharP[i] = (char)(m_BufferPtr[i] & 0xFF);
			}
			tmpCharP[m_BufferSize] = 0;
			retV = atoi(tmpCharP);
			delete [] tmpCharP;
		}
	}
	return retV;
}

PPCStringW PPCStringW::Mid(int nFirst, int nCount)
{
	PPCStringW retStr;
	PPWCHAR *tmpWP;
	int i;

	retStr = "";
	if (m_BufferPtr != 0)
	{
		if (nFirst + nCount <= m_BufferSize )
		{
			tmpWP = CPPMem.new_PPWCHAR(nFirst + nCount+1);
			if (tmpWP != 0)
			{
				for (i = 0;i < nCount;i++)
				{
					tmpWP[i] = m_BufferPtr[nFirst+i];
				}
				tmpWP[i] = 0;
				retStr = tmpWP;
				delete [] tmpWP;
			}
		}
	}
	return retStr;
}

//------------------------------------------------------------------------------
