//
//  PPViewController.m
//  
//
//  Created by Mike on 13/5/7.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static UIColor * PPViewController_DefaultBackgroundColor = nil;
static UIColor * PPViewController_DefaultNavigationBarBackgroundColor = nil;
static NSNumber * PPViewController_PreferredStatusBarStyle = nil;
static NSNumber * PPViewController_NavigationBarBackgroundImageHidden = nil;
static NSNumber * PPViewController_ModelPresentationStyle = nil;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPViewController()

@interface PPViewController()
@property(nonatomic,assign)             BOOL        shouldLayoutSubviews;
@property(nonatomic,readwrite,retain)   UIImageView *backgroundImageView;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPViewController

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Synthesize

@synthesize
shouldLayoutSubviews                = shouldLayoutSubviews_,
backgroundImageView                 = backgroundImageView_,
masterViewPopoverController         = masterViewPopoverController_,
ppInterfaceOrientationController    = ppInterfaceOrientationController_,
navigationBarBackgroundColor        = navigationBarBackgroundColor_;




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    if(self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil])
    {
        [self commitInit];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (id)init
{
	if((self=[super init]))
	{	
        [self commitInit];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [backgroundImageView_ removeFromSuperview];
    [backgroundImageView_ release];
    backgroundImageView_ = nil;
    
    [navigationBarBackgroundColor_ release];
    navigationBarBackgroundColor_ = nil;
    
    [masterViewPopoverController_ release];
    masterViewPopoverController_ = nil;
    
	[ppInterfaceOrientationController_ release];
    ppInterfaceOrientationController_ = nil;
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
	[super viewWillAppear:animated];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    // Set color of navigation bar
    
    if(self.navigationBarBackgroundColor != nil)
    {
        // !! ios7 要設定translucent不然無法設定顏色
        self.navigationController.navigationBar.translucent = NO;
        if (@available(iOS 7.0, *))
        {
            self.navigationController.navigationBar.barTintColor = self.navigationBarBackgroundColor;
        }
    }
    
    if ([PPViewController_NavigationBarBackgroundImageHidden boolValue])
    {
        [self.navigationController.navigationBar setBackgroundImage:[[[UIImage alloc]init] autorelease] forBarMetrics:UIBarMetricsDefault];
        [self.navigationController.navigationBar setShadowImage:[[[UIImage alloc] init] autorelease]];
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    @autoreleasepool
    {
        if(self.backgroundImageView==nil)
        {
            self.backgroundImageView = [[[UIImageView alloc] initWithFrame:self.view.bounds] autorelease];
        }
        if(self.backgroundImageView!=nil)
        {
            self.backgroundImageView.autoresizingMask   = UIViewAutoresizingFlexibleWidth|UIViewAutoresizingFlexibleHeight;
            self.backgroundImageView.backgroundColor    = [UIColor clearColor];
            
            [self.view insertSubview:self.backgroundImageView atIndex:0];
        }
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    self.shouldLayoutSubviews = YES;
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    self.isViewDidAppear = YES;
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    self.isViewDidAppear = NO;
    
    [self.backgroundImageView removeFromSuperview];
    self.backgroundImageView = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super viewDidDisappear:animated];
}


//================================================================================
//
//================================================================================
- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(self.shouldLayoutSubviews==YES)
    {
        [self layoutSubviews];
        
        self.shouldLayoutSubviews = NO;
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Responding to View Rotation Events


//================================================================================
//
//================================================================================
- (UIInterfaceOrientationMask)supportedInterfaceOrientations
{
    return [self.ppInterfaceOrientationController supportedInterfaceOrientations];
}


//================================================================================
//
//================================================================================
- (BOOL)shouldAutorotate
{
    return [self.ppInterfaceOrientationController shouldAutorotate];
}


//================================================================================
//
//================================================================================
- (void)willAnimateRotationToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation duration:(NSTimeInterval)duration
{
	[super willAnimateRotationToInterfaceOrientation:toInterfaceOrientation duration:duration];
	
	////////////////////////////////////////////////////////////////////////////////////////////////////

    [self layoutSubviews];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prefersStatusBarHidden


//================================================================================
//
//================================================================================
- (BOOL)prefersStatusBarHidden
{
    return self.preferedStatusBarHidden;
}


//================================================================================
// info.plist要加入 UIViewControllerBasedStatusBarAppearance 設定為YES才有用
//================================================================================
- (UIStatusBarStyle)preferredStatusBarStyle 
{
    return (UIStatusBarStyle)[PPViewController_PreferredStatusBarStyle integerValue];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Presenting Another View Controller’s Content


//================================================================================
//
//================================================================================
- (BOOL)disablesAutomaticKeyboardDismissal  
{  
    if(self.modalPresentationStyle==UIModalPresentationFormSheet) 
    {
        return NO;
    }
    
    return [super disablesAutomaticKeyboardDismissal];  
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Intended For Subclasses Method

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{

}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)commitInit
{
    [ppInterfaceOrientationController_ release];
    ppInterfaceOrientationController_ = [[PPInterfaceOrientationController alloc] init];
    self.preferedStatusBarHidden = NO;
    
    if(PPViewController_DefaultBackgroundColor!= nil)
    {
        self.view.backgroundColor = PPViewController_DefaultBackgroundColor;
    }

    if(PPViewController_DefaultNavigationBarBackgroundColor!= nil)
    {
        self.navigationBarBackgroundColor = PPViewController_DefaultNavigationBarBackgroundColor;
    }
    
    if (PPViewController_ModelPresentationStyle!=nil)
    {
        self.modalPresentationStyle = (UIModalPresentationStyle)[PPViewController_ModelPresentationStyle integerValue];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods

//================================================================================
//
//================================================================================
- (BOOL)viewIsVisible
{
    return (self.isViewLoaded && self.view.window);
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class method

//================================================================================
//
//================================================================================
+ (void)setDefaultBackgroundColor:(UIColor *)color
{
    PPViewController_DefaultBackgroundColor = [[UIColor alloc] initWithCGColor:color.CGColor];
}


//================================================================================
//
//================================================================================
+ (void)setDefaultNavigationBarBackgroundColor:(UIColor *)color
{
    PPViewController_DefaultNavigationBarBackgroundColor = [[UIColor alloc] initWithCGColor:color.CGColor];
}


//==============================================================================
//
//==============================================================================
+ (void)setDefaultStatusBarStyle:(UIStatusBarStyle)style
{
    PPViewController_PreferredStatusBarStyle = [[NSNumber numberWithInteger:style] retain];
}


//==============================================================================
//
//==============================================================================
+ (void)setNavigationBarBackgroundImageHidden:(BOOL)hidden
{
    PPViewController_NavigationBarBackgroundImageHidden = [@(hidden) retain];
}


//==============================================================================
//
//==============================================================================
+ (void)setDefaultModalPresentationStyle:(UIModalPresentationStyle)style
{
    PPViewController_ModelPresentationStyle = [@(style) retain];
}


@end
