//
//  PPTextFieldTableViewCell.m
//  
//
//  Created by Mike on 13/5/15.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPTextFieldTableViewCell.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPTextFieldTableViewCell(Notification)

@interface PPTextFieldTableViewCell(Notification)
- (void)textFieldTextDidChangeNotification:(NSNotification *)notification;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPTextFieldTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize textField = textField_;
@synthesize maxLength = maxLength_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if((self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        self.selectionStyle = UITableViewCellSelectionStyleNone;

        //////////////////////////////////////////////////

        //預設輸入上限最高
        maxLength_ = NSUIntegerMax;
        
        //////////////////////////////////////////////////
        
        textField_ = [[CustomRectTextField alloc] init];
        if(self.textField!=nil) 
        {
            self.textField.autocapitalizationType   = UITextAutocapitalizationTypeWords;
            self.textField.autocorrectionType       = UITextAutocorrectionTypeNo;
            self.textField.backgroundColor          = [UIColor clearColor];
            self.textField.borderStyle              = UITextBorderStyleNone;
            self.textField.clearButtonMode          = UITextFieldViewModeWhileEditing;
            self.textField.contentVerticalAlignment = UIControlContentVerticalAlignmentCenter;
            self.textField.delegate                 = self;
            self.textField.returnKeyType            = UIReturnKeyDone;

            [self.contentView addSubview:self.textField];
            
            //////////////////////////////////////////////////
            
            if(self.detailTextLabel!=nil) 
            {
                self.textField.textColor = self.detailTextLabel.textColor;
            }
        }
    
        //////////////////////////////////////////////////
        
        [self layoutSubviews];
        
        //////////////////////////////////////////////////
        
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(textFieldTextDidChangeNotification:)
                                                     name:UITextFieldTextDidChangeNotification
                                                   object:nil];
    }
    
    return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{	
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UITextFieldTextDidChangeNotification object:nil];
    
    //////////////////////////////////////////////////
    
    _delegate = nil;
    
    [textField_ setDelegate:nil];
    [textField_ setDataSource:nil];
    
    [textField_ removeFromSuperview];
    [textField_ release];
	textField_ = nil;
    
    //////////////////////////////////////////////////

	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
	[super layoutSubviews];

    //////////////////////////////////////////////////

    CGRect textFieldFrame = self.contentView.bounds;
    
    //////////////////////////////////////////////////

    if(self.textField!=nil)
    {
        switch(self.style) 
        {
            case UITableViewCellStyleValue1:
            case UITableViewCellStyleValue2:
            {

                break;
            }
            case UITableViewCellStyleSubtitle:
            {
                CGRect textLabelFrame = self.contentView.bounds;
                
                textLabelFrame.size.height  = (self.contentView.bounds.size.height-(PPTableViewCellDefaultVerticalGap+self.contentInsets.top+self.contentInsets.bottom))/2;
                self.textLabel.frame = textLabelFrame;

                
                textFieldFrame.origin.x     = textLabelFrame.origin.x;
                textFieldFrame.origin.y     = textLabelFrame.origin.y+textLabelFrame.size.height+PPTableViewCellDefaultVerticalGap;
                textFieldFrame.size.width   = textLabelFrame.size.width;
                textFieldFrame.size.height  = textLabelFrame.size.height;
                
                break;
            }
            case UITableViewCellStyleDefault:
            default:
            {
                textFieldFrame.origin.x     = self.contentInsets.left;
                textFieldFrame.origin.y     = self.contentInsets.top;
                textFieldFrame.size.width   -= (self.contentInsets.left+self.contentInsets.right);
                textFieldFrame.size.height  -= (self.contentInsets.top+self.contentInsets.bottom);
                
                break;
            }
        }
        
        self.textField.frame = textFieldFrame;
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Intended For Subclasses Method

//================================================================================
//
//================================================================================
- (void)textFieldDidBeginEditing
{
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextFieldTableViewCellDidBeginEditing:)]==YES)
    {
        [self.delegate ppTextFieldTableViewCellDidBeginEditing:self];
    }
}

//================================================================================
//
//================================================================================
- (void)textFieldDidChange
{
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextFieldTableViewCellDidChanged:)]==YES)
    {
        [self.delegate ppTextFieldTableViewCellDidChanged:self];
    }
}

//================================================================================
//
//================================================================================
- (void)textFieldDidEndEditing;
{
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextFieldTableViewCellDidEndEditing:)]==YES)
    {
        [self.delegate ppTextFieldTableViewCellDidEndEditing:self];
    }
}

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldBeginEditing
{
    BOOL shouldBeginEditing = YES;
    
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextFieldTableViewCellShouldBeginEditing:)]==YES)
    {
        shouldBeginEditing = [self.delegate ppTextFieldTableViewCellShouldBeginEditing:self];
    }
    
    return shouldBeginEditing;
}

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    BOOL shouldChange = YES;
    
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextFieldTableViewCell:shouldChangeCharactersInRange:replacementString:)]==YES)
    {
        shouldChange = [self.delegate ppTextFieldTableViewCell:self shouldChangeCharactersInRange:range replacementString:string];
    }
    else if(self.textField.text.length+string.length>self.maxLength)
    {
        // 新增文字，或取代文字
        if(range.length<=string.length &&
           [string length]>0)
        {
            shouldChange = NO;
        }
    }
    
    return shouldChange;
}

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldClear
{
    BOOL shouldClear = YES;
    
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextFieldTableViewCellShouldClear:)]==YES)
    {
        shouldClear = [self.delegate ppTextFieldTableViewCellShouldClear:self];
    }
    
    return shouldClear;
}

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldEndEditing
{
    BOOL shouldEndEditing = YES;
    
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextFieldTableViewCellShouldEndEditing:)]==YES)
    {
        shouldEndEditing = [self.delegate ppTextFieldTableViewCellShouldEndEditing:self];
    }
    
    return shouldEndEditing;
}

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldReturn
{
    BOOL shouldReturn = YES;
    
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextFieldTableViewCellShouldReturn:)]==YES)
    {
        shouldReturn = [self.delegate ppTextFieldTableViewCellShouldReturn:self];
    }
    
    return shouldReturn;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notification Methods

//================================================================================
//
//================================================================================
- (void)textFieldTextDidChangeNotification:(NSNotification*)notification
{
    if(self.textField==[notification object] && self.textField.text.length<=self.maxLength)
    {
        [self textFieldDidChange];
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITextFieldDelegate

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField
{
    return [self textFieldShouldBeginEditing];
}

//================================================================================
//
//================================================================================
- (void)textFieldDidBeginEditing:(UITextField *)textField
{
    [self textFieldDidBeginEditing];
}

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldEndEditing:(UITextField *)textField
{
    return [self textFieldShouldEndEditing];
}

//================================================================================
//
//================================================================================
- (void)textFieldDidEndEditing:(UITextField *)textField;
{
    [self textFieldDidEndEditing];
}

//================================================================================
//
//================================================================================
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    return [self textFieldShouldChangeCharactersInRange:range replacementString:string];
}

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldClear:(UITextField *)textField
{
    return [self textFieldShouldClear];
}

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
    BOOL shouldReturn = [self textFieldShouldReturn];
    
    if(shouldReturn==YES)
    {
        [textField resignFirstResponder];
    }
    
    return shouldReturn;
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - subclass


//==============================================================================
//
//==============================================================================
- (void)setEnable:(BOOL)enable
{
    [super setEnable:enable];
    
    self.textField.userInteractionEnabled = enable;
    self.textField.enabled = enable;
}
@end
