//
//  PPSwitchTableViewCell.m
//  
//
//  Created by Mike on 13/5/15.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPSwitchTableViewCell.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPSliderTableViewCell()

@interface PPSwitchTableViewCell ()
- (void)switchControlValueChanged:(id)sender;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPSwitchTableViewCell




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if((self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //////////////////////////////////////////////////
                
        _switchControl = [[UISwitch alloc] init];
        if(self.switchControl!=nil) 
        {
            [self.switchControl addTarget:self
                                   action:@selector(switchControlValueChanged:)
                         forControlEvents:UIControlEventValueChanged];

            self.accessoryView = self.switchControl;
        }
        
        //////////////////////////////////////////////////
        
        [self layoutSubviews];
        
    }
    
    return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{	
    [_switchControl removeFromSuperview];
    [_switchControl release];
	_switchControl = nil;
    
    //////////////////////////////////////////////////
    
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout of Subview

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    CGRect textLabelFrame = self.contentView.bounds;
    
    self.textLabel.frame = CGRectMake(self.contentInsets.left,
                                      self.contentInsets.top,
                                      textLabelFrame.size.width-self.contentInsets.left-self.contentInsets.right,
                                      textLabelFrame.size.height-self.contentInsets.top-self.contentInsets.bottom);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Methods

//================================================================================
//
//================================================================================
- (void)switchControlValueChanged:(id)sender
{
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppSwitchTableViewCellValueChanged:)]==YES)
    {
        [self.delegate ppSwitchTableViewCellValueChanged:self];
    }
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - subclass


//==============================================================================
//
//==============================================================================
- (void)setEnable:(BOOL)enable
{
    [super setEnable:enable];
    
    self.switchControl.userInteractionEnabled = enable;
    self.switchControl.enabled = enable;
}
@end
