//
//  PPPickerTableViewCell.m
//
//
//  Created by Howard.Lin on 2014/10/29.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "PPPickerTableViewCell.h"

@implementation PPPickerTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object


//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if((self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        _pickerView = [[UIPickerView alloc] initWithFrame:CGRectZero];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    // MARK: Howard 這邊 release 會造成crash ,先註解掉，疑似system bug
    //[_pickerView setDataSource:nil];
    //[_pickerView setDelegate:nil];
    
    [_pickerView removeFromSuperview];
    [_pickerView release];
    _pickerView = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITextFieldDelegate Method

//================================================================================
//
//================================================================================
- (void)textFieldDidBeginEditing:(UITextField *)textField
{
    textField.inputView = self.pickerView;
    
    //////////////////////////////////////////////////
    
    [super textFieldDidBeginEditing:textField];
}


//================================================================================
//
//================================================================================
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    //只能由UIPicker輸入
    return NO;
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - subclass


//==============================================================================
//
//==============================================================================
- (void)setEnable:(BOOL)enable
{
    [super setEnable:enable];
    
    self.pickerView.userInteractionEnabled = enable;
}
@end
