//
//  PPTextFieldButtonView.m
//  Pods
//
//  Created by Howard.Lin on 2014/9/29.
//
//

#import "PPTextFieldButtonView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static UIEdgeInsets const PPTextFieldButtonViewDetailDisclosureButton_EdgeInset = {0,0,0,5};
static NSUInteger   const PPTextFieldButtonViewDetailDisclosureButton_Width     = 24;
static NSUInteger   const PPTextFieldButtonViewDetailDisclosureButton_Height    = 24;

NSString * const ImageNameTextFieldButtonViewDetailDisclosureButton   = @"PPTextFieldButtonViewDetailDisclosureButton";

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPTextFieldButtonView()
@end


////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPTextFieldButtonView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//==============================================================================
//
//==============================================================================
- (void)initilizeProcess
{
    //預設輸入上限最高
    _maxLength = NSUIntegerMax;
    
    //////////////////////////////////////////////////
    
    _textField = [[CustomRectTextField alloc] init];
    
    if(_textField!=nil)
    {
        _textField.autocapitalizationType   = UITextAutocapitalizationTypeWords;
        _textField.autocorrectionType       = UITextAutocorrectionTypeNo;
        _textField.backgroundColor          = [UIColor clearColor];
        _textField.borderStyle              = UITextBorderStyleNone;
        _textField.clearButtonMode          = UITextFieldViewModeWhileEditing;
        _textField.contentVerticalAlignment = UIControlContentVerticalAlignmentCenter;
        _textField.delegate                 = self;
        _textField.returnKeyType            = UIReturnKeyDone;
        
        [self addSubview:_textField];
    }
    
    //////////////////////////////////////////////////
    
    _ppButtonDetail = [[PPButton alloc] init];
    
    if(_ppButtonDetail!=nil)
    {
        _ppButtonDetail.delegate = self;
        [_ppButtonDetail addControlEvents:UIControlEventTouchUpInside];
        [_ppButtonDetail setImageWithName:ImageNameTextFieldButtonViewDetailDisclosureButton];
        [self addSubview:_ppButtonDetail];
    }
    
    //////////////////////////////////////////////////
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(textFieldTextDidChangeNotification:)
                                                 name:UITextFieldTextDidChangeNotification
                                               object:nil];
}


//================================================================================
//
//================================================================================
- (id)initWithCoder:(NSCoder *)coder
{
    if((self = [super initWithCoder:coder]))
    {
        [self initilizeProcess];
    }
    return self;
}


//================================================================================
//
//================================================================================
- (id)init
{
    if((self = [super init]))
    {
        [self initilizeProcess];
    }
    
    return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    
    //////////////////////////////////////////////////
    
    self.delegate = nil;
    
    [_textField setDelegate:nil];
    [_textField setDataSource:nil];
    
    [_textField removeFromSuperview];
    [_textField release];
    _textField = nil;
    
    //////////////////////////////////////////////////
    
    [_ppButtonDetail setDelegate:nil];
    [_ppButtonDetail release];
    _ppButtonDetail = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    if(self.textField!=nil)
    {
        CGRect textFieldFrame = self.bounds;
        
        if([self ppButtonDetail].hidden==NO)
        {
            textFieldFrame.size.width-=(PPTextFieldButtonViewDetailDisclosureButton_Width+PPTextFieldButtonViewDetailDisclosureButton_EdgeInset.right);
        }
        
        self.textField.frame = textFieldFrame;
    }
    
    //////////////////////////////////////////////////
    
    if(self.ppButtonDetail!=nil)
    {
        self.ppButtonDetail.frame = CGRectMake(self.textField.frame.origin.x+self.textField.frame.size.width
                                               ,(self.bounds.size.height-PPTextFieldButtonViewDetailDisclosureButton_Height)/2
                                               ,PPTextFieldButtonViewDetailDisclosureButton_Width
                                               ,PPTextFieldButtonViewDetailDisclosureButton_Height);
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Intended For Subclasses Method

//================================================================================
//
//================================================================================
- (void)textFieldDidBeginEditing
{
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextFieldButtonViewDidBeginEditing:)]==YES)
    {
        [self.delegate ppTextFieldButtonViewDidBeginEditing:self];
    }
}

//================================================================================
//
//================================================================================
- (void)textFieldDidChange
{
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextFieldButtonViewDidChanged:)]==YES)
    {
        [self.delegate ppTextFieldButtonViewDidChanged:self];
    }
}

//================================================================================
//
//================================================================================
- (void)textFieldDidEndEditing;
{
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextFieldButtonViewDidEndEditing:)]==YES)
    {
        [self.delegate ppTextFieldButtonViewDidEndEditing:self];
    }
}

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldBeginEditing
{
    BOOL shouldBeginEditing = YES;
    
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextFieldButtonViewShouldBeginEditing:)]==YES)
    {
        shouldBeginEditing = [self.delegate ppTextFieldButtonViewShouldBeginEditing:self];
    }
    
    return shouldBeginEditing;
}

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    BOOL shouldChange = YES;
    
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextFieldButtonView:shouldChangeCharactersInRange:replacementString:)]==YES)
    {
        shouldChange = [self.delegate ppTextFieldButtonView:self shouldChangeCharactersInRange:range replacementString:string];
    }
    else if(self.textField.text.length+string.length>self.maxLength)
    {
        // 新增文字，或取代文字
        if(range.length<=string.length &&
           [string length]>0)
        {
            shouldChange = NO;
        }
    }
    
    return shouldChange;
}

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldClear
{
    BOOL shouldClear = YES;
    
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextFieldButtonViewShouldClear:)]==YES)
    {
        shouldClear = [self.delegate ppTextFieldButtonViewShouldClear:self];
    }
    
    return shouldClear;
}

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldEndEditing
{
    BOOL shouldEndEditing = YES;
    
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextFieldButtonViewShouldEndEditing:)]==YES)
    {
        shouldEndEditing = [self.delegate ppTextFieldButtonViewShouldEndEditing:self];
    }
    
    return shouldEndEditing;
}

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldReturn
{
    BOOL shouldReturn = YES;
    
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextFieldButtonViewShouldReturn:)]==YES)
    {
        shouldReturn = [self.delegate ppTextFieldButtonViewShouldReturn:self];
    }
    
    return shouldReturn;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notification Methods

//================================================================================
//
//================================================================================
- (void)textFieldTextDidChangeNotification:(NSNotification*)notification
{
    if(self.textField==[notification object] && self.textField.text.length<=self.maxLength)
    {
        [self textFieldDidChange];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppButton:controlEvent:withPPTextFieldButtonView:)]==YES)
    {
        [self.delegate ppButton:ppButton controlEvent:controlEvent withPPTextFieldButtonView:self];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITextFieldDelegate

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField
{
    return [self textFieldShouldBeginEditing];
}

//================================================================================
//
//================================================================================
- (void)textFieldDidBeginEditing:(UITextField *)textField
{
    [self textFieldDidBeginEditing];
}

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldEndEditing:(UITextField *)textField
{
    return [self textFieldShouldEndEditing];
}

//================================================================================
//
//================================================================================
- (void)textFieldDidEndEditing:(UITextField *)textField;
{
    [self textFieldDidEndEditing];
}

//================================================================================
//
//================================================================================
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    return [self textFieldShouldChangeCharactersInRange:range replacementString:string];
}

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldClear:(UITextField *)textField
{
    return [self textFieldShouldClear];
}

//================================================================================
//
//================================================================================
- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
    BOOL shouldReturn = [self textFieldShouldReturn];
    
    if(shouldReturn==YES)
    {
        [textField resignFirstResponder];
    }
    
    return shouldReturn;
}


@end
