//
//  PPMultipleTextFieldButtonTableViewCell.h
//
//  Created by Howard.Lin on 13/9/30.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPTableViewCell.h"
#import "PPTextFieldButtonView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPMultipleTextFieldButtonTableViewCell;

@protocol PPMultipleTextFieldButtonTableViewCellDelegate <NSObject>

@optional

/**
 * To notify the cell is to edit initially
 * @param multipleTextFieldTableViewCell The cell prepares to edit
 * @param tag The tag of textifield
 */
- (void)ppMultipleTextFieldButtonTableViewCellDidBeginEditing:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldTableViewCell
                                           textFieldTag:(NSUInteger)tag;


/**
 * To notify the cell is to edit before keyboard showing.
 * @param multipleTextFieldTableViewCell The cell prepares to edit
 * @param tag The tag of textifield
 */
- (BOOL)ppMultipleTextFieldButtonTableViewCellShouldBeginEditing:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldTableViewCell textFieldTag:(NSUInteger)tag;


/**
 * To ask the keyboard if show or hide
 * @param multipleTextFieldTableViewCell The cell has keyboard foucs
 * @return: Return YES if hide
 */
- (BOOL)ppMultipleTextFieldButtonTableViewCellShouldReturn:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldTableViewCell;


/**
 * To notify the cell text is changed
 * @param multipleTextFieldTableViewCell The cell is typing words
 * @param tag The tag of textifield
 */
- (void)ppMultipleTextFieldButtonTableViewCellDidChanged:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldTableViewCell
                                      textFieldTag:(NSUInteger)tag;

- (void)ppMultipleTextFieldButtonTableViewCellTouchDetail:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldButtonTableViewCell
                                             textFieldTag:(NSUInteger)tag;


- (void)ppMultipleTextFieldButtonTableViewCellDidEndEditing:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldTableViewCell
                                               textFieldTag:(NSUInteger)tag;


- (BOOL)ppMultipleTextFieldButtonTableViewCell:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldTableViewCell
                 shouldChangeCharactersInRange:(NSRange)range
                             replacementString:(NSString *)string
                                  textFieldTag:(NSUInteger)tag;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPMultipleTextFieldButtonTableViewCell : PPTableViewCell <PPTextFieldButtonViewDelegate,UITextFieldDelegate>


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign)   id<PPMultipleTextFieldButtonTableViewCellDelegate> delegate;
@property (nonatomic,readonly) NSMutableArray                                     *textFieldButtonViews;
@property (nonatomic,assign)   NSUInteger                                         maxLength;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 * To custom the fields with placeholders
 * @param placeholders The field's placeholder
 */
- (void)customTextFieldsWithPlacehoders:(NSArray *)placeholders;

@end
