//
//  PPButtonTableViewCell.m
//  WorldCardCloud
//
//  Created by Howard.Lin on 2014/10/24.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "PPButtonTableViewCell.h"
#import "UIView+Appearance.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSString * const ImageNamePPButtonTableViewCellSwitchOn   = @"PPButtonTableViewCellSwitchOn";
static NSString * const ImageNamePPButtonTableViewCellSwitchOff  = @"PPButtonTableViewCellSwitchOff";
static CGSize     const PPButtonTableViewCellButtonFrame         = {75,36};
static CGFloat    const PPButtonTableViewCellButtonRadius        = 10;

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPButtonTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if((self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //////////////////////////////////////////////////
        
        _ppButtoSelect = [[PPButton alloc] initWithFrame:CGRectMake(0, 0, PPButtonTableViewCellButtonFrame.width, PPButtonTableViewCellButtonFrame.height)];
        
        if(self.ppButtoSelect!=nil)
        {
            self.ppButtoSelect.delegate = self;
            
            [self.ppButtoSelect setCornerRadius:PPButtonTableViewCellButtonRadius];
            [self.ppButtoSelect setImage:[UIImage imageWithName:ImageNamePPButtonTableViewCellSwitchOff] forState:UIControlStateNormal];
            
            [self.ppButtoSelect setImage:[UIImage imageWithName:ImageNamePPButtonTableViewCellSwitchOn] forState:UIControlStateSelected];
            
            [self.ppButtoSelect addControlEvents:UIControlEventTouchUpInside];
            
            self.accessoryView = self.ppButtoSelect;
        }
        
        //////////////////////////////////////////////////
        
        [self layoutSubviews];
    }
    
    return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    
    _ppButtoSelect.delegate = nil;
    [_ppButtoSelect removeControlEvents:UIControlEventTouchUpInside];
    [_ppButtoSelect removeFromSuperview];
    [_ppButtoSelect release];
    _ppButtoSelect = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    if(self.ppButtoSelect!=nil)
    {
        CGRect textLabelFrame = self.textLabel.frame;
        textLabelFrame.origin.x     = self.contentInsets.left+self.indentationLevel*self.indentationWidth;
        textLabelFrame.size.width   = self.ppButtoSelect.frame.origin.x-self.contentInsets.right-self.textLabel.frame.origin.x;
        self.textLabel.frame = textLabelFrame;
        
        CGRect detailTextLabelFrame = self.detailTextLabel.frame;
        detailTextLabelFrame.origin.x     = self.contentInsets.left+self.indentationLevel*self.indentationWidth;
        detailTextLabelFrame.size.width   = self.ppButtoSelect.frame.origin.x-self.contentInsets.right-self.textLabel.frame.origin.x;
        self.detailTextLabel.frame = detailTextLabelFrame;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    ppButton.selected = !ppButton.selected;
    
    //////////////////////////////////////////////////
    
    if([self.delegate respondsToSelector:@selector(ppButtonTableViewCell:ppButton:controlEvent:)]==YES)
    {
        [self.delegate ppButtonTableViewCell:self
                                    ppButton:ppButton
                                controlEvent:controlEvent];
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - subclass


//==============================================================================
//
//==============================================================================
- (void)setEnable:(BOOL)enable
{
    [super setEnable:enable];
    
    self.ppButtoSelect.userInteractionEnabled = enable;
    self.ppButtoSelect.enabled = enable;
}


@end
