//
//  PPSyncCompareModel.m
//  
//
//  Created by Mike Shih on 12/03/16.
//  Copyright (c) 2012年 Penpower. All rights reserved.
//

#import "PPSyncCompareModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation PPSyncCompareModel

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.uniqueID = nil;
    self.lastModifiedDate = nil;
    
    //////////////////////////////////////////////////
    
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Override methods

//================================================================================
//
//================================================================================
- (NSString *)description
{
	return [NSString stringWithFormat:@"{deleted:%@ needForceUpdate:%@ uniqueID:%@ lastModifiedDate:%@}",
            (self.deleted?@"YES":@"NO"),
            (self.needForceUpdate?@"YES":@"NO"),
			self.uniqueID, 
			self.lastModifiedDate];
}


//==============================================================================
//
//==============================================================================
- (id)copyWithZone:(nullable NSZone *)zone
{
    PPSyncCompareModel *compareModel = [[[self class] allocWithZone:zone] init];

    compareModel.deleted = self.deleted;
    compareModel.needForceUpdate = self.needForceUpdate;
    compareModel.uniqueID = [[self.uniqueID copyWithZone:zone] autorelease];
    compareModel.lastModifiedDate = [[self.lastModifiedDate copyWithZone:zone] autorelease];
    
    return compareModel;
}


//===============================================================================
//
//===============================================================================
- (BOOL)isEqual:(id)object
{
    if(object == nil || [object isKindOfClass:[self class]] == NO)
    {
        return NO;
    }
    
    //////////////////////////////////////////////////
    
    PPSyncCompareModel *target = (PPSyncCompareModel *)object;

    return (self.deleted == target.deleted &&
            self.needForceUpdate == target.needForceUpdate &&
            [self.uniqueID isEqualToString:target.uniqueID] == YES &&
            [self.lastModifiedDate isEqualToDate:target.lastModifiedDate] == YES);
}

@end
