//
//  NSMutableDictionary+NSInteger.m
//  
//
//  Created by Mike on 13/10/28.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "NSMutableDictionary+NSInteger.h"

@implementation NSMutableDictionary (NSInteger)

//===============================================================================
//
//===============================================================================
- (id)objectForIntegerKey:(NSInteger)integerKey
{
    id object = nil;
    
    NSString *key = [[NSString alloc] initWithFormat:@"%@", @(integerKey)];
    if(key!=nil)
    {
        object = [self objectForKey:key];
        
        [key release];
    }
    
	return object;
}

//===============================================================================
//
//===============================================================================
- (void)setObject:(id)object forIntegerKey:(NSInteger)integerKey
{
    NSString *key = [[NSString alloc] initWithFormat:@"%@", @(integerKey)];
    if(key!=nil)
    {
       [self setObject:object forKey:key];
        
        [key release];
    }
}

//===============================================================================
//
//===============================================================================
- (void)removeObjectForIntegerKey:(NSInteger)integerKey
{
    NSString *key = [[NSString alloc] initWithFormat:@"%@", @(integerKey)];
    if(key!=nil)
    {
        [self removeObjectForKey:key];
        
        [key release];
    }
}

//===============================================================================
//
//===============================================================================
- (NSInteger)integerValueForKey:(id<NSCopying>)key
{
	return [[self objectForKey:key] integerValue];
}

//===============================================================================
//
//===============================================================================
- (void)setIntegerValue:(NSInteger)integerValue forKey:(id<NSCopying>)key
{
    NSNumber *object = [[NSNumber alloc] initWithInteger:integerValue];
    if(object!=nil)
    {
        [self setObject:object forKey:key];
        [object release];
    }
}

@end
