//
//  PPStorageSpaceSelectSectionController.m
//  Pods
//
//  Created by Howard on 2015/8/3.
//
//

#import "PPStorageSpaceSelectSectionController.h"

// define
#import "PPStorageSpaceSelectViewController+ResourceDefine.h"
#import "PPStorageSpaceSelectViewController+SettingKey.h"

// model
#import "PPSpaceRowModel.h"

// Controller
#import "PPSettingsController.h"
#import "PPCloudController.h"
#import "PPCloud_Dropbox.h"
#import "PPCloud_GoogleDrive.h"
#import "PPCloud_iCloud.h"
#import "PPCloud_OneDrive.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPStorageSpaceSelectSectionController



//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    [_exchangeServerName release];
    _exchangeServerName = nil;
    [super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (PPSpaceRowModel *)spaceRowModelWithStorageSpaceSelectSectionControllerRow:(PPStorageSpaceSelectSectionControllerRow)storageSpaceSelectSectionControllerRow
{
    PPSpaceRowModel *spaceRowModel = nil;
    
    do
    {
        PPSectionModel *sectionModel = [self.sectionModelsForDefault firstObject];
        
        if(sectionModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        for(PPSpaceRowModel *rowModel in sectionModel.rowModels)
        {
            if(rowModel.storageSpaceSelectSectionControllerRow==storageSpaceSelectSectionControllerRow)
            {
                spaceRowModel = [rowModel retain];
                
                break;
            }
        }
    }
    while (0);

    return [spaceRowModel autorelease];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (BOOL)needFetchAccoutInfoWithRow:(NSUInteger)row;
{
    BOOL result = NO;
    
    do
    {
        PPRowModel *rowModel = [self rowModelAtIndex:row forSearching:NO];
        
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if(rowModel.object==nil ||
           [rowModel.object isKindOfClass:[NSNumber class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        //已存在帳號資訊顯示
        if(rowModel.detailText!=nil &&
           rowModel.detailText.length>0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        result = [[rowModel object] boolValue];
    }
    while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)fetchDefaultDataWithSpaceTypes:(NSArray *)spaceTypes
{
    [self.sectionModelsForDefault removeAllObjects];
    
    //////////////////////////////////////////////////

    @autoreleasepool
    {
        do
        {
            if(spaceTypes==nil ||
               spaceTypes.count<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////

            PPSectionModel *sectionModel = [[[PPSectionModel alloc] init] autorelease];
            
            if(sectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            [self.sectionModelsForDefault addObject:sectionModel];
            
            //////////////////////////////////////////////////
            
            for(id object in spaceTypes)
            {
                PPSpaceRowModel *rowModel = [[[PPSpaceRowModel alloc] init] autorelease];
                
                if(rowModel==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////

                rowModel.row = sectionModel.rowModels.count;
                
                rowModel.storageSpaceSelectSectionControllerRow = [object unsignedIntegerValue];
                
                //////////////////////////////////////////////////
                
                switch ([object unsignedIntegerValue])
                {
                    case PPStorageSpaceSelectSectionControllerRow_Baidu:
                    {
                        rowModel.text = PSSSVC_MLS_Baidu;
                        
                        //////////////////////////////////////////////////
                        
                        // TODO 百度
                        rowModel.object = @(NO);
                        
                        break;
                    }
                    case PPStorageSpaceSelectSectionControllerRow_Dropbox:
                    {
                        rowModel.text = PSSSVC_MLS_Dropbox;
                        
                        rowModel.object = @(NO);
                        
                        break;
                    }
                    case PPStorageSpaceSelectSectionControllerRow_GoogleDrive:
                    {
                        rowModel.text = PSSSVC_MLS_GoogleDrive;
                        
                        rowModel.object = @(NO);
                        
                        break;
                    }
                    case PPStorageSpaceSelectSectionControllerRow_OneDrive:
                    {
                        rowModel.text = PSSSVC_MLS_OneDrive;
                        
                        rowModel.object = @(NO);
                        
                        break;
                    }
                    case PPStorageSpaceSelectSectionControllerRow_Huawei:
                    {
                        rowModel.text = PSSSVC_MLS_Huawei;
                        
                        rowModel.object = @(NO);

                        break;
                    }
                    case PPStorageSpaceSelectSectionControllerRow_iCloud:
                    {
                        rowModel.text = PSSSVC_MLS_iCloud;
                        
                        rowModel.object = @(NO);
                        
                        break;
                    }
                    case PPStorageSpaceSelectSectionControllerRow_iTune:
                    {
                        rowModel.text = PSSSVC_MLS_iTune;
                        
                        // iTune
                        rowModel.object = @(YES);
                        
                        
                        break;
                    }
                    case PPStorageSpaceSelectSectionControllerRow_AddressBook:
                    {
                        rowModel.text = PSSSVC_MLS_SystemContact;
                        
                        // SystemContact
                        rowModel.object = @(YES);
                        
                        break;
                    }
                    case PPStorageSpaceSelectSectionControllerRow_Salesforce:
                    {
                        rowModel.text = PSSSVC_MLS_Salesforce;
                        
                        rowModel.object = @(NO);
                        break;
                    }
                    case PPStorageSpaceSelectSectionControllerRow_ExchangeServer:
                    {
                        NSString *rowText = PSSSVC_MLS_ExchangeServer;
                        if ([self.exchangeServerName length]>0)
                        {
                            rowText = [rowText stringByAppendingFormat:@"(%@)", self.exchangeServerName];
                        }
                        rowModel.text = rowText;
                        
                        rowModel.object = @(NO);
                        break;
                    }
                    case PPStorageSpaceSelectSectionControllerRow_Specific:
                    {
                        rowModel.text = PSSSVC_MLS_StorageSpecificTitle;
                        
                        // Specific ex WorldCardTeam WorldCardMobileLite
                        rowModel.object = @(YES);
                        
                        break;
                    }
                    default:
                    {
                        break;
                    }
                }
                
                //////////////////////////////////////////////////

                [sectionModel.rowModels addObject:rowModel];
            }
        }
        while (0);
    }
}


//================================================================================
//
//================================================================================
- (void)fetchNeedFetchAccoutInfoWithPPStorageSpaceSelectSectionControllerRow:(PPStorageSpaceSelectSectionControllerRow)storageSpaceSelectSectionControllerRow
{
    do
    {
        PPSpaceRowModel *rowModel = [self spaceRowModelWithStorageSpaceSelectSectionControllerRow:storageSpaceSelectSectionControllerRow];
        
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        switch (storageSpaceSelectSectionControllerRow)
        {
            case PPStorageSpaceSelectSectionControllerRow_Baidu:
            {
                // TODO Baidu
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_Dropbox:
            {
                rowModel.object = [NSNumber numberWithBool:[PPCloudController isLinkedWithCloudClass:[PPCloud_Dropbox class]]];
                
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_GoogleDrive:
            {
                rowModel.object = [NSNumber numberWithBool:[PPCloudController isLinkedWithCloudClass:[PPCloud_GoogleDrive class]]];
                
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_OneDrive:
            {
                rowModel.object = [NSNumber numberWithBool:[PPCloudController isLinkedWithCloudClass:[PPCloud_OneDrive class]]];
                
                break;
            }
//            case PPStorageSpaceSelectSectionControllerRow_Huawei:
//            {
//                rowModel.object = [NSNumber numberWithBool:[PPCloudController isLinkedWithCloudClass:[PPCloud_Huawei class]]];
//                
//                break;
//            }
            case PPStorageSpaceSelectSectionControllerRow_iCloud:
            {
                rowModel.object = [NSNumber numberWithBool:[PPCloudController isLinkedWithCloudClass:[PPCloud_iCloud class]]];
                
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_iTune:
            {
                // TODO: iTune
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_AddressBook:
            {
                // TODO: SystemContact
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_Salesforce:
            {
                if([[PPSettingsController stringValueWithKey:PSSSVCSettingKey_SalesforceAccountName] length]>0)
                {
                    rowModel.object = @(YES);
                }
                else
                {
                    rowModel.object = @(NO);
                }
                
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_ExchangeServer:
            {
                if([[PPSettingsController stringValueWithKey:PSSSVCSettingKey_ExchangeServerAccountName] length]>0)
                {
                    rowModel.object = @(YES);
                }
                else
                {
                    rowModel.object = @(NO);
                }
                
                break;
            }
            case PPStorageSpaceSelectSectionControllerRow_Specific:
            {
                break;
            }
            default:
            {
                break;
            }
        }
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)fetchAccountInfoWithStorageSpaceSelectSectionControllerRow:(PPStorageSpaceSelectSectionControllerRow)storageSpaceSelectSectionControllerRow cloudAccountInfo:(PPCloudAccountInfo *)cloudAccountInfo
{
    do
    {
        PPSpaceRowModel *rowModel = [self spaceRowModelWithStorageSpaceSelectSectionControllerRow:storageSpaceSelectSectionControllerRow];
        
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(cloudAccountInfo==nil)
        {
            rowModel.detailText = nil;
        }
        else
        {
            rowModel.detailText = cloudAccountInfo.displayName;
        }
        
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (NSUInteger)indexPathRowForStorageSpaceSelectSectionControllerRow:(PPStorageSpaceSelectSectionControllerRow)storageSpaceSelectSectionControllerRow
{
    NSUInteger indexPathRow = 0;

    do
    {
        PPSectionModel *sectionModel = [self.sectionModelsForDefault firstObject];
        
        if(sectionModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(PPSpaceRowModel *rowModel in sectionModel.rowModels)
        {
            if(rowModel.storageSpaceSelectSectionControllerRow==storageSpaceSelectSectionControllerRow)
            {
                indexPathRow = [sectionModel.rowModels indexOfObject:rowModel];
                
                break;
            }
        }
    }
    while (0);

    return indexPathRow;
}
@end
