//
//  PPStorageFileFetch_iTune.m
//  Pods
//
//  Created by Howard on 2015/8/4.
//
//

#import "PPStorageFileFetch_iTune.h"

// Controller
#import "PPPathController.h"
#import "PPStorageFielSelectRowModel.h"

@implementation PPStorageFileFetch_iTune

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (NSComparisonResult)modifydateCompareAtFilePath1:(NSString *)filePath1 filePath2:(NSString *)filePath2
{
    NSComparisonResult result = NSOrderedSame;
    
    do
    {
        if(filePath1==nil ||
           filePath2==nil ||
           filePath1.length<=0 ||
           filePath2.length<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        NSDictionary *property1 = [[NSFileManager defaultManager] attributesOfItemAtPath:filePath1
                                                                                   error:nil];
        
        if(property1==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSDate *modifyDate1 = [property1 objectForKey:NSFileModificationDate];
        
        if(modifyDate1==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSDictionary *property2 = [[NSFileManager defaultManager] attributesOfItemAtPath:filePath2
                                                                                   error:nil];
        
        if(property2==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSDate *modifyDate2 = [property2 objectForKey:NSFileModificationDate];
        
        if(modifyDate2==nil)
        {
            break;
        }
        
        result = [modifyDate1 compare:modifyDate2];
    }
    while (0);

    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (BOOL)fetchSectinoModels
{
    NSMutableArray *sectionModels = nil;
    
    do
    {
        if([self.storageFileFetchDelegate respondsToSelector:@selector(fetchedStorageFileSectionModels:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        sectionModels = [NSMutableArray array];
        
        if(sectionModels==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(id object in self.extensionFileNames)
        {
            if(object==nil ||
               [object isKindOfClass:[NSString class]]==NO)
            {
                continue;
            }
            
            //////////////////////////////////////////////////
            
            PPSectionModel *sectionModel = [self sectionModelWithExtensionFileName:object sectionTitle:[self.sectionTitleDictionary objectForKey:object]];
            
            if(sectionModel==nil ||
               sectionModel.rowModels.count<=0)
            {
                continue;
            }
            
            //////////////////////////////////////////////////
            
            [sectionModels addObject:sectionModel];
        }
        
        //////////////////////////////////////////////////

        [self.storageFileFetchDelegate fetchedStorageFileSectionModels:sectionModels];
    }
    while (0);
    
    return YES;
}



//================================================================================
//
//================================================================================
- (PPSectionModel *)sectionModelWithExtensionFileName:(NSString *)extensionFileName sectionTitle:(NSString *)sectionTitle
{
    PPSectionModel *sectionModel = nil;
    
    do
    {
        if(extensionFileName==nil ||
           extensionFileName.length<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        sectionModel = [[PPSectionModel alloc] init];
        
        if(sectionModel==nil)
        {
            break;
        }
        
        sectionModel.title = sectionTitle;
        
        //////////////////////////////////////////////////
        
        @autoreleasepool
        {
            NSFileManager *defaultManager = [NSFileManager defaultManager];
            
            if(defaultManager==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSString *iTuenFilePath = nil;
            
            if(self.defaultFilePath!=nil)
            {
                iTuenFilePath = [[PPPathController documentsDirectory] stringByAppendingString:self.defaultFilePath];
            }
            else
            {
                iTuenFilePath = [PPPathController documentsDirectory];
            }
            
            
            if(iTuenFilePath==nil ||
               iTuenFilePath.length<=0)
            {
                break;
            }
            
            PPLogFunction(@" iTuenFilePath:%@",iTuenFilePath);
    
            //////////////////////////////////////////////////
            
            NSDirectoryEnumerator *dirEnum = [defaultManager enumeratorAtPath:iTuenFilePath];
            
            if(dirEnum==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSString *fileName = nil;
            
            while(fileName=[dirEnum nextObject])
            {
                if([[fileName pathExtension] isEqualToString:extensionFileName]==NO ||
                   [[fileName pathComponents] count]!=1)
                {
                    continue;
                }
                
                //////////////////////////////////////////////////
                
                PPLogFunction(@"fileName:%@",fileName);
                
                //////////////////////////////////////////////////
                
                NSString *filePath = [iTuenFilePath stringByAppendingFormat:@"/%@",fileName];
                
                if(filePath==nil)
                {
                    continue;
                }
                
                //////////////////////////////////////////////////
                
                PPStorageFielSelectRowModel *rowModel = [[PPStorageFielSelectRowModel alloc] init];
                
                if(rowModel!=nil)
                {
                    rowModel.row  = sectionModel.rowModels.count;
                    
                    if([extensionFileName compare:@"wcxf"]==NSOrderedSame)
                    {
                        NSInteger cardCount = 0;
                        
                        if([self.storageFileFetchDelegate respondsToSelector:@selector(cardCountFromFilePath:)]==YES)
                        {
                            cardCount = [self.storageFileFetchDelegate cardCountFromFilePath:filePath];
                            
                            //////////////////////////////////////////////////
                            
                            if(cardCount!=NSNotFound)
                            {
                                rowModel.detailText = [[NSString stringWithFormat:@"%td",cardCount] stringByAppendingString:PPSFSV_MLS_Entry];
                            }
                        }
                        
                        //////////////////////////////////////////////////
                        
                        rowModel.text = [fileName stringByDeletingPathExtension];
                    }
                    else
                    {
                        /// 單一檔案只有一個聯絡人的匯出檔名格式 (Index_DisplayName.*) - ex: "01_EddieHu.vcf"
                        /// 沒有姓名時使用 "NoName"
                        
                        NSArray *cadidatedWords = [fileName componentsSeparatedByString:@"_"];
                        
                        //檔名符合預期格式
                        if(cadidatedWords.count==2)
                        {
                            NSString *frontWord = [cadidatedWords lastObject];
                            
                            rowModel.text = [frontWord stringByDeletingPathExtension];
                        }
                        else
                        {
                            rowModel.text = [fileName stringByDeletingPathExtension];
                        }
                    }
                    
                    //////////////////////////////////////////////////
                    
                    rowModel.object = filePath;

                    //////////////////////////////////////////////////

//                    NSUInteger insertRowModelIndex = 0;
//                    
//                    // sort by modifydate
//                    for(; insertRowModelIndex<sectionModel.rowModels.count; insertRowModelIndex++)
//                    {
//                        PPRowModel *existRowModel = [sectionModel.rowModels objectAtIndex:insertRowModelIndex];
//                        
//                        if([self modifydateCompareAtFilePath1:existRowModel.object filePath2:rowModel.object]==NSOrderedAscending)
//                        {
//                            break;
//                        }
//                    }
//                    
//                    if(insertRowModelIndex==sectionModel.rowModels.count)
//                    {
                        [sectionModel.rowModels addObject:rowModel];
//                    }
//                    else
//                    {
//                        [sectionModel.rowModels insertObject:rowModel atIndex:insertRowModelIndex];
//                    }
                    
                }
                
                [rowModel release];
                
            }
        }
    }
    while (0);
    
    return [sectionModel autorelease];
}


//================================================================================
//
//================================================================================
- (void)deleteFileFromPath:(NSString *)path userInfo:(id)userInfo
{
    [super deleteLocalFileFromPath:path userInfo:userInfo];
}

@end
