//
//  PPStorageFileFetch_GoogleDrive.m
//  Pods
//
//  Created by Howard on 2015/8/16.
//
//

#import "PPStorageFileFetch_OneDrive.h"
#import "PPCloud_OneDrive.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPStorageFileFetch_OneDrive

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance method

//================================================================================
//
//================================================================================
- (BOOL)fetchSectinoModels
{
    return [PPCloudController loadMetadata:self.defaultFilePath
                                  delegate:self
                                  userInfo:nil
                                cloudClass:[PPCloud_OneDrive class]];
}


//================================================================================
//
//================================================================================
- (void)downloadFileWithPath:(NSString *)path fileID:(NSString *)fileID useinfo:(id)userinfo
{
    NSString *intoPath = [[PPPathController tempDirectory] stringByAppendingString:[NSString stringWithFormat:@"%@",[path lastPathComponent]]];
    
    [PPCloudController loadFileFromPath:path
                               orFileID:fileID
                               intoPath:intoPath
                               delegate:self
                               userInfo:userinfo
                             cloudClass:[PPCloud_OneDrive class]];
}


//================================================================================
//
//================================================================================
- (void)deleteFileFromPath:(NSString *)path userInfo:(id)userInfo
{
    [PPCloudController deletePath:path
                         delegate:self
                         userInfo:userInfo
                       cloudClass:[PPCloud_OneDrive class]];
}


@end
