//
//  PPSelectImageView.m
//
//
//  Created by Mike.Shih on 13/10/14.
//  Copyright (c) 2013年 Mike.Shih. All rights reserved.
//

#import "PPSelectImageView.h"

// Define
#import "PPSelectImageView+ParameterDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSInteger    instanceCount                   = 0;
static UIImage      *selectImageViewSelectImage     = nil;
static UIImage      *selectImageViewUnselectImage   = nil;
static UIImage      *selectImageViewSelectHighlightedImage = nil;
static UIImage      *selectImageViewUnSelectHighlightedImage = nil;

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPSelectImageView





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize status = status_;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    @autoreleasepool
    {
        if((self = [super init]))
        {
            instanceCount++;
            
            if(instanceCount==1)
            {
                selectImageViewSelectImage = [[UIImage imageWithName:ImageNamePPSelectImageViewSelect] retain];
                selectImageViewUnselectImage = [[UIImage imageWithName:ImageNamePPSelectImageViewUnselect] retain];
                selectImageViewSelectHighlightedImage = [[UIImage imageWithName:ImageNamePPSelectImageViewSelectHighlighted] retain];
                selectImageViewUnSelectHighlightedImage = [[UIImage imageWithName:ImageNamePPSelectImageViewUnselectHighlighted] retain];
            }
        }
    }
	
	return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    instanceCount--;
    
    if(instanceCount==0)
	{
		[selectImageViewSelectImage release];
		selectImageViewSelectImage = nil;
        
        [selectImageViewUnselectImage release];
		selectImageViewUnselectImage = nil;
        
        [selectImageViewSelectHighlightedImage release];
        selectImageViewSelectHighlightedImage = nil;
        
        [selectImageViewUnselectImage release];
        selectImageViewUnselectImage = nil;
	}
    
    //////////////////////////////////////////////////
    
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Methods

//================================================================================
//  設定目前PPSelectImageView的狀態圖示
//================================================================================
- (void)setStatus:(PPSelectStatus)status
{
    status_ = status;
    
    //////////////////////////////////////////////////
    
    switch(self.status)
    {
        case PPSelectStatus_Select:
        {
            self.image = selectImageViewSelectImage;
            
            break;
        }
        case PPSelectStatus_Unselect:
        {
            self.image = selectImageViewUnselectImage;
            
            break;
        }
        case PPSelectStatus_SelectHighlighted:
        {
            self.image = selectImageViewSelectHighlightedImage;
            break;
        }
        case PPSelectStatus_UnSelectHighlighted:
        {
            self.image = selectImageViewUnSelectHighlightedImage;
            break;
        }
        case PPSelectStatus_None:
        default:
        {
            self.image = nil;
            
            break;
        }
    }
}

@end
