//
//  SalesforceParamHelper.m
//  Pods
//
//  Created by sanhue on 2016/9/19.
//
//

#import "SalesforceParamHelper.h"

@implementation SalesforceParamHelper

//==============================================================================
//
//==============================================================================
+ (NSMutableDictionary *)parseQueryString:(NSString *)query
{
    return [self parseQueryString:query decodeParams:YES];
}


//==============================================================================
//
//==============================================================================
+ (NSMutableDictionary *)parseQueryString:(NSString *)query decodeParams:(BOOL)decodeParams
{
    NSArray *pairs = [query componentsSeparatedByString:@"&"]; // TODO: support semicolon delimiter also
    NSMutableDictionary *result = [[NSMutableDictionary alloc] initWithCapacity:pairs.count];
    
    for (NSString *pair in pairs) {
        NSArray *keyValue = [pair componentsSeparatedByString:@"="];
        NSString *key = keyValue[0];
        NSString *value = keyValue[1];
        if (decodeParams) {
            key = [[key
                    stringByReplacingOccurrencesOfString:@"+" withString:@" "] stringByRemovingPercentEncoding];
            value = [[value
                      stringByReplacingOccurrencesOfString:@"+" withString:@" "] stringByRemovingPercentEncoding];
        }
        result[key] = value;
    }
    return [result autorelease];
}

@end
