//
//  WCTMatomoController
//

#import "WCTMatomoController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

NSString *const WCTMatomoController_ProductName = @"WCT";

typedef NS_ENUM(NSUInteger, WCTMatomoController_Platform)
{
    WCTMatomoController_Platform_iOS = 0,
    WCTMatomoController_Platform_Mac,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCTMatomoController

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private methods

//================================================================================
//
//================================================================================
+ (NSString *)urlStringOfCurrentPlatform
{
#ifdef __IPHONE_OS_VERSION_MIN_REQUIRED
    return @"iOS";
#else
    return @"Mac";
#endif
}


//================================================================================
//
//================================================================================
+ (NSString *)urlStringOfCurrentVersion
{
    NSString *appVersion = [[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleShortVersionString"];
    
    return [NSString stringWithFormat:@"v%@", appVersion];
}


//================================================================================
//
//================================================================================
+ (NSString *)baseUrlStringWithFeature:(WCTMatomoController_Feature)feature
{
    NSString *resultURL = @"";
    NSMutableArray *urlComponents = [NSMutableArray array];
    
    if(urlComponents != nil)
    {
        NSDictionary *dictionary = @{@(WCTMatomoController_Feature_Add):@"Add",
                                     @(WCTMatomoController_Feature_ManualShare):@"ManualShare",
                                     @(WCTMatomoController_Feature_Download):@"Download",
                                     @(WCTMatomoController_Feature_Import):@"Import",
                                     @(WCTMatomoController_Feature_Export):@"Export",
                                     @(WCTMatomoController_Feature_Email):@"Email",
                                     @(WCTMatomoController_Feature_Skype):@"Skype",
                                     @(WCTMatomoController_Feature_Map):@"Map",
                                     @(WCTMatomoController_Feature_Settings):@"Settings"};
        
        NSString *featureString = [dictionary objectForKey:@(feature)];
        
        if([featureString length] > 0)
        {
            [urlComponents addObject:@"http:/"];
            [urlComponents addObject:WCTMatomoController_ProductName];
            [urlComponents addObject:[self urlStringOfCurrentPlatform]];
            [urlComponents addObject:[self urlStringOfCurrentVersion]];
            [urlComponents addObject:featureString];
            
            resultURL = [urlComponents componentsJoinedByString:@"/"];
        }
    }
    
    return resultURL;
}


//================================================================================
//
//================================================================================
+ (NSString *)urlStringWithDownloadSource:(WCTMatomoController_DownloadSource)downloadSource
{
    NSDictionary *dictionary = @{@(WCTMatomoController_DownloadSource_Notification):@"Notification",
                                 @(WCTMatomoController_DownloadSource_SharedList):@"SharedList"};
    
    NSString *result = [dictionary objectForKey:@(downloadSource)];
    
    return result;
}


//================================================================================
//
//================================================================================
+ (NSString *)urlStringWithExportTarget:(WCTMatomoController_ExportTarget)exportTarget
{
    NSDictionary *dictionary = @{@(WCTMatomoController_ExportTarget_Outlook):@"Outlook",
                                 @(WCTMatomoController_ExportTarget_CSV):@"CSV",
                                 @(WCTMatomoController_ExportTarget_VCF):@"VCF",
                                 @(WCTMatomoController_ExportTarget_SalesforceContact):@"SalesforceContact",
                                 @(WCTMatomoController_ExportTarget_SalesforceLead):@"SalesforceLead"};
    
    NSString *result = [dictionary objectForKey:@(exportTarget)];
    
    return result;
}


//================================================================================
//
//================================================================================
+ (NSString *)urlStringWithSettingsItem:(WCTMatomoController_SettingsItem)settingsItem
{
    NSDictionary *dictionary = @{@(WCTMatomoController_SettingsItem_AutoShare):@"AutoShare",
                                 @(WCTMatomoController_SettingsItem_ManualShare):@"ManualShare",
                                 @(WCTMatomoController_SettingsItem_SalesforceAutoSync):@"SalesforceAutoSync",
                                 @(WCTMatomoController_SettingsItem_SalesforceManualExport):@"SalesforceManualExport"};
    
    NSString *result = [dictionary objectForKey:@(settingsItem)];
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods (暫不開放)

//================================================================================
//
//================================================================================
+ (void)sendLogWithFeature:(WCTMatomoController_Feature)feature
{
//    NSString *urlString = [self baseUrlStringWithFeature:feature];
//
//    [PPMatomoController sendMatomoRequestWithUrl:urlString];
}


//================================================================================
//
//================================================================================
+ (void)sendLogWithDownloadSource:(WCTMatomoController_DownloadSource)downloadSource
{
//    NSString *urlString = [self baseUrlStringWithFeature:WCTMatomoController_Feature_Download];
//
//    urlString = [urlString stringByAppendingPathComponent:[self urlStringWithDownloadSource:downloadSource]];
//
//    [PPMatomoController sendMatomoRequestWithUrl:urlString];
}


//================================================================================
//
//================================================================================
+ (void)sendLogWithExportTarget:(WCTMatomoController_ExportTarget)exportTarget
{
//    NSString *urlString = [self baseUrlStringWithFeature:WCTMatomoController_Feature_Export];
//
//    urlString = [urlString stringByAppendingPathComponent:[self urlStringWithExportTarget:exportTarget]];
//
//    [PPMatomoController sendMatomoRequestWithUrl:urlString];
}


//================================================================================
//
//================================================================================
+ (void)sendLogWithSettingsItem:(WCTMatomoController_SettingsItem)settingsItem
{
//    NSString *urlString = [self baseUrlStringWithFeature:WCTMatomoController_Feature_Settings];
//
//    urlString = [urlString stringByAppendingPathComponent:[self urlStringWithSettingsItem:settingsItem]];
//
//    [PPMatomoController sendMatomoRequestWithUrl:urlString];
}

@end
