//
//  PPTouchID.m
//  Pods
//
//  Created by sanhue on 2015/9/22.
//
//

#import "PPTouchID.h"
#import <LocalAuthentication/LocalAuthentication.h>


static LAContext *laContext = nil;
////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation PPTouchID


//==============================================================================
//
//==============================================================================
+ (BOOL)canUseTouchID
{
    LAContext *myContext = [[[LAContext alloc] init] autorelease];
    return [myContext canEvaluatePolicy:LAPolicyDeviceOwnerAuthenticationWithBiometrics error:nil];
}


//==============================================================================
//
//==============================================================================
+ (void)showWithReason:(NSString * __nonnull)reason
customEnterPasswordTitle:(NSString * __nullable)customEnterPasswordTitle
            completion:(PPTouchIDCompletion __nullable)completion
{
    static BOOL isAlertPresent = NO;
    laContext = [[LAContext alloc] init];
    NSError *authError = nil;
    NSString *myLocalizedReasonString = reason;
    if (isAlertPresent==YES)
    {
        if (completion)
        {
            completion(PPTouchIDResponse_AlreadyPresent);
            [laContext release];
            laContext = nil;
        }
        return;
    }
    
    if ([laContext canEvaluatePolicy:LAPolicyDeviceOwnerAuthenticationWithBiometrics error:&authError]) {
        isAlertPresent = YES;
        
        laContext.localizedFallbackTitle = customEnterPasswordTitle;
        
        [laContext evaluatePolicy:LAPolicyDeviceOwnerAuthenticationWithBiometrics
                  localizedReason:myLocalizedReasonString
                            reply:^(BOOL success, NSError *error) {
                                isAlertPresent = NO;
                                // !! replay may not called on main thread, so dispatch always
                                dispatch_async(dispatch_get_main_queue(), ^{
                                    if (success)
                                    {
                                        // User authenticated successfully, take appropriate action
                                        if (completion)
                                        {
                                            completion(PPTouchIDResponse_Success);
                                        }
                                    }
                                    else
                                    {
                                        // User did not authenticate successfully, look at error and take appropriate action
                                        PPTouchIDResponse response;
                                        switch (error.code)
                                        {
                                            case LAErrorUserFallback:
                                            {
                                                response = PPTouchIDResponse_UsePasscode;
                                                break;
                                            }
                                            case LAErrorAuthenticationFailed: // when TouchID max retry is reached, fallbacks to passcode
                                            {
                                                response = PPTouchIDResponse_ReachMaxRetry;
                                                break;
                                            }
                                            case LAErrorSystemCancel:
                                            {
                                                response = PPTouchIDResponse_SystemCanceled;
                                                break;
                                            }
                                            case LAErrorUserCancel:
                                            {
                                                response = PPTouchIDResponse_UserCanceled;
                                                break;
                                            }
                                            default:
                                            {
                                                response = PPTouchIDResponse_Unknown;
                                                break;
                                            }
                                        }
                                        if (completion) {
                                            completion(response);
                                        }
                                    }
                                    
                                    [laContext release];
                                    laContext = nil;
                                });
                            }];
    }
    else
    {
        // Could not evaluate policy; look at authError and present an appropriate message to user
        if (completion)
        {
            completion(PPTouchIDResponse_NotSupport);
            [laContext release];
            laContext = nil;
        }
    }
}


//==============================================================================
//
//==============================================================================
+ (void)dismissTouchIDAlert
{
    if (@available(iOS 9.0, *))
    {
        [laContext invalidate];
    }
    [laContext release];
    laContext = nil;
}



@end
