//
//  PPImageEnhanceController.m
//  
//
//  Created by Mike on 13/6/6.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPImageEnhanceController.h"

static PPImageEnchanceControllerProgressingBlock dewarpProgressingBlock;
static PPImageEnchanceControllerProgressingBlock lightCorrectProgressingBlock;

@implementation PPImageEnhanceController





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - CallBack Function

//================================================================================
//
//================================================================================
void callBackForDeskewImage(int wPercent)
{
    CGFloat progress = (CGFloat)wPercent / 10;
    
    if (dewarpProgressingBlock != nil)
    {
        dewarpProgressingBlock(progress);
    }
}

//================================================================================
//
//================================================================================
void callBackForLightCorrect(int wPercent)
{
    CGFloat progress = (CGFloat)wPercent / 10;
    
    if (lightCorrectProgressingBlock != nil)
    {
        lightCorrectProgressingBlock(progress);
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (CPImage *)deskewImage:(CPImage *)image
  withQuadrilateralModel:(PPQuadrilateralModel *)quadrilateralModel
        progressingBlock:(PPImageEnchanceControllerProgressingBlock)block
{
    CPImage *deskewImage = nil;
    
    do
    {
        if(image==nil || quadrilateralModel==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
#if TARGET_OS_IPHONE
        
        if(image.imageOrientation!=UIImageOrientationUp)
        {
            image = [image imageRotatedByDegrees:0];
        }
#endif
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        BITMAPPTR inputBitmapPTR;
        memset(&inputBitmapPTR, 0, sizeof(BITMAPPTR));
        
        if([CPImage createBitmapPTR:&inputBitmapPTR image:image]==YES)
        {
            int width=0, height=0;
            MYPOINT myPoint[4];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            myPoint[0].x = quadrilateralModel.bottomLeft.x;
            myPoint[0].y = abs(inputBitmapPTR.pHeader->biHeight)-quadrilateralModel.bottomLeft.y;
            myPoint[1].x = quadrilateralModel.bottomRight.x;
            myPoint[1].y = abs(inputBitmapPTR.pHeader->biHeight)-quadrilateralModel.bottomRight.y;
            myPoint[2].x = quadrilateralModel.topLeft.x;
            myPoint[2].y = abs(inputBitmapPTR.pHeader->biHeight)-quadrilateralModel.topLeft.y;
            myPoint[3].x = quadrilateralModel.topRight.x;
            myPoint[3].y = abs(inputBitmapPTR.pHeader->biHeight)-quadrilateralModel.topRight.y;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            getrectWH_DOC(myPoint[0], myPoint[1], myPoint[2], myPoint[3], (int)image.size.width, (int)image.size.height, &width, &height, MAX(inputBitmapPTR.pHeader->biWidth, inputBitmapPTR.pHeader->biHeight));
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if(width>0 && height>0)
            {
                BITMAPPTR outputBitmapPTR;
                memset(&outputBitmapPTR, 0, sizeof(BITMAPPTR));
                
                if([CPImage createBitmapPTR:&outputBitmapPTR width:width height:height bitCount:24]==YES)
                {
                    dewarpProgressingBlock = block;
                    
                    QuadrToRect(&inputBitmapPTR, &outputBitmapPTR, myPoint[0], myPoint[1], myPoint[2], myPoint[3], &callBackForDeskewImage);
                    
                    dewarpProgressingBlock = nil;
                    
                    deskewImage = [CPImage imageWithBitmapPTR:&outputBitmapPTR];
                    
                    [CPImage releaseBitmapPTR:&outputBitmapPTR];
                }
            }
            
            [CPImage releaseBitmapPTR:&inputBitmapPTR];
        }
        
    }while(0);
    
    return deskewImage;
}

+ (CPImage *)deskewImage:(CPImage *)image withQuadrilateralModel:(PPQuadrilateralModel *)quadrilateralModel
{
    return [PPImageEnhanceController deskewImage:image withQuadrilateralModel:quadrilateralModel progressingBlock:nil];
}

+ (PPQuadrilateralModel *)houghTransformQuadrilateralModelForImage:(CPImage *)image
{
    PPQuadrilateralModel *ppQuadrilateralModel = nil;
    
    do
    {
        if(image==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
#if TARGET_OS_IPHONE
        
        if(image.imageOrientation!=UIImageOrientationUp)
        {
            image = [image imageRotatedByDegrees:0];
        }
        
#endif
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        BITMAPPTR inputBitmapPTR;
        memset(&inputBitmapPTR, 0, sizeof(BITMAPPTR));
        
        if([CPImage createBitmapPTR:&inputBitmapPTR image:image]==YES)
        {
            MYPOINT myPoint[4];
            
            if(HoughTrans_Color(&inputBitmapPTR, myPoint)==0)
            {
                ppQuadrilateralModel = [[[PPQuadrilateralModel alloc] init] autorelease];
                if(ppQuadrilateralModel!=nil)
                {
                    ppQuadrilateralModel.bottomLeft  = CGPointMake(myPoint[0].x, abs(inputBitmapPTR.pHeader->biHeight)-myPoint[0].y);
                    ppQuadrilateralModel.bottomRight = CGPointMake(myPoint[1].x, abs(inputBitmapPTR.pHeader->biHeight)-myPoint[1].y);
                    ppQuadrilateralModel.topLeft     = CGPointMake(myPoint[2].x, abs(inputBitmapPTR.pHeader->biHeight)-myPoint[2].y);
                    ppQuadrilateralModel.topRight    = CGPointMake(myPoint[3].x, abs(inputBitmapPTR.pHeader->biHeight)-myPoint[3].y);
                }
            }
            
            [CPImage releaseBitmapPTR:&inputBitmapPTR];
        }
        
    }while(0);
    
    return ppQuadrilateralModel;
}

+ (CPImage *)lightCorrectImage:(CPImage *)image
              progressingBlock:(PPImageEnchanceControllerProgressingBlock)block
{
    CPImage *lightCorrectImage = nil;
    
    do
    {
        if(image==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
#if TARGET_OS_IPHONE
        
        if(image.imageOrientation!=UIImageOrientationUp)
        {
            image = [image imageRotatedByDegrees:0];
        }
#endif
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        BITMAPPTR inputBitmapPTR;
        memset(&inputBitmapPTR, 0, sizeof(BITMAPPTR));
        
        if([CPImage createBitmapPTR:&inputBitmapPTR image:image]==YES)
        {
            BITMAPPTR outputBitmapPTR;
            memset(&outputBitmapPTR, 0, sizeof(BITMAPPTR));
            
            if([CPImage createBitmapPTR:&outputBitmapPTR
                                  width:inputBitmapPTR.pHeader->biWidth
                                 height:inputBitmapPTR.pHeader->biHeight
                               bitCount:inputBitmapPTR.pHeader->biBitCount]==YES)
            {
                lightCorrectProgressingBlock = block;
                
                if(LightCorrect(&inputBitmapPTR, &outputBitmapPTR, &callBackForLightCorrect)==YES)
                {
                    lightCorrectImage = [CPImage imageWithBitmapPTR:&outputBitmapPTR];
                }
                
                lightCorrectProgressingBlock = nil;
                
                [CPImage releaseBitmapPTR:&outputBitmapPTR];
            }
            
            [CPImage releaseBitmapPTR:&inputBitmapPTR];
        }
        
    }while(0);
    
    return lightCorrectImage;
}

+ (CPImage *)lightCorrectImage:(CPImage *)image
{
    return [PPImageEnhanceController lightCorrectImage:image progressingBlock:nil];
}

@end
