//
//  PPGuideFocusModel.m
//  Pods
//
//  Created by eddie on 2015/4/13.
//
//

#import "PPGuideFocusModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPGuideFocusModel ()

@property (nonatomic, assign, readwrite) PPGuideFocusStyle style;
@property (nonatomic, assign, readwrite) PPGuideFocusShape shape;
@property (nonatomic, retain, readwrite) UIImage *image;
@property (nonatomic, retain, readwrite) UIView *view;
@property (nonatomic, assign, readwrite) CGRect imageTransparentFrame;
@property (nonatomic, assign, readwrite) BOOL canTouchThrough;
@property (nonatomic, assign, readwrite) CGSize targetAreaInset;
@property (nonatomic, assign, readwrite) CGFloat infoAreaGap;


// for PPGuideFocusStyle_DrawDoubleRing
@property (nonatomic, retain, readwrite) UIColor *color;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPGuideFocusModel


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Life cycle methods

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.view = nil;
    self.image = nil;
    self.color = nil;
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods

//================================================================================
//
//================================================================================
+ (PPGuideFocusModel *)modelWithGuideFocusShape:(PPGuideFocusShape)shape
                                      imageName:(NSString *)imageName
                          imageTransparentFrame:(CGRect)imageTransparentFrame
                                canTouchThrough:(BOOL)canTouchThrough
                                targetAreaInset:(CGSize)targetAreaInset
{
    //////////////////////////////////////////////////

    if([imageName length] == 0)
    {
        // 使用預設的image
        imageName = @"PPGuideControllerFocusImage@2x.png";
        imageTransparentFrame = CGRectMake(102, 102, 196, 196);
    }
    
    // !! image在PPGuideView中會依據imageTransparentFrame大小進行縮放處理，
    //    所以這裡可用imageNamed讀取，不用管檔名中@?x的指定的縮放比。
    UIImage *focusImage = [UIImage imageNamed:imageName];

//    // !! Only running in debug mode
//    NSAssert(focusImage != nil, @"!! Please check focus image path !!");

    //////////////////////////////////////////////////


    if(focusImage != nil)
    {
        PPGuideFocusModel *model = [[PPGuideFocusModel alloc] init];
        
        if(model != nil)
        {
            model.style = PPGuideFocusStyle_Image;
            model.shape = shape;
            model.canTouchThrough = canTouchThrough;
            model.targetAreaInset = targetAreaInset;
            model.image = focusImage;
            
            CGRect scaledFrame = CGRectMake(imageTransparentFrame.origin.x/focusImage.scale,
                                            imageTransparentFrame.origin.y/focusImage.scale,
                                            imageTransparentFrame.size.width/focusImage.scale,
                                            imageTransparentFrame.size.height/focusImage.scale);
            
            model.imageTransparentFrame = scaledFrame;
        }
        
        return [model autorelease];
    }
    
    return nil;
}


//================================================================================
//
//================================================================================
+ (PPGuideFocusModel *)modelWithImageName:(NSString *)imageName
                              infoAreaGap:(CGFloat)infoAreaGap
{
    //////////////////////////////////////////////////
    
    UIImage *image = [UIImage imageNamed:imageName];
    
    // 檢查是不是有@3x的圖檔被當作1x讀取 (iOS7會出現此現象)
    if(image.scale == 1.0)
    {
        NSRange range = [imageName rangeOfString:@"@"];
        
        // 根據檔名指定的倍率進行縮放
        if(range.length > 0)
        {
            range.length = 1;
            range.location += 1;
            
            NSString *scaleString = [imageName substringWithRange:range];
            CGFloat scale = [scaleString floatValue];
            
            image = [UIImage imageWithCGImage:image.CGImage scale:scale orientation:image.imageOrientation];
        }
    }
    
//    // !! Only running in debug mode
//    NSAssert(image != nil, @"!! Please check icon image path !!");
    
    //////////////////////////////////////////////////
    
    
    if(image != nil)
    {
        PPGuideFocusModel *model = [[PPGuideFocusModel alloc] init];
        
        if(model != nil)
        {
            model.style = PPGuideFocusStyle_Image;
            model.shape = PPGuideFocusShape_None;
            model.image = image;
            model.infoAreaGap = infoAreaGap;
        }
        
        return [model autorelease];
    }
    
    return nil;
}


//================================================================================
//
//================================================================================
+ (PPGuideFocusModel *)modelWithCustomView:(UIView *)customView
                               infoAreaGap:(CGFloat)infoAreaGap
{
    if(customView != nil)
    {
        PPGuideFocusModel *model = [[PPGuideFocusModel alloc] init];
        
        if(model != nil)
        {
            model.style = PPGuideFocusStyle_View;
            model.shape = PPGuideFocusShape_None;
            model.view = customView;
            model.infoAreaGap = infoAreaGap;
        }
        
        return [model autorelease];
    }
    
    return nil;
}


//================================================================================
//
//================================================================================
+ (PPGuideFocusModel *)modelWithDoubleRingStyleColor:(UIColor *)color
                                     canTouchThrough:(BOOL)canTouchThrough
                                     targetAreaInset:(CGSize)targetAreaInset
{
    PPGuideFocusModel *model = [[PPGuideFocusModel alloc] init];
    
    if(model != nil)
    {
        model.style = PPGuideFocusStyle_DoubleRing;
        model.shape = PPGuideFocusShape_Circle;
        model.canTouchThrough = canTouchThrough;
        model.targetAreaInset = targetAreaInset;
        model.color = color;
    }
    
    return [model autorelease];

}


//================================================================================
//
//================================================================================
+ (PPGuideFocusModel *)modelWithGuideFocusShape:(PPGuideFocusShape)shape
                                canTouchThrough:(BOOL)canTouchThrough
                                targetAreaInset:(CGSize)targetAreaInset
                                    infoAreaGap:(CGFloat)infoAreaGap
{
    PPGuideFocusModel *model = [[PPGuideFocusModel alloc] init];
    
    if(model != nil)
    {
        model.style = PPGuideFocusStyle_Transparent;
        model.shape = shape;
        model.canTouchThrough = canTouchThrough;
        model.targetAreaInset = targetAreaInset;
        model.infoAreaGap = infoAreaGap;
    }
    
    return [model autorelease];
}


@end
