//
//  PPEncodeController.m
//  
//
//  Created by  Eddie  on 2011/12/22.
//  Fixed   by  Howard on 2013/09/09.
//  Copyright (c) 2011年 Penpower. All rights reserved.
//
//  
//  porting from knight's EasyEncode C++ class
//

////////////////////////////////////////////////////////////////////////////////////////////////////

static Byte xyzzy_tmpc;
#define SWAP_BYTE(a,b) xyzzy_tmpc=a; a=b; b=xyzzy_tmpc

////////////////////////////////////////////////////////////////////////////////////////////////////

#import "PPEncodeController.h"

@interface PPEncodeController()

+ (int)intValueOfHexChar:(char)hexChar;
+ (int)isValidHexCharData:(Byte *)inData dataLen:(int)dataLen;
+ (void)logBuf:(Byte *)buf len:(int)len;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPEncodeController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private methods

//=============================================================================================================
// 
//=============================================================================================================
+ (int)intValueOfHexChar:(char)hexChar
{
	if (((unsigned)hexChar >= '0') && ((unsigned)hexChar <= '9'))
	{
		hexChar = hexChar - '0';
	}
    else if (((unsigned)hexChar >= 'a') && ((unsigned)hexChar <= 'z'))
	{
		hexChar =  hexChar - 'a' + 10;
	}
    else if (((unsigned)hexChar >= 'A') && ((unsigned)hexChar <= 'Z'))
	{
		hexChar = hexChar - 'A' + 10;
	}
    
	return hexChar;
}


//=============================================================================================================
// 
//=============================================================================================================
+ (int)isValidHexCharData:(Byte *)inData dataLen:(int)dataLen
{
    int result = 0;

    do
    {
        if(inData==0 || (dataLen%2)!=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        Byte tempByte;
        
        int validHex = 1;
        
        for(int index=0; index<dataLen; index++)
		{
            
			tempByte = inData[index];
			if (((tempByte >= 'a') && (tempByte <= 'f')) ||
				((tempByte >= 'A') && (tempByte <= 'F')) ||
				((tempByte >= '0') && (tempByte <= '9')))
			{
                
			}
            else
			{
				validHex = 0;
                break;
			}
		}
        
		result = validHex;
        
    } while (0);
    
    return result;
}


//=============================================================================================================
// 
//=============================================================================================================
+ (void)logBuf:(Byte *)buf len:(int)len
{
    NSMutableString *logStr = [[NSMutableString alloc] init];
    if(logStr!=nil)
    {
        for(int i=0; i<len; i++)
        {
            NSLog(@"[%d] %d", i, buf[i]);
        }
        
        [logStr release];
    }
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance methods

//=============================================================================================================
// 
//=============================================================================================================
+ (Byte *)allocHexBytesFromHexCharData:(char *)inData dataLen:(int)dataLen retLen:(int *)retLen
{
	Byte *dataPtr = NULL;
    
    do
    {
        if([self isValidHexCharData:(Byte *)inData dataLen:dataLen]==0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        dataPtr = (Byte *)malloc(sizeof(Byte) * dataLen * 2 + 10);
        if(dataPtr==NULL)
        {
            break;
        }

        //////////////////////////////////////////////////
        
        int j = 0;
        
        for(int i=0; i<dataLen; i+=2)
        {
            dataPtr[j] = (([self intValueOfHexChar:inData[i]] << 4) & 0xF0);
            dataPtr[j] |= (([self intValueOfHexChar:inData[i+1]] & 0x0F));
            j++;
        }
        
        *retLen = j;
        
    } while (0);
    
    return dataPtr;
}


//=============================================================================================================
// porting from EasyEncodeEx_Bin
//=============================================================================================================
+ (Byte *)allocEncodeDataWithSource:(Byte *)sourceByte 
                          sourceLen:(int)sourceLen 
                            keyByte:(Byte *)keyByte 
                             keyLen:(int)keyLen 
                             retLen:(int *)retLen
{
    Byte *retBuf = NULL;

    do
    {
        if(sourceLen==0 || keyLen==0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        int     i,j;
        Byte    NextKey;
        int     iCheckSum;
        Byte    tmpXorKey;
        Byte    *tmpKeyByte = NULL;
        
        //////////////////////////////////////////////////
        
        if((tmpKeyByte = (Byte *)malloc(sizeof(Byte) * (keyLen * 2))))
        {
            if((retBuf = (Byte *)malloc(sizeof(Byte) * ((sourceLen * 2) + 10))))
            {
                for (i = 0;i < keyLen;i++)
                {
                    tmpKeyByte[i] = keyByte[i] ^ 0x57;
                }
                
                for (i = 0;i < sourceLen;i++)
                {
                    retBuf[i] = sourceByte[i] ^ 0x75;
                }
                
                iCheckSum = 0;
                for (j = 0;j < keyLen;j++)
                {
                    tmpXorKey = tmpKeyByte[j];
                    for (i = 0;i < sourceLen;i++)
                    {
                        NextKey = retBuf[i] ^ tmpXorKey;
                        iCheckSum += retBuf[i];
                        retBuf[i] = NextKey;
                        if (i != (sourceLen -1))
                        {
                            tmpXorKey = NextKey;
                        }
                    }
                }
                
                retBuf[sourceLen] = (iCheckSum >> 8) & 0xFF;
                retBuf[sourceLen+1] = iCheckSum  & 0xFF;
                
                *retLen = sourceLen+2;
            }        
            
            free(tmpKeyByte);
        }

    } while (0);
    
    return retBuf;
}


//=============================================================================================================
// porting from EasyDecodeEx_Bin
//=============================================================================================================
+ (Byte *)allocDecodeDataWithSource:(Byte *)sourceByte 
                          sourceLen:(int)sourceLen 
                            keyByte:(Byte *)keyByte 
                             keyLen:(int)keyLen
                             retLen:(int *)retLen
{
    int     i,j;
	Byte    NextKey;
	int     iCheckSum;
	Byte    *tmpKeyStr;
	int     idx;
	Byte    decodeOneKey;
	int     iCheckSumCal;
	Byte    *retBuf = 0;
    BOOL    bSuccess = NO;
    
    //////////////////////////////////////////////////
    
    do
    {
        if(!sourceLen || !keyLen)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if((retBuf = malloc(sizeof(Byte) * (sourceLen + 4))))
        {
            memcpy(retBuf, sourceByte, sourceLen);
            
            if((tmpKeyStr = (Byte *)malloc(sizeof(Byte) * (keyLen * 2))))
            {
                for (i = 0;i < keyLen;i++)
                {
                    tmpKeyStr[i] = keyByte[i] ^ 0x57;
                }
                
                iCheckSum = (retBuf[sourceLen-2]) & 0xFF;
                iCheckSum <<= 8;
                iCheckSum |= (retBuf[sourceLen-1] & 0xFF);
                
                idx = sourceLen - 2;
                iCheckSumCal = 0;
                
                for (j = 0;j < keyLen;j++)
                {
                    decodeOneKey = tmpKeyStr[keyLen - j - 1];
                    for (i = 0;i < idx;i++)
                    {
                        NextKey = retBuf[i];
                        retBuf[i] = retBuf[i] ^ decodeOneKey;
                        iCheckSumCal += retBuf[i];
                        decodeOneKey = NextKey;
                    }
                }
                
                if ((iCheckSumCal & 0xFFFF) == iCheckSum)
                {
                    for (i = 0;i < idx;i++)
                    {
                        retBuf[i] = retBuf[i] ^ 0x75;
                    }
                    
                    retBuf[idx] = 0;
                    retBuf[idx+1] = 0;
                    *retLen = idx;
                    bSuccess = YES;
                }
                
                free(tmpKeyStr);
            }
        }
        
        if(!bSuccess && retBuf)
        {
            free(retBuf);
            retBuf = nil;
            *retLen = 0;
        }

    } while (0);

    return retBuf;
}


//=============================================================================================================
// 
//=============================================================================================================
+ (BOOL)RC4Init:(char *)pszKey keyLen:(int)nKeyLen key:(RC4_KEY *)key
{
    BOOL result = NO;
    
    do
    {
        if((strlen(pszKey)<1)||(nKeyLen<1))
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        Byte    by1,by2;
        Byte    *bySTab;
        int     nCount;
        
        nKeyLen=(nKeyLen>256)?(256):nKeyLen; //±KΩX≥Ã¶h•uØ‡256¶Ï§∏≤’
        
        bySTab = &key->bySTab[0];
        for (nCount=0; nCount<256; nCount++)
        {
            bySTab[nCount]=(Byte)nCount;
        }
        
        key->byIt=0;
        key->byJt=0;
        by1=by2=0;
        for (nCount=0; nCount<256; nCount++)
        {
            by2 = (Byte)(pszKey[by1] + bySTab[nCount] + by2);
            SWAP_BYTE(bySTab[nCount], bySTab[by2]);
            by1 = (Byte)(by1+1)%nKeyLen;
        }

        result = YES;
        
    } while (0);
   
    return result;
}


//=============================================================================================================
// 
//=============================================================================================================
+ (BOOL)RC4Works:(Byte *)pbyData dataLen:(int)nDataLen key:(RC4_KEY *)key
{
    BOOL result = NO;
    
    do
    {
        if((pbyData==NULL) ||(nDataLen<1))
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        Byte    byIt,byJt;
        Byte    *bySTab;
        int     nCount;
        
        byIt=key->byIt;
        byJt=key->byJt;
        
        bySTab = &key->bySTab[0];
        for (nCount=0; nCount<nDataLen; nCount++)
        {
            byIt++;
            byJt += bySTab[byIt];
            SWAP_BYTE(bySTab[byIt], bySTab[byJt]);
            pbyData[nCount] ^= bySTab[(bySTab[byIt] + bySTab[byJt])&0xFF];
        }
        
        key->byIt=byIt;
        key->byJt=byJt;
        
        result = YES;
        
    } while (0);
    
    return result;
}


@end
