//
//  PPCountryCodeConvert.h
//
//  Created by Bill on 2014/1/7.
//
//  Copyright 2011年 Penpower. All rights reserved.
//

// 值的是參照 namecard.h, 在不需要知道 namecard.h 的情況可以正確 mapping 回去
// PPCountry_Code 的值必需和 namecard.h 完全對映
typedef NS_ENUM(NSInteger, PPCountry_Code) {
    Country_Code_B5 = 0, // 繁體中文
    Country_Code_HK = 1, // 繁體中文+香港字
    Country_Code_GB = 2, // 簡體中文
    Country_Code_EN = 3, // 英文
    Country_Code_GE = 4, // 德文
    Country_Code_FR = 5, // 法文
    Country_Code_IT = 6, // 義大利
    Country_Code_ES = 7, // 西班牙
    Country_Code_NO = 8, // 挪威
    Country_Code_HU = 9, // 匈牙利
    Country_Code_PL = 10, // 波蘭
    Country_Code_SE = 11, // 瑞典
    Country_Code_NL = 12, // 荷蘭
    Country_Code_TR = 13, // 土耳其
    Country_Code_RU = 14, // 俄羅斯
    Country_Code_JP = 15, // 日文
    Country_Code_KS = 16, // 韓文
    Country_Code_DK = 17, // 丹麥
    Country_Code_FI = 18, // 芬蘭
    Country_Code_PT = 19, // 葡萄牙
    Country_Code_GR = 20, // 希臘
    Country_Code_BR = 21, // 巴西
    Country_Code_MX = 22, // 墨西哥
    Country_Code_CZ = 23, // 捷克
    Country_Code_SK = 24, // 斯洛伐克
    Country_Code_AR = 25, // 阿拉伯
};

@interface PPCountryCodeConvert : NSObject

/**
 * MARK: 產生CN2CC的methods, 將系統中的國名與國碼mapping，平時不需使用
 * 如果要加入新的國名與國碼mapping請加到additionalDict中，再重新產生
 * 檔案放在Document目錄下
 */
+ (void)generateCN2CC;


////////////////////////////////////////////////////////////////////////////////////////////////////

+ (NSString *)countryCodeFromLocalizeString:(NSString *)localizeString;
+ (NSString *)localizeStringFromCountryCode:(NSString *)countryCode;
+ (NSString *)localizeStringFromCountryCode:(NSString *)countryCode withLanguageCode:(NSString *)languageCode;
+ (NSString *)defaultCountryCode;

+ (NSString *)languageCodeWithRecogLang:(NSInteger)recogLang;

/**
 *  配合　CountryCode　取得預設辨識語系
 *
 *  @param countryCode one of PPCountry_Code
 *
 *  @return 辨識語系
 */
+ (PPCountry_Code)defaultRecogLangWithCountryCode:(NSString *)countryCode;



/**
 取得國家列表, Country Code 順序 (同步)
 
 @param languageCode 辨識語系
 @param completion 回傳結果
 */
+ (void)countryListForLanguageCode:(NSString *)languageCode completion:(void (^)(NSDictionary *countryNameDictionary, NSDictionary *regionNameDictionary,  NSArray *countryCodes, NSArray *regionCountries))completion;
@end
