//
//  PPiCloudOperation_UploadFile.m
//  
//
//  Created by Mike on 13/4/23.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPiCloudOperation_UploadFile.h"

@implementation PPiCloudOperation_UploadFile

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize uploadFile  = uploadFile_;
@synthesize toPath      = toPath_;
@synthesize fromPath    = fromPath_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [uploadFile_ release];
    [toPath_ release];
    [fromPath_ release];
	
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        NSURL *tempFileURL = nil;
        NSURL *uploadFileURL = nil;
        
        do
        {
            if(self.uploadFile==nil || self.toPath==nil || self.fromPath==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }

            ////////////////////////////////////////////////////////////////////////////////////////////////////
            //先拷貝一份到Document目錄下
            
            NSString *tempFilePath = [[self documentPath] stringByAppendingPathComponent:[NSString stringWithFormat:@"%f-%@", [[NSDate date] timeIntervalSince1970], self.uploadFile]];
            
            if([[NSFileManager defaultManager] copyItemAtPath:self.fromPath
                                                       toPath:tempFilePath
                                                        error:&error]==NO)
            {
                error = [self convertErrorFromSystemError:error];
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            tempFileURL = [NSURL fileURLWithPath:tempFilePath];
            
            if(tempFileURL==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            uploadFileURL = [self URLForCloudPath:[self.toPath stringByAppendingPathComponent:self.uploadFile]];
            
            if(uploadFileURL==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([[NSFileManager defaultManager] setUbiquitous:YES
                                                   itemAtURL:tempFileURL
                                              destinationURL:uploadFileURL
                                                       error:&error]==NO)
            {
                error = [self convertErrorFromSystemError:error];
                break;
            }
                
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([self.delegate respondsToSelector:@selector(ppiCloudOperation:uploadedFile:from:metadata:)]==YES)
            {
                PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithiCloudURL:uploadFileURL path:[self.toPath stringByAppendingPathComponent:self.uploadFile] error:&error];
                
                if(ppCloudMetadata!=nil)
                {
                    if(error==nil)
                    {
                        [self.delegate ppiCloudOperation:self uploadedFile:[self.toPath stringByAppendingPathComponent:self.uploadFile] from:self.fromPath metadata:ppCloudMetadata];
                    }
                    
                    [ppCloudMetadata release];
                }
                else
                {
                    if(error != nil)
                    {
                        error = [self convertErrorFromSystemError:error];
                    }
                }
            }
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(error != nil)
        {
            // !! 如果setUbiquitoust成功，tempFilePath會被移到uploadFileURL；失敗時可能還留著，要把它刪除。
            if(tempFileURL != nil)
            {
                [[NSFileManager defaultManager] removeItemAtURL:tempFileURL error:nil];
            }
            
            // !! 如果錯誤原因不是“檔案已存在”，要把原來上傳的檔案刪除
            if([error.localizedFailureReason containsString:@"Domain=NSPOSIXErrorDomain Code=17"] == NO && uploadFileURL != nil)
            {
                [[NSFileManager defaultManager] removeItemAtURL:uploadFileURL error:nil];
            }
            
            if([self.delegate respondsToSelector:@selector(ppiCloudOperation:uploadFileFailedWithError:)]==YES)
            {
                [self.delegate ppiCloudOperation:self uploadFileFailedWithError:error];
            }
        }
    
        [self completion];
    }
}

@end
