//
//  PPiCloudOperation_Delete.m
//  
//
//  Created by Mike on 13/4/23.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPiCloudOperation_Delete.h"

@implementation PPiCloudOperation_Delete

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize deletePath = deletePath_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [deletePath_ release];
	
	////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if(self.deletePath==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSURL *deletePathURL = [self URLForCloudPath:self.deletePath];
            if(deletePathURL==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSFileManager *fileManager = [NSFileManager defaultManager];
            if(fileManager==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([fileManager removeItemAtURL:deletePathURL
                                      error:&error]==NO)
            {
                error = [self convertErrorFromSystemError:error];
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([self.delegate respondsToSelector:@selector(ppiCloudOperation:deletedPath:)]==YES)
            {
               [self.delegate ppiCloudOperation:self deletedPath:self.deletePath];
            }
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(error!=nil)
        {
            if([self.delegate respondsToSelector:@selector(ppiCloudOperation:deletePathFailedWithError:)]==YES)
            {
                [self.delegate ppiCloudOperation:self deletePathFailedWithError:error];
            }
        }
    
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        [self completion];
    }
}

@end
