//
//  PPOneDriveOperation_Link.m
//  
//
//  Created by Mike on 13-3-12.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPOneDriveOperation_Link.h"
#import "PPCloud.h"

@implementation PPOneDriveOperation_Link





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.viewcontroller = nil;
    
    //////////////////////////////////////////////////

	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        
        do
        {
            if(self.viewcontroller==nil)
            {
                NSError *error = PPErrorParameterInvalidity(nil);
                
                if([self.delegate respondsToSelector:@selector(ppOneDriveOperation:linkFailedWithError:)]==YES)
                {
                    [self.delegate ppOneDriveOperation:self linkFailedWithError:error];
                }
                
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            __block typeof(self) blockSelf = self;
            
            [ODClient authenticatedClientWithCompletion:^(ODClient *client, NSError *error){
                
                if (error == nil)
                {
                    blockSelf.odClient = client;
                    
                    [ODClient setCurrentClient:client];
                    
                    dispatch_async(dispatch_get_main_queue(), ^{
                        
                        if([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperationLinkSuccess:)]==YES)
                        {
                            [blockSelf.delegate ppOneDriveOperationLinkSuccess:self];
                        }
                    });
                }
                else
                {
                    if([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:linkFailedWithError:)]==YES)
                    {
                        NSError *linkFailedError = nil;
                        if(([error.domain isEqualToString:OD_AUTH_ERROR_DOMAIN])&&
                           error.code==ODAuthCanceled)
                        {
                            linkFailedError = PPErrorMake(PPCloudCommonError_CancelLogin, @"取消登入", error);
                        }
                        else
                        {
                            linkFailedError = error;
                        }
                        
                        dispatch_async(dispatch_get_main_queue(), ^{
                            
                            [blockSelf.delegate ppOneDriveOperation:self linkFailedWithError:linkFailedError];
                        });
                        
                    }
                }
                
                [blockSelf completion];
            }];
            
        }while(0);
        
        //////////////////////////////////////////////////
        
        
        
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overwrite Methods

- (void)cancel
{
    [super cancel];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    [self completion];
}


@end
