//
//  PPOneDriveOperation_Copy.m
//  
//
//  Created by Mike on 13-3-14.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPOneDriveOperation_Copy.h"

@implementation PPOneDriveOperation_Copy

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    self.fromPath = nil;
    self.toPath = nil;
	
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if(self.fromPath==nil || self.toPath==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                
                if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppOneDriveOperation:copyPathFailedWithError:)]==YES)
                {
                    [self.delegate ppOneDriveOperation:self copyPathFailedWithError:error];
                }
                
                [self completion];
                break;
            }
            
            //////////////////////////////////////////////////
            // 產生Copy目標的ParentRef
            ODItemReference *parentRef = [[ODItemReference alloc] init] ;
            
            NSString *copiedItemName = [self.toPath lastPathComponent];
            NSString *copiedItemPath = [self.toPath stringByDeletingLastPathComponent];
            
            if ([copiedItemPath isEqualToString:@"/"])
            {
                parentRef.path = @"/drive/root";
            }
            else
            {
                parentRef.path = [NSString stringWithFormat:@"/drive/root:%@", copiedItemPath];
            }
            
            //////////////////////////////////////////////////
            // 去掉Path開頭的'/'
            self.fromPath = [self.fromPath substringFromIndex:1];
            
            ODItemCopyRequestBuilder *copyRequestBuilder = [[[self.odClient root] itemByPath:self.fromPath] copyWithName:copiedItemName parentReference:parentRef];
            
            ODItemCopyRequest *copyRequest = [copyRequestBuilder request];
            
            [copyRequestBuilder release];
            
            __block typeof(self) blockSelf = self;
            
            [copyRequest executeWithCompletion:^(ODItem *response, ODAsyncOperationStatus *status, NSError *error) {
                
                if(error!=nil)
                {
                    if(blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:copyPathFailedWithError:)]==YES)
                    {
                        [blockSelf.delegate ppOneDriveOperation:blockSelf copyPathFailedWithError:error];
                    }
                    
                    [blockSelf completion];
                }
                else
                {
                    if (response != nil)
                    {
                        if([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:copiedPath:to:)]==YES)
                        {
                            [blockSelf.delegate ppOneDriveOperation:blockSelf copiedPath:blockSelf.fromPath to:response];
                        }
                        
                        [blockSelf completion];
                    }
                }
                
            }];
            
            [parentRef release];
    
                                            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        
    }
}

@end
