//
//  PPGoogleDriveOperation_LoadMetadata.m
//  
//
//  Created by Mike on 13/4/9.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPGoogleDriveOperation_LoadMetadata.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperation_LoadMetadata()

@interface PPGoogleDriveOperation_LoadMetadata()
@property(nonatomic,retain) GTLRDrive_File *loadMetadataFile;
- (void)serviceTicket:(GTLRServiceTicket *)ticket finishedWithFileList:(GTLRDrive_FileList *)fileList error:(NSError *)error;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPGoogleDriveOperation_LoadMetadata

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize loadMetadata        = loadMetadata_;
@synthesize loadMetadataFile    = loadMetadataFile_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [loadMetadata_ release];
	[loadMetadataFile_ release];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
	
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;

        do
        {
            if(self.loadMetadata==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }

            //////////////////////////////////////////////////

            NSDictionary *identifierForFolderDictionary = [GTLRDriveService sharedServiceDrive].identifierForFolderDictionary;
            
            NSString *fileID = [identifierForFolderDictionary objectForKey:self.loadMetadata];
        
            self.loadMetadataFile = [[GTLRDriveService sharedServiceDrive] fileForIdentifier:fileID
                                                                                       error:nil];
            
            if(self.loadMetadataFile==nil)
            {
                NSArray *loadMetadataFiles = [[GTLRDriveService sharedServiceDrive] filesForPathComponents:[self.loadMetadata pathComponents]
                                                                                    currentPathComponentID:nil
                                                                                                     error:&error];
                if(error!=nil)
                {
                    break;
                }
                
                ////////////////////////////////////////////////////////////////////////////////////////////////////
                
                if([loadMetadataFiles count]<1)
                {
                    error = PPErrorMake(PPCloudCommonError_PathNotExist, @"Folder not found", nil);
                    break;
                }
                
                ////////////////////////////////////////////////////////////////////////////////////////////////////
                
                if([loadMetadataFiles count]>1)
                {
                    error = PPErrorMake(PPCloudCommonError_MultipleItemsWithSamePath, @"More than one folders", nil);
                    break;
                }
                
                ////////////////////////////////////////////////////////////////////////////////////////////////////
                
                self.loadMetadataFile = [loadMetadataFiles objectAtIndex:0];
                
                //////////////////////////////////////////////////

                [[GTLRDriveService sharedServiceDrive].identifierForFolderDictionary setObject:self.loadMetadataFile.identifier forKey:self.loadMetadata];
            }

            //////////////////////////////////////////////////
        
            if([self.loadMetadataFile.mimeType isEqualToString:GTLDriveFile_MimeType_Folder]==YES)
            {
                GTLRDriveQuery_FilesList *fileListQuery = [GTLRDriveQuery_FilesList query];

                if(fileListQuery==nil)
                {
                    error = PPErrorOperationFailed(nil);
                    break;
                }

                ////////////////////////////////////////////////////////////////////////////////////////////////////

                fileListQuery.q =  [NSString stringWithFormat:@"trashed=false and '%@' in parents", self.loadMetadataFile.identifier];

                ////////////////////////////////////////////////////////////////////////////////////////////////////

                GTLRServiceTicket *ticket = [[GTLRDriveService sharedServiceDrive] executeQuery:fileListQuery
                                                                                     delegate:self
                                                                            didFinishSelector:@selector(serviceTicket:finishedWithFileList:error:)];
                if(ticket==nil)
                {
                    error = PPErrorOperationFailed(nil);
                    break;
                }
            }
            else
            {
                if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:loadedMetadata:)]==YES)
                {
                    [self.delegate ppGoogleDriveOperation:self loadedMetadata:[NSDictionary dictionaryWithObjectsAndKeys:self.loadMetadataFile, NSStringFromClass([self.loadMetadataFile class]), nil]];
                }

                [self completion];
            }

        }while(0);

        ////////////////////////////////////////////////////////////////////////////////////////////////////

        if(error!=nil)
        {
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:loadMetadataFailedWithError:)]==YES)
            {
                [self.delegate ppGoogleDriveOperation:self loadMetadataFailedWithError:error];
            }

            [self completion];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private

//================================================================================
//
//================================================================================
- (void)serviceTicket:(GTLRServiceTicket *)ticket
 finishedWithFileList:(GTLRDrive_FileList *)fileList
                error:(NSError *)error
{
    if(error!=nil)
    {
        if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:loadMetadataFailedWithError:)]==YES)
        {
            [self.delegate ppGoogleDriveOperation:self loadMetadataFailedWithError:error];
        }
    }
    else
    {
        if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:loadedMetadata:)]==YES)
        {
            [self.delegate ppGoogleDriveOperation:self loadedMetadata:[NSDictionary dictionaryWithObjectsAndKeys:self.loadMetadataFile, NSStringFromClass([self.loadMetadataFile class]), fileList, NSStringFromClass([fileList class]), nil]];
        }
    }
    
    [self completion];
}

@end
