//
//  PPGoogleDriveOperation_Copy.m
//  
//
//  Created by Mike on 13/4/16.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPGoogleDriveOperation_Copy.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperation_Copy()

@interface PPGoogleDriveOperation_Copy()
- (void)serviceTicket:(GTLRServiceTicket *)ticket finishedWithFile:(GTLRDrive_File *)file error:(NSError *)error;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPGoogleDriveOperation_Copy

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize fromPath    = fromPath_;
@synthesize toPath      = toPath_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [fromPath_ release];
    [toPath_ release];
    
    //////////////////////////////////////////////////
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if(self.fromPath==nil || self.toPath==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }

            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSArray *fromPathFiles = [[GTLRDriveService sharedServiceDrive] filesForPathComponents:[self.fromPath pathComponents]
                                                                           currentPathComponentID:nil
                                                                                            error:&error];
            if(error!=nil)
            {
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([fromPathFiles count]<1)
            {
                error = PPErrorMake(PPCloudCommonError_PathNotExist, @"Path not found", nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([fromPathFiles count]>1)
            {
                error = PPErrorMake(PPCloudCommonError_MultipleItemsWithSamePath, @"Duplicate folder", nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            GTLRDrive_File *fromPathFile = [fromPathFiles objectAtIndex:0];
            
            //copy來源不可以是目錄
            if([fromPathFile.mimeType isEqualToString:GTLDriveFile_MimeType_Folder]==YES)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSArray *toPathParentFiles = [[GTLRDriveService sharedServiceDrive] filesForPathComponents:[[self.toPath stringByDeletingLastPathComponent] pathComponents]
                                                                               currentPathComponentID:nil
                                                                                                error:&error];
            if(error!=nil)
            {
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([toPathParentFiles count]<1)
            {
                error = PPErrorMake(PPCloudCommonError_PathNotExist, @"File not found", nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([toPathParentFiles count]>1)
            {
                error = PPErrorMake(PPCloudCommonError_MultipleItemsWithSamePath, @"Path already exist", nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            GTLRDrive_File *toPathParentFile = [toPathParentFiles objectAtIndex:0];
            
            //Parent一定要是目錄
            if([toPathParentFile.mimeType isEqualToString:GTLDriveFile_MimeType_Folder]==NO)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            GTLRDrive_File *copyFile = [GTLRDrive_File object];
            if(copyFile==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            copyFile.name      = [self.toPath lastPathComponent];
            copyFile.parents    = [NSArray arrayWithObjects:toPathParentFile.identifier, nil];
            
            if(copyFile.parents==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            GTLRDriveQuery_FilesCopy *copyQuery = [GTLRDriveQuery_FilesCopy queryWithObject:copyFile fileId:fromPathFile.identifier];
      
            if(copyQuery==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            GTLRServiceTicket *ticket = [[GTLRDriveService sharedServiceDrive] executeQuery:copyQuery
                                                                                 delegate:self
                                                                        didFinishSelector:@selector(serviceTicket:finishedWithFile:error:)];
            if(ticket==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(error!=nil)
        {
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:copyPathFailedWithError:)]==YES)
            {
                [self.delegate ppGoogleDriveOperation:self copyPathFailedWithError:error];
            }
            
            [self completion];
        }
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private

- (void)serviceTicket:(GTLRServiceTicket *)ticket finishedWithFile:(GTLRDrive_File *)file error:(NSError *)error
{    
    if(error!=nil)
    {
        if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:copyPathFailedWithError:)]==YES)
        {
            [self.delegate ppGoogleDriveOperation:self copyPathFailedWithError:error];
        }
    }
    else
    {
        if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:copiedPath:to:)]==YES)
        {
            [self.delegate ppGoogleDriveOperation:self copiedPath:self.fromPath to:[NSDictionary dictionaryWithObjectsAndKeys:file, NSStringFromClass([file class]), nil]];
        }
    }
    
    [self completion];
}

@end
