//
//  PPDropboxOperation_Move.m
//  
//
//  Created by Mike on 13/3/15.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPDropboxOperation_Move.h"

@implementation PPDropboxOperation_Move

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize moveFrom    = moveFrom_;
@synthesize toPath      = toPath_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [moveFrom_ release];
    [toPath_ release];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

//================================================================================
//
//================================================================================
- (void)main
{
    @autoreleasepool
    {
        NSError *returnError = nil;
        
        do
        {
            if(self.moveFrom==nil || self.toPath==nil)
            {
                returnError = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            DBFILESUserAuthRoutes *fileRoutes = [DBClientsManager authorizedClient].filesRoutes;
            
            if(fileRoutes==nil)
            {
                returnError  = PPErrorParameterInvalidity(nil);
                break;
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            __block typeof(self) blockself = self;
            
            [[[fileRoutes moveV2:self.moveFrom toPath:self.toPath]
              setResponseBlock:^(DBFILESRelocationResult * _Nullable result, DBFILESRelocationError *routeError, DBRequestError *error)
              {
                  if(result!=nil)
                  {
                      if([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:movedPath:to:)]==YES)
                      {
                          [blockself.delegate ppDropboxOperation:blockself movedPath:blockself.toPath to:result.metadata];
                      }
                  }
                  else
                  {
                      if([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:movePathFailedWithError:)]==YES)
                      {
                          NSError *convertedError = [self convertErrorFromSystemError:error];
                          
                          [blockself.delegate ppDropboxOperation:blockself movePathFailedWithError:convertedError];
                      }
                  }
                  
                  //////////////////////////////////////////////////
                  
                  [blockself completion];
                  
              }]
             setProgressBlock:^(int64_t bytesSent, int64_t totalBytesSent, int64_t totalBytesExpectedToSend)
             {
                 
             }];

            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(returnError!=nil)
        {
            if([self.delegate respondsToSelector:@selector(ppDropboxOperation:movePathFailedWithError:)]==YES)
            {
                [self.delegate ppDropboxOperation:self movePathFailedWithError:returnError];
            }
            
            [self completion];
        }
    }
}

@end
