//
//  PPDropboxOperation_LoadThumbnail.m
//  
//
//  Created by Mike on 13-3-14.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPDropboxOperation_LoadThumbnail.h"

// Define
#import "CrossPlatformDefine.h"

#if TARGET_OS_IPHONE

#elif TARGET_OS_MAC
// Category
#import "NSImage+Additions.h"

#endif

////////////////////////////////////////////////////////////////////////////////////////////////////

NSString *PPDropboxThumbnailSize_Large  = @"large";
NSString *PPDropboxThumbnailSize_Medium = @"medium";
NSString *PPDropboxThumbnailSize_Small	= @"small";

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPDropboxOperation_LoadThumbnail

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize loadThumbnail   = loadThumbnail_;
@synthesize intoPath        = intoPath_;
@synthesize ofSize          = ofSize_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark -
#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [loadThumbnail_ release];
	[intoPath_ release];
	[ofSize_ release];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

    
    
    
    

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

//================================================================================
//
//================================================================================
- (void)main
{
    @autoreleasepool
    {
        NSError *returnError = nil;
        
        do
        {
            if(self.loadThumbnail==nil || self.ofSize==nil || self.intoPath==nil)
            {
                returnError = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
       
            DBFILESUserAuthRoutes *fileRoutes = [DBClientsManager authorizedClient].filesRoutes;
            
            if(fileRoutes==nil)
            {
                returnError  = PPErrorParameterInvalidity(nil);
                break;
            }
            
            //////////////////////////////////////////////////

            DBFILESThumbnailFormat *format = nil;
            
            if([[self.loadThumbnail pathExtension] compare:@"png"]==NSOrderedSame)
            {
                format = [[[DBFILESThumbnailFormat alloc] initWithPng] autorelease];
            }
            else
            {
                format = [[[DBFILESThumbnailFormat alloc] initWithJpeg] autorelease];
            }
            
            //////////////////////////////////////////////////

            DBFILESThumbnailSize *size = nil;
            
            if([self.ofSize isEqualToString:PPDropboxThumbnailSize_Large]==YES)
            {
                size = [[[DBFILESThumbnailSize alloc] initWithW128h128] autorelease];
            }
            else if([self.ofSize isEqualToString:PPDropboxThumbnailSize_Medium]==YES)
            {
                size = [[[DBFILESThumbnailSize alloc] initWithW64h64] autorelease];
            }
            else
            {
                size = [[[DBFILESThumbnailSize alloc] initWithW32h32] autorelease];
            }

            if(size==nil)
            {
                returnError  = PPErrorParameterInvalidity(nil);
                break;
            }

            //////////////////////////////////////////////////

            DBFILESThumbnailMode *mode = [[[DBFILESThumbnailMode alloc] initWithFitoneBestfit] autorelease];
            
            //////////////////////////////////////////////////

            __block typeof(self) blockself = self;
          
            [[[fileRoutes getThumbnailData:self.loadThumbnail
                                    format:format
                                      size:size
                                      mode:mode] setResponseBlock:^(DBFILESFileMetadata *fileMetadata, DBFILESThumbnailError *thumbnailError, DBRequestError * error, NSData * thumbnailData)
              {
                if(fileMetadata!=nil)
                {
                    if([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:loadedThumbnail:)]==YES)
                    {
                        [thumbnailData writeToFile:blockself.intoPath atomically:YES];
                        
                        [blockself.delegate ppDropboxOperation:blockself loadedThumbnail:blockself.intoPath];
                    }
                }
                else
                {
                    if([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:loadThumbnailFailedWithError:)]==YES)
                    {
                        NSError *convertedError = [blockself convertErrorFromSystemError:error];
                        
                        [blockself.delegate ppDropboxOperation:blockself loadThumbnailFailedWithError:convertedError];
                    }
                }
                
                //////////////////////////////////////////////////

                [blockself completion];
                
            }] setProgressBlock:^(int64_t bytesSent, int64_t totalBytesSent, int64_t totalBytesExpectedToSend)
            {
                
            }];
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(returnError!=nil)
        {
            if([self.delegate respondsToSelector:@selector(ppDropboxOperation:loadThumbnailFailedWithError:)]==YES)
            {
                [self.delegate ppDropboxOperation:self loadThumbnailFailedWithError:returnError];
            }
            
            [self completion];
        }
    }
}



@end
