//
//  PPDropboxOperation.m
//  
//
//  Created by Mike on 13-3-12.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPDropboxOperation.h"

@implementation PPDropboxOperation

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    id object = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if((self=[super init]))
    {
        self.privateConcurrent = YES;
  
        object = self;
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(object!=self)
    {
        [self release];
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    return object;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)start
{
	if([self isCancelled]==YES)
	{
		[self setFinished:YES];
	}
	else
	{
        [self setExecuting:YES];
        
        // DBRestClient的delegate一定要在mainThread才收的到？
        [self performSelector:@selector(main) withObject:nil];
	}
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods

//================================================================================
//
//================================================================================
- (NSError *)convertErrorFromSystemError:(DBRequestError *)systemError
{
    NSError *convertError = systemError.nsError;
    NSString *errorMsg = systemError.errorContent;
    
    if([errorMsg length] > 0)
    {
        convertError = PPErrorMake([systemError.statusCode integerValue],
                                   errorMsg,
                                   systemError.nsError);
    }
    
    return convertError;
}


@end
