//
//  PPCloudAccountInfo.m
//  
//
//  Created by Mike on 13/5/14.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPCloudAccountInfo.h"

@implementation PPCloudAccountInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize cloudClassName  = cloudClassName_;
@synthesize displayName     = displayName_;
@synthesize userID          = userID_;
@synthesize totalBytes      = totalBytes_;
@synthesize usedBytes       = usedBytes_;
@synthesize rawData         = rawData_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [cloudClassName_ release];
    [displayName_ release];
    [userID_ release];
    [totalBytes_ release];
    [usedBytes_ release];
	[rawData_ release];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

- (NSString *)description
{
	return [NSString stringWithFormat:@"[PPCloudAccountInfo]\ncloudClassName:%@\ndisplayName:%@\nuserID:%@\ntotalBytes:%@\nusedBytes:%@\nrawData:%@",
            self.cloudClassName,
            self.displayName,
            self.userID,
            self.totalBytes,
            self.usedBytes,
            self.rawData];
}

@end
