//
//  PPCloud.m
//  
//
//  Created by Mike on 13/5/14.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPCloud.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

NSString *PPCloud_RootPath  = @"/";

////////////////////////////////////////////////////////////////////////////////////////////////////

NSString *PPCloud_ThumbnailSize_Maximum = @"PPCloud_ThumbnailSize_Maximum";
NSString *PPCloud_ThumbnailSize_Large   = @"PPCloud_ThumbnailSize_Large";
NSString *PPCloud_ThumbnailSize_Medium  = @"PPCloud_ThumbnailSize_Medium";
NSString *PPCloud_ThumbnailSize_Small   = @"PPCloud_ThumbnailSize_Small";
NSString *PPCloud_ThumbnailSize_Minimum = @"PPCloud_ThumbnailSize_Minimum";

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSMutableDictionary *parameterDictionary = nil;

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPCloud

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize operationQueue = operationQueue_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (id)init
{
    id object = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    NSOperationQueue *operationQueue = [[NSOperationQueue alloc] init];
    if(operationQueue!=nil)
    {
        [operationQueue setMaxConcurrentOperationCount:1];
        
        if((self=[self initWithOperationQueue:operationQueue]))
        {
            object = self;
        }
        
        [operationQueue release];
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    return object;
}

- (id)initWithOperationQueue:(NSOperationQueue *)operationQueue
{
    id object = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    do
    {
        if(operationQueue==nil)
        {
            break;
        }
    
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if((self=[super init]))
        {
            operationQueue_ = [operationQueue retain];
            
            object = self;
        }
        
    }while(0);
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(object==nil)
    {
        [self release];
    }
	
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	return object;
}

- (void)dealloc
{
	[operationQueue_ release];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (BOOL)isLinked
{
    return NO;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (id)parameterForKey:(NSString *)key
{
    id parameter = nil;
    
    if(parameterDictionary!=nil && key!=nil)
    {
        parameter = [parameterDictionary objectForKey:key];
    }
    
    return parameter;
}

+ (void)setParameter:(id)parameter forKey:(NSString *)key
{
    if(key!=nil)
    {
        if(parameterDictionary==nil)
        {
            parameterDictionary = [[NSMutableDictionary alloc] init];
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(parameterDictionary!=nil)
        {
            if(parameter!=nil)
            {
                [parameterDictionary setObject:parameter forKey:key];
            }
            else
            {
                [parameterDictionary removeObjectForKey:key];
            }
        }
    }
    else
    {
        [parameterDictionary release];
        parameterDictionary = nil;
    }
}

@end
