//
//  PPCloud+Private.m
//  
//
//  Created by Mike on 13/5/14.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPCloud+Private.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

NSString *PPCloud_UserInfoKey_Delegate  = @"PPCloud_UserInfoKey_Delegate";
NSString *PPCloud_UserInfoKey_UserInfo  = @"PPCloud_UserInfoKey_UserInfo";

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPCloud (Private)

- (NSDictionary *)userInfoDictionaryWithDelegate:(id)delegate userInfo:(id)userInfo
{
    NSMutableDictionary *userInfoDictionary = [[[NSMutableDictionary alloc] init] autorelease];
    
    if(userInfoDictionary!=nil)
    {
        if(delegate!=nil)
        {
            [userInfoDictionary setObject:delegate forKey:PPCloud_UserInfoKey_Delegate];
        }
        
        if(userInfo!=nil)
        {
            [userInfoDictionary setObject:userInfo forKey:PPCloud_UserInfoKey_UserInfo];
        }
    }
    
    return userInfoDictionary;
}

- (id)delegateFromUserInfoDictionary:(NSDictionary *)userInfoDictionary
{
    id delegate = nil;
    
    if(userInfoDictionary!=nil)
    {
        delegate = [userInfoDictionary objectForKey:PPCloud_UserInfoKey_Delegate];
    }
    
    return delegate;
}

- (id)userInfoFromUserInfoDictionary:(NSDictionary *)userInfoDictionary
{
    id userInfo = nil;
    
    if(userInfoDictionary!=nil)
    {
        userInfo = [userInfoDictionary objectForKey:PPCloud_UserInfoKey_UserInfo];
    }
    
    return userInfo;
}

- (BOOL)addOperation:(NSOperation *)operation
{
    BOOL result = NO;
    
    if(operation!=nil)
    {
        [self.operationQueue addOperation:operation];
        
        result = YES;
    }
    
    return result;
}

@end
