//
//  PPClipContactPhotoViewController.m
//
//
//  Created by Andrewlia on 13/12/13.
//  Copyright (c) 2013年 penpower. All rights reserved.
//

#import "PPClipContactPhotoViewController.h"
#import "UIImage+Additions.h"
#import "PPClipContactPhotoMaskView.h"
#import "PPClipContactPhotoViewController+ResourceDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSUInteger const PPClipContactPhotoViewController_TitleFontSize   = 22;
static NSUInteger const PPClipContactPhotoViewController_ToolBarFontSize = 20;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPClipContactPhotoViewController()

@interface PPClipContactPhotoViewController()





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic, retain) NSOperationQueue                 *operationQueue;
@property (nonatomic, retain) PPBarView                        *ppToolBarView;
@property (nonatomic, retain) PPBusyView                       *ppBusyView;
@property (nonatomic, retain) PPButton                         *ppButtonCancel;
@property (nonatomic, retain) PPButton                         *ppButtonChoose;
@property (nonatomic, retain) PPClipContactPhotoMaskView       *ppClipContactPhotoMaskView;
@property (nonatomic, retain) PPImageScrollView                *ppImageScrollView;
@property (nonatomic, retain) PPTitleBarView                   *ppTitleBarView;
@property (nonatomic, retain) UIView                           *imageMaskViewLeft;
@property (nonatomic, retain) UIView                           *imageMaskViewRight;
- (void)clipContactPhoto;
- (void)mainThreadTerminalClipImage:(UIImage *)resultImage;
- (void)refreshContentSize;
@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation PPClipContactPhotoViewController

@implementation PPClipContactPhotoViewController





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
// 初始化參數
//================================================================================
- (id)init
{
	if((self = [super init]))
	{
        _operationQueue = [[NSOperationQueue alloc] init];
        
        _maximumZoomScale = PPClipContactPhotoViewControllerDefaultMaximumZoomScale;
        
        _maxmumSizeOfSourceImage = PPClipContactPhotoViewControllerDefaultMaxmumImageSize;
        
        //////////////////////////////////////////////////
        
        _textColorForTitleBar = [UIColor whiteColor];
        _textColorForToolBar  = [UIColor whiteColor];
        
        //////////////////////////////////////////////////
        //設定介面可旋轉
        
        [self.ppInterfaceOrientationController setMask:(PPInterfaceOrientationControllerMask_Portrait|PPInterfaceOrientationControllerMask_PortraitUpsideDown|PPInterfaceOrientationControllerMask_LandscapeLeft|PPInterfaceOrientationControllerMask_LandscapeRight)];
	}
	
	return self;
}


//================================================================================
// 釋放物件的處理(釋放.h檔裡所宣告的物件)
//================================================================================
- (void)dealloc
{
    [_sourceImage release];
    _sourceImage = nil;
    
    [_operationQueue cancelAllOperations]; //已執行的處理不會中斷
    [_operationQueue release];
    _operationQueue = nil;
    
    //////////////////////////////////////////////////
    
    [_backgroundColorForTitleBar release];
    _backgroundColorForTitleBar = nil;
    
    [_textColorForTitleBar release];
    _textColorForTitleBar = nil;
    
    [_backgroundColorForToolBar release];
    _backgroundColorForToolBar = nil;
    
    [_textColorForToolBar release];
    _textColorForToolBar = nil;
    
    [_backgroundColorForMask release];
    _backgroundColorForMask = nil;
    
    [self.ppButtonCancel removeFromSuperview];
    self.ppButtonCancel = nil;
    
    [self.ppButtonChoose removeFromSuperview];
    self.ppButtonChoose = nil;
    
    [self.ppToolBarView removeFromSuperview];
    self.ppToolBarView = nil;
    
    [self.ppTitleBarView removeFromSuperview];
    self.ppTitleBarView = nil;
    
    [self.ppClipContactPhotoMaskView removeFromSuperview];
    self.ppClipContactPhotoMaskView = nil;
    
    [self.ppImageScrollView removeFromSuperview];
    self.ppImageScrollView = nil;
    
    [self.imageMaskViewLeft removeFromSuperview];
    self.imageMaskViewLeft = nil;
    
    [self.imageMaskViewRight removeFromSuperview];
    self.imageMaskViewRight = nil;
    
    [self.ppBusyView removeFromSuperview];
    self.ppBusyView = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
// View要呈現前即被呼叫
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    // 中間的ImageScrollView
    
    PPImageScrollView *ppImageScrollView = [[PPImageScrollView alloc] initWithFrame:CGRectZero];
    if (ppImageScrollView!=nil)
    {
        ppImageScrollView.backgroundColor   = [UIColor darkGrayColor];
        ppImageScrollView.bouncesZoom       = NO;
        ppImageScrollView.imageMode         = PPImageScrollViewImageMode_ScaleAspectRecessed;
        
        ppImageScrollView.proxy             = self;
        
        [self.view addSubview:ppImageScrollView];
        
        self.ppImageScrollView = ppImageScrollView;
        [ppImageScrollView release];
    }
    
    //////////////////////////////////////////////////
    // maskView
    
    PPClipContactPhotoMaskView *ppClipContactPhotoMaskView = [[PPClipContactPhotoMaskView alloc] initWithFrame:CGRectZero];
    if (ppClipContactPhotoMaskView!=nil)
    {
        ppClipContactPhotoMaskView.maskColor = self.backgroundColorForMask;
        [self.view addSubview:ppClipContactPhotoMaskView];
        
        self.ppClipContactPhotoMaskView = ppClipContactPhotoMaskView;
        [ppClipContactPhotoMaskView release];
    }

    //////////////////////////////////////////////////
    // 上方的Navigation Bar

    PPTitleBarView *ppTitleBarView = [[PPTitleBarView alloc] initWithFrame:CGRectZero];
    if (ppTitleBarView!=nil)
    {
        ppTitleBarView.backgroundColor      = self.backgroundColorForTitleBar;
        ppTitleBarView.style                = PPBarViewStyle_CenteredAbsolute;
        ppTitleBarView.titleLabel.font	    = [UIFont boldSystemFontOfSize:PPClipContactPhotoViewController_TitleFontSize];
        ppTitleBarView.titleLabel.textColor	= self.textColorForTitleBar;
        ppTitleBarView.titleLabel.text      = PCCPV_MLS_MoveAndZoom;
        
        [self.view addSubview:ppTitleBarView];
        
        self.ppTitleBarView = ppTitleBarView;
        [ppTitleBarView release];
    }
    
    //////////////////////////////////////////////////
    // 下方的Navigation ToolBar
    
    PPBarView *ppToolBarView = [[PPBarView alloc] initWithFrame:CGRectZero];
    if (ppToolBarView!=nil)
    {
        ppToolBarView.backgroundColor   = self.backgroundColorForToolBar;
        ppToolBarView.style             = PPBarViewStyle_Average;
        
        //////////////////////////////////////////////////
        
        PPButton *ppButtonCancel = [[PPButton alloc] initWithFrame:CGRectZero];
        if (ppButtonCancel!=nil)
        {
            ppButtonCancel.delegate   = self;
            ppButtonCancel.tag        = PPClipContactPhotoViewControllerButtonTag_Cancel;
            ppButtonCancel.titleLabel.font = [UIFont systemFontOfSize:PPClipContactPhotoViewController_ToolBarFontSize];
            
            [ppButtonCancel setTitleColor:self.textColorForToolBar];
            [ppButtonCancel addControlEvents:UIControlEventTouchUpInside];
            [ppButtonCancel setBackgroundImageWithName:ImageNamePPButtonBackgroundForNavigationBar];
            
            [ppToolBarView setViews:@[ppButtonCancel] forBlockType:PPBarViewBlockType_Left];
            
            self.ppButtonCancel = ppButtonCancel;
            [ppButtonCancel release];
        }
        
        PPButton *ppButtonChoose = [[PPButton alloc] initWithFrame:CGRectZero];
        if (ppButtonChoose!=nil)
        {
            ppButtonChoose.delegate   = self;
            ppButtonChoose.tag        = PPClipContactPhotoViewControllerButtonTag_Choose;
            ppButtonChoose.titleLabel.font = [UIFont systemFontOfSize:PPClipContactPhotoViewController_ToolBarFontSize];
            
            [ppButtonChoose setTitleColor:self.textColorForToolBar];
            [ppButtonChoose addControlEvents:UIControlEventTouchUpInside];
            [ppButtonChoose setBackgroundImageWithName:ImageNamePPButtonBackgroundForNavigationBar];
            
            [ppToolBarView setViews:@[ppButtonChoose] forBlockType:PPBarViewBlockType_Right];
            
            self.ppButtonChoose = ppButtonChoose;
            [ppButtonChoose release];
        }
        
        [self.view addSubview:ppToolBarView];
        
        self.ppToolBarView = ppToolBarView;
        [ppToolBarView release];
    }
    
    //////////////////////////////////////////////////
    //左右兩側用來標示出裁切範圍的View（只有Device為橫向時才會出現）
    
    _imageMaskViewLeft = [[UIView alloc] initWithFrame:CGRectZero];
   
    if (self.imageMaskViewLeft != nil)
    {
        self.imageMaskViewLeft.backgroundColor = [UIColor clearColor];
        [self.view addSubview:self.imageMaskViewLeft];
        [self.imageMaskViewLeft setHidden:YES];
    }
    
    _imageMaskViewRight = [[UIView alloc] initWithFrame:CGRectZero];
    
    if (self.imageMaskViewRight != nil)
    {
        self.imageMaskViewRight.backgroundColor = [UIColor clearColor];
        [self.view addSubview:self.imageMaskViewRight];
        [self.imageMaskViewLeft setHidden:YES];
    }
}


//================================================================================
// View要關閉前即被呼叫
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self.ppButtonCancel removeFromSuperview];
    self.ppButtonCancel = nil;
    
    [self.ppButtonChoose removeFromSuperview];
    self.ppButtonChoose = nil;
    
    [self.ppToolBarView removeFromSuperview];
    self.ppToolBarView = nil;
    
    [self.ppTitleBarView removeFromSuperview];
    self.ppTitleBarView = nil;
    
    [self.ppClipContactPhotoMaskView removeFromSuperview];
    self.ppClipContactPhotoMaskView = nil;
    
    [self.ppImageScrollView removeFromSuperview];
    self.ppImageScrollView = nil;
    
    [self.imageMaskViewLeft removeFromSuperview];
    self.imageMaskViewLeft = nil;
    
    [self.imageMaskViewRight removeFromSuperview];
    self.imageMaskViewRight = nil;
    
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Intended For Subclasses Method Override

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    //　處理旋轉時的SubView
    
    CGRect frame = self.view.bounds;
    CGFloat topHeight;
    CGFloat bottomHeight;
    CGFloat leftWidth;
    CGFloat rightWidth;
    CGFloat clipRectSize;
    
    if(self.view.bounds.size.width<self.view.bounds.size.height)
    {
        // 裝置為縱向
        
        topHeight    = (frame.size.height-frame.size.width)/2;
        bottomHeight = frame.size.height-frame.size.width-topHeight;
        leftWidth    = 0;
        
        clipRectSize = frame.size.width;
        
        [self.imageMaskViewLeft setHidden:YES];
        [self.imageMaskViewRight setHidden:YES];
    }
    else
    {
        // 裝置為橫向
        
        topHeight       = PPClipContactPhotoViewControllerToolBarHeightWhenLandscape;
        bottomHeight    = PPClipContactPhotoViewControllerToolBarHeightWhenLandscape;
        
        //　計算裝置為橫向時的imageMaskView大小
        
        CGFloat maskFrameHeight = frame.size.height - PPClipContactPhotoViewControllerToolBarHeightWhenLandscape * 2;
        leftWidth  = (frame.size.width - maskFrameHeight) / 2;
        rightWidth = leftWidth;
        
        CGRect maskFrame = CGRectMake(0.0, topHeight, leftWidth, maskFrameHeight);
        [self.imageMaskViewLeft setFrame:maskFrame];
        
        maskFrame = CGRectMake(frame.size.width - rightWidth, topHeight, rightWidth, maskFrameHeight);
        [self.imageMaskViewRight setFrame:maskFrame];
        
        clipRectSize = maskFrameHeight;
    
        [self.imageMaskViewLeft setHidden:NO];
        [self.imageMaskViewRight setHidden:NO];
    }
    
    CGFloat bottomOriginalY = frame.size.height-bottomHeight;
    
    //////////////////////////////////////////////////
    // 上方覆蓋的MaskView
    
    self.ppClipContactPhotoMaskView.frame = frame;
    self.ppClipContactPhotoMaskView.showClearRect = CGRectMake(leftWidth, topHeight, clipRectSize, clipRectSize);
    [self.ppClipContactPhotoMaskView setNeedsDisplay];
    
    //////////////////////////////////////////////////
    // 中間的ImageScrollView
    
//    // MARK:因為指定ppImageScrollView的Frame會讓ContentOffset跑掉只好這樣做，可能有更好的解決法
//    CGPoint contentOffsetTemp = self.ppImageScrollView.contentOffset;
    self.ppImageScrollView.frame = self.ppClipContactPhotoMaskView.showClearRect;
    self.ppImageScrollView.edgeInsetsForRecessed = UIEdgeInsetsZero;

//    if (self.sourceImage.size.width>=self.sourceImage.size.height)
//    {
//        //以寬度為基準
//        self.ppImageScrollView.maximumZoomScaleForImageSize = (clipRectSize/self.sourceImage.size.width)*self.maximumZoomScale;
//    }
//    else
//    {
//        //以高度為基準
//        self.ppImageScrollView.maximumZoomScaleForImageSize = (clipRectSize/self.sourceImage.size.height)*self.maximumZoomScale;
//    }
//    
    //設定影像初始位置和大小
    self.ppImageScrollView.image                  = self.sourceImage;
    self.ppImageScrollView.doubleTapZoomScale     = self.maximumZoomScale;
//
//    //設定imageView較小的高度或寬度去貼齊邊緣
//    if (self.ppImageScrollView.imageView.frame.size.width>=self.ppImageScrollView.imageView.frame.size.height)
//    {
//        CGFloat zoomImageWidth = self.ppImageScrollView.imageView.frame.size.width*self.ppImageScrollView.imageView.frame.size.width/self.ppImageScrollView.imageView.frame.size.height;
//        CGFloat avergeZoomWidth = (zoomImageWidth-self.ppImageScrollView.imageView.frame.size.width)/2;
//        self.ppImageScrollView.edgeInsetsForRecessed  = UIEdgeInsetsMake(topHeight, leftWidth-avergeZoomWidth,  bottomHeight, rightWidth-avergeZoomWidth);
//    }
//    else
//    {
//        CGFloat zoomImageHeight = self.ppImageScrollView.imageView.frame.size.height*self.ppImageScrollView.imageView.frame.size.height/self.ppImageScrollView.imageView.frame.size.width;
//        CGFloat avergeZoomHeight = (zoomImageHeight-self.ppImageScrollView.imageView.frame.size.height)/2;
//        self.ppImageScrollView.edgeInsetsForRecessed  = UIEdgeInsetsMake(topHeight-avergeZoomHeight, leftWidth,  bottomHeight-avergeZoomHeight, rightWidth);
//    }
    
//    // 將ContentOffset設回來
//    [self.ppImageScrollView setContentOffset:contentOffsetTemp];
    
    //////////////////////////////////////////////////
    // 上方的Navigation Bar
    
    frame.size.height           = topHeight;
    self.ppTitleBarView.frame   = frame;
    
    //////////////////////////////////////////////////
    // 下方的Navigation ToolBar
    
    frame.size.height           = bottomHeight;
    frame.origin.y              = bottomOriginalY;
    self.ppToolBarView.frame    = frame;
    
    [self.ppButtonCancel setTitle:PCCPV_MLS_Cancel maxWidth:0];
    [self.ppButtonChoose setTitle:PCCPV_MLS_Choose maxWidth:0];
    
    //////////////////////////////////////////////////
    
    // 重新設定ContentInset
//    [self refreshContentSize];

    //////////////////////////////////////////////////

    // 修改ContentOffset，讓scrollView的可視範圍也在Content的中心
//    self.ppImageScrollView.contentOffset =  CGPointMake(self.ppImageScrollView.contentSize.width / 2 - self.ppImageScrollView.frame.size.width / 2,
//                                                        self.ppImageScrollView.contentSize.height / 2 - self.ppImageScrollView.frame.size.height / 2);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Methods

//================================================================================
// 點擊選擇按鈕
//================================================================================
- (void)clipContactPhoto
{
//    NSLog(@"Bounds: %@", NSStringFromCGRect(self.ppImageScrollView.bounds));
//    NSLog(@"Frame: %@", NSStringFromCGRect(self.ppImageScrollView.frame));

//    if (clipRect.size.height > clipRect.size.width) //畫面為縱向
//    {
//        clipRect.origin.y    = clipRect.origin.y;
//        clipRect.size.height = clipRect.size.width;
//    }
//    else                                            //畫面為橫向
//    {
//        clipRect.size.height = clipRect.size.height;
//        clipRect.origin.x   = clipRect.origin.x;
//        clipRect.size.width = clipRect.size.height;
//    }
    
    [self showBusyView:YES];
    
    CGRect clipRect = self.ppImageScrollView.bounds;
    
    CGRect convertClipRect  = [self.ppImageScrollView convertRect:clipRect toView:self.ppImageScrollView.imageView];
    
    CGFloat scale = self.ppImageScrollView.imageView.image.size.width/self.ppImageScrollView.imageView.bounds.size.width;
   
    CGRect scaleConvertClipRect = CGRectMake(floor(convertClipRect.origin.x*scale),
                                                     floor(convertClipRect.origin.y*scale),
                                                     ceil(convertClipRect.size.width*scale),
                                                     ceil(convertClipRect.size.height*scale));


    UIImage *finalImage = [self.ppImageScrollView.image imageCroppedByRect:scaleConvertClipRect];
    
    //////////////////////////////////////////////////
    // 定義部分畫布區域

    CGSize contextSize = finalImage.size;

    if (CGSizeEqualToSize(finalImage.size, CGSizeZero)==true)
    {
        //影像拖曳至最邊界,imageView內無影像,所以呈現 1*1 全白影像

        contextSize.width   = 1;
        contextSize.height  = 1;
    }
    else
    {
        //imageView內有影像,以最長邊為主
        
        if (self.ppImageScrollView.imageView.bounds.origin.x+self.ppImageScrollView.imageView.bounds.size.width<clipRect.size.width)
        {
            if (scaleConvertClipRect.size.height>self.sourceImage.size.height)
            {
                scaleConvertClipRect.size.height = self.sourceImage.size.height;
            }
            
            contextSize.width = scaleConvertClipRect.size.height;
            contextSize.height = scaleConvertClipRect.size.height;
        }
        else if (self.ppImageScrollView.imageView.bounds.origin.y+self.ppImageScrollView.imageView.bounds.size.height<clipRect.size.height)
        {
            if (scaleConvertClipRect.size.width>self.sourceImage.size.width)
            {
                scaleConvertClipRect.size.width = self.sourceImage.size.width;
            }
            
            contextSize.width = scaleConvertClipRect.size.width;
            contextSize.height = scaleConvertClipRect.size.width;
        }
        else
        {
            if (finalImage.size.width>=finalImage.size.height)
            {
                contextSize.height = contextSize.width;
            }
            else
            {
                contextSize.width = contextSize.height;
            }
        }
    }
    
    if (scaleConvertClipRect.origin.y>0)
    {
        scaleConvertClipRect.origin.y = 0;
    }
    
    if (scaleConvertClipRect.origin.x>0)
    {
        scaleConvertClipRect.origin.x = 0;
    }
                
//    NSLog(@"convertClipRect: %@", NSStringFromCGRect(convertClipRect));
//    NSLog(@"imageViewFrame: %@", NSStringFromCGRect(self.ppImageScrollView.imageView.frame));
    
    NSOperationQueue *operationQueue = [[[NSOperationQueue alloc] init] autorelease];
    
    [operationQueue addOperationWithBlock:^{
      
          

          //////////////////////////////////////////////////
          // 初始畫布
          
          CGColorSpaceRef colorSpace  = CGColorSpaceCreateDeviceRGB();
          if(colorSpace!=NULL)
          {
              CGContextRef throughContext = CGBitmapContextCreate(NULL, contextSize.width, contextSize.height, 8, contextSize.width*4, colorSpace, kCGBitmapAlphaInfoMask&kCGImageAlphaPremultipliedLast);
              if (throughContext!=NULL)
              {
                  CGContextSetFillColorWithColor(throughContext, [UIColor whiteColor].CGColor);
                  CGContextFillRect(throughContext, CGRectMake(0, 0, contextSize.width, contextSize.height));
            
                  CGContextDrawImage(throughContext, CGRectMake(-scaleConvertClipRect.origin.x, contextSize.height-finalImage.size.height+scaleConvertClipRect.origin.y, finalImage.size.width, finalImage.size.height), finalImage.CGImage);
                  
                  //////////////////////////////////////////////////
                  // 繪畫區域的影像
                  
                  CGImageRef throughImage = CGBitmapContextCreateImage(throughContext);
                  UIImage *resultImage    = [UIImage imageWithCGImage:throughImage];
                  
                  CGImageRelease(throughImage);
                  CGContextRelease(throughContext);
                  
                  //////////////////////////////////////////////////
                  // 委託設定大頭貼影像
                  
                  if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppClipContactPhotoViewController:resignContactPhoto:)])
                  {
                      [self performSelectorOnMainThread:@selector(mainThreadTerminalClipImage:) withObject:resultImage waitUntilDone:YES];
                  }
              }
              
              CGColorSpaceRelease(colorSpace);
          }
    }];
  
}


//================================================================================
// 主線程傳輸結果
//================================================================================
- (void)mainThreadTerminalClipImage:(UIImage *)resultImage
{
    [self showBusyView:NO];
    
    [self.delegate ppClipContactPhotoViewController:self resignContactPhoto:resultImage];
}


//================================================================================
// 影像縮放後重新設定contentSize
//================================================================================
- (void)refreshContentSize
{
//    //ToolBar高度
//    CGFloat barHeight = self.ppToolBarView.frame.size.height;
//    
//    //剪裁區域大小，依畫面縱向/橫向而有所不同。
//    CGSize clipSize;
//    
//    if(self.interfaceOrientation == UIInterfaceOrientationPortrait || self.interfaceOrientation == UIInterfaceOrientationPortraitUpsideDown)
//    {
//        //橫向，剪裁區域寬度為畫面寬度，高度為(畫面高度 - 兩倍ToolBar高度)
//        clipSize = CGSizeMake(self.ppImageScrollView.bounds.size.width,
//                              self.ppImageScrollView.bounds.size.height - barHeight * 2);
//    }
//    else
//    {
//        //縱向，剪裁區域寬度為(畫面高度 - 兩倍ToolBar高度)，高度為(畫面高度 - 兩倍ToolBar高度)
//        clipSize = CGSizeMake(self.ppImageScrollView.bounds.size.height - barHeight * 2,
//                              self.ppImageScrollView.bounds.size.height - barHeight * 2);
//    }
//    
//    //////////////////////////////////////////////////
//    // 設定contentSize
//    
//    CGSize contentSize;
//
//    // 用contentSize設定能捲動的範圍，也就是整個scrollView的寬度 + 剪裁區域寬度和圖片寬度的距離差
//    // 因為要讓圖片能捲動的範圍切齊剪裁區域的邊緣，所以contentSize要比imageScrollView和imageView都大
//    
//    // Case 1
//    // imageView比imageScrollView小，要多捲動imageView和clipRect中間的那段距離
//    // 所以是imageScrollView.frame + (imageView.frame - clipRect.frame)
//    // Case 2
//    // imageView比imageScrollView大，要多捲動imageScrollView和clipRect中間的那段距離
//    // 所以是imageView.frame + (imageScrollView.frame - clipRect.frame)
//    //
//    // 簡化合併後可得下面式子 → imageView.frame + imageScrollView.frame - clipRect.frame
//    // 但是imageView有可能比clipRect小，所以程式碼如下
//    
//    contentSize =
//    CGSizeMake(self.ppImageScrollView.frame.size.width + ABS(clipSize.width - self.ppImageScrollView.imageView.frame.size.width),
//               self.ppImageScrollView.frame.size.height + ABS(clipSize.height - self.ppImageScrollView.imageView.frame.size.height));
//    self.ppImageScrollView.contentSize = contentSize;
//    
//    //////////////////////////////////////////////////
//    
//    // 將imageView置於Content的中心
//    self.ppImageScrollView.imageViewFrameOrigin =
//    CGPointMake(contentSize.width / 2 - self.ppImageScrollView.imageView.frame.size.width / 2,
//                contentSize.height / 2 - self.ppImageScrollView.imageView.frame.size.height / 2);
}


//================================================================================
// 是否顯示等待UI
//================================================================================
- (void)showBusyView:(BOOL)show
{
    if (show==YES)
    {
        if (self.ppBusyView==nil)
        {
            _ppBusyView         = [[PPBusyView alloc] initWithSuperView:self.view];
            _ppBusyView.style    = PPBusyViewStyle_Border;
        }
    }
    else
    {
        [self.ppBusyView removeFromSuperview];
        self.ppBusyView = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
// PPButton Events
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case PPClipContactPhotoViewControllerButtonTag_Cancel:
        {
            if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppClipContactPhotoViewControllerDidCancel:)])
            {
                [self.delegate ppClipContactPhotoViewControllerDidCancel:self];
            }
            
            break;
        }
        case PPClipContactPhotoViewControllerButtonTag_Choose:
        {
            [self clipContactPhoto];
    
            
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UIScrollViewDelegate

//================================================================================
// 影像縮放事件
//================================================================================
- (void)scrollViewDidZoom:(UIScrollView *)scrollView
{
    [self refreshContentSize];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Method

//================================================================================
//
//================================================================================
- (void)setSourceImage:(UIImage *)sourceImage
{
    
    //鏡像圖要小心
    if(sourceImage!=nil)
    {
        switch (sourceImage.imageOrientation)
        {
            case UIImageOrientationDownMirrored:
            {
                sourceImage = [UIImage imageWithCGImage:sourceImage.CGImage scale:sourceImage.scale orientation:UIImageOrientationDown];
                break;
            }
            case UIImageOrientationLeftMirrored:
            {
                sourceImage = [UIImage imageWithCGImage:sourceImage.CGImage scale:sourceImage.scale orientation:UIImageOrientationLeft];
                break;
            }
            case UIImageOrientationRightMirrored:
            {
                sourceImage = [UIImage imageWithCGImage:sourceImage.CGImage scale:sourceImage.scale orientation:UIImageOrientationRight];
                break;
            }
            case UIImageOrientationUpMirrored:
            {
                sourceImage = [UIImage imageWithCGImage:sourceImage.CGImage scale:sourceImage.scale orientation:UIImageOrientationUp];
                break;
            }
            default:
            {
                break;
            }
        }
    }
    
    //////////////////////////////////////////////////

    if(sourceImage==nil)
    {
        [_sourceImage release];
        _sourceImage = sourceImage;
    }
    else
    {
        UIImage *compactImage = sourceImage;

        //圖太大，不壓縮會  out of memory
        if(sourceImage.size.width>self.maxmumSizeOfSourceImage.width ||
           sourceImage.size.height>self.maxmumSizeOfSourceImage.height)
        {
            BOOL compact = YES;
            
            do
            {
                if(self.delegate==nil ||
                    [self.delegate respondsToSelector:@selector(compactImageWithPPClipContactPhotoViewControllerDidImageCheckSize:)]==NO)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                compact = [self.delegate compactImageWithPPClipContactPhotoViewControllerDidImageCheckSize:self];
                
            } while (0);
            
            //////////////////////////////////////////////////
            
            if(compact==YES)
            {
                compactImage = [sourceImage imageScalingMaxLength:MAX(self.maxmumSizeOfSourceImage.width, self.maxmumSizeOfSourceImage.height)];
            }
            
            if(self.delegate!=nil &&
               [self.delegate respondsToSelector:@selector(compactImage:withPPClipContactPhotoViewController:)]==YES)
            {
                [self.delegate compactImage:compactImage withPPClipContactPhotoViewController:self];
            }
        }
        
        //////////////////////////////////////////////////
            
        [compactImage retain];
        
        [_sourceImage release];
        
        _sourceImage = compactImage;
    }
}
@end
