//
//  PPCheckBoxView.m
//  
//
//  Created by Mike on 13/5/21.
//  Modify by Andrew on 15/4/24.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPCheckBoxView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Resource

NSString *DefaultImageNameForPPCheckBoxViewSelected   = @"DefaultImageForCheckBoxViewSelected";
NSString *DefaultImageNameForPPCheckBoxViewUnselected = @"DefaultImageForCheckBoxViewUnselected";





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCheckBoxView Extension

@interface PPCheckBoxView()
@property (nonatomic, retain) UIImageView *imageView;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCheckBoxView Implementation

@implementation PPCheckBoxView





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
// init
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
	if((self = [super initWithFrame:frame]))
	{						
		self.backgroundColor = [UIColor clearColor];
        
        //////////////////////////////////////////////////
        // 記憶體要求例外處理

        do
        {
            self.checkBoxImageSelected = [UIImage imageWithName:DefaultImageNameForPPCheckBoxViewSelected];
            self.checkBoxImageUnSelected = [UIImage imageWithName:DefaultImageNameForPPCheckBoxViewUnselected];
            self.imageEdgeInsets = UIEdgeInsetsZero;
            
            _imageView = [[UIImageView alloc] initWithFrame:CGRectMake(PPCheckBoxViewDefaultGap, PPCheckBoxViewDefaultGap, PPCheckBoxViewDefaultImageSize.width, PPCheckBoxViewDefaultImageSize.height)];
            if (self.imageView==nil)
            {
                self = nil;
                break;
            }
            
            self.imageView.backgroundColor = [UIColor clearColor];
            [self addSubview:self.imageView];
        } while (0);
	}
	
	return self;
}


//================================================================================
// release memory
//================================================================================
- (void)dealloc
{
	[self.imageView removeFromSuperview];
	self.imageView.image = nil;
    self.imageView = nil;
	
	//////////////////////////////////////////////////

    self.checkBoxImageSelected = nil;
    self.checkBoxImageUnSelected = nil;
	
	//////////////////////////////////////////////////

    [super dealloc];
}


//==============================================================================
//
//==============================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////

    if(self.imageEdgeInsets.top!=0 ||
       self.imageEdgeInsets.left!=0 ||
       self.imageEdgeInsets.right!= 0 ||
       self.imageEdgeInsets.bottom!=0)
    {
        CGRect imageFrame = UIEdgeInsetsInsetRect(self.bounds, self.imageEdgeInsets);
        NSInteger size = MIN(imageFrame.size.width, imageFrame.size.height);
        imageFrame.size.width = size;
        imageFrame.size.height = size;
        imageFrame.origin.x = (self.bounds.size.width-size)/2;
        imageFrame.origin.y = (self.bounds.size.height-size)/2;
        [self.imageView setFrame:imageFrame];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
// 設定目前PPCheckBoxView的狀態圖示
//================================================================================
- (void)setStatus:(PPCheckBoxViewStatus)status
{
    _status = status;
    
    //////////////////////////////////////////////////
    
	switch(self.status) 
	{
		case PPCheckBoxViewStatus_Select:
		{			
			self.imageView.image = self.checkBoxImageSelected;
			break;
		}
		case PPCheckBoxViewStatus_Unselect:
		{			
			self.imageView.image = self.checkBoxImageUnSelected;
			break;
		}
		case PPCheckBoxViewStatus_None:
		default:
		{
			self.imageView.image = nil;
			break;
		}
	}
    
    //////////////////////////////////////////////////

	if(self.status!=PPCheckBoxViewStatus_None)
	{
		[self bringSubviewToFront:self.imageView];
	}
}


//==============================================================================
//
//==============================================================================
- (void)setImageEdgeInsets:(UIEdgeInsets)imageEdgeInsets
{
    _imageEdgeInsets = imageEdgeInsets;
    
    [self setNeedsLayout];
}

@end
