//
//  MetalHelper.m
//  Pods
//
//  Created by sanhue cheng on 2020/5/29.
//

#import "MetalHelper.h"

@implementation MetalHelper



//==============================================================================
//
//==============================================================================
+ (id<MTLTexture>)textureWithSize:(CGSize)size pixelFormat:(MTLPixelFormat)pixelformat device:(nonnull id<MTLDevice>)device
{
    NSAssert(device!=nil, @"device 要有值");
    NSAssert(size.width>0&&size.height>0, @"size 不能為空");
    
    MTLTextureDescriptor *texBufferDesc =
    [MTLTextureDescriptor texture2DDescriptorWithPixelFormat:pixelformat
                                                       width:size.width
                                                      height:size.height
                                                   mipmapped:NO];
    texBufferDesc.textureType = MTLTextureType2D;
    texBufferDesc.storageMode = MTLStorageModeShared;
    texBufferDesc.usage |= MTLTextureUsageRenderTarget | MTLTextureUsageShaderWrite | MTLTextureUsageShaderRead;
    id<MTLTexture> texture = [device newTextureWithDescriptor:texBufferDesc];
    
    return [texture autorelease];
}

@end
