//
//  PPButton.h
//  
//
//  Created by Mike on 13/5/17.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PPAppearance.h"
#import "UIButton+Additions.h"

typedef NS_ENUM(NSInteger, PPButtonLayoutType)
{
    PPButtonLayoutType_Normal = 0,  // 原本的layout
    PPButtonLayoutType_Bottom,  //標題在下
    PPButtonLayoutType_Right        //標題在右
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Resource

/**
 *  Back鍵背景圖
 */
extern NSString *ImageNamePPButtonBackgroundForBack;

/**
 *  系統的返回鍵圖示, ex: <
 */
extern NSString *ImageNamePPButtonIconForSystemBackImitation;

/**
 *  Navigation bar 上面的按鈕圖示
 */
extern NSString *ImageNamePPButtonBackgroundForNavigationBar;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Delegate

@class PPButton;
@protocol PPButtonDelegate <NSObject>
@required
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent;
@optional
- (void)ppButton:(PPButton *)ppButton longPressWithState:(UIGestureRecognizerState)state;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPButton : UIButton <PPAppearance>
{
@private
    id<PPButtonDelegate>    delegate_;
    BOOL					orientationDetect_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) id<PPButtonDelegate>   delegate;
@property (nonatomic,assign) BOOL                   orientationDetect;
@property (nonatomic,assign) BOOL                   enableLongPress;

/**
 * 圖示的最小高度
 * 如果套用imageEdgeInsets後的高度，比|minimumImageHeight|小
 * 會以|minimumImageHeight|來顯示圖示大小
 * 如果設定的|minimumImageHeight|比按鈕大小還要大，會以按鈕大小為優先，也就是圖示一定會比按鈕小
 * 預設為0表示以imageEdgeInsets為主，沒有最小高度
 */

@property (nonatomic,assign) CGFloat                minimumImageHeight PP_APPEARANCE_SELECTOR;

@property (nonatomic,assign) PPButtonLayoutType     layoutType;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (UIControlEvents)addControlEvents:(UIControlEvents)controlEvents;
- (UIControlEvents)removeControlEvents:(UIControlEvents)controlEvents;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (void)setDefaultTitleColor:(UIColor *)color;
+ (void)setDefaultTitleShadowColor:(UIColor *)color;
+ (void)setDefaultTitleLabelFont:(UIFont *)font;

@end

