//
//  PPViewController+PPBusyView.m
//  WorldNote
//
//  Created by sanhue on 2014/4/9.
//  Copyright (c) 2014年 Eddie. All rights reserved.
//

#import "NSObject+PPBusyView.h"
#import <objc/runtime.h>

static char NSObject_PPBusyView;
static char NSObject_PPBusyView_BusyCount;


@implementation NSObject (PPBusyView)
@dynamic busyView;


//================================================================================
//
//================================================================================
- (PPBusyView*)busyView
{
    return objc_getAssociatedObject(self, &NSObject_PPBusyView);
}


//================================================================================
//
//================================================================================
- (void)setBusyView:(PPBusyView*)busyView
{
    objc_setAssociatedObject(self, &NSObject_PPBusyView, busyView, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}


//==============================================================================
//
//==============================================================================
- (NSUInteger)busyCount
{
    id value = objc_getAssociatedObject(self, &NSObject_PPBusyView_BusyCount);
    if(value)
    {
        return [value unsignedIntegerValue];
    }
    return 0;
}


//================================================================================
//
//================================================================================
- (void)setBusyCount:(NSUInteger)busyCount
{
    objc_setAssociatedObject(self, &NSObject_PPBusyView_BusyCount, @(busyCount), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

//================================================================================
//
//================================================================================
- (void)setBusy:(NSNumber*)busy
{
    [self setBusy:busy withView:nil];
}


//================================================================================
//
//================================================================================
- (void)setBusy:(NSNumber*)busy withView:(UIView *)view
{
    @synchronized(self)
    {
        NSUInteger busyCount = [self busyCount];
        
        if([busy boolValue])
        {
            if(busyCount == 0)
            {
                if (self.busyView)
                {
                    [self.busyView removeFromSuperview];
                    self.busyView = nil;
                }
                
                self.busyView = [[[PPBusyView alloc] initWithSuperView:view] autorelease];
            }
            
            [self setBusyCount:busyCount+1];
        }
        else // hide busy view
        {
            if(busyCount == 1)
            {
                [self.busyView removeFromSuperview];
                self.busyView = nil;
            }
            
            if (busyCount>=1)
            {
                [self setBusyCount:busyCount-1];
            }
        }
    }
}
@end
