//
//  PPNavigationBarView.m
//  
//
//  Created by Mike on 13/5/23.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPNavigationBarView.h"

@implementation PPNavigationBarView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
	if((self = [super initWithFrame:frame]))
	{
        UIColor *defaultColor = [PPBarView barBackgroundColor];
        if (defaultColor==nil)
        {
            defaultColor = [UIColor clearColor];
        }
        
        self.backgroundColor = defaultColor;
        
        self.backgroundImageView.image = [UIImage imageWithName:ImageNamePPBarViewBackgroundForNavigationBar];
	}
	
	return self;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Override Method

//================================================================================
//
//================================================================================
- (void)setFrame:(CGRect)frame
{
    CGRect adjustFrame = frame;
    
    UIView *superView = self.superview;
    //  判斷是否為iphone X，橫式
    NSInteger horzMargin = 0;
    
    if(@available(iOS 11.0, *))
    {
        horzMargin = self.superview.safeAreaInsets.left;
//                                NSLog(@"horzMargin:%@", @(horzMargin));
    }
//    if([[[UIDevice currentDevice] systemVersion] floatValue]>=11.0)
//    {
//        adjustFrame = CGRectMake(0,
//                                 frame.origin.x,
//                                 frame.size.width,
//                                 frame.size.height);
//        
////        if(superView!=nil)
////        {
////            CGRect buttonBarStackViewFrame = CGRectZero;
////            
////            // 找UINavigaionBar的寬度
////            do
////            {
////                if([NSStringFromClass([superView class]) isEqualToString:@"_UIButtonBarStackView"]==YES)
////                {
////                    adjustFrame.origin.x = -superView.frame.origin.x;
////                    buttonBarStackViewFrame = superView.frame;
////                }
////                NSLog(@"superView.bounds:%@", NSStringFromCGRect(superView.bounds));
////                NSLog(@"buttonBarStackViewFrame:%@", NSStringFromCGRect(buttonBarStackViewFrame));
////                //////////////////////////////////////////////////
////
////                if([superView isKindOfClass:[UINavigationBar class]]==YES)
////                {
////                    adjustFrame.size.width = superView.bounds.size.width;
////                    
////                    //!! 特殊做法，因為 PPNavigationBar 超過 superView 的範圍會點擊不到，這邊透過 blockEdgeInset 調整
////                    
////                    if(UIInterfaceOrientationIsPortrait([[UIApplication sharedApplication] statusBarOrientation])==NO)
////                    {
////                        CGFloat left = MAX(buttonBarStackViewFrame.origin.x, superView.bounds.size.width-CGRectGetMaxX(buttonBarStackViewFrame));
////                        
////                        CGFloat right = left;
////                        
////                        if([PPBarView ignoreEdgeInset]==NO)
////                        {
////                            left = left - PPBarViewBlockModelDefaultEdgeInsertsForNormalBar.left;
////                            
////                            right = right - PPBarViewBlockModelDefaultEdgeInsertsForNormalBar.right;
////                        }
////                        
////                        self.addtionBlockEdgeInsets = UIEdgeInsetsMake(0, left, 0, right);
////                        
////                    }
////                    else
////                    {
////                        self.addtionBlockEdgeInsets = UIEdgeInsetsMake(0, 0, 0, 0);
////                    }
////                    
////                    
////                    break;
////                }
////
////                superView = superView.superview;
////            }
////            while (superView!=nil);
////        }
//    }
//    else
    {
        // 找UINavigaionBar的寬度
        do
        {
            if([superView isKindOfClass:[UINavigationBar class]]==YES)
            {
                adjustFrame.origin.x = superView.frame.origin.x+horzMargin;
                adjustFrame.size.width = superView.frame.origin.x+superView.frame.size.width-(horzMargin*2);

                break;
            }

            superView = superView.superview;
        }
        while (superView!=nil);
    }

    //////////////////////////////////////////////////

    if(adjustFrame.origin.x==self.frame.origin.x &&
       adjustFrame.origin.y==self.frame.origin.y &&
       adjustFrame.size.width==self.frame.size.width &&
       adjustFrame.size.height==self.frame.size.height)
    {
        [super layoutSubviews];
    }
    else
    {
        [super setFrame:adjustFrame];
    }
}

@end
